#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.audit_logs_event_list_response import AuditLogsEventListResponse
from datarobot.models.testing.generated.model.audit_logs_retrieve_one_response import AuditLogsRetrieveOneResponse
from datarobot.models.testing.generated.model.audit_logs_retrieve_response import AuditLogsRetrieveResponse
from datarobot.models.testing.generated.model.prediction_usage_retrieve_response import PredictionUsageRetrieveResponse
from datarobot.models.testing.generated.model.usage_data_events_list_response import UsageDataEventsListResponse
from datarobot.models.testing.generated.model.usage_data_export import UsageDataExport
from datarobot.models.testing.generated.model.usage_data_retrieve_response import UsageDataRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.user_activity_api import UserActivityApi




@responses.activate
def test_user_activity_api_event_logs_events_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/eventLogs/events/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ "data", "data" ],
  "count" : 0
})
    )
    result = UserActivityApi.event_logs_events_list()
    assert isinstance(result, AuditLogsEventListResponse)


@responses.activate
def test_user_activity_api_event_logs_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/eventLogs/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "ip" : "ip",
    "context" : {
      "orgName" : "orgName",
      "projectType" : "projectType",
      "projectName" : "projectName",
      "orgId" : "orgId",
      "userProjectRole" : "userProjectRole"
    },
    "id" : "id",
    "event" : "event",
    "projectId" : "projectId",
    "userId" : "userId",
    "timestamp" : "2000-01-23T04:56:07.000+00:00",
    "username" : "username"
  }, {
    "ip" : "ip",
    "context" : {
      "orgName" : "orgName",
      "projectType" : "projectType",
      "projectName" : "projectName",
      "orgId" : "orgId",
      "userProjectRole" : "userProjectRole"
    },
    "id" : "id",
    "event" : "event",
    "projectId" : "projectId",
    "userId" : "userId",
    "timestamp" : "2000-01-23T04:56:07.000+00:00",
    "username" : "username"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = UserActivityApi.event_logs_list()
    assert isinstance(result, AuditLogsRetrieveResponse)


@responses.activate
def test_user_activity_api_event_logs_prediction_usage_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/eventLogs/predictionUsage/'.format(endpoint=unittest_endpoint,
        minTimestamp=parser.parse('1970-01-01T00:00:00.00Z'), maxTimestamp=parser.parse('1970-01-01T00:00:00.00Z'), ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "userErrorCount" : 2,
    "orgName" : "orgName",
    "predictionExplanations" : True,
    "modelId" : "modelId",
    "requestsCount" : 5,
    "predictionMethod" : "predictionMethod",
    "groupId" : "groupId",
    "projectType" : "projectType",
    "predictionRowsCount" : 1,
    "avgExecutionTime" : 6.027456183070403,
    "modelType" : "modelType",
    "userId" : "userId",
    "orgId" : "orgId",
    "recommendedModel" : True,
    "blenderModelTypes" : "blenderModelTypes",
    "deploymentType" : "deploymentType",
    "groupName" : "groupName",
    "serverErrorCount" : 5,
    "deploymentId" : "deploymentId",
    "datasetId" : "datasetId",
    "projectId" : "projectId",
    "userProjectRole" : "userProjectRole",
    "timestamp" : "2000-01-23T04:56:07.000+00:00",
    "username" : "username"
  }, {
    "userErrorCount" : 2,
    "orgName" : "orgName",
    "predictionExplanations" : True,
    "modelId" : "modelId",
    "requestsCount" : 5,
    "predictionMethod" : "predictionMethod",
    "groupId" : "groupId",
    "projectType" : "projectType",
    "predictionRowsCount" : 1,
    "avgExecutionTime" : 6.027456183070403,
    "modelType" : "modelType",
    "userId" : "userId",
    "orgId" : "orgId",
    "recommendedModel" : True,
    "blenderModelTypes" : "blenderModelTypes",
    "deploymentType" : "deploymentType",
    "groupName" : "groupName",
    "serverErrorCount" : 5,
    "deploymentId" : "deploymentId",
    "datasetId" : "datasetId",
    "projectId" : "projectId",
    "userProjectRole" : "userProjectRole",
    "timestamp" : "2000-01-23T04:56:07.000+00:00",
    "username" : "username"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 7
})
    )
    result = UserActivityApi.event_logs_prediction_usage_list(min_timestamp=parser.parse('1970-01-01T00:00:00.00Z'), max_timestamp=parser.parse('1970-01-01T00:00:00.00Z'), )
    assert isinstance(result, PredictionUsageRetrieveResponse)


@responses.activate
def test_user_activity_api_event_logs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/eventLogs/{recordId}/'.format(endpoint=unittest_endpoint,
        recordId="recordId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "ip" : "ip",
  "context" : {
    "orgName" : "orgName",
    "projectType" : "projectType",
    "projectName" : "projectName",
    "orgId" : "orgId",
    "userProjectRole" : "userProjectRole"
  },
  "id" : "id",
  "event" : "event",
  "projectId" : "projectId",
  "userId" : "userId",
  "timestamp" : "2000-01-23T04:56:07.000+00:00",
  "username" : "username"
})
    )
    result = UserActivityApi.event_logs_retrieve(record_id="recordId_example", )
    assert isinstance(result, AuditLogsRetrieveOneResponse)


@responses.activate
def test_user_activity_api_usage_data_exports_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/usageDataExports/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='',
    )
    result = UserActivityApi.usage_data_exports_create()
    assert isinstance(result, type(None))


@responses.activate
def test_user_activity_api_usage_data_exports_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/usageDataExports/{artifactId}/'.format(endpoint=unittest_endpoint,
        artifactId="artifactId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "data" : ""
})
    )
    result = UserActivityApi.usage_data_exports_retrieve(artifact_id="artifactId_example", )
    assert isinstance(result, UsageDataRetrieveResponse)


@responses.activate
def test_user_activity_api_usage_data_exports_supported_events_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/usageDataExports/supportedEvents/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : "Empty Catalog Item Created"
})
    )
    result = UserActivityApi.usage_data_exports_supported_events_list()
    assert isinstance(result, UsageDataEventsListResponse)
