#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.calendar_access_control_list_response import CalendarAccessControlListResponse
from datarobot.models.testing_list.generated.model.calendar_access_control_update import CalendarAccessControlUpdate
from datarobot.models.testing_list.generated.model.calendar_file_upload import CalendarFileUpload
from datarobot.models.testing_list.generated.model.calendar_from_dataset import CalendarFromDataset
from datarobot.models.testing_list.generated.model.calendar_list_response import CalendarListResponse
from datarobot.models.testing_list.generated.model.calendar_name_update import CalendarNameUpdate
from datarobot.models.testing_list.generated.model.calendar_record import CalendarRecord
from datarobot.models.testing_list.generated.model.created_calendar_dataset_response import CreatedCalendarDatasetResponse
from datarobot.models.testing_list.generated.model.preloaded_calendar import PreloadedCalendar
from datarobot.models.testing_list.generated.model.preloaded_calendar_list_response import PreloadedCalendarListResponse
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.calendars_api import CalendarsApi




@responses.activate
def test_calendars_api_calendar_country_codes_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/calendarCountryCodes/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "code" : "code",
    "name" : "name"
  }, {
    "code" : "code",
    "name" : "name"
  } ],
  "previous" : "previous",
  "count" : 0
})
    )
    result = CalendarsApi.calendar_country_codes_list()
    assert isinstance(result, PreloadedCalendarListResponse)


@responses.activate
def test_calendars_api_calendars_access_control_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/calendars/{calendarId}/accessControl/'.format(endpoint=unittest_endpoint,
        calendarId="calendarId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "role" : "USER",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  }, {
    "role" : "USER",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  } ],
  "previous" : "previous",
  "count" : 0
})
    )
    result = CalendarsApi.calendars_access_control_list(calendar_id="calendarId_example", )
    assert isinstance(result, CalendarAccessControlListResponse)


@responses.activate
def test_calendars_api_calendars_access_control_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/calendars/{calendarId}/accessControl/'.format(endpoint=unittest_endpoint,
        calendarId="calendarId_example", ),
        status=200,
        content_type='',
    )
    result = CalendarsApi.calendars_access_control_patch_many(calendar_id="calendarId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_calendars_api_calendars_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/calendars/{calendarId}/'.format(endpoint=unittest_endpoint,
        calendarId="calendarId_example", ),
        status=204,
        content_type='application/json',
        body=json.dumps(dict(calendar_id="calendarId_example", ))
    )
    result = CalendarsApi.calendars_delete(calendar_id="calendarId_example", )
    assert isinstance(result, dict)


@responses.activate
def test_calendars_api_calendars_file_upload_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/calendars/fileUpload/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps(dict())
    )
    result = CalendarsApi.calendars_file_upload_create()
    assert isinstance(result, dict)


@responses.activate
def test_calendars_api_calendars_from_country_code_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/calendars/fromCountryCode/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps(dict())
    )
    result = CalendarsApi.calendars_from_country_code_create()
    assert isinstance(result, dict)


@responses.activate
def test_calendars_api_calendars_from_dataset_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/calendars/fromDataset/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = CalendarsApi.calendars_from_dataset_create()
    assert isinstance(result, CreatedCalendarDatasetResponse)


@responses.activate
def test_calendars_api_calendars_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/calendars/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "role" : "USER",
    "created" : "2000-01-23T04:56:07.000+00:00",
    "datetimeFormat" : "%m/%d/%Y",
    "numEventTypes" : 6,
    "earliestEvent" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "latestEvent" : "2000-01-23T04:56:07.000+00:00",
    "multiseriesIdColumns" : [ "multiseriesIdColumns" ],
    "numEvents" : 1,
    "id" : "id",
    "source" : "source",
    "projectId" : [ "projectId", "projectId" ]
  }, {
    "role" : "USER",
    "created" : "2000-01-23T04:56:07.000+00:00",
    "datetimeFormat" : "%m/%d/%Y",
    "numEventTypes" : 6,
    "earliestEvent" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "latestEvent" : "2000-01-23T04:56:07.000+00:00",
    "multiseriesIdColumns" : [ "multiseriesIdColumns" ],
    "numEvents" : 1,
    "id" : "id",
    "source" : "source",
    "projectId" : [ "projectId", "projectId" ]
  } ],
  "previous" : "previous",
  "count" : 0
})
    )
    result = CalendarsApi.calendars_list(offset=0, limit=0, )
    assert isinstance(result, CalendarListResponse)


@responses.activate
def test_calendars_api_calendars_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/calendars/{calendarId}/'.format(endpoint=unittest_endpoint,
        calendarId="calendarId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps(dict(calendar_id="calendarId_example", ))
    )
    result = CalendarsApi.calendars_patch(calendar_id="calendarId_example", )
    assert isinstance(result, dict)


@responses.activate
def test_calendars_api_calendars_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/calendars/{calendarId}/'.format(endpoint=unittest_endpoint,
        calendarId="calendarId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "role" : "USER",
  "created" : "2000-01-23T04:56:07.000+00:00",
  "datetimeFormat" : "%m/%d/%Y",
  "numEventTypes" : 6,
  "earliestEvent" : "2000-01-23T04:56:07.000+00:00",
  "name" : "name",
  "latestEvent" : "2000-01-23T04:56:07.000+00:00",
  "multiseriesIdColumns" : [ "multiseriesIdColumns" ],
  "numEvents" : 1,
  "id" : "id",
  "source" : "source",
  "projectId" : [ "projectId", "projectId" ]
})
    )
    result = CalendarsApi.calendars_retrieve(calendar_id="calendarId_example", )
    assert isinstance(result, CalendarRecord)

