#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.cross_class_accuracy_create_response import CrossClassAccuracyCreateResponse
from datarobot.models.testing_list.generated.model.cross_class_accuracy_list import CrossClassAccuracyList
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.cross_class_accuracy_api import CrossClassAccuracyApi




@responses.activate
def test_cross_class_accuracy_api_projects_models_cross_class_accuracy_scores_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = CrossClassAccuracyApi.projects_models_cross_class_accuracy_scores_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, CrossClassAccuracyCreateResponse)


@responses.activate
def test_cross_class_accuracy_api_projects_models_cross_class_accuracy_scores_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "predictionThreshold" : 0.14658129805029452,
    "feature" : "feature",
    "modelId" : "modelId",
    "perClassAccuracyScores" : [ {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    }, {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    } ]
  }, {
    "predictionThreshold" : 0.14658129805029452,
    "feature" : "feature",
    "modelId" : "modelId",
    "perClassAccuracyScores" : [ {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    }, {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    } ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = CrossClassAccuracyApi.projects_models_cross_class_accuracy_scores_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, CrossClassAccuracyList)

