#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.data_disparity_create_payload import DataDisparityCreatePayload
from datarobot.models.testing_list.generated.model.data_disparity_create_response import DataDisparityCreateResponse
from datarobot.models.testing_list.generated.model.data_disparity_retrieve_response import DataDisparityRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.data_disparity_api import DataDisparityApi




@responses.activate
def test_data_disparity_api_projects_models_data_disparity_insights_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = DataDisparityApi.projects_models_data_disparity_insights_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, DataDisparityCreateResponse)


@responses.activate
def test_data_disparity_api_projects_models_data_disparity_insights_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(endpoint=unittest_endpoint,
        feature="feature_example", className1="className1_example", className2="className2_example", projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : {
    "features" : [ {
      "disparityScore" : 1.4658129805029452,
      "name" : "name",
      "detailsHistogram" : [ {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      }, {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      } ],
      "featureImpact" : 5.962133916683182,
      "status" : "Healthy"
    }, {
      "disparityScore" : 1.4658129805029452,
      "name" : "name",
      "detailsHistogram" : [ {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      }, {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      } ],
      "featureImpact" : 5.962133916683182,
      "status" : "Healthy"
    } ],
    "metric" : "metric",
    "protectedFeature" : "protectedFeature",
    "values" : [ {
      "count" : 5,
      "label" : "label"
    }, {
      "count" : 5,
      "label" : "label"
    } ]
  },
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 2
})
    )
    result = DataDisparityApi.projects_models_data_disparity_insights_list(feature="feature_example", class_name1="className1_example", class_name2="className2_example", project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, DataDisparityRetrieveResponse)

