#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.prime_file_create import PrimeFileCreate
from datarobot.models.testing_list.generated.model.prime_file_list_response import PrimeFileListResponse
from datarobot.models.testing_list.generated.model.prime_file_response import PrimeFileResponse
from datarobot.models.testing_list.generated.model.prime_info_retrieve_response import PrimeInfoRetrieveResponse
from datarobot.models.testing_list.generated.model.prime_model_create_payload import PrimeModelCreatePayload
from datarobot.models.testing_list.generated.model.prime_model_details_retrieve_response import PrimeModelDetailsRetrieveResponse
from datarobot.models.testing_list.generated.model.prime_model_list_response import PrimeModelListResponse
from datarobot.models.testing_list.generated.model.prime_rulesets_list_response import PrimeRulesetsListResponse
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.datarobot_prime_api import DatarobotPrimeApi




@responses.activate
def test_datarobot_prime_api_projects_models_prime_info_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/models/{modelId}/primeInfo/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "canMakePrime" : True,
  "messageId" : 0,
  "message" : "message"
})
    )
    result = DatarobotPrimeApi.projects_models_prime_info_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, PrimeInfoRetrieveResponse)


@responses.activate
def test_datarobot_prime_api_projects_models_prime_rulesets_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/models/{modelId}/primeRulesets/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = DatarobotPrimeApi.projects_models_prime_rulesets_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datarobot_prime_api_projects_models_prime_rulesets_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/models/{modelId}/primeRulesets/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps([{
  "rulesetId" : 6,
  "score" : 1.4658129805029452,
  "ruleCount" : 0,
  "parentModelId" : "parentModelId",
  "modelId" : "modelId",
  "projectId" : "projectId"
}])
    )
    result = DatarobotPrimeApi.projects_models_prime_rulesets_list(project_id="projectId_example", model_id="modelId_example", )
    assert all(isinstance(item, PrimeRulesetsListResponse) for item in result)



@responses.activate
def test_datarobot_prime_api_projects_prime_files_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/primeFiles/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = DatarobotPrimeApi.projects_prime_files_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datarobot_prime_api_projects_prime_files_download_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/primeFiles/{primeFileId}/download/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", primeFileId="primeFileId_example", ),
        status=200,
        content_type='',
    )
    result = DatarobotPrimeApi.projects_prime_files_download_list(project_id="projectId_example", prime_file_id="primeFileId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datarobot_prime_api_projects_prime_files_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/primeFiles/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "rulesetId" : 6,
    "parentModelId" : "parentModelId",
    "modelId" : "modelId",
    "isValid" : True,
    "language" : "Python",
    "id" : "id",
    "projectId" : "projectId"
  }, {
    "rulesetId" : 6,
    "parentModelId" : "parentModelId",
    "modelId" : "modelId",
    "isValid" : True,
    "language" : "Python",
    "id" : "id",
    "projectId" : "projectId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = DatarobotPrimeApi.projects_prime_files_list(project_id="projectId_example", )
    assert isinstance(result, PrimeFileListResponse)


@responses.activate
def test_datarobot_prime_api_projects_prime_files_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/primeFiles/{primeFileId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", primeFileId="primeFileId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "rulesetId" : 6,
  "parentModelId" : "parentModelId",
  "modelId" : "modelId",
  "isValid" : True,
  "language" : "Python",
  "id" : "id",
  "projectId" : "projectId"
})
    )
    result = DatarobotPrimeApi.projects_prime_files_retrieve(project_id="projectId_example", prime_file_id="primeFileId_example", )
    assert isinstance(result, PrimeFileResponse)


@responses.activate
def test_datarobot_prime_api_projects_prime_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/primeModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = DatarobotPrimeApi.projects_prime_models_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datarobot_prime_api_projects_prime_models_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/primeModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "rulesetId" : 5,
    "samplePct" : 5.637376656633329,
    "featurelistName" : "featurelistName",
    "modelFamily" : "modelFamily",
    "predictionThreshold" : 6.027456183070403,
    "score" : 2.3021358869347655,
    "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "isFrozen" : True,
    "modelCategory" : "model",
    "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
    "supportsComposableMl" : True,
    "processes" : [ "processes", "processes" ],
    "linkFunction" : "linkFunction",
    "trainingDuration" : "trainingDuration",
    "parentModelId" : "parentModelId",
    "predictionThresholdReadOnly" : True,
    "isStarred" : True,
    "featurelistId" : "featurelistId",
    "modelType" : "modelType",
    "blueprintId" : "blueprintId",
    "supportsMonotonicConstraints" : True,
    "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
    "ruleCount" : 1,
    "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "trainingRowCount" : 7,
    "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": None,\n                    \"backtestingScores\": None,\n                    \"crossValidation\": 6000,\n                    \"training\": None\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": None,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": None,\n                    \"backtestingScores\": None,\n                    \"training\": None\n                },\n            }\n        }\n",
    "projectId" : "projectId"
  }, {
    "rulesetId" : 5,
    "samplePct" : 5.637376656633329,
    "featurelistName" : "featurelistName",
    "modelFamily" : "modelFamily",
    "predictionThreshold" : 6.027456183070403,
    "score" : 2.3021358869347655,
    "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "isFrozen" : True,
    "modelCategory" : "model",
    "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
    "supportsComposableMl" : True,
    "processes" : [ "processes", "processes" ],
    "linkFunction" : "linkFunction",
    "trainingDuration" : "trainingDuration",
    "parentModelId" : "parentModelId",
    "predictionThresholdReadOnly" : True,
    "isStarred" : True,
    "featurelistId" : "featurelistId",
    "modelType" : "modelType",
    "blueprintId" : "blueprintId",
    "supportsMonotonicConstraints" : True,
    "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
    "ruleCount" : 1,
    "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "trainingRowCount" : 7,
    "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": None,\n                    \"backtestingScores\": None,\n                    \"crossValidation\": 6000,\n                    \"training\": None\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": None,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": None,\n                    \"backtestingScores\": None,\n                    \"training\": None\n                },\n            }\n        }\n",
    "projectId" : "projectId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = DatarobotPrimeApi.projects_prime_models_list(project_id="projectId_example", )
    assert isinstance(result, PrimeModelListResponse)


@responses.activate
def test_datarobot_prime_api_projects_prime_models_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/primeModels/{modelId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "rulesetId" : 5,
  "samplePct" : 5.637376656633329,
  "featurelistName" : "featurelistName",
  "modelFamily" : "modelFamily",
  "predictionThreshold" : 6.027456183070403,
  "score" : 2.3021358869347655,
  "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "id" : "id",
  "isFrozen" : True,
  "modelCategory" : "model",
  "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
  "supportsComposableMl" : True,
  "processes" : [ "processes", "processes" ],
  "linkFunction" : "linkFunction",
  "trainingDuration" : "trainingDuration",
  "parentModelId" : "parentModelId",
  "predictionThresholdReadOnly" : True,
  "isStarred" : True,
  "featurelistId" : "featurelistId",
  "modelType" : "modelType",
  "blueprintId" : "blueprintId",
  "supportsMonotonicConstraints" : True,
  "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
  "ruleCount" : 1,
  "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "trainingRowCount" : 7,
  "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": None,\n                    \"backtestingScores\": None,\n                    \"crossValidation\": 6000,\n                    \"training\": None\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": None,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": None,\n                    \"backtestingScores\": None,\n                    \"training\": None\n                },\n            }\n        }\n",
  "projectId" : "projectId"
})
    )
    result = DatarobotPrimeApi.projects_prime_models_retrieve(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, PrimeModelDetailsRetrieveResponse)

