#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.datetime_partitioning_data_for_open_api import DatetimePartitioningDataForOpenApi
from datarobot.models.testing_list.generated.model.datetime_partitioning_response import DatetimePartitioningResponse
from datarobot.models.testing_list.generated.model.final_datetime_partitioning_response import FinalDatetimePartitioningResponse
from datarobot.models.testing_list.generated.model.optimized_datetime_partitioning_data import OptimizedDatetimePartitioningData
from datarobot.models.testing_list.generated.model.optimized_datetime_partitioning_list_response import OptimizedDatetimePartitioningListResponse
from datarobot.models.testing_list.generated.model.time_series_feature_log_list_controller_response import TimeSeriesFeatureLogListControllerResponse
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.datetime_partitioning_api import DatetimePartitioningApi




@responses.activate
def test_datetime_partitioning_api_projects_datetime_partitioning_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/datetimePartitioning/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "aggregationType" : "total",
  "dateFormat" : "dateFormat",
  "holdoutEndDate" : "2000-01-23T04:56:07.000+00:00",
  "modelSplits" : 3,
  "availableTrainingDuration" : "availableTrainingDuration",
  "featureDerivationWindowEnd" : 0,
  "autopilotDataSelectionMethod" : "duration",
  "periodicities" : [ {
    "timeSteps" : 2147483647,
    "timeUnit" : "MILLISECOND"
  }, {
    "timeSteps" : 2147483647,
    "timeUnit" : "MILLISECOND"
  } ],
  "datetimePartitionColumn" : "datetimePartitionColumn",
  "calendarName" : "calendarName",
  "featureSettings" : [ {
    "doNotDerive" : True,
    "featureName" : "featureName",
    "knownInAdvance" : True,
    "aPriori" : True
  }, {
    "doNotDerive" : True,
    "featureName" : "featureName",
    "knownInAdvance" : True,
    "aPriori" : True
  } ],
  "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
  "useCrossSeriesFeatures" : True,
  "disableHoldout" : True,
  "differencingMethod" : "auto",
  "primaryTrainingDuration" : "primaryTrainingDuration",
  "treatAsExponential" : "auto",
  "numberOfKnownInAdvanceFeatures" : 3,
  "multiseriesIdColumns" : [ "multiseriesIdColumns", "multiseriesIdColumns" ],
  "forecastWindowStart" : 0,
  "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "defaultToKnownInAdvance" : True,
  "backtests" : [ {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  } ],
  "gapDuration" : "gapDuration",
  "defaultToAPriori" : True,
  "defaultToDoNotDerive" : True,
  "calendarId" : "calendarId",
  "forecastWindowEnd" : 0,
  "crossSeriesGroupByColumns" : [ "crossSeriesGroupByColumns" ],
  "holdoutDuration" : "holdoutDuration",
  "partitioningWarnings" : [ {
    "backtestIndex" : 1,
    "partition" : "partition",
    "warnings" : [ "warnings", "warnings" ]
  }, {
    "backtestIndex" : 1,
    "partition" : "partition",
    "warnings" : [ "warnings", "warnings" ]
  } ],
  "windowsBasisUnit" : "MILLISECOND",
  "numberOfDoNotDeriveFeatures" : 9,
  "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
  "holdoutStartDate" : "2000-01-23T04:56:07.000+00:00",
  "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "useTimeSeries" : True,
  "validationDuration" : "validationDuration",
  "numberOfBacktests" : 14,
  "projectId" : "projectId",
  "featureDerivationWindowStart" : 0
})
    )
    result = DatetimePartitioningApi.projects_datetime_partitioning_create(project_id="projectId_example", )
    assert isinstance(result, DatetimePartitioningResponse)


@responses.activate
def test_datetime_partitioning_api_projects_datetime_partitioning_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/datetimePartitioning/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "primaryTrainingRowCount" : 4,
  "aggregationType" : "total",
  "dateFormat" : "dateFormat",
  "holdoutEndDate" : "2000-01-23T04:56:07.000+00:00",
  "modelSplits" : 1,
  "availableTrainingDuration" : "availableTrainingDuration",
  "featureDerivationWindowEnd" : 0,
  "autopilotDataSelectionMethod" : "duration",
  "periodicities" : [ {
    "timeSteps" : 2147483647,
    "timeUnit" : "MILLISECOND"
  }, {
    "timeSteps" : 2147483647,
    "timeUnit" : "MILLISECOND"
  } ],
  "datetimePartitionColumn" : "datetimePartitionColumn",
  "calendarName" : "calendarName",
  "featureSettings" : [ {
    "doNotDerive" : True,
    "featureName" : "featureName",
    "knownInAdvance" : True,
    "aPriori" : True
  }, {
    "doNotDerive" : True,
    "featureName" : "featureName",
    "knownInAdvance" : True,
    "aPriori" : True
  } ],
  "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
  "useCrossSeriesFeatures" : True,
  "disableHoldout" : True,
  "differencingMethod" : "auto",
  "primaryTrainingDuration" : "primaryTrainingDuration",
  "treatAsExponential" : "auto",
  "numberOfKnownInAdvanceFeatures" : 7,
  "multiseriesIdColumns" : [ "multiseriesIdColumns", "multiseriesIdColumns" ],
  "totalRowCount" : 5,
  "forecastWindowStart" : 0,
  "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "defaultToKnownInAdvance" : True,
  "backtests" : [ {
    "primaryTrainingRowCount" : 5,
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 5,
    "gapDuration" : "gapDuration",
    "validationRowCount" : 7,
    "availableTrainingRowCount" : 6,
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapRowCount" : 1,
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "totalRowCount" : 2,
    "validationDuration" : "validationDuration"
  }, {
    "primaryTrainingRowCount" : 5,
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 5,
    "gapDuration" : "gapDuration",
    "validationRowCount" : 7,
    "availableTrainingRowCount" : 6,
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapRowCount" : 1,
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "totalRowCount" : 2,
    "validationDuration" : "validationDuration"
  }, {
    "primaryTrainingRowCount" : 5,
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 5,
    "gapDuration" : "gapDuration",
    "validationRowCount" : 7,
    "availableTrainingRowCount" : 6,
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapRowCount" : 1,
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "totalRowCount" : 2,
    "validationDuration" : "validationDuration"
  }, {
    "primaryTrainingRowCount" : 5,
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 5,
    "gapDuration" : "gapDuration",
    "validationRowCount" : 7,
    "availableTrainingRowCount" : 6,
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapRowCount" : 1,
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "totalRowCount" : 2,
    "validationDuration" : "validationDuration"
  }, {
    "primaryTrainingRowCount" : 5,
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 5,
    "gapDuration" : "gapDuration",
    "validationRowCount" : 7,
    "availableTrainingRowCount" : 6,
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapRowCount" : 1,
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "totalRowCount" : 2,
    "validationDuration" : "validationDuration"
  } ],
  "gapDuration" : "gapDuration",
  "defaultToAPriori" : True,
  "availableTrainingRowCount" : 0,
  "defaultToDoNotDerive" : True,
  "calendarId" : "calendarId",
  "forecastWindowEnd" : 0,
  "crossSeriesGroupByColumns" : [ "crossSeriesGroupByColumns" ],
  "holdoutDuration" : "holdoutDuration",
  "partitioningWarnings" : [ {
    "backtestIndex" : 1,
    "partition" : "partition",
    "warnings" : [ "warnings", "warnings" ]
  }, {
    "backtestIndex" : 1,
    "partition" : "partition",
    "warnings" : [ "warnings", "warnings" ]
  } ],
  "windowsBasisUnit" : "MILLISECOND",
  "numberOfDoNotDeriveFeatures" : 6,
  "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
  "holdoutStartDate" : "2000-01-23T04:56:07.000+00:00",
  "gapRowCount" : 7,
  "holdoutRowCount" : 1,
  "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "useTimeSeries" : True,
  "validationDuration" : "validationDuration",
  "numberOfBacktests" : 3,
  "projectId" : "projectId",
  "featureDerivationWindowStart" : 0
})
    )
    result = DatetimePartitioningApi.projects_datetime_partitioning_list(project_id="projectId_example", )
    assert isinstance(result, FinalDatetimePartitioningResponse)


@responses.activate
def test_datetime_partitioning_api_projects_optimized_datetime_partitionings_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/optimizedDatetimePartitionings/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "aggregationType" : "total",
  "dateFormat" : "dateFormat",
  "holdoutEndDate" : "2000-01-23T04:56:07.000+00:00",
  "modelSplits" : 3,
  "availableTrainingDuration" : "availableTrainingDuration",
  "featureDerivationWindowEnd" : 0,
  "autopilotDataSelectionMethod" : "duration",
  "periodicities" : [ {
    "timeSteps" : 2147483647,
    "timeUnit" : "MILLISECOND"
  }, {
    "timeSteps" : 2147483647,
    "timeUnit" : "MILLISECOND"
  } ],
  "datetimePartitionColumn" : "datetimePartitionColumn",
  "calendarName" : "calendarName",
  "featureSettings" : [ {
    "doNotDerive" : True,
    "featureName" : "featureName",
    "knownInAdvance" : True,
    "aPriori" : True
  }, {
    "doNotDerive" : True,
    "featureName" : "featureName",
    "knownInAdvance" : True,
    "aPriori" : True
  } ],
  "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
  "useCrossSeriesFeatures" : True,
  "disableHoldout" : True,
  "differencingMethod" : "auto",
  "primaryTrainingDuration" : "primaryTrainingDuration",
  "treatAsExponential" : "auto",
  "numberOfKnownInAdvanceFeatures" : 3,
  "multiseriesIdColumns" : [ "multiseriesIdColumns", "multiseriesIdColumns" ],
  "forecastWindowStart" : 0,
  "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "defaultToKnownInAdvance" : True,
  "backtests" : [ {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  } ],
  "gapDuration" : "gapDuration",
  "defaultToAPriori" : True,
  "defaultToDoNotDerive" : True,
  "calendarId" : "calendarId",
  "forecastWindowEnd" : 0,
  "crossSeriesGroupByColumns" : [ "crossSeriesGroupByColumns" ],
  "holdoutDuration" : "holdoutDuration",
  "partitioningWarnings" : [ {
    "backtestIndex" : 1,
    "partition" : "partition",
    "warnings" : [ "warnings", "warnings" ]
  }, {
    "backtestIndex" : 1,
    "partition" : "partition",
    "warnings" : [ "warnings", "warnings" ]
  } ],
  "windowsBasisUnit" : "MILLISECOND",
  "numberOfDoNotDeriveFeatures" : 9,
  "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
  "holdoutStartDate" : "2000-01-23T04:56:07.000+00:00",
  "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "useTimeSeries" : True,
  "validationDuration" : "validationDuration",
  "numberOfBacktests" : 14,
  "projectId" : "projectId",
  "featureDerivationWindowStart" : 0
})
    )
    result = DatetimePartitioningApi.projects_optimized_datetime_partitionings_create(project_id="projectId_example", )
    assert isinstance(result, DatetimePartitioningResponse)


@responses.activate
def test_datetime_partitioning_api_projects_optimized_datetime_partitionings_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/optimizedDatetimePartitionings/'.format(endpoint=unittest_endpoint,
        limit=10, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "partitionData" : {
      "aggregationType" : "total",
      "dateFormat" : "dateFormat",
      "holdoutEndDate" : "2000-01-23T04:56:07.000+00:00",
      "modelSplits" : 3,
      "availableTrainingDuration" : "availableTrainingDuration",
      "featureDerivationWindowEnd" : 0,
      "autopilotDataSelectionMethod" : "duration",
      "periodicities" : [ {
        "timeSteps" : 2147483647,
        "timeUnit" : "MILLISECOND"
      }, {
        "timeSteps" : 2147483647,
        "timeUnit" : "MILLISECOND"
      } ],
      "datetimePartitionColumn" : "datetimePartitionColumn",
      "calendarName" : "calendarName",
      "featureSettings" : [ {
        "doNotDerive" : True,
        "featureName" : "featureName",
        "knownInAdvance" : True,
        "aPriori" : True
      }, {
        "doNotDerive" : True,
        "featureName" : "featureName",
        "knownInAdvance" : True,
        "aPriori" : True
      } ],
      "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
      "useCrossSeriesFeatures" : True,
      "disableHoldout" : True,
      "differencingMethod" : "auto",
      "primaryTrainingDuration" : "primaryTrainingDuration",
      "treatAsExponential" : "auto",
      "numberOfKnownInAdvanceFeatures" : 3,
      "multiseriesIdColumns" : [ "multiseriesIdColumns", "multiseriesIdColumns" ],
      "forecastWindowStart" : 0,
      "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "defaultToKnownInAdvance" : True,
      "backtests" : [ {
        "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingDuration" : "availableTrainingDuration",
        "index" : 0,
        "gapDuration" : "gapDuration",
        "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingDuration" : "primaryTrainingDuration",
        "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "validationDuration" : "validationDuration"
      }, {
        "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingDuration" : "availableTrainingDuration",
        "index" : 0,
        "gapDuration" : "gapDuration",
        "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingDuration" : "primaryTrainingDuration",
        "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "validationDuration" : "validationDuration"
      }, {
        "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingDuration" : "availableTrainingDuration",
        "index" : 0,
        "gapDuration" : "gapDuration",
        "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingDuration" : "primaryTrainingDuration",
        "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "validationDuration" : "validationDuration"
      }, {
        "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingDuration" : "availableTrainingDuration",
        "index" : 0,
        "gapDuration" : "gapDuration",
        "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingDuration" : "primaryTrainingDuration",
        "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "validationDuration" : "validationDuration"
      }, {
        "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingDuration" : "availableTrainingDuration",
        "index" : 0,
        "gapDuration" : "gapDuration",
        "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingDuration" : "primaryTrainingDuration",
        "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "validationDuration" : "validationDuration"
      } ],
      "gapDuration" : "gapDuration",
      "defaultToAPriori" : True,
      "defaultToDoNotDerive" : True,
      "calendarId" : "calendarId",
      "forecastWindowEnd" : 0,
      "crossSeriesGroupByColumns" : [ "crossSeriesGroupByColumns" ],
      "holdoutDuration" : "holdoutDuration",
      "partitioningWarnings" : [ {
        "backtestIndex" : 1,
        "partition" : "partition",
        "warnings" : [ "warnings", "warnings" ]
      }, {
        "backtestIndex" : 1,
        "partition" : "partition",
        "warnings" : [ "warnings", "warnings" ]
      } ],
      "windowsBasisUnit" : "MILLISECOND",
      "numberOfDoNotDeriveFeatures" : 9,
      "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
      "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
      "holdoutStartDate" : "2000-01-23T04:56:07.000+00:00",
      "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
      "useTimeSeries" : True,
      "validationDuration" : "validationDuration",
      "numberOfBacktests" : 14,
      "projectId" : "projectId",
      "featureDerivationWindowStart" : 0
    },
    "id" : "id",
    "datetimePartitionColumn" : "datetimePartitionColumn",
    "target" : "target"
  }, {
    "partitionData" : {
      "aggregationType" : "total",
      "dateFormat" : "dateFormat",
      "holdoutEndDate" : "2000-01-23T04:56:07.000+00:00",
      "modelSplits" : 3,
      "availableTrainingDuration" : "availableTrainingDuration",
      "featureDerivationWindowEnd" : 0,
      "autopilotDataSelectionMethod" : "duration",
      "periodicities" : [ {
        "timeSteps" : 2147483647,
        "timeUnit" : "MILLISECOND"
      }, {
        "timeSteps" : 2147483647,
        "timeUnit" : "MILLISECOND"
      } ],
      "datetimePartitionColumn" : "datetimePartitionColumn",
      "calendarName" : "calendarName",
      "featureSettings" : [ {
        "doNotDerive" : True,
        "featureName" : "featureName",
        "knownInAdvance" : True,
        "aPriori" : True
      }, {
        "doNotDerive" : True,
        "featureName" : "featureName",
        "knownInAdvance" : True,
        "aPriori" : True
      } ],
      "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
      "useCrossSeriesFeatures" : True,
      "disableHoldout" : True,
      "differencingMethod" : "auto",
      "primaryTrainingDuration" : "primaryTrainingDuration",
      "treatAsExponential" : "auto",
      "numberOfKnownInAdvanceFeatures" : 3,
      "multiseriesIdColumns" : [ "multiseriesIdColumns", "multiseriesIdColumns" ],
      "forecastWindowStart" : 0,
      "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "defaultToKnownInAdvance" : True,
      "backtests" : [ {
        "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingDuration" : "availableTrainingDuration",
        "index" : 0,
        "gapDuration" : "gapDuration",
        "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingDuration" : "primaryTrainingDuration",
        "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "validationDuration" : "validationDuration"
      }, {
        "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingDuration" : "availableTrainingDuration",
        "index" : 0,
        "gapDuration" : "gapDuration",
        "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingDuration" : "primaryTrainingDuration",
        "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "validationDuration" : "validationDuration"
      }, {
        "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingDuration" : "availableTrainingDuration",
        "index" : 0,
        "gapDuration" : "gapDuration",
        "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingDuration" : "primaryTrainingDuration",
        "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "validationDuration" : "validationDuration"
      }, {
        "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingDuration" : "availableTrainingDuration",
        "index" : 0,
        "gapDuration" : "gapDuration",
        "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingDuration" : "primaryTrainingDuration",
        "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "validationDuration" : "validationDuration"
      }, {
        "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingDuration" : "availableTrainingDuration",
        "index" : 0,
        "gapDuration" : "gapDuration",
        "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingDuration" : "primaryTrainingDuration",
        "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
        "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
        "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
        "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
        "validationDuration" : "validationDuration"
      } ],
      "gapDuration" : "gapDuration",
      "defaultToAPriori" : True,
      "defaultToDoNotDerive" : True,
      "calendarId" : "calendarId",
      "forecastWindowEnd" : 0,
      "crossSeriesGroupByColumns" : [ "crossSeriesGroupByColumns" ],
      "holdoutDuration" : "holdoutDuration",
      "partitioningWarnings" : [ {
        "backtestIndex" : 1,
        "partition" : "partition",
        "warnings" : [ "warnings", "warnings" ]
      }, {
        "backtestIndex" : 1,
        "partition" : "partition",
        "warnings" : [ "warnings", "warnings" ]
      } ],
      "windowsBasisUnit" : "MILLISECOND",
      "numberOfDoNotDeriveFeatures" : 9,
      "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
      "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
      "holdoutStartDate" : "2000-01-23T04:56:07.000+00:00",
      "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
      "useTimeSeries" : True,
      "validationDuration" : "validationDuration",
      "numberOfBacktests" : 14,
      "projectId" : "projectId",
      "featureDerivationWindowStart" : 0
    },
    "id" : "id",
    "datetimePartitionColumn" : "datetimePartitionColumn",
    "target" : "target"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = DatetimePartitioningApi.projects_optimized_datetime_partitionings_list(limit=10, project_id="projectId_example", )
    assert isinstance(result, OptimizedDatetimePartitioningListResponse)


@responses.activate
def test_datetime_partitioning_api_projects_optimized_datetime_partitionings_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/optimizedDatetimePartitionings/{datetimePartitioningId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", datetimePartitioningId="datetimePartitioningId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "aggregationType" : "total",
  "dateFormat" : "dateFormat",
  "holdoutEndDate" : "2000-01-23T04:56:07.000+00:00",
  "modelSplits" : 3,
  "availableTrainingDuration" : "availableTrainingDuration",
  "featureDerivationWindowEnd" : 0,
  "autopilotDataSelectionMethod" : "duration",
  "periodicities" : [ {
    "timeSteps" : 2147483647,
    "timeUnit" : "MILLISECOND"
  }, {
    "timeSteps" : 2147483647,
    "timeUnit" : "MILLISECOND"
  } ],
  "datetimePartitionColumn" : "datetimePartitionColumn",
  "calendarName" : "calendarName",
  "featureSettings" : [ {
    "doNotDerive" : True,
    "featureName" : "featureName",
    "knownInAdvance" : True,
    "aPriori" : True
  }, {
    "doNotDerive" : True,
    "featureName" : "featureName",
    "knownInAdvance" : True,
    "aPriori" : True
  } ],
  "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
  "useCrossSeriesFeatures" : True,
  "disableHoldout" : True,
  "differencingMethod" : "auto",
  "primaryTrainingDuration" : "primaryTrainingDuration",
  "treatAsExponential" : "auto",
  "numberOfKnownInAdvanceFeatures" : 3,
  "multiseriesIdColumns" : [ "multiseriesIdColumns", "multiseriesIdColumns" ],
  "forecastWindowStart" : 0,
  "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "defaultToKnownInAdvance" : True,
  "backtests" : [ {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  }, {
    "availableTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingDuration" : "availableTrainingDuration",
    "index" : 0,
    "gapDuration" : "gapDuration",
    "gapEndDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingDuration" : "primaryTrainingDuration",
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
    "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00",
    "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationDuration" : "validationDuration"
  } ],
  "gapDuration" : "gapDuration",
  "defaultToAPriori" : True,
  "defaultToDoNotDerive" : True,
  "calendarId" : "calendarId",
  "forecastWindowEnd" : 0,
  "crossSeriesGroupByColumns" : [ "crossSeriesGroupByColumns" ],
  "holdoutDuration" : "holdoutDuration",
  "partitioningWarnings" : [ {
    "backtestIndex" : 1,
    "partition" : "partition",
    "warnings" : [ "warnings", "warnings" ]
  }, {
    "backtestIndex" : 1,
    "partition" : "partition",
    "warnings" : [ "warnings", "warnings" ]
  } ],
  "windowsBasisUnit" : "MILLISECOND",
  "numberOfDoNotDeriveFeatures" : 9,
  "primaryTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "gapStartDate" : "2000-01-23T04:56:07.000+00:00",
  "holdoutStartDate" : "2000-01-23T04:56:07.000+00:00",
  "primaryTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "availableTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "useTimeSeries" : True,
  "validationDuration" : "validationDuration",
  "numberOfBacktests" : 14,
  "projectId" : "projectId",
  "featureDerivationWindowStart" : 0
})
    )
    result = DatetimePartitioningApi.projects_optimized_datetime_partitionings_retrieve(project_id="projectId_example", datetime_partitioning_id="datetimePartitioningId_example", )
    assert isinstance(result, DatetimePartitioningResponse)


@responses.activate
def test_datetime_partitioning_api_projects_time_series_feature_log_file_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/timeSeriesFeatureLog/file/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = DatetimePartitioningApi.projects_time_series_feature_log_file_list(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datetime_partitioning_api_projects_time_series_feature_log_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/timeSeriesFeatureLog/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "previous" : "https://openapi-generator.tech",
  "totalLogLines" : 6,
  "count" : 0,
  "featureLog" : "featureLog"
})
    )
    result = DatetimePartitioningApi.projects_time_series_feature_log_list(project_id="projectId_example", )
    assert isinstance(result, TimeSeriesFeatureLogListControllerResponse)

