#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.accuracy_over_time_response import AccuracyOverTimeResponse
from datarobot.models.testing_list.generated.model.accuracy_retrieve_response import AccuracyRetrieveResponse
from datarobot.models.testing_list.generated.model.challenger_create import ChallengerCreate
from datarobot.models.testing_list.generated.model.challenger_list_response import ChallengerListResponse
from datarobot.models.testing_list.generated.model.challenger_response import ChallengerResponse
from datarobot.models.testing_list.generated.model.challenger_score import ChallengerScore
from datarobot.models.testing_list.generated.model.challenger_update import ChallengerUpdate
from datarobot.models.testing_list.generated.model.deleted_deployment_list_response import DeletedDeploymentListResponse
from datarobot.models.testing_list.generated.model.deployment_actuals import DeploymentActuals
from datarobot.models.testing_list.generated.model.deployment_create_from_learning_model import DeploymentCreateFromLearningModel
from datarobot.models.testing_list.generated.model.deployment_create_from_project_recommended_model import DeploymentCreateFromProjectRecommendedModel
from datarobot.models.testing_list.generated.model.deployment_create_response import DeploymentCreateResponse
from datarobot.models.testing_list.generated.model.deployment_dataset_create import DeploymentDatasetCreate
from datarobot.models.testing_list.generated.model.deployment_feature_drift_response import DeploymentFeatureDriftResponse
from datarobot.models.testing_list.generated.model.deployment_list_response import DeploymentListResponse
from datarobot.models.testing_list.generated.model.deployment_permanent_delete import DeploymentPermanentDelete
from datarobot.models.testing_list.generated.model.deployment_retrieve_response import DeploymentRetrieveResponse
from datarobot.models.testing_list.generated.model.deployment_settings_response import DeploymentSettingsResponse
from datarobot.models.testing_list.generated.model.deployment_settings_update import DeploymentSettingsUpdate
from datarobot.models.testing_list.generated.model.deployment_target_drift_response import DeploymentTargetDriftResponse
from datarobot.models.testing_list.generated.model.deployment_update import DeploymentUpdate
from datarobot.models.testing_list.generated.model.feature_list_response import FeatureListResponse
from datarobot.models.testing_list.generated.model.humility_stats_over_time_retrieve_response import HumilityStatsOverTimeRetrieveResponse
from datarobot.models.testing_list.generated.model.humility_stats_retrieve_response import HumilityStatsRetrieveResponse
from datarobot.models.testing_list.generated.model.model_replacement_submission import ModelReplacementSubmission
from datarobot.models.testing_list.generated.model.model_replacement_validation_request import ModelReplacementValidationRequest
from datarobot.models.testing_list.generated.model.model_replacement_validation_response import ModelReplacementValidationResponse
from datarobot.models.testing_list.generated.model.prediction_dataset_assignment import PredictionDatasetAssignment
from datarobot.models.testing_list.generated.model.prediction_proxy_response import PredictionProxyResponse
from datarobot.models.testing_list.generated.model.prediction_results_list_response import PredictionResultsListResponse
from datarobot.models.testing_list.generated.model.prediction_server_list_response import PredictionServerListResponse
from datarobot.models.testing_list.generated.model.scheduled_report_on_demmand import ScheduledReportOnDemmand
from datarobot.models.testing_list.generated.model.scoring_code_build_payload import ScoringCodeBuildPayload
from datarobot.models.testing_list.generated.model.secondary_dataset_config_response import SecondaryDatasetConfigResponse
from datarobot.models.testing_list.generated.model.secondary_dataset_config_update import SecondaryDatasetConfigUpdate
from datarobot.models.testing_list.generated.model.secondary_datasets_config_list_response import SecondaryDatasetsConfigListResponse
from datarobot.models.testing_list.generated.model.service_stats_over_time_response import ServiceStatsOverTimeResponse
from datarobot.models.testing_list.generated.model.service_stats_retrieve_response import ServiceStatsRetrieveResponse
from datarobot.models.testing_list.generated.model.shared_roles_update_with_grant import SharedRolesUpdateWithGrant
from datarobot.models.testing_list.generated.model.sharing_list_v2_response import SharingListV2Response
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.deployments_api import DeploymentsApi




@responses.activate
def test_deployments_api_deleted_deployments_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deletedDeployments/'.format(endpoint=unittest_endpoint,
        offset=0, limit=20, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "deletedAt" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "label" : "label"
  }, {
    "deletedAt" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "label" : "label"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = DeploymentsApi.deleted_deployments_list(offset=0, limit=20, )
    assert isinstance(result, DeletedDeploymentListResponse)


@responses.activate
def test_deployments_api_deleted_deployments_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
       '{endpoint}/deletedDeployments/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='',
    )
    result = DeploymentsApi.deleted_deployments_patch_many()
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_accuracy_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/accuracy/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "segmentAttribute" : "segmentAttribute",
  "targetClasses" : "targetClasses",
  "period" : {
    "start" : "2000-01-23T04:56:07.000+00:00",
    "end" : "2000-01-23T04:56:07.000+00:00"
  },
  "modelId" : "modelId",
  "segmentValue" : "segmentValue",
  "metrics" : "\n                {\"metrics\": {\n                    \"LogLoss\": {\n                        \"baselineValue\": 0.454221484838069,\n                        \"value\": 0.880778024500618,\n                        \"percentChange\": -93.91\n                    },\n                    \"AUC\": {\n                        \"baselineValue\": 0.8690358459556535,\n                        \"value\": 0.5294117647058824,\n                        \"percentChange\": -39.08\n                    },\n                    \"Kolmogorov-Smirnov\": {\n                        \"baselineValue\": 0.5753202944706626,\n                        \"value\": 0.4117647058823529,\n                        \"percentChange\": -28.43\n                    },\n                    \"Rate@Top10%\": {\n                        \"baselineValue\": 0.9603223806571606,\n                        \"value\": 1.0,\n                        \"percentChange\": 4.13\n                    },\n                    \"Gini Norm\": {\n                        \"baselineValue\": 0.7380716919113071,\n                        \"value\": 0.05882352941176472,\n                        \"percentChange\": -92.03\n                    }\n                }\n                "
})
    )
    result = DeploymentsApi.deployments_accuracy_list(deployment_id="deploymentId_example", )
    assert isinstance(result, AccuracyRetrieveResponse)


@responses.activate
def test_deployments_api_deployments_accuracy_over_time_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/accuracyOverTime/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "segmentAttribute" : "segmentAttribute",
  "summary" : {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "valuePerClass" : "\n                {\n                    \"class1\": 0.880778024500618,\n                    \"class2\": 0.5294117647058824,\n                    \"class3\": 0.4117647058823529\n                }\n            ",
    "sampleSize" : 0,
    "value" : 6.027456183070403
  },
  "metric" : "RMSE",
  "modelId" : "modelId",
  "buckets" : [ {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "valuePerClass" : "\n                {\n                    \"class1\": 0.880778024500618,\n                    \"class2\": 0.5294117647058824,\n                    \"class3\": 0.4117647058823529\n                }\n            ",
    "sampleSize" : 0,
    "value" : 6.027456183070403
  }, {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "valuePerClass" : "\n                {\n                    \"class1\": 0.880778024500618,\n                    \"class2\": 0.5294117647058824,\n                    \"class3\": 0.4117647058823529\n                }\n            ",
    "sampleSize" : 0,
    "value" : 6.027456183070403
  } ],
  "segmentValue" : "segmentValue",
  "baseline" : {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "valuePerClass" : "\n                {\n                    \"class1\": 0.880778024500618,\n                    \"class2\": 0.5294117647058824,\n                    \"class3\": 0.4117647058823529\n                }\n            ",
    "sampleSize" : 0,
    "value" : 6.027456183070403
  }
})
    )
    result = DeploymentsApi.deployments_accuracy_over_time_list(deployment_id="deploymentId_example", )
    assert isinstance(result, AccuracyOverTimeResponse)


@responses.activate
def test_deployments_api_deployments_actuals_from_dataset_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/deployments/{deploymentId}/actuals/fromDataset/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=202,
        content_type='',
    )
    result = DeploymentsApi.deployments_actuals_from_dataset_create(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_actuals_from_json_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/deployments/{deploymentId}/actuals/fromJSON/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=202,
        content_type='',
    )
    result = DeploymentsApi.deployments_actuals_from_json_create(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_challenger_predictions_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/deployments/{deploymentId}/challengerPredictions/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=202,
        content_type='',
    )
    result = DeploymentsApi.deployments_challenger_predictions_create(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_challengers_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/deployments/{deploymentId}/challengers/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=202,
        content_type='',
    )
    result = DeploymentsApi.deployments_challengers_create(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_challengers_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/deployments/{deploymentId}/challengers/{challengerId}/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", challengerId="challengerId_example", ),
        status=204,
        content_type='',
    )
    result = DeploymentsApi.deployments_challengers_delete(deployment_id="deploymentId_example", challenger_id="challengerId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_challengers_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/challengers/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "modelPackage" : {
      "name" : "name",
      "id" : "id"
    },
    "name" : "name",
    "model" : {
      "executionType" : "executionType",
      "datasetName" : "datasetName",
      "name" : "name",
      "description" : "description",
      "id" : "id",
      "projectName" : "projectName",
      "projectId" : "projectId"
    },
    "id" : "id",
    "predictionEnvironment" : {
      "name" : "name",
      "id" : "id"
    }
  }, {
    "modelPackage" : {
      "name" : "name",
      "id" : "id"
    },
    "name" : "name",
    "model" : {
      "executionType" : "executionType",
      "datasetName" : "datasetName",
      "name" : "name",
      "description" : "description",
      "id" : "id",
      "projectName" : "projectName",
      "projectId" : "projectId"
    },
    "id" : "id",
    "predictionEnvironment" : {
      "name" : "name",
      "id" : "id"
    }
  } ]
})
    )
    result = DeploymentsApi.deployments_challengers_list(deployment_id="deploymentId_example", )
    assert isinstance(result, ChallengerListResponse)


@responses.activate
def test_deployments_api_deployments_challengers_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/deployments/{deploymentId}/challengers/{challengerId}/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", challengerId="challengerId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelPackage" : {
    "name" : "name",
    "id" : "id"
  },
  "name" : "name",
  "model" : {
    "executionType" : "executionType",
    "datasetName" : "datasetName",
    "name" : "name",
    "description" : "description",
    "id" : "id",
    "projectName" : "projectName",
    "projectId" : "projectId"
  },
  "id" : "id",
  "predictionEnvironment" : {
    "name" : "name",
    "id" : "id"
  }
})
    )
    result = DeploymentsApi.deployments_challengers_patch(deployment_id="deploymentId_example", challenger_id="challengerId_example", )
    assert isinstance(result, ChallengerResponse)


@responses.activate
def test_deployments_api_deployments_challengers_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/challengers/{challengerId}/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", challengerId="challengerId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelPackage" : {
    "name" : "name",
    "id" : "id"
  },
  "name" : "name",
  "model" : {
    "executionType" : "executionType",
    "datasetName" : "datasetName",
    "name" : "name",
    "description" : "description",
    "id" : "id",
    "projectName" : "projectName",
    "projectId" : "projectId"
  },
  "id" : "id",
  "predictionEnvironment" : {
    "name" : "name",
    "id" : "id"
  }
})
    )
    result = DeploymentsApi.deployments_challengers_retrieve(deployment_id="deploymentId_example", challenger_id="challengerId_example", )
    assert isinstance(result, ChallengerResponse)


@responses.activate
def test_deployments_api_deployments_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/deployments/{deploymentId}/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=204,
        content_type='',
    )
    result = DeploymentsApi.deployments_delete(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_feature_drift_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/featureDrift/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "segmentAttribute" : "segmentAttribute",
  "period" : {
    "start" : "2000-01-23T04:56:07.000+00:00",
    "end" : "2000-01-23T04:56:07.000+00:00"
  },
  "data" : [ {
    "baselineSampleSize" : 6,
    "name" : "name",
    "driftScore" : 1.4658129805029452,
    "sampleSize" : 5,
    "featureImpact" : 5.962133916683182
  }, {
    "baselineSampleSize" : 6,
    "name" : "name",
    "driftScore" : 1.4658129805029452,
    "sampleSize" : 5,
    "featureImpact" : 5.962133916683182
  } ],
  "previous" : "previous",
  "metric" : "psi",
  "modelId" : "modelId",
  "count" : 0,
  "segmentValue" : "segmentValue"
})
    )
    result = DeploymentsApi.deployments_feature_drift_list(deployment_id="deploymentId_example", )
    assert isinstance(result, DeploymentFeatureDriftResponse)


@responses.activate
def test_deployments_api_deployments_features_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/features/'.format(endpoint=unittest_endpoint,
        offset=0, limit=50, deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "dateFormat" : "dateFormat",
    "knownInAdvance" : True,
    "importance" : 6.027456183070403,
    "featureType" : "featureType",
    "name" : "name"
  }, {
    "dateFormat" : "dateFormat",
    "knownInAdvance" : True,
    "importance" : 6.027456183070403,
    "featureType" : "featureType",
    "name" : "name"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = DeploymentsApi.deployments_features_list(offset=0, limit=50, deployment_id="deploymentId_example", )
    assert isinstance(result, FeatureListResponse)


@responses.activate
def test_deployments_api_deployments_from_learning_model_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/deployments/fromLearningModel/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "id" : "id"
})
    )
    result = DeploymentsApi.deployments_from_learning_model_create()
    assert isinstance(result, DeploymentCreateResponse)


@responses.activate
def test_deployments_api_deployments_from_project_recommended_model_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/deployments/fromProjectRecommendedModel/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "id" : "id"
})
    )
    result = DeploymentsApi.deployments_from_project_recommended_model_create()
    assert isinstance(result, DeploymentCreateResponse)


@responses.activate
def test_deployments_api_deployments_humility_stats_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/humilityStats/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "segmentAttribute" : "segmentAttribute",
  "period" : {
    "start" : "2000-01-23T04:56:07.000+00:00",
    "end" : "2000-01-23T04:56:07.000+00:00"
  },
  "data" : [ {
    "ruleName" : "ruleName",
    "ruleId" : "ruleId",
    "value" : 0
  }, {
    "ruleName" : "ruleName",
    "ruleId" : "ruleId",
    "value" : 0
  } ],
  "modelId" : "modelId",
  "segmentValue" : "segmentValue"
})
    )
    result = DeploymentsApi.deployments_humility_stats_list(deployment_id="deploymentId_example", )
    assert isinstance(result, HumilityStatsRetrieveResponse)


@responses.activate
def test_deployments_api_deployments_humility_stats_over_time_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/humilityStatsOverTime/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "segmentAttribute" : "segmentAttribute",
  "summary" : {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "values" : [ {
      "ruleName" : "ruleName",
      "ruleId" : "ruleId",
      "value" : 0
    }, {
      "ruleName" : "ruleName",
      "ruleId" : "ruleId",
      "value" : 0
    } ]
  },
  "modelId" : "modelId",
  "buckets" : [ {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "values" : [ {
      "ruleName" : "ruleName",
      "ruleId" : "ruleId",
      "value" : 0
    }, {
      "ruleName" : "ruleName",
      "ruleId" : "ruleId",
      "value" : 0
    } ]
  }, {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "values" : [ {
      "ruleName" : "ruleName",
      "ruleId" : "ruleId",
      "value" : 0
    }, {
      "ruleName" : "ruleName",
      "ruleId" : "ruleId",
      "value" : 0
    } ]
  } ],
  "segmentValue" : "segmentValue"
})
    )
    result = DeploymentsApi.deployments_humility_stats_over_time_list(deployment_id="deploymentId_example", )
    assert isinstance(result, HumilityStatsOverTimeRetrieveResponse)


@responses.activate
def test_deployments_api_deployments_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/'.format(endpoint=unittest_endpoint,
        offset=0, limit=20, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "approvalStatus" : "PENDING",
    "modelHealth" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "message" : "message",
      "startDate" : "2000-01-23T04:56:07.000+00:00",
      "status" : "warning"
    },
    "modelPackageInitialDownload" : {
      "timestamp" : "2000-01-23T04:56:07.000+00:00"
    },
    "scoringCodeInitialDownload" : {
      "timestamp" : "2000-01-23T04:56:07.000+00:00"
    },
    "settings" : {
      "predictionIntervalsEnabled" : True,
      "predictionWarningEnabled" : True,
      "humbleAiEnabled" : True
    },
    "capabilities" : {
      "supportsPredictionIntervals" : True,
      "supportsAutomaticActuals" : True,
      "supportsHumilityRules" : True,
      "supportsTargetDriftTracking" : True,
      "supportsFeatureDriftTracking" : True,
      "supportsHumilityRulesDefaultCalculations" : True,
      "supportsChallengerModels" : True,
      "supportsModelReplacement" : True,
      "supportsPredictionWarning" : True,
      "supportsHumilityRecommendedRules" : True,
      "supportsScoringCodeDownload" : True,
      "supportsPortablePredictionServer" : True,
      "supportsShapBasedPredictionExplanations" : True,
      "supportsSegmentedAnalysisDriftAndAccuracy" : True
    },
    "modelPackage" : {
      "name" : "name",
      "id" : "id"
    },
    "predictionUsage" : {
      "lastTimestamp" : "2000-01-23T04:56:07.000+00:00",
      "dailyRates" : [ 1, 1 ]
    },
    "accuracyHealth" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "message" : "message",
      "startDate" : "2000-01-23T04:56:07.000+00:00",
      "status" : "unknown"
    },
    "importance" : "CRITICAL",
    "openedChangeRequests" : [ "openedChangeRequests", "openedChangeRequests" ],
    "serviceHealth" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00",
      "status" : "warning"
    },
    "description" : "description",
    "owners" : {
      "preview" : [ {
        "firstName" : "firstName",
        "lastName" : "lastName",
        "id" : "id",
        "email" : "email"
      }, {
        "firstName" : "firstName",
        "lastName" : "lastName",
        "id" : "id",
        "email" : "email"
      } ],
      "count" : 6
    },
    "label" : "label",
    "createdAt" : "2000-01-23T04:56:07.000+00:00",
    "defaultPredictionServer" : {
      "datarobot-key" : "datarobot-key",
      "id" : "id",
      "url" : "url"
    },
    "permissions" : [ "CAN_DELETE_CHALLENGERS", "CAN_DELETE_CHALLENGERS" ],
    "model" : {
      "decisionFlowVersionId" : "decisionFlowVersionId",
      "targetName" : "targetName",
      "unsupervisedType" : "anomaly",
      "decisionFlowId" : "decisionFlowId",
      "targetType" : "targetType",
      "hasAutomodel" : True,
      "type" : "type",
      "deployedAt" : "2000-01-23T04:56:07.000+00:00",
      "unsupervisedMode" : True,
      "buildEnvironmentType" : "buildEnvironmentType",
      "id" : "id",
      "projectName" : "projectName",
      "projectId" : "projectId",
      "hasDecisionFlow" : True
    },
    "id" : "id",
    "state" : "ready",
    "predictionEnvironment" : {
      "supportedModelFormats" : [ "datarobot", "datarobot", "datarobot", "datarobot" ],
      "plugin" : "plugin",
      "isManagedByManagementAgent" : True,
      "name" : "name",
      "id" : "id",
      "platform" : "aws"
    },
    "governance" : {
      "approvalStatus" : "APPROVED",
      "hasOpenedChangeRequests" : True
    },
    "status" : "active"
  }, {
    "approvalStatus" : "PENDING",
    "modelHealth" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "message" : "message",
      "startDate" : "2000-01-23T04:56:07.000+00:00",
      "status" : "warning"
    },
    "modelPackageInitialDownload" : {
      "timestamp" : "2000-01-23T04:56:07.000+00:00"
    },
    "scoringCodeInitialDownload" : {
      "timestamp" : "2000-01-23T04:56:07.000+00:00"
    },
    "settings" : {
      "predictionIntervalsEnabled" : True,
      "predictionWarningEnabled" : True,
      "humbleAiEnabled" : True
    },
    "capabilities" : {
      "supportsPredictionIntervals" : True,
      "supportsAutomaticActuals" : True,
      "supportsHumilityRules" : True,
      "supportsTargetDriftTracking" : True,
      "supportsFeatureDriftTracking" : True,
      "supportsHumilityRulesDefaultCalculations" : True,
      "supportsChallengerModels" : True,
      "supportsModelReplacement" : True,
      "supportsPredictionWarning" : True,
      "supportsHumilityRecommendedRules" : True,
      "supportsScoringCodeDownload" : True,
      "supportsPortablePredictionServer" : True,
      "supportsShapBasedPredictionExplanations" : True,
      "supportsSegmentedAnalysisDriftAndAccuracy" : True
    },
    "modelPackage" : {
      "name" : "name",
      "id" : "id"
    },
    "predictionUsage" : {
      "lastTimestamp" : "2000-01-23T04:56:07.000+00:00",
      "dailyRates" : [ 1, 1 ]
    },
    "accuracyHealth" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "message" : "message",
      "startDate" : "2000-01-23T04:56:07.000+00:00",
      "status" : "unknown"
    },
    "importance" : "CRITICAL",
    "openedChangeRequests" : [ "openedChangeRequests", "openedChangeRequests" ],
    "serviceHealth" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00",
      "status" : "warning"
    },
    "description" : "description",
    "owners" : {
      "preview" : [ {
        "firstName" : "firstName",
        "lastName" : "lastName",
        "id" : "id",
        "email" : "email"
      }, {
        "firstName" : "firstName",
        "lastName" : "lastName",
        "id" : "id",
        "email" : "email"
      } ],
      "count" : 6
    },
    "label" : "label",
    "createdAt" : "2000-01-23T04:56:07.000+00:00",
    "defaultPredictionServer" : {
      "datarobot-key" : "datarobot-key",
      "id" : "id",
      "url" : "url"
    },
    "permissions" : [ "CAN_DELETE_CHALLENGERS", "CAN_DELETE_CHALLENGERS" ],
    "model" : {
      "decisionFlowVersionId" : "decisionFlowVersionId",
      "targetName" : "targetName",
      "unsupervisedType" : "anomaly",
      "decisionFlowId" : "decisionFlowId",
      "targetType" : "targetType",
      "hasAutomodel" : True,
      "type" : "type",
      "deployedAt" : "2000-01-23T04:56:07.000+00:00",
      "unsupervisedMode" : True,
      "buildEnvironmentType" : "buildEnvironmentType",
      "id" : "id",
      "projectName" : "projectName",
      "projectId" : "projectId",
      "hasDecisionFlow" : True
    },
    "id" : "id",
    "state" : "ready",
    "predictionEnvironment" : {
      "supportedModelFormats" : [ "datarobot", "datarobot", "datarobot", "datarobot" ],
      "plugin" : "plugin",
      "isManagedByManagementAgent" : True,
      "name" : "name",
      "id" : "id",
      "platform" : "aws"
    },
    "governance" : {
      "approvalStatus" : "APPROVED",
      "hasOpenedChangeRequests" : True
    },
    "status" : "active"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = DeploymentsApi.deployments_list(offset=0, limit=20, )
    assert isinstance(result, DeploymentListResponse)


@responses.activate
def test_deployments_api_deployments_model_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/deployments/{deploymentId}/model/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "checks" : {
    "humilityRules" : {
      "message" : "message",
      "status" : "warning"
    },
    "targetClasses" : {
      "message" : "message",
      "status" : "warning"
    },
    "modelStatus" : {
      "message" : "message",
      "status" : "warning"
    },
    "validChallenger" : {
      "message" : "message",
      "status" : "warning"
    },
    "modelCanBeDeployed" : {
      "message" : "message",
      "status" : "warning"
    },
    "notCurrentModel" : {
      "message" : "message",
      "status" : "warning"
    },
    "permission" : {
      "message" : "message",
      "status" : "warning"
    },
    "targetType" : {
      "message" : "message",
      "status" : "warning"
    },
    "combinedModelSegments" : {
      "message" : "message",
      "status" : "warning"
    },
    "target" : {
      "message" : "message",
      "status" : "warning"
    },
    "features" : {
      "message" : "message",
      "status" : "warning"
    },
    "predictionReady" : {
      "message" : "message",
      "status" : "warning"
    },
    "featureDataTypes" : {
      "message" : "message",
      "status" : "warning"
    },
    "seriesType" : {
      "message" : "message",
      "status" : "warning"
    },
    "containsTrackedSegmentAttributes" : {
      "message" : "message",
      "status" : "warning"
    },
    "timeSeriesCompatibility" : {
      "message" : "message",
      "status" : "warning"
    },
    "supported" : {
      "message" : "message",
      "status" : "warning"
    }
  },
  "message" : "message",
  "status" : "warning"
})
    )
    result = DeploymentsApi.deployments_model_patch_many(deployment_id="deploymentId_example", )
    assert isinstance(result, ModelReplacementValidationResponse)


@responses.activate
def test_deployments_api_deployments_model_secondary_dataset_configuration_history_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/model/secondaryDatasetConfigurationHistory/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "configName" : "configName",
    "configId" : "configId",
    "updated" : "updated",
    "username" : "username"
  }, {
    "configName" : "configName",
    "configId" : "configId",
    "updated" : "updated",
    "username" : "username"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = DeploymentsApi.deployments_model_secondary_dataset_configuration_history_list(offset=0, limit=100, deployment_id="deploymentId_example", )
    assert isinstance(result, SecondaryDatasetsConfigListResponse)


@responses.activate
def test_deployments_api_deployments_model_secondary_dataset_configuration_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/model/secondaryDatasetConfiguration/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "creatorUserId" : "creatorUserId",
  "isDefault" : True,
  "secondaryDatasetConfigId" : "secondaryDatasetConfigId",
  "isDeleted" : True,
  "created" : "2000-01-23T04:56:07.000+00:00",
  "name" : "name",
  "creatorFullName" : "creatorFullName",
  "credentialIds" : [ {
    "catalogVersionId" : "catalogVersionId",
    "credentialId" : "credentialId",
    "url" : "url"
  }, {
    "catalogVersionId" : "catalogVersionId",
    "credentialId" : "credentialId",
    "url" : "url"
  } ],
  "featurelistId" : "featurelistId",
  "projectId" : "projectId",
  "secondaryDatasets" : [ {
    "identifier" : "identifier",
    "catalogId" : "catalogId",
    "catalogVersionId" : "catalogVersionId",
    "snapshotPolicy" : "specified"
  }, {
    "identifier" : "identifier",
    "catalogId" : "catalogId",
    "catalogVersionId" : "catalogVersionId",
    "snapshotPolicy" : "specified"
  } ]
})
    )
    result = DeploymentsApi.deployments_model_secondary_dataset_configuration_list(deployment_id="deploymentId_example", )
    assert isinstance(result, SecondaryDatasetConfigResponse)


@responses.activate
def test_deployments_api_deployments_model_secondary_dataset_configuration_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/deployments/{deploymentId}/model/secondaryDatasetConfiguration/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=204,
        content_type='',
    )
    result = DeploymentsApi.deployments_model_secondary_dataset_configuration_patch_many(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_model_validation_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/deployments/{deploymentId}/model/validation/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "checks" : {
    "humilityRules" : {
      "message" : "message",
      "status" : "warning"
    },
    "targetClasses" : {
      "message" : "message",
      "status" : "warning"
    },
    "modelStatus" : {
      "message" : "message",
      "status" : "warning"
    },
    "validChallenger" : {
      "message" : "message",
      "status" : "warning"
    },
    "modelCanBeDeployed" : {
      "message" : "message",
      "status" : "warning"
    },
    "notCurrentModel" : {
      "message" : "message",
      "status" : "warning"
    },
    "permission" : {
      "message" : "message",
      "status" : "warning"
    },
    "targetType" : {
      "message" : "message",
      "status" : "warning"
    },
    "combinedModelSegments" : {
      "message" : "message",
      "status" : "warning"
    },
    "target" : {
      "message" : "message",
      "status" : "warning"
    },
    "features" : {
      "message" : "message",
      "status" : "warning"
    },
    "predictionReady" : {
      "message" : "message",
      "status" : "warning"
    },
    "featureDataTypes" : {
      "message" : "message",
      "status" : "warning"
    },
    "seriesType" : {
      "message" : "message",
      "status" : "warning"
    },
    "containsTrackedSegmentAttributes" : {
      "message" : "message",
      "status" : "warning"
    },
    "timeSeriesCompatibility" : {
      "message" : "message",
      "status" : "warning"
    },
    "supported" : {
      "message" : "message",
      "status" : "warning"
    }
  },
  "message" : "message",
  "status" : "warning"
})
    )
    result = DeploymentsApi.deployments_model_validation_create(deployment_id="deploymentId_example", )
    assert isinstance(result, ModelReplacementValidationResponse)


@responses.activate
def test_deployments_api_deployments_on_demand_reports_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/deployments/{deploymentId}/onDemandReports/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='',
    )
    result = DeploymentsApi.deployments_on_demand_reports_create(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/deployments/{deploymentId}/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=204,
        content_type='',
    )
    result = DeploymentsApi.deployments_patch(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_prediction_inputs_from_dataset_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/deployments/{deploymentId}/predictionInputs/fromDataset/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=202,
        content_type='',
    )
    result = DeploymentsApi.deployments_prediction_inputs_from_dataset_create(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_prediction_results_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/predictionResults/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/jsontext/csv',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "actual" : "",
    "modelId" : "modelId",
    "forecastDistance" : 6,
    "predicted" : "",
    "associationId" : "associationId",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "actual" : "",
    "modelId" : "modelId",
    "forecastDistance" : 6,
    "predicted" : "",
    "associationId" : "associationId",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "previous" : "https://openapi-generator.tech",
  "associationIdColumnNames" : [ "associationIdColumnNames", "associationIdColumnNames" ],
  "count" : 0
})
    )
    result = DeploymentsApi.deployments_prediction_results_list(deployment_id="deploymentId_example", )
    assert isinstance(result, PredictionResultsListResponse)


@responses.activate
def test_deployments_api_deployments_predictions_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/deployments/{deploymentId}/predictions/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "passthroughValues" : "{}",
    "predictionExplanations" : [ {
      "featureValue" : "",
      "feature" : "feature",
      "strength" : 6.027456183070403,
      "label" : "",
      "qualitativeStrength" : "qualitativeStrength"
    }, {
      "featureValue" : "",
      "feature" : "feature",
      "strength" : 6.027456183070403,
      "label" : "",
      "qualitativeStrength" : "qualitativeStrength"
    } ],
    "predictionValues" : [ {
      "label" : "",
      "value" : 5.962133916683182
    }, {
      "label" : "",
      "value" : 5.962133916683182
    } ],
    "forecastDistance" : 0,
    "seriesId" : "seriesId",
    "isOutlierPrediction" : True,
    "rowId" : 0,
    "predictionThreshold" : 0.14658129805029452,
    "shapExplanationsMetadata" : [ {
      "baseValue" : 2.3021358869347655,
      "warnings" : [ {
        "mismatchRowCount" : 3,
        "maxNormalizedMismatch" : 9.301444243932576
      }, {
        "mismatchRowCount" : 3,
        "maxNormalizedMismatch" : 9.301444243932576
      } ],
      "remainingTotal" : 7.061401241503109
    }, {
      "baseValue" : 2.3021358869347655,
      "warnings" : [ {
        "mismatchRowCount" : 3,
        "maxNormalizedMismatch" : 9.301444243932576
      }, {
        "mismatchRowCount" : 3,
        "maxNormalizedMismatch" : 9.301444243932576
      } ],
      "remainingTotal" : 7.061401241503109
    } ],
    "prediction" : "",
    "predictionIntervals" : "{}",
    "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
    "deploymentApprovalStatus" : "",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "passthroughValues" : "{}",
    "predictionExplanations" : [ {
      "featureValue" : "",
      "feature" : "feature",
      "strength" : 6.027456183070403,
      "label" : "",
      "qualitativeStrength" : "qualitativeStrength"
    }, {
      "featureValue" : "",
      "feature" : "feature",
      "strength" : 6.027456183070403,
      "label" : "",
      "qualitativeStrength" : "qualitativeStrength"
    } ],
    "predictionValues" : [ {
      "label" : "",
      "value" : 5.962133916683182
    }, {
      "label" : "",
      "value" : 5.962133916683182
    } ],
    "forecastDistance" : 0,
    "seriesId" : "seriesId",
    "isOutlierPrediction" : True,
    "rowId" : 0,
    "predictionThreshold" : 0.14658129805029452,
    "shapExplanationsMetadata" : [ {
      "baseValue" : 2.3021358869347655,
      "warnings" : [ {
        "mismatchRowCount" : 3,
        "maxNormalizedMismatch" : 9.301444243932576
      }, {
        "mismatchRowCount" : 3,
        "maxNormalizedMismatch" : 9.301444243932576
      } ],
      "remainingTotal" : 7.061401241503109
    }, {
      "baseValue" : 2.3021358869347655,
      "warnings" : [ {
        "mismatchRowCount" : 3,
        "maxNormalizedMismatch" : 9.301444243932576
      }, {
        "mismatchRowCount" : 3,
        "maxNormalizedMismatch" : 9.301444243932576
      } ],
      "remainingTotal" : 7.061401241503109
    } ],
    "prediction" : "",
    "predictionIntervals" : "{}",
    "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
    "deploymentApprovalStatus" : "",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  } ]
})
    )
    result = DeploymentsApi.deployments_predictions_create(deployment_id="deploymentId_example", )
    assert isinstance(result, PredictionProxyResponse)


@responses.activate
def test_deployments_api_deployments_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "approvalStatus" : "PENDING",
  "modelHealth" : {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "message" : "message",
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "status" : "warning"
  },
  "modelPackageInitialDownload" : {
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  },
  "scoringCodeInitialDownload" : {
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  },
  "settings" : {
    "predictionIntervalsEnabled" : True,
    "predictionWarningEnabled" : True,
    "humbleAiEnabled" : True
  },
  "capabilities" : {
    "supportsPredictionIntervals" : True,
    "supportsAutomaticActuals" : True,
    "supportsHumilityRules" : True,
    "supportsTargetDriftTracking" : True,
    "supportsFeatureDriftTracking" : True,
    "supportsHumilityRulesDefaultCalculations" : True,
    "supportsChallengerModels" : True,
    "supportsModelReplacement" : True,
    "supportsPredictionWarning" : True,
    "supportsHumilityRecommendedRules" : True,
    "supportsScoringCodeDownload" : True,
    "supportsPortablePredictionServer" : True,
    "supportsShapBasedPredictionExplanations" : True,
    "supportsSegmentedAnalysisDriftAndAccuracy" : True
  },
  "modelPackage" : {
    "name" : "name",
    "id" : "id"
  },
  "predictionUsage" : {
    "lastTimestamp" : "2000-01-23T04:56:07.000+00:00",
    "dailyRates" : [ 1, 1 ]
  },
  "accuracyHealth" : {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "message" : "message",
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "status" : "unknown"
  },
  "importance" : "CRITICAL",
  "openedChangeRequests" : [ "openedChangeRequests", "openedChangeRequests" ],
  "serviceHealth" : {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "status" : "warning"
  },
  "description" : "description",
  "owners" : {
    "preview" : [ {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "id" : "id",
      "email" : "email"
    }, {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "id" : "id",
      "email" : "email"
    } ],
    "count" : 6
  },
  "label" : "label",
  "createdAt" : "2000-01-23T04:56:07.000+00:00",
  "defaultPredictionServer" : {
    "datarobot-key" : "datarobot-key",
    "id" : "id",
    "url" : "url"
  },
  "permissions" : [ "CAN_DELETE_CHALLENGERS", "CAN_DELETE_CHALLENGERS" ],
  "model" : {
    "decisionFlowVersionId" : "decisionFlowVersionId",
    "targetName" : "targetName",
    "unsupervisedType" : "anomaly",
    "decisionFlowId" : "decisionFlowId",
    "targetType" : "targetType",
    "hasAutomodel" : True,
    "type" : "type",
    "deployedAt" : "2000-01-23T04:56:07.000+00:00",
    "unsupervisedMode" : True,
    "buildEnvironmentType" : "buildEnvironmentType",
    "id" : "id",
    "projectName" : "projectName",
    "projectId" : "projectId",
    "hasDecisionFlow" : True
  },
  "id" : "id",
  "state" : "ready",
  "predictionEnvironment" : {
    "supportedModelFormats" : [ "datarobot", "datarobot", "datarobot", "datarobot" ],
    "plugin" : "plugin",
    "isManagedByManagementAgent" : True,
    "name" : "name",
    "id" : "id",
    "platform" : "aws"
  },
  "governance" : {
    "approvalStatus" : "APPROVED",
    "hasOpenedChangeRequests" : True
  },
  "status" : "active"
})
    )
    result = DeploymentsApi.deployments_retrieve(deployment_id="deploymentId_example", )
    assert isinstance(result, DeploymentRetrieveResponse)


@responses.activate
def test_deployments_api_deployments_scoring_code_builds_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/deployments/{deploymentId}/scoringCodeBuilds/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='',
    )
    result = DeploymentsApi.deployments_scoring_code_builds_create(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_scoring_code_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/scoringCode/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='',
    )
    result = DeploymentsApi.deployments_scoring_code_list(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_service_stats_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/serviceStats/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "segmentAttribute" : "segmentAttribute",
  "period" : {
    "start" : "2000-01-23T04:56:07.000+00:00",
    "end" : "2000-01-23T04:56:07.000+00:00"
  },
  "modelId" : "modelId",
  "segmentValue" : "segmentValue",
  "metrics" : {
    "executionTime" : 6.027456183070403,
    "medianLoad" : 1.4658129805029452,
    "cacheHitRatio" : 0.8008281904610115,
    "peakLoad" : 5.637376656633329,
    "serverErrorRate" : 7.061401241503109,
    "totalPredictions" : 3,
    "responseTime" : 2.3021358869347655,
    "totalRequests" : 2,
    "numConsumers" : 5,
    "userErrorRate" : 4.145608029883936,
    "slowRequests" : 9
  }
})
    )
    result = DeploymentsApi.deployments_service_stats_list(deployment_id="deploymentId_example", )
    assert isinstance(result, ServiceStatsRetrieveResponse)


@responses.activate
def test_deployments_api_deployments_service_stats_over_time_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/serviceStatsOverTime/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "segmentAttribute" : "segmentAttribute",
  "summary" : {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "value" : 0.8008281904610115
  },
  "metric" : "metric",
  "modelId" : "modelId",
  "buckets" : [ {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "value" : 0.8008281904610115
  }, {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "value" : 0.8008281904610115
  } ],
  "segmentValue" : "segmentValue"
})
    )
    result = DeploymentsApi.deployments_service_stats_over_time_list(deployment_id="deploymentId_example", )
    assert isinstance(result, ServiceStatsOverTimeResponse)


@responses.activate
def test_deployments_api_deployments_settings_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/settings/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "challengerModels" : {
    "enabled" : True
  },
  "predictionsByForecastDate" : {
    "datetimeFormat" : "datetimeFormat",
    "enabled" : True,
    "columnName" : "columnName"
  },
  "featureDrift" : {
    "enabled" : True
  },
  "humility" : {
    "enabled" : True
  },
  "automaticActuals" : {
    "enabled" : True
  },
  "predictionIntervals" : {
    "percentiles" : [ 0, 0 ],
    "enabled" : True
  },
  "targetDrift" : {
    "enabled" : True
  },
  "predictionWarning" : {
    "customBoundaries" : {
      "lower" : 6.027456183070403,
      "upper" : 1.4658129805029452
    },
    "enabled" : True
  },
  "predictionsDataCollection" : {
    "enabled" : True
  },
  "segmentAnalysis" : {
    "attributes" : [ "attributes", "attributes" ],
    "enabled" : True
  },
  "associationId" : {
    "columnNames" : [ "columnNames", "columnNames" ],
    "requiredInPredictionRequests" : True
  }
})
    )
    result = DeploymentsApi.deployments_settings_list(deployment_id="deploymentId_example", )
    assert isinstance(result, DeploymentSettingsResponse)


@responses.activate
def test_deployments_api_deployments_settings_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/deployments/{deploymentId}/settings/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=202,
        content_type='',
    )
    result = DeploymentsApi.deployments_settings_patch_many(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_shared_roles_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        offset=0, limit=10, deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "shareRecipientType" : "user",
    "role" : "USER",
    "name" : "name",
    "id" : "id"
  }, {
    "shareRecipientType" : "user",
    "role" : "USER",
    "name" : "name",
    "id" : "id"
  } ],
  "previous" : "previous",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DeploymentsApi.deployments_shared_roles_list(offset=0, limit=10, deployment_id="deploymentId_example", )
    assert isinstance(result, SharingListV2Response)


@responses.activate
def test_deployments_api_deployments_shared_roles_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/deployments/{deploymentId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=204,
        content_type='',
    )
    result = DeploymentsApi.deployments_shared_roles_patch_many(deployment_id="deploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_deployments_api_deployments_target_drift_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/deployments/{deploymentId}/targetDrift/'.format(endpoint=unittest_endpoint,
        deploymentId="deploymentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "segmentAttribute" : "segmentAttribute",
  "period" : {
    "start" : "2000-01-23T04:56:07.000+00:00",
    "end" : "2000-01-23T04:56:07.000+00:00"
  },
  "targetName" : "targetName",
  "baselineSampleSize" : 0,
  "metric" : "psi",
  "modelId" : "modelId",
  "segmentValue" : "segmentValue",
  "driftScore" : 6.027456183070403,
  "sampleSize" : 1
})
    )
    result = DeploymentsApi.deployments_target_drift_list(deployment_id="deploymentId_example", )
    assert isinstance(result, DeploymentTargetDriftResponse)


@responses.activate
def test_deployments_api_prediction_servers_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/predictionServers/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "datarobot-key" : "datarobot-key",
    "id" : "id",
    "url" : "url"
  }, {
    "datarobot-key" : "datarobot-key",
    "id" : "id",
    "url" : "url"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = DeploymentsApi.prediction_servers_list()
    assert isinstance(result, PredictionServerListResponse)

