#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.create_driver_request import CreateDriverRequest
from datarobot.models.testing_list.generated.model.driver_configuration_retrieve_response import DriverConfigurationRetrieveResponse
from datarobot.models.testing_list.generated.model.driver_list_response import DriverListResponse
from datarobot.models.testing_list.generated.model.driver_response import DriverResponse
from datarobot.models.testing_list.generated.model.driver_upload_request import DriverUploadRequest
from datarobot.models.testing_list.generated.model.driver_upload_response import DriverUploadResponse
from datarobot.models.testing_list.generated.model.update_driver_request import UpdateDriverRequest
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.drivers_api import DriversApi




@responses.activate
def test_drivers_api_external_data_driver_file_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/externalDataDriverFile/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "localUrl" : "localUrl"
})
    )
    result = DriversApi.external_data_driver_file_create()
    assert isinstance(result, DriverUploadResponse)


@responses.activate
def test_drivers_api_external_data_drivers_configuration_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/externalDataDrivers/{driverId}/configuration/'.format(endpoint=unittest_endpoint,
        driverId="driverId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "standardizedName" : "standardizedName",
  "creator" : "creator",
  "jdbcUrlPathDelimiter" : "jdbcUrlPathDelimiter",
  "jdbcUrlPrefix" : "jdbcUrlPrefix",
  "jdbcUrlQueryDelimiter" : "jdbcUrlQueryDelimiter",
  "jdbcUrlQueryParamKeyValueDelimiter" : "jdbcUrlQueryParamKeyValueDelimiter",
  "associatedAuthTypes" : [ "associatedAuthTypes", "associatedAuthTypes" ],
  "jdbcFieldSchemas" : {
    "default" : "default",
    "kind" : "QUERY_PARAM",
    "visibleByDefault" : True,
    "name" : "name",
    "description" : "description",
    "index" : 0,
    "choices" : [ "choices", "choices" ],
    "required" : True
  },
  "className" : "className",
  "id" : "id",
  "updated" : "updated",
  "jdbcUrlQueryParamDelimiter" : "jdbcUrlQueryParamDelimiter"
})
    )
    result = DriversApi.external_data_drivers_configuration_list(driver_id="driverId_example", )
    assert isinstance(result, DriverConfigurationRetrieveResponse)


@responses.activate
def test_drivers_api_external_data_drivers_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/externalDataDrivers/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "creator" : "creator",
  "baseNames" : [ "baseNames", "baseNames" ],
  "associatedAuthTypes" : [ "snowflakeOauthUserAccount", "snowflakeOauthUserAccount" ],
  "className" : "className",
  "configurationId" : "configurationId",
  "id" : "id",
  "version" : "version",
  "canonicalName" : "canonicalName"
})
    )
    result = DriversApi.external_data_drivers_create()
    assert isinstance(result, DriverResponse)


@responses.activate
def test_drivers_api_external_data_drivers_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/externalDataDrivers/{driverId}/'.format(endpoint=unittest_endpoint,
        driverId="driverId_example", ),
        status=204,
        content_type='',
    )
    result = DriversApi.external_data_drivers_delete(driver_id="driverId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_drivers_api_external_data_drivers_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/externalDataDrivers/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "creator" : "creator",
    "baseNames" : [ "baseNames", "baseNames" ],
    "associatedAuthTypes" : [ "snowflakeOauthUserAccount", "snowflakeOauthUserAccount" ],
    "className" : "className",
    "configurationId" : "configurationId",
    "id" : "id",
    "version" : "version",
    "canonicalName" : "canonicalName"
  }, {
    "creator" : "creator",
    "baseNames" : [ "baseNames", "baseNames" ],
    "associatedAuthTypes" : [ "snowflakeOauthUserAccount", "snowflakeOauthUserAccount" ],
    "className" : "className",
    "configurationId" : "configurationId",
    "id" : "id",
    "version" : "version",
    "canonicalName" : "canonicalName"
  } ]
})
    )
    result = DriversApi.external_data_drivers_list()
    assert isinstance(result, DriverListResponse)


@responses.activate
def test_drivers_api_external_data_drivers_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/externalDataDrivers/{driverId}/'.format(endpoint=unittest_endpoint,
        driverId="driverId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "creator" : "creator",
  "baseNames" : [ "baseNames", "baseNames" ],
  "associatedAuthTypes" : [ "snowflakeOauthUserAccount", "snowflakeOauthUserAccount" ],
  "className" : "className",
  "configurationId" : "configurationId",
  "id" : "id",
  "version" : "version",
  "canonicalName" : "canonicalName"
})
    )
    result = DriversApi.external_data_drivers_patch(driver_id="driverId_example", )
    assert isinstance(result, DriverResponse)


@responses.activate
def test_drivers_api_external_data_drivers_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/externalDataDrivers/{driverId}/'.format(endpoint=unittest_endpoint,
        driverId="driverId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "creator" : "creator",
  "baseNames" : [ "baseNames", "baseNames" ],
  "associatedAuthTypes" : [ "snowflakeOauthUserAccount", "snowflakeOauthUserAccount" ],
  "className" : "className",
  "configurationId" : "configurationId",
  "id" : "id",
  "version" : "version",
  "canonicalName" : "canonicalName"
})
    )
    result = DriversApi.external_data_drivers_retrieve(driver_id="driverId_example", )
    assert isinstance(result, DriverResponse)

