#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.batch_feature_transform import BatchFeatureTransform
from datarobot.models.testing_list.generated.model.batch_feature_transform_retrieve_response import BatchFeatureTransformRetrieveResponse
from datarobot.models.testing_list.generated.model.feature_histogram_response import FeatureHistogramResponse
from datarobot.models.testing_list.generated.model.feature_lineage_response import FeatureLineageResponse
from datarobot.models.testing_list.generated.model.feature_metrics_response import FeatureMetricsResponse
from datarobot.models.testing_list.generated.model.feature_transform import FeatureTransform
from datarobot.models.testing_list.generated.model.modeling_feature_list_response import ModelingFeatureListResponse
from datarobot.models.testing_list.generated.model.modeling_feature_response import ModelingFeatureResponse
from datarobot.models.testing_list.generated.model.project_feature_response import ProjectFeatureResponse
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.features_api import FeaturesApi




@responses.activate
def test_features_api_projects_batch_type_transform_features_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/batchTypeTransformFeatures/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = FeaturesApi.projects_batch_type_transform_features_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_features_api_projects_batch_type_transform_features_result_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/batchTypeTransformFeaturesResult/{jobId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", jobId=1, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "failures" : "{}",
  "newFeatureNames" : [ "newFeatureNames", "newFeatureNames" ]
})
    )
    result = FeaturesApi.projects_batch_type_transform_features_result_retrieve(project_id="projectId_example", job_id=1, )
    assert isinstance(result, BatchFeatureTransformRetrieveResponse)


@responses.activate
def test_features_api_projects_feature_histograms_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/featureHistograms/{featureName}/'.format(endpoint=unittest_endpoint,
        binLimit=60, projectId="projectId_example", featureName="featureName_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "plot" : [ {
    "count" : 0.8008281904610115,
    "label" : "label",
    "target" : 6.027456183070403
  }, {
    "count" : 0.8008281904610115,
    "label" : "label",
    "target" : 6.027456183070403
  } ]
})
    )
    result = FeaturesApi.projects_feature_histograms_retrieve(bin_limit=60, project_id="projectId_example", feature_name="featureName_example", )
    assert isinstance(result, FeatureHistogramResponse)


@responses.activate
def test_features_api_projects_feature_lineages_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/featureLineages/{featureLineageId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featureLineageId="featureLineageId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "steps" : [ {
    "isTimeAware" : True,
    "catalogId" : "catalogId",
    "stepType" : "data",
    "timeInfo" : {
      "duration" : {
        "duration" : 0,
        "timeUnit" : "timeUnit"
      },
      "latest" : {
        "duration" : 0,
        "timeUnit" : "timeUnit"
      }
    },
    "catalogVersionId" : "catalogVersionId",
    "joinInfo" : {
      "rightTable" : {
        "columns" : [ "columns", "columns" ],
        "datasteps" : [ 1, 1 ]
      },
      "joinType" : "left, right",
      "leftTable" : {
        "columns" : [ "columns", "columns" ],
        "datasteps" : [ 1, 1 ]
      }
    },
    "name" : "name",
    "description" : "description",
    "arguments" : "{}",
    "groupBy" : [ "groupBy", "groupBy" ],
    "id" : 0,
    "parents" : [ 0, 0 ]
  }, {
    "isTimeAware" : True,
    "catalogId" : "catalogId",
    "stepType" : "data",
    "timeInfo" : {
      "duration" : {
        "duration" : 0,
        "timeUnit" : "timeUnit"
      },
      "latest" : {
        "duration" : 0,
        "timeUnit" : "timeUnit"
      }
    },
    "catalogVersionId" : "catalogVersionId",
    "joinInfo" : {
      "rightTable" : {
        "columns" : [ "columns", "columns" ],
        "datasteps" : [ 1, 1 ]
      },
      "joinType" : "left, right",
      "leftTable" : {
        "columns" : [ "columns", "columns" ],
        "datasteps" : [ 1, 1 ]
      }
    },
    "name" : "name",
    "description" : "description",
    "arguments" : "{}",
    "groupBy" : [ "groupBy", "groupBy" ],
    "id" : 0,
    "parents" : [ 0, 0 ]
  } ]
})
    )
    result = FeaturesApi.projects_feature_lineages_retrieve(project_id="projectId_example", feature_lineage_id="featureLineageId_example", )
    assert isinstance(result, FeatureLineageResponse)


@responses.activate
def test_features_api_projects_features_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/features/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps([{
  "dateFormat" : "dateFormat",
  "importance" : 6.027456183070403,
  "naCount" : 1,
  "lowInformation" : True,
  "min" : "",
  "timeSeriesEligible" : True,
  "timeStep" : 5,
  "multilabelInsights" : {
    "multilabelInsightsKey" : "multilabelInsightsKey"
  },
  "featureType" : "Text",
  "keySummary" : "",
  "dataQualities" : "ISSUES_FOUND",
  "id" : 0,
  "timeUnit" : "timeUnit",
  "timeSeriesEligibilityReason" : "timeSeriesEligibilityReason",
  "featureLineageId" : "featureLineageId",
  "max" : "",
  "isRestoredAfterReduction" : True,
  "targetLeakageReason" : "targetLeakageReason",
  "median" : "",
  "mean" : "",
  "name" : "name",
  "isZeroInflated" : True,
  "parentFeatureNames" : [ "parentFeatureNames", "parentFeatureNames" ],
  "stdDev" : "",
  "projectId" : "projectId",
  "targetLeakage" : "SKIPPED_DETECTION",
  "uniqueCount" : 5
}])
    )
    result = FeaturesApi.projects_features_list(project_id="projectId_example", )
    assert all(isinstance(item, ProjectFeatureResponse) for item in result)



@responses.activate
def test_features_api_projects_features_metrics_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/features/metrics/'.format(endpoint=unittest_endpoint,
        featureName="featureName_example", projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "featureName" : "featureName",
  "availableMetrics" : [ "availableMetrics", "availableMetrics" ],
  "metricDetails" : [ {
    "metricName" : "metricName",
    "supportsTimeseries" : True,
    "supportsRegression" : True,
    "supportsMulticlass" : True,
    "ascending" : True,
    "supportsBinary" : True
  }, {
    "metricName" : "metricName",
    "supportsTimeseries" : True,
    "supportsRegression" : True,
    "supportsMulticlass" : True,
    "ascending" : True,
    "supportsBinary" : True
  } ]
})
    )
    result = FeaturesApi.projects_features_metrics_list(feature_name="featureName_example", project_id="projectId_example", )
    assert isinstance(result, FeatureMetricsResponse)


@responses.activate
def test_features_api_projects_features_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/features/{featureName}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featureName="featureName_example", ),
        status=200,
        content_type='',
    )
    result = FeaturesApi.projects_features_retrieve(project_id="projectId_example", feature_name="featureName_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_features_api_projects_modeling_features_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/modelingFeatures/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "featureLineageId" : "featureLineageId",
    "dateFormat" : "dateFormat",
    "max" : "",
    "importance" : 6.027456183070403,
    "isRestoredAfterReduction" : True,
    "naCount" : 1,
    "lowInformation" : True,
    "targetLeakageReason" : "targetLeakageReason",
    "min" : "",
    "median" : "",
    "mean" : "",
    "multilabelInsights" : {
      "multilabelInsightsKey" : "multilabelInsightsKey"
    },
    "featureType" : "Text",
    "keySummary" : "",
    "name" : "name",
    "dataQualities" : "ISSUES_FOUND",
    "isZeroInflated" : True,
    "parentFeatureNames" : [ "parentFeatureNames", "parentFeatureNames" ],
    "stdDev" : "",
    "projectId" : "projectId",
    "targetLeakage" : "SKIPPED_DETECTION",
    "uniqueCount" : 5
  }, {
    "featureLineageId" : "featureLineageId",
    "dateFormat" : "dateFormat",
    "max" : "",
    "importance" : 6.027456183070403,
    "isRestoredAfterReduction" : True,
    "naCount" : 1,
    "lowInformation" : True,
    "targetLeakageReason" : "targetLeakageReason",
    "min" : "",
    "median" : "",
    "mean" : "",
    "multilabelInsights" : {
      "multilabelInsightsKey" : "multilabelInsightsKey"
    },
    "featureType" : "Text",
    "keySummary" : "",
    "name" : "name",
    "dataQualities" : "ISSUES_FOUND",
    "isZeroInflated" : True,
    "parentFeatureNames" : [ "parentFeatureNames", "parentFeatureNames" ],
    "stdDev" : "",
    "projectId" : "projectId",
    "targetLeakage" : "SKIPPED_DETECTION",
    "uniqueCount" : 5
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = FeaturesApi.projects_modeling_features_list(offset=0, limit=0, project_id="projectId_example", )
    assert isinstance(result, ModelingFeatureListResponse)


@responses.activate
def test_features_api_projects_modeling_features_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/modelingFeatures/{featureName}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featureName="featureName_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "featureLineageId" : "featureLineageId",
  "dateFormat" : "dateFormat",
  "max" : "",
  "importance" : 6.027456183070403,
  "isRestoredAfterReduction" : True,
  "naCount" : 1,
  "lowInformation" : True,
  "targetLeakageReason" : "targetLeakageReason",
  "min" : "",
  "median" : "",
  "mean" : "",
  "multilabelInsights" : {
    "multilabelInsightsKey" : "multilabelInsightsKey"
  },
  "featureType" : "Text",
  "keySummary" : "",
  "name" : "name",
  "dataQualities" : "ISSUES_FOUND",
  "isZeroInflated" : True,
  "parentFeatureNames" : [ "parentFeatureNames", "parentFeatureNames" ],
  "stdDev" : "",
  "projectId" : "projectId",
  "targetLeakage" : "SKIPPED_DETECTION",
  "uniqueCount" : 5
})
    )
    result = FeaturesApi.projects_modeling_features_retrieve(project_id="projectId_example", feature_name="featureName_example", )
    assert isinstance(result, ModelingFeatureResponse)


@responses.activate
def test_features_api_projects_type_transform_features_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/typeTransformFeatures/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = FeaturesApi.projects_type_transform_features_create(project_id="projectId_example", )
    assert isinstance(result, type(None))
