#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.feature_list_response import FeatureListResponse
from datarobot.models.testing_list.generated.model.model_package_create_from_learning_model import ModelPackageCreateFromLearningModel
from datarobot.models.testing_list.generated.model.model_package_list_response import ModelPackageListResponse
from datarobot.models.testing_list.generated.model.model_package_retrieve_response import ModelPackageRetrieveResponse
from datarobot.models.testing_list.generated.model.sharing_list_v2_response import SharingListV2Response
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.model_packages_api import ModelPackagesApi




@responses.activate
def test_model_packages_api_model_packages_archive_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/modelPackages/{modelPackageId}/archive/'.format(endpoint=unittest_endpoint,
        modelPackageId="modelPackageId_example", ),
        status=204,
        content_type='',
    )
    result = ModelPackagesApi.model_packages_archive_create(model_package_id="modelPackageId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_model_packages_api_model_packages_features_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/modelPackages/{modelPackageId}/features/'.format(endpoint=unittest_endpoint,
        offset=0, limit=50, modelPackageId="modelPackageId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "dateFormat" : "dateFormat",
    "knownInAdvance" : True,
    "importance" : 6.027456183070403,
    "featureType" : "featureType",
    "name" : "name"
  }, {
    "dateFormat" : "dateFormat",
    "knownInAdvance" : True,
    "importance" : 6.027456183070403,
    "featureType" : "featureType",
    "name" : "name"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = ModelPackagesApi.model_packages_features_list(offset=0, limit=50, model_package_id="modelPackageId_example", )
    assert isinstance(result, FeatureListResponse)


@responses.activate
def test_model_packages_api_model_packages_from_learning_model_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/modelPackages/fromLearningModel/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='',
    )
    result = ModelPackagesApi.model_packages_from_learning_model_create()
    assert isinstance(result, type(None))


@responses.activate
def test_model_packages_api_model_packages_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/modelPackages/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "capabilities" : {
      "supportsPredictionWarning" : True,
      "supportsHumilityRecommendedRules" : True,
      "supportsScoringCodeDownload" : True,
      "supportsAutomaticActuals" : True,
      "supportsHumilityRules" : True,
      "supportsTargetDriftTracking" : True,
      "supportsShapBasedPredictionExplanations" : True,
      "supportsFeatureDriftTracking" : True,
      "supportsHumilityRulesDefaultCalculations" : True,
      "supportsChallengerModels" : True,
      "supportsSegmentedAnalysisDriftAndAccuracy" : True
    },
    "importMeta" : {
      "originalFileName" : "originalFileName",
      "dateCreated" : "dateCreated",
      "creatorUsername" : "creatorUsername",
      "creatorId" : "creatorId"
    },
    "modelId" : "modelId",
    "isArchived" : True,
    "datasets" : {
      "targetHistogramBaseline" : "predictions",
      "trainingDataCatalogId" : "trainingDataCatalogId",
      "datasetName" : "datasetName",
      "holdoutDataCatalogId" : "holdoutDataCatalogId",
      "holdoutDatasetName" : "holdoutDatasetName",
      "trainingDataSize" : 1,
      "baselineSegmentedBy" : [ "baselineSegmentedBy", "baselineSegmentedBy" ]
    },
    "target" : {
      "predictionThreshold" : 0.5637376656633328,
      "classCount" : 0,
      "predictionProbabilitiesColumn" : "predictionProbabilitiesColumn",
      "name" : "name",
      "classNames" : [ "classNames", "classNames", "classNames", "classNames", "classNames" ],
      "type" : "Binary"
    },
    "modelDescription" : {
      "modelName" : "modelName",
      "buildEnvironmentType" : "DataRobot",
      "description" : "description",
      "location" : "location"
    },
    "timeseries" : {
      "forecastDistanceColumnName" : "forecastDistanceColumnName",
      "seriesColumnName" : "seriesColumnName",
      "forecastDistancesTimeUnit" : "MICROSECOND",
      "isTraditionalTimeSeries" : True,
      "featureDerivationWindowEnd" : 0,
      "effectiveFeatureDerivationWindowStart" : 0,
      "isCrossSeries" : True,
      "forecastPointColumnName" : "forecastPointColumnName",
      "datetimeColumnName" : "datetimeColumnName",
      "datetimeColumnFormat" : "datetimeColumnFormat",
      "effectiveFeatureDerivationWindowEnd" : 0,
      "forecastDistances" : [ 2, 2 ],
      "isNewSeriesSupport" : True,
      "featureDerivationWindowStart" : 0
    },
    "permissions" : [ "permissions", "permissions" ],
    "name" : "name",
    "id" : "id",
    "activeDeploymentCount" : 6,
    "sourceMeta" : {
      "decisionFlowVersionId" : "decisionFlowVersionId",
      "decisionFlowId" : "decisionFlowId",
      "scoringCode" : {
        "location" : "local_leaderboard",
        "dataRobotPredictionVersion" : "dataRobotPredictionVersion"
      },
      "projectName" : "projectName",
      "projectId" : "projectId",
      "environmentUrl" : "https://openapi-generator.tech"
    },
    "modelKind" : {
      "isDecisionFlow" : True,
      "isUnsupervisedLearning" : True,
      "isAnomalyDetectionModel" : True,
      "isMultiseries" : True,
      "isFeatureDiscovery" : True,
      "isTimeSeries" : True
    },
    "modelExecutionType" : "dedicated"
  }, {
    "capabilities" : {
      "supportsPredictionWarning" : True,
      "supportsHumilityRecommendedRules" : True,
      "supportsScoringCodeDownload" : True,
      "supportsAutomaticActuals" : True,
      "supportsHumilityRules" : True,
      "supportsTargetDriftTracking" : True,
      "supportsShapBasedPredictionExplanations" : True,
      "supportsFeatureDriftTracking" : True,
      "supportsHumilityRulesDefaultCalculations" : True,
      "supportsChallengerModels" : True,
      "supportsSegmentedAnalysisDriftAndAccuracy" : True
    },
    "importMeta" : {
      "originalFileName" : "originalFileName",
      "dateCreated" : "dateCreated",
      "creatorUsername" : "creatorUsername",
      "creatorId" : "creatorId"
    },
    "modelId" : "modelId",
    "isArchived" : True,
    "datasets" : {
      "targetHistogramBaseline" : "predictions",
      "trainingDataCatalogId" : "trainingDataCatalogId",
      "datasetName" : "datasetName",
      "holdoutDataCatalogId" : "holdoutDataCatalogId",
      "holdoutDatasetName" : "holdoutDatasetName",
      "trainingDataSize" : 1,
      "baselineSegmentedBy" : [ "baselineSegmentedBy", "baselineSegmentedBy" ]
    },
    "target" : {
      "predictionThreshold" : 0.5637376656633328,
      "classCount" : 0,
      "predictionProbabilitiesColumn" : "predictionProbabilitiesColumn",
      "name" : "name",
      "classNames" : [ "classNames", "classNames", "classNames", "classNames", "classNames" ],
      "type" : "Binary"
    },
    "modelDescription" : {
      "modelName" : "modelName",
      "buildEnvironmentType" : "DataRobot",
      "description" : "description",
      "location" : "location"
    },
    "timeseries" : {
      "forecastDistanceColumnName" : "forecastDistanceColumnName",
      "seriesColumnName" : "seriesColumnName",
      "forecastDistancesTimeUnit" : "MICROSECOND",
      "isTraditionalTimeSeries" : True,
      "featureDerivationWindowEnd" : 0,
      "effectiveFeatureDerivationWindowStart" : 0,
      "isCrossSeries" : True,
      "forecastPointColumnName" : "forecastPointColumnName",
      "datetimeColumnName" : "datetimeColumnName",
      "datetimeColumnFormat" : "datetimeColumnFormat",
      "effectiveFeatureDerivationWindowEnd" : 0,
      "forecastDistances" : [ 2, 2 ],
      "isNewSeriesSupport" : True,
      "featureDerivationWindowStart" : 0
    },
    "permissions" : [ "permissions", "permissions" ],
    "name" : "name",
    "id" : "id",
    "activeDeploymentCount" : 6,
    "sourceMeta" : {
      "decisionFlowVersionId" : "decisionFlowVersionId",
      "decisionFlowId" : "decisionFlowId",
      "scoringCode" : {
        "location" : "local_leaderboard",
        "dataRobotPredictionVersion" : "dataRobotPredictionVersion"
      },
      "projectName" : "projectName",
      "projectId" : "projectId",
      "environmentUrl" : "https://openapi-generator.tech"
    },
    "modelKind" : {
      "isDecisionFlow" : True,
      "isUnsupervisedLearning" : True,
      "isAnomalyDetectionModel" : True,
      "isMultiseries" : True,
      "isFeatureDiscovery" : True,
      "isTimeSeries" : True
    },
    "modelExecutionType" : "dedicated"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 4
})
    )
    result = ModelPackagesApi.model_packages_list()
    assert isinstance(result, ModelPackageListResponse)


@responses.activate
def test_model_packages_api_model_packages_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/modelPackages/{modelPackageId}/'.format(endpoint=unittest_endpoint,
        modelPackageId="modelPackageId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "capabilities" : {
    "supportsPredictionWarning" : True,
    "supportsHumilityRecommendedRules" : True,
    "supportsScoringCodeDownload" : True,
    "supportsAutomaticActuals" : True,
    "supportsHumilityRules" : True,
    "supportsTargetDriftTracking" : True,
    "supportsShapBasedPredictionExplanations" : True,
    "supportsFeatureDriftTracking" : True,
    "supportsHumilityRulesDefaultCalculations" : True,
    "supportsChallengerModels" : True,
    "supportsSegmentedAnalysisDriftAndAccuracy" : True
  },
  "importMeta" : {
    "originalFileName" : "originalFileName",
    "dateCreated" : "dateCreated",
    "creatorUsername" : "creatorUsername",
    "creatorId" : "creatorId"
  },
  "modelId" : "modelId",
  "isArchived" : True,
  "datasets" : {
    "targetHistogramBaseline" : "predictions",
    "trainingDataCatalogId" : "trainingDataCatalogId",
    "datasetName" : "datasetName",
    "holdoutDataCatalogId" : "holdoutDataCatalogId",
    "holdoutDatasetName" : "holdoutDatasetName",
    "trainingDataSize" : 1,
    "baselineSegmentedBy" : [ "baselineSegmentedBy", "baselineSegmentedBy" ]
  },
  "target" : {
    "predictionThreshold" : 0.5637376656633328,
    "classCount" : 0,
    "predictionProbabilitiesColumn" : "predictionProbabilitiesColumn",
    "name" : "name",
    "classNames" : [ "classNames", "classNames", "classNames", "classNames", "classNames" ],
    "type" : "Binary"
  },
  "modelDescription" : {
    "modelName" : "modelName",
    "buildEnvironmentType" : "DataRobot",
    "description" : "description",
    "location" : "location"
  },
  "timeseries" : {
    "forecastDistanceColumnName" : "forecastDistanceColumnName",
    "seriesColumnName" : "seriesColumnName",
    "forecastDistancesTimeUnit" : "MICROSECOND",
    "isTraditionalTimeSeries" : True,
    "featureDerivationWindowEnd" : 0,
    "effectiveFeatureDerivationWindowStart" : 0,
    "isCrossSeries" : True,
    "forecastPointColumnName" : "forecastPointColumnName",
    "datetimeColumnName" : "datetimeColumnName",
    "datetimeColumnFormat" : "datetimeColumnFormat",
    "effectiveFeatureDerivationWindowEnd" : 0,
    "forecastDistances" : [ 2, 2 ],
    "isNewSeriesSupport" : True,
    "featureDerivationWindowStart" : 0
  },
  "permissions" : [ "permissions", "permissions" ],
  "name" : "name",
  "id" : "id",
  "activeDeploymentCount" : 6,
  "sourceMeta" : {
    "decisionFlowVersionId" : "decisionFlowVersionId",
    "decisionFlowId" : "decisionFlowId",
    "scoringCode" : {
      "location" : "local_leaderboard",
      "dataRobotPredictionVersion" : "dataRobotPredictionVersion"
    },
    "projectName" : "projectName",
    "projectId" : "projectId",
    "environmentUrl" : "https://openapi-generator.tech"
  },
  "modelKind" : {
    "isDecisionFlow" : True,
    "isUnsupervisedLearning" : True,
    "isAnomalyDetectionModel" : True,
    "isMultiseries" : True,
    "isFeatureDiscovery" : True,
    "isTimeSeries" : True
  },
  "modelExecutionType" : "dedicated"
})
    )
    result = ModelPackagesApi.model_packages_retrieve(model_package_id="modelPackageId_example", )
    assert isinstance(result, ModelPackageRetrieveResponse)


@responses.activate
def test_model_packages_api_model_packages_shared_roles_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/modelPackages/{modelPackageId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        offset=0, limit=10, modelPackageId="modelPackageId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "shareRecipientType" : "user",
    "role" : "USER",
    "name" : "name",
    "id" : "id"
  }, {
    "shareRecipientType" : "user",
    "role" : "USER",
    "name" : "name",
    "id" : "id"
  } ],
  "previous" : "previous",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = ModelPackagesApi.model_packages_shared_roles_list(offset=0, limit=10, model_package_id="modelPackageId_example", )
    assert isinstance(result, SharingListV2Response)

