#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.notification_event_list_response import NotificationEventListResponse
from datarobot.models.testing_list.generated.model.notification_log_list_response import NotificationLogListResponse
from datarobot.models.testing_list.generated.model.notification_policy_mute_create import NotificationPolicyMuteCreate
from datarobot.models.testing_list.generated.model.notification_policy_mute_list_response import NotificationPolicyMuteListResponse
from datarobot.models.testing_list.generated.model.notification_policy_mute_response import NotificationPolicyMuteResponse
from datarobot.models.testing_list.generated.model.notification_resend import NotificationResend
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.notifications_api import NotificationsApi




@responses.activate
def test_notifications_api_notification_events_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/notificationEvents/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "eventGroups" : [ {
    "id" : "id",
    "label" : "label",
    "events" : [ "events", "events" ]
  }, {
    "id" : "id",
    "label" : "label",
    "events" : [ "events", "events" ]
  } ],
  "events" : [ {
    "id" : "id",
    "label" : "label"
  }, {
    "id" : "id",
    "label" : "label"
  } ]
})
    )
    result = NotificationsApi.notification_events_list()
    assert isinstance(result, NotificationEventListResponse)


@responses.activate
def test_notifications_api_notification_logs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/notificationLogs/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "request" : {
      "headers" : "headers",
      "body" : "body",
      "url" : "https://openapi-generator.tech"
    },
    "parentNotificationId" : "parentNotificationId",
    "policyId" : "policyId",
    "response" : {
      "duration" : 6,
      "headers" : "headers",
      "body" : "body",
      "statusCode" : "statusCode"
    },
    "retryCount" : 1,
    "id" : "id",
    "emailSubject" : "emailSubject",
    "channelId" : "channelId",
    "status" : "status",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "request" : {
      "headers" : "headers",
      "body" : "body",
      "url" : "https://openapi-generator.tech"
    },
    "parentNotificationId" : "parentNotificationId",
    "policyId" : "policyId",
    "response" : {
      "duration" : 6,
      "headers" : "headers",
      "body" : "body",
      "statusCode" : "statusCode"
    },
    "retryCount" : 1,
    "id" : "id",
    "emailSubject" : "emailSubject",
    "channelId" : "channelId",
    "status" : "status",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = NotificationsApi.notification_logs_list(offset=0, limit=100, )
    assert isinstance(result, NotificationLogListResponse)


@responses.activate
def test_notifications_api_notification_policy_mutes_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/notificationPolicyMutes/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "uid" : "uid",
  "policyId" : "policyId",
  "entityId" : "entityId",
  "id" : "id"
})
    )
    result = NotificationsApi.notification_policy_mutes_create()
    assert isinstance(result, NotificationPolicyMuteResponse)


@responses.activate
def test_notifications_api_notification_policy_mutes_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/notificationPolicyMutes/{muteId}/'.format(endpoint=unittest_endpoint,
        muteId="muteId_example", ),
        status=200,
        content_type='',
    )
    result = NotificationsApi.notification_policy_mutes_delete(mute_id="muteId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_notifications_api_notification_policy_mutes_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/notificationPolicyMutes/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "uid" : "uid",
    "policyId" : "policyId",
    "entityId" : "entityId",
    "id" : "id"
  }, {
    "uid" : "uid",
    "policyId" : "policyId",
    "entityId" : "entityId",
    "id" : "id"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = NotificationsApi.notification_policy_mutes_list(offset=0, limit=100, )
    assert isinstance(result, NotificationPolicyMuteListResponse)


@responses.activate
def test_notifications_api_notifications_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/notifications/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='',
    )
    result = NotificationsApi.notifications_create()
    assert isinstance(result, type(None))
