#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.aim import Aim
from datarobot.models.testing_list.generated.model.autopilot import Autopilot
from datarobot.models.testing_list.generated.model.autopilot_start import AutopilotStart
from datarobot.models.testing_list.generated.model.cross_series_group_by_column_retrieve_response import CrossSeriesGroupByColumnRetrieveResponse
from datarobot.models.testing_list.generated.model.cross_series_group_by_column_validate_payload import CrossSeriesGroupByColumnValidatePayload
from datarobot.models.testing_list.generated.model.cross_series_group_by_column_validate_response import CrossSeriesGroupByColumnValidateResponse
from datarobot.models.testing_list.generated.model.deleted_project_count_response import DeletedProjectCountResponse
from datarobot.models.testing_list.generated.model.deleted_project_list_response import DeletedProjectListResponse
from datarobot.models.testing_list.generated.model.external_ts_baseline_payload import ExternalTSBaselinePayload
from datarobot.models.testing_list.generated.model.external_ts_baseline_response import ExternalTSBaselineResponse
from datarobot.models.testing_list.generated.model.hdfs_project_create import HdfsProjectCreate
from datarobot.models.testing_list.generated.model.job_details_response import JobDetailsResponse
from datarobot.models.testing_list.generated.model.job_list_response import JobListResponse
from datarobot.models.testing_list.generated.model.multiseries_payload import MultiseriesPayload
from datarobot.models.testing_list.generated.model.multiseries_retrieve_response import MultiseriesRetrieveResponse
from datarobot.models.testing_list.generated.model.project_clone import ProjectClone
from datarobot.models.testing_list.generated.model.project_create import ProjectCreate
from datarobot.models.testing_list.generated.model.project_create_response import ProjectCreateResponse
from datarobot.models.testing_list.generated.model.project_details_response import ProjectDetailsResponse
from datarobot.models.testing_list.generated.model.project_nuke import ProjectNuke
from datarobot.models.testing_list.generated.model.project_nuke_job_list_status import ProjectNukeJobListStatus
from datarobot.models.testing_list.generated.model.project_nuke_job_status import ProjectNukeJobStatus
from datarobot.models.testing_list.generated.model.project_nuke_job_status_summary import ProjectNukeJobStatusSummary
from datarobot.models.testing_list.generated.model.project_recover import ProjectRecover
from datarobot.models.testing_list.generated.model.project_recover_response import ProjectRecoverResponse
from datarobot.models.testing_list.generated.model.project_retrieve_response import ProjectRetrieveResponse
from datarobot.models.testing_list.generated.model.project_secondary_dataset_config_response import ProjectSecondaryDatasetConfigResponse
from datarobot.models.testing_list.generated.model.project_status_response import ProjectStatusResponse
from datarobot.models.testing_list.generated.model.project_update import ProjectUpdate
from datarobot.models.testing_list.generated.model.relationships_config_response import RelationshipsConfigResponse
from datarobot.models.testing_list.generated.model.secondary_dataset_config_list_response import SecondaryDatasetConfigListResponse
from datarobot.models.testing_list.generated.model.secondary_dataset_create import SecondaryDatasetCreate
from datarobot.models.testing_list.generated.model.sharing_list_response import SharingListResponse
from datarobot.models.testing_list.generated.model.sharing_update_or_remove import SharingUpdateOrRemove
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.projects_api import ProjectsApi




@responses.activate
def test_projects_api_deleted_projects_count_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/deletedProjectsCount/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "projectCountLimit" : 0,
  "deletedProjectsCount" : 0,
  "valueExceedsLimit" : True
})
    )
    result = ProjectsApi.deleted_projects_count_list()
    assert isinstance(result, DeletedProjectCountResponse)


@responses.activate
def test_projects_api_deleted_projects_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/deletedProjects/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "fileName" : "fileName",
    "scheduledForDeletion" : True,
    "createdBy" : {
      "id" : "id",
      "email" : "email"
    },
    "organization" : {
      "name" : "name",
      "id" : "id"
    },
    "deletionTime" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "projectName" : "Untitled Project",
    "deletedBy" : {
      "id" : "id",
      "email" : "email"
    }
  }, {
    "fileName" : "fileName",
    "scheduledForDeletion" : True,
    "createdBy" : {
      "id" : "id",
      "email" : "email"
    },
    "organization" : {
      "name" : "name",
      "id" : "id"
    },
    "deletionTime" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "projectName" : "Untitled Project",
    "deletedBy" : {
      "id" : "id",
      "email" : "email"
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = ProjectsApi.deleted_projects_list()
    assert isinstance(result, DeletedProjectListResponse)


@responses.activate
def test_projects_api_deleted_projects_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/deletedProjects/{projectId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = ProjectsApi.deleted_projects_patch(project_id="projectId_example", )
    assert isinstance(result, ProjectRecoverResponse)


@responses.activate
def test_projects_api_hdfs_projects_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/hdfsProjects/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "pid" : "pid"
})
    )
    result = ProjectsApi.hdfs_projects_create()
    assert isinstance(result, ProjectCreateResponse)


@responses.activate
def test_projects_api_project_cleanup_jobs_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/projectCleanupJobs/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='',
    )
    result = ProjectsApi.project_cleanup_jobs_create()
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_project_cleanup_jobs_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/projectCleanupJobs/{statusId}/'.format(endpoint=unittest_endpoint,
        statusId="statusId_example", ),
        status=200,
        content_type='',
    )
    result = ProjectsApi.project_cleanup_jobs_delete(status_id="statusId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_project_cleanup_jobs_download_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projectCleanupJobs/{statusId}/download/'.format(endpoint=unittest_endpoint,
        statusId="statusId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "message" : "message",
    "projectId" : "projectId",
    "status" : "BLOCKED"
  }, {
    "message" : "message",
    "projectId" : "projectId",
    "status" : "BLOCKED"
  }, {
    "message" : "message",
    "projectId" : "projectId",
    "status" : "BLOCKED"
  }, {
    "message" : "message",
    "projectId" : "projectId",
    "status" : "BLOCKED"
  }, {
    "message" : "message",
    "projectId" : "projectId",
    "status" : "BLOCKED"
  } ],
  "statusId" : "statusId",
  "created" : "2000-01-23T04:56:07.000+00:00",
  "message" : "message",
  "status" : "BLOCKED"
})
    )
    result = ProjectsApi.project_cleanup_jobs_download_list(status_id="statusId_example", )
    assert isinstance(result, ProjectNukeJobStatus)


@responses.activate
def test_projects_api_project_cleanup_jobs_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/projectCleanupJobs/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "jobs" : [ {
    "data" : [ {
      "message" : "message",
      "projectId" : "projectId",
      "status" : "BLOCKED"
    }, {
      "message" : "message",
      "projectId" : "projectId",
      "status" : "BLOCKED"
    }, {
      "message" : "message",
      "projectId" : "projectId",
      "status" : "BLOCKED"
    }, {
      "message" : "message",
      "projectId" : "projectId",
      "status" : "BLOCKED"
    }, {
      "message" : "message",
      "projectId" : "projectId",
      "status" : "BLOCKED"
    } ],
    "statusId" : "statusId",
    "created" : "2000-01-23T04:56:07.000+00:00",
    "message" : "message",
    "status" : "BLOCKED"
  }, {
    "data" : [ {
      "message" : "message",
      "projectId" : "projectId",
      "status" : "BLOCKED"
    }, {
      "message" : "message",
      "projectId" : "projectId",
      "status" : "BLOCKED"
    }, {
      "message" : "message",
      "projectId" : "projectId",
      "status" : "BLOCKED"
    }, {
      "message" : "message",
      "projectId" : "projectId",
      "status" : "BLOCKED"
    }, {
      "message" : "message",
      "projectId" : "projectId",
      "status" : "BLOCKED"
    } ],
    "statusId" : "statusId",
    "created" : "2000-01-23T04:56:07.000+00:00",
    "message" : "message",
    "status" : "BLOCKED"
  } ]
})
    )
    result = ProjectsApi.project_cleanup_jobs_list()
    assert isinstance(result, ProjectNukeJobListStatus)


@responses.activate
def test_projects_api_project_cleanup_jobs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projectCleanupJobs/{statusId}/'.format(endpoint=unittest_endpoint,
        statusId="statusId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "message" : "message",
    "projectId" : "projectId",
    "status" : "BLOCKED"
  }, {
    "message" : "message",
    "projectId" : "projectId",
    "status" : "BLOCKED"
  }, {
    "message" : "message",
    "projectId" : "projectId",
    "status" : "BLOCKED"
  }, {
    "message" : "message",
    "projectId" : "projectId",
    "status" : "BLOCKED"
  }, {
    "message" : "message",
    "projectId" : "projectId",
    "status" : "BLOCKED"
  } ],
  "statusId" : "statusId",
  "created" : "2000-01-23T04:56:07.000+00:00",
  "message" : "message",
  "status" : "BLOCKED"
})
    )
    result = ProjectsApi.project_cleanup_jobs_retrieve(status_id="statusId_example", )
    assert isinstance(result, ProjectNukeJobStatus)


@responses.activate
def test_projects_api_project_cleanup_jobs_summary_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projectCleanupJobs/{statusId}/summary/'.format(endpoint=unittest_endpoint,
        statusId="statusId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "summary" : {
    "expired" : 0,
    "aborted" : 0,
    "completed" : 0,
    "error" : 0
  },
  "jobId" : "jobId"
})
    )
    result = ProjectsApi.project_cleanup_jobs_summary_list(status_id="statusId_example", )
    assert isinstance(result, ProjectNukeJobStatusSummary)


@responses.activate
def test_projects_api_project_clones_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/projectClones/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "pid" : "pid"
})
    )
    result = ProjectsApi.project_clones_create()
    assert isinstance(result, ProjectCreateResponse)


@responses.activate
def test_projects_api_projects_access_control_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/accessControl/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "role" : "role",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  }, {
    "role" : "role",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  } ],
  "previous" : "previous",
  "count" : 0
})
    )
    result = ProjectsApi.projects_access_control_list(offset=0, limit=0, project_id="projectId_example", )
    assert isinstance(result, SharingListResponse)


@responses.activate
def test_projects_api_projects_access_control_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/projects/{projectId}/accessControl/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=204,
        content_type='',
    )
    result = ProjectsApi.projects_access_control_patch_many(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_aim_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/projects/{projectId}/aim/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = ProjectsApi.projects_aim_patch_many(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_autopilot_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/autopilot/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = ProjectsApi.projects_autopilot_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_autopilots_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/autopilots/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=201,
        content_type='',
    )
    result = ProjectsApi.projects_autopilots_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/projects/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "pid" : "pid"
})
    )
    result = ProjectsApi.projects_create()
    assert isinstance(result, ProjectCreateResponse)


@responses.activate
def test_projects_api_projects_cross_series_properties_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/crossSeriesProperties/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = ProjectsApi.projects_cross_series_properties_create(project_id="projectId_example", )
    assert isinstance(result, CrossSeriesGroupByColumnValidateResponse)


@responses.activate
def test_projects_api_projects_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/projects/{projectId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=204,
        content_type='',
    )
    result = ProjectsApi.projects_delete(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_external_time_series_baseline_data_validation_jobs_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/externalTimeSeriesBaselineDataValidationJobs/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = ProjectsApi.projects_external_time_series_baseline_data_validation_jobs_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_external_time_series_baseline_data_validation_jobs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/externalTimeSeriesBaselineDataValidationJobs/{baselineValidationJobId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", baselineValidationJobId="baselineValidationJobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "forecastWindowStart" : 0,
  "holdoutEndDate" : "2000-01-23T04:56:07.000+00:00",
  "baselineValidationJobId" : "baselineValidationJobId",
  "backtests" : [ {
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "validationStartDate" : "2000-01-23T04:56:07.000+00:00",
    "validationEndDate" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "message" : "message",
  "datetimePartitionColumn" : "datetimePartitionColumn",
  "target" : "target",
  "forecastWindowEnd" : 0,
  "isExternalBaselineDatasetValid" : True,
  "catalogVersionId" : "catalogVersionId",
  "holdoutStartDate" : "2000-01-23T04:56:07.000+00:00",
  "multiseriesIdColumns" : [ "multiseriesIdColumns" ],
  "projectId" : "projectId"
})
    )
    result = ProjectsApi.projects_external_time_series_baseline_data_validation_jobs_retrieve(project_id="projectId_example", baseline_validation_job_id="baselineValidationJobId_example", )
    assert isinstance(result, ExternalTSBaselineResponse)


@responses.activate
def test_projects_api_projects_features_multiseries_properties_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/features/{featureName}/multiseriesProperties/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featureName="featureName_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "detectedMultiseriesIdColumns" : [ {
    "timeStep" : 0,
    "multiseriesIdColumns" : [ "multiseriesIdColumns", "multiseriesIdColumns" ],
    "timeUnit" : "MILLISECOND"
  }, {
    "timeStep" : 0,
    "multiseriesIdColumns" : [ "multiseriesIdColumns", "multiseriesIdColumns" ],
    "timeUnit" : "MILLISECOND"
  } ],
  "datetimePartitionColumn" : "datetimePartitionColumn"
})
    )
    result = ProjectsApi.projects_features_multiseries_properties_list(project_id="projectId_example", feature_name="featureName_example", )
    assert isinstance(result, MultiseriesRetrieveResponse)


@responses.activate
def test_projects_api_projects_jobs_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/projects/{projectId}/jobs/{jobId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", jobId="jobId_example", ),
        status=204,
        content_type='',
    )
    result = ProjectsApi.projects_jobs_delete(project_id="projectId_example", job_id="jobId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_jobs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/jobs/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "previous" : "previous",
  "jobs" : [ {
    "modelId" : "modelId",
    "isBlocked" : True,
    "id" : "id",
    "jobType" : "model",
    "projectId" : "projectId",
    "url" : "url",
    "status" : "queue"
  }, {
    "modelId" : "modelId",
    "isBlocked" : True,
    "id" : "id",
    "jobType" : "model",
    "projectId" : "projectId",
    "url" : "url",
    "status" : "queue"
  } ],
  "count" : 0
})
    )
    result = ProjectsApi.projects_jobs_list(project_id="projectId_example", )
    assert isinstance(result, JobListResponse)


@responses.activate
def test_projects_api_projects_jobs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/jobs/{jobId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", jobId="jobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "isBlocked" : True,
  "id" : "id",
  "jobType" : "model",
  "projectId" : "projectId",
  "url" : "url",
  "status" : "queue"
})
    )
    result = ProjectsApi.projects_jobs_retrieve(project_id="projectId_example", job_id="jobId_example", )
    assert isinstance(result, JobDetailsResponse)


@responses.activate
def test_projects_api_projects_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/projects/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps([{
  "autopilotMode" : 2,
  "fileName" : "fileName",
  "minClusters" : 21,
  "useFeatureDiscovery" : True,
  "advancedOptions" : {
    "blueprintThreshold" : 0,
    "considerBlendersInRecommendation" : True,
    "offset" : [ "offset", "offset" ],
    "seed" : "seed",
    "prepareModelForDeployment" : True,
    "downsampledMinorityRows" : 1,
    "scoringCodeOnly" : True,
    "runLeakageRemovedFeatureList" : True,
    "smartDownsampled" : True,
    "weights" : "weights",
    "scaleoutModelingMode" : "disabled",
    "defaultMonotonicDecreasingFeaturelistId" : "defaultMonotonicDecreasingFeaturelistId",
    "shapOnlyMode" : True,
    "responseCap" : "",
    "downsampledMajorityRows" : 6,
    "onlyIncludeMonotonicBlueprints" : False,
    "exposure" : "exposure",
    "minSecondaryValidationModelCount" : True,
    "defaultMonotonicIncreasingFeaturelistId" : "defaultMonotonicIncreasingFeaturelistId",
    "allowedPairwiseInteractionGroups" : [ [ "allowedPairwiseInteractionGroups", "allowedPairwiseInteractionGroups" ], [ "allowedPairwiseInteractionGroups", "allowedPairwiseInteractionGroups" ] ],
    "blendBestModels" : True,
    "majorityDownsamplingRate" : 5.962133916683182,
    "eventsCount" : "eventsCount"
  },
  "scaleoutMaxTrainPct" : 1.4894159098541704,
  "holdoutUnlocked" : True,
  "maxTrainPct" : 9.301444243932576,
  "positiveClass" : 1.0246457001441578,
  "partition" : {
    "userPartitionCol" : "userPartitionCol",
    "reps" : 7.386281948385884,
    "validationPct" : 1.2315135367772556,
    "cvHoldoutLevel" : "",
    "validationType" : "CV",
    "cvMethod" : "random",
    "holdoutLevel" : "",
    "datetimePartitionColumn" : "datetimePartitionColumn",
    "holdoutPct" : 4.145608029883936,
    "datetimeCol" : "datetimeCol",
    "validationLevel" : "",
    "useTimeSeries" : True,
    "trainingLevel" : "",
    "partitionKeyCols" : "partitionKeyCols"
  },
  "id" : "id",
  "recommender" : {
    "isRecommender" : True,
    "recommenderUserId" : "recommenderUserId",
    "recommenderItemId" : "recommenderItemId"
  },
  "unsupervisedType" : "anomaly",
  "created" : "2000-01-23T04:56:07.000+00:00",
  "targetType" : "Binary",
  "maxTrainRows" : 3,
  "scaleoutMaxTrainRows" : 6,
  "target" : "target",
  "unsupervisedMode" : True,
  "autopilotClusterList" : [ 57, 57, 57, 57, 57 ],
  "maxClusters" : 71,
  "stage" : "stage",
  "metric" : "metric",
  "featureEngineeringPredictionPoint" : "featureEngineeringPredictionPoint",
  "projectName" : "projectName"
}])
    )
    result = ProjectsApi.projects_list()
    assert all(isinstance(item, ProjectDetailsResponse) for item in result)



@responses.activate
def test_projects_api_projects_multiseries_ids_cross_series_properties_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/multiseriesIds/{multiseriesId}/crossSeriesProperties/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", multiseriesId="multiseriesId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "multiseriesId" : "multiseriesId",
  "crossSeriesGroupByColumns" : [ {
    "name" : "name",
    "eligibility" : "eligibility",
    "isEligible" : True
  }, {
    "name" : "name",
    "eligibility" : "eligibility",
    "isEligible" : True
  } ]
})
    )
    result = ProjectsApi.projects_multiseries_ids_cross_series_properties_list(project_id="projectId_example", multiseries_id="multiseriesId_example", )
    assert isinstance(result, CrossSeriesGroupByColumnRetrieveResponse)


@responses.activate
def test_projects_api_projects_multiseries_properties_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/multiseriesProperties/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = ProjectsApi.projects_multiseries_properties_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/projects/{projectId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = ProjectsApi.projects_patch(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_relationships_configuration_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/relationshipsConfiguration/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "relationships" : [ {
    "featureDerivationWindowEnd" : 0,
    "dataset1Identifier" : "dataset1Identifier",
    "dataset2Keys" : [ "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys" ],
    "dataset1Keys" : [ "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys" ],
    "predictionPointRounding" : 4,
    "predictionPointRoundingTimeUnit" : "MILLISECOND",
    "dataset2Identifier" : "dataset2Identifier",
    "featureDerivationWindowStart" : 0,
    "featureDerivationWindowTimeUnit" : "MILLISECOND"
  }, {
    "featureDerivationWindowEnd" : 0,
    "dataset1Identifier" : "dataset1Identifier",
    "dataset2Keys" : [ "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys" ],
    "dataset1Keys" : [ "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys" ],
    "predictionPointRounding" : 4,
    "predictionPointRoundingTimeUnit" : "MILLISECOND",
    "dataset2Identifier" : "dataset2Identifier",
    "featureDerivationWindowStart" : 0,
    "featureDerivationWindowTimeUnit" : "MILLISECOND"
  } ],
  "featureDiscoverySettings" : [ {
    "name" : "name",
    "verboseName" : "verboseName",
    "description" : "description",
    "family" : "family",
    "settingType" : "settingType",
    "value" : True
  }, {
    "name" : "name",
    "verboseName" : "verboseName",
    "description" : "description",
    "family" : "family",
    "settingType" : "settingType",
    "value" : True
  } ],
  "datasetDefinitions" : [ {
    "identifier" : "identifier",
    "originalIdentifier" : "originalIdentifier",
    "catalogId" : "catalogId",
    "isDeleted" : True,
    "catalogVersionId" : "catalogVersionId",
    "featureListId" : "featureListId",
    "snapshotPolicy" : "specified",
    "primaryTemporalKey" : "primaryTemporalKey",
    "dataSource" : {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    },
    "dataSources" : [ {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    }, {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    } ],
    "featureLists" : [ "featureLists", "featureLists" ]
  }, {
    "identifier" : "identifier",
    "originalIdentifier" : "originalIdentifier",
    "catalogId" : "catalogId",
    "isDeleted" : True,
    "catalogVersionId" : "catalogVersionId",
    "featureListId" : "featureListId",
    "snapshotPolicy" : "specified",
    "primaryTemporalKey" : "primaryTemporalKey",
    "dataSource" : {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    },
    "dataSources" : [ {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    }, {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    } ],
    "featureLists" : [ "featureLists", "featureLists" ]
  } ],
  "snowflakePushDownCompatible" : True,
  "id" : "id",
  "featureDiscoveryMode" : "default"
})
    )
    result = ProjectsApi.projects_relationships_configuration_list(project_id="projectId_example", )
    assert isinstance(result, RelationshipsConfigResponse)


@responses.activate
def test_projects_api_projects_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "autopilotMode" : "0",
  "fileName" : "fileName",
  "minClusters" : 57,
  "useFeatureDiscovery" : True,
  "advancedOptions" : {
    "blueprintThreshold" : 0,
    "considerBlendersInRecommendation" : True,
    "offset" : [ "offset", "offset" ],
    "seed" : "seed",
    "prepareModelForDeployment" : True,
    "downsampledMinorityRows" : 1,
    "scoringCodeOnly" : True,
    "runLeakageRemovedFeatureList" : True,
    "smartDownsampled" : True,
    "weights" : "weights",
    "scaleoutModelingMode" : "disabled",
    "defaultMonotonicDecreasingFeaturelistId" : "defaultMonotonicDecreasingFeaturelistId",
    "shapOnlyMode" : True,
    "responseCap" : "",
    "downsampledMajorityRows" : 6,
    "onlyIncludeMonotonicBlueprints" : False,
    "exposure" : "exposure",
    "minSecondaryValidationModelCount" : True,
    "defaultMonotonicIncreasingFeaturelistId" : "defaultMonotonicIncreasingFeaturelistId",
    "allowedPairwiseInteractionGroups" : [ [ "allowedPairwiseInteractionGroups", "allowedPairwiseInteractionGroups" ], [ "allowedPairwiseInteractionGroups", "allowedPairwiseInteractionGroups" ] ],
    "blendBestModels" : True,
    "majorityDownsamplingRate" : 5.962133916683182,
    "eventsCount" : "eventsCount"
  },
  "scaleoutMaxTrainPct" : 3.616076749251911,
  "holdoutUnlocked" : True,
  "quickrun" : True,
  "maxTrainPct" : 1.4658129805029452,
  "externalTimeSeriesBaselineDatasetMetadata" : {
    "datasetName" : "datasetName",
    "datasetId" : "datasetId"
  },
  "positiveClass" : "",
  "catalogId" : "catalogId",
  "partition" : {
    "userPartitionCol" : "userPartitionCol",
    "reps" : 7,
    "validationPct" : 9.301444243932576,
    "cvHoldoutLevel" : "cvHoldoutLevel",
    "validationType" : "CV",
    "cvMethod" : "random",
    "holdoutLevel" : "holdoutLevel",
    "datetimePartitionColumn" : "datetimePartitionColumn",
    "holdoutPct" : 2.3021358869347655,
    "datetimeCol" : "datetimeCol",
    "validationLevel" : "validationLevel",
    "useTimeSeries" : True,
    "trainingLevel" : "trainingLevel",
    "partitionKeyCols" : "partitionKeyCols"
  },
  "catalogVersionId" : "catalogVersionId",
  "segmentation" : {
    "parentProjectId" : "parentProjectId",
    "segment" : "segment",
    "segmentationTaskId" : "segmentationTaskId"
  },
  "id" : "id",
  "recommender" : {
    "isRecommender" : True,
    "recommenderUserId" : "recommenderUserId",
    "recommenderItemId" : "recommenderItemId"
  },
  "unsupervisedType" : "anomaly",
  "created" : "2000-01-23T04:56:07.000+00:00",
  "automodelDeploymentId" : "automodelDeploymentId",
  "targetType" : "Binary",
  "maxTrainRows" : 5,
  "scaleoutMaxTrainRows" : 2,
  "target" : "target",
  "unsupervisedMode" : True,
  "autopilotClusterList" : [ 9, 9, 9, 9, 9 ],
  "maxClusters" : 61,
  "stage" : "modeling",
  "metric" : "metric",
  "featureEngineeringPredictionPoint" : "featureEngineeringPredictionPoint",
  "projectName" : "projectName"
})
    )
    result = ProjectsApi.projects_retrieve(project_id="projectId_example", )
    assert isinstance(result, ProjectRetrieveResponse)


@responses.activate
def test_projects_api_projects_secondary_datasets_configurations_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/secondaryDatasetsConfigurations/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = ProjectsApi.projects_secondary_datasets_configurations_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_secondary_datasets_configurations_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/projects/{projectId}/secondaryDatasetsConfigurations/{secondaryDatasetConfigId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", secondaryDatasetConfigId="secondaryDatasetConfigId_example", ),
        status=204,
        content_type='',
    )
    result = ProjectsApi.projects_secondary_datasets_configurations_delete(project_id="projectId_example", secondary_dataset_config_id="secondaryDatasetConfigId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_projects_api_projects_secondary_datasets_configurations_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/secondaryDatasetsConfigurations/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "creatorUserId" : "creatorUserId",
    "isDefault" : True,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "creatorFullName" : "creatorFullName",
    "credentialIds" : [ {
      "catalogVersionId" : "catalogVersionId",
      "credentialId" : "credentialId",
      "url" : "url"
    }, {
      "catalogVersionId" : "catalogVersionId",
      "credentialId" : "credentialId",
      "url" : "url"
    } ],
    "featurelistId" : "featurelistId",
    "id" : "id",
    "config" : [ {
      "featureEngineeringGraphId" : "featureEngineeringGraphId",
      "secondaryDatasets" : [ {
        "identifier" : "identifier",
        "catalogId" : "catalogId",
        "catalogVersionId" : "catalogVersionId",
        "snapshotPolicy" : "latest"
      }, {
        "identifier" : "identifier",
        "catalogId" : "catalogId",
        "catalogVersionId" : "catalogVersionId",
        "snapshotPolicy" : "latest"
      } ]
    }, {
      "featureEngineeringGraphId" : "featureEngineeringGraphId",
      "secondaryDatasets" : [ {
        "identifier" : "identifier",
        "catalogId" : "catalogId",
        "catalogVersionId" : "catalogVersionId",
        "snapshotPolicy" : "latest"
      }, {
        "identifier" : "identifier",
        "catalogId" : "catalogId",
        "catalogVersionId" : "catalogVersionId",
        "snapshotPolicy" : "latest"
      } ]
    } ],
    "projectId" : "projectId",
    "projectVersion" : "projectVersion",
    "secondaryDatasets" : [ {
      "identifier" : "identifier",
      "requiredFeatures" : [ "requiredFeatures", "requiredFeatures" ],
      "catalogId" : "catalogId",
      "catalogVersionId" : "catalogVersionId",
      "snapshotPolicy" : "specified"
    }, {
      "identifier" : "identifier",
      "requiredFeatures" : [ "requiredFeatures", "requiredFeatures" ],
      "catalogId" : "catalogId",
      "catalogVersionId" : "catalogVersionId",
      "snapshotPolicy" : "specified"
    } ]
  }, {
    "creatorUserId" : "creatorUserId",
    "isDefault" : True,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "creatorFullName" : "creatorFullName",
    "credentialIds" : [ {
      "catalogVersionId" : "catalogVersionId",
      "credentialId" : "credentialId",
      "url" : "url"
    }, {
      "catalogVersionId" : "catalogVersionId",
      "credentialId" : "credentialId",
      "url" : "url"
    } ],
    "featurelistId" : "featurelistId",
    "id" : "id",
    "config" : [ {
      "featureEngineeringGraphId" : "featureEngineeringGraphId",
      "secondaryDatasets" : [ {
        "identifier" : "identifier",
        "catalogId" : "catalogId",
        "catalogVersionId" : "catalogVersionId",
        "snapshotPolicy" : "latest"
      }, {
        "identifier" : "identifier",
        "catalogId" : "catalogId",
        "catalogVersionId" : "catalogVersionId",
        "snapshotPolicy" : "latest"
      } ]
    }, {
      "featureEngineeringGraphId" : "featureEngineeringGraphId",
      "secondaryDatasets" : [ {
        "identifier" : "identifier",
        "catalogId" : "catalogId",
        "catalogVersionId" : "catalogVersionId",
        "snapshotPolicy" : "latest"
      }, {
        "identifier" : "identifier",
        "catalogId" : "catalogId",
        "catalogVersionId" : "catalogVersionId",
        "snapshotPolicy" : "latest"
      } ]
    } ],
    "projectId" : "projectId",
    "projectVersion" : "projectVersion",
    "secondaryDatasets" : [ {
      "identifier" : "identifier",
      "requiredFeatures" : [ "requiredFeatures", "requiredFeatures" ],
      "catalogId" : "catalogId",
      "catalogVersionId" : "catalogVersionId",
      "snapshotPolicy" : "specified"
    }, {
      "identifier" : "identifier",
      "requiredFeatures" : [ "requiredFeatures", "requiredFeatures" ],
      "catalogId" : "catalogId",
      "catalogVersionId" : "catalogVersionId",
      "snapshotPolicy" : "specified"
    } ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = ProjectsApi.projects_secondary_datasets_configurations_list(project_id="projectId_example", )
    assert isinstance(result, SecondaryDatasetConfigListResponse)


@responses.activate
def test_projects_api_projects_secondary_datasets_configurations_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/secondaryDatasetsConfigurations/{secondaryDatasetConfigId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", secondaryDatasetConfigId="secondaryDatasetConfigId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "creatorUserId" : "creatorUserId",
  "isDefault" : True,
  "created" : "2000-01-23T04:56:07.000+00:00",
  "name" : "name",
  "creatorFullName" : "creatorFullName",
  "credentialIds" : [ {
    "catalogVersionId" : "catalogVersionId",
    "credentialId" : "credentialId",
    "url" : "url"
  }, {
    "catalogVersionId" : "catalogVersionId",
    "credentialId" : "credentialId",
    "url" : "url"
  } ],
  "featurelistId" : "featurelistId",
  "id" : "id",
  "config" : [ {
    "featureEngineeringGraphId" : "featureEngineeringGraphId",
    "secondaryDatasets" : [ {
      "identifier" : "identifier",
      "catalogId" : "catalogId",
      "catalogVersionId" : "catalogVersionId",
      "snapshotPolicy" : "latest"
    }, {
      "identifier" : "identifier",
      "catalogId" : "catalogId",
      "catalogVersionId" : "catalogVersionId",
      "snapshotPolicy" : "latest"
    } ]
  }, {
    "featureEngineeringGraphId" : "featureEngineeringGraphId",
    "secondaryDatasets" : [ {
      "identifier" : "identifier",
      "catalogId" : "catalogId",
      "catalogVersionId" : "catalogVersionId",
      "snapshotPolicy" : "latest"
    }, {
      "identifier" : "identifier",
      "catalogId" : "catalogId",
      "catalogVersionId" : "catalogVersionId",
      "snapshotPolicy" : "latest"
    } ]
  } ],
  "projectId" : "projectId",
  "projectVersion" : "projectVersion",
  "secondaryDatasets" : [ {
    "identifier" : "identifier",
    "requiredFeatures" : [ "requiredFeatures", "requiredFeatures" ],
    "catalogId" : "catalogId",
    "catalogVersionId" : "catalogVersionId",
    "snapshotPolicy" : "specified"
  }, {
    "identifier" : "identifier",
    "requiredFeatures" : [ "requiredFeatures", "requiredFeatures" ],
    "catalogId" : "catalogId",
    "catalogVersionId" : "catalogVersionId",
    "snapshotPolicy" : "specified"
  } ]
})
    )
    result = ProjectsApi.projects_secondary_datasets_configurations_retrieve(project_id="projectId_example", secondary_dataset_config_id="secondaryDatasetConfigId_example", )
    assert isinstance(result, ProjectSecondaryDatasetConfigResponse)


@responses.activate
def test_projects_api_projects_status_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/status/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "autopilotDone" : True,
  "stage" : "modeling",
  "stageDescription" : "stageDescription"
})
    )
    result = ProjectsApi.projects_status_list(project_id="projectId_example", )
    assert isinstance(result, ProjectStatusResponse)

