#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.create_rating_table_model import CreateRatingTableModel
from datarobot.models.testing_list.generated.model.rating_table_create_response import RatingTableCreateResponse
from datarobot.models.testing_list.generated.model.rating_table_list_response import RatingTableListResponse
from datarobot.models.testing_list.generated.model.rating_table_model_details_response import RatingTableModelDetailsResponse
from datarobot.models.testing_list.generated.model.rating_table_retrieve_response import RatingTableRetrieveResponse
from datarobot.models.testing_list.generated.model.rating_table_update import RatingTableUpdate
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.rating_tables_api import RatingTablesApi




@responses.activate
def test_rating_tables_api_projects_rating_table_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/ratingTableModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = RatingTablesApi.projects_rating_table_models_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_rating_tables_api_projects_rating_table_models_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/ratingTableModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps([{
  "samplePct" : 1.4658129805029452,
  "featurelistName" : "featurelistName",
  "modelFamily" : "modelFamily",
  "predictionThreshold" : 6.027456183070403,
  "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "id" : "id",
  "isFrozen" : True,
  "modelCategory" : "model",
  "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
  "supportsComposableMl" : True,
  "processes" : [ "processes", "processes" ],
  "linkFunction" : "linkFunction",
  "trainingDuration" : "trainingDuration",
  "parentModelId" : "parentModelId",
  "predictionThresholdReadOnly" : True,
  "isStarred" : True,
  "featurelistId" : "featurelistId",
  "modelType" : "modelType",
  "blueprintId" : "blueprintId",
  "supportsMonotonicConstraints" : True,
  "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
  "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "trainingRowCount" : 5,
  "modelNumber" : 0,
  "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": None,\n                    \"backtestingScores\": None,\n                    \"crossValidation\": 6000,\n                    \"training\": None\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": None,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": None,\n                    \"backtestingScores\": None,\n                    \"training\": None\n                },\n            }\n        }\n",
  "projectId" : "projectId",
  "ratingTableId" : "ratingTableId"
}])
    )
    result = RatingTablesApi.projects_rating_table_models_list(project_id="projectId_example", )
    assert all(isinstance(item, RatingTableModelDetailsResponse) for item in result)



@responses.activate
def test_rating_tables_api_projects_rating_table_models_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/ratingTableModels/{modelId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "samplePct" : 1.4658129805029452,
  "featurelistName" : "featurelistName",
  "modelFamily" : "modelFamily",
  "predictionThreshold" : 6.027456183070403,
  "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "id" : "id",
  "isFrozen" : True,
  "modelCategory" : "model",
  "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
  "supportsComposableMl" : True,
  "processes" : [ "processes", "processes" ],
  "linkFunction" : "linkFunction",
  "trainingDuration" : "trainingDuration",
  "parentModelId" : "parentModelId",
  "predictionThresholdReadOnly" : True,
  "isStarred" : True,
  "featurelistId" : "featurelistId",
  "modelType" : "modelType",
  "blueprintId" : "blueprintId",
  "supportsMonotonicConstraints" : True,
  "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
  "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "trainingRowCount" : 5,
  "modelNumber" : 0,
  "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": None,\n                    \"backtestingScores\": None,\n                    \"crossValidation\": 6000,\n                    \"training\": None\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": None,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": None,\n                    \"backtestingScores\": None,\n                    \"training\": None\n                },\n            }\n        }\n",
  "projectId" : "projectId",
  "ratingTableId" : "ratingTableId"
})
    )
    result = RatingTablesApi.projects_rating_table_models_retrieve(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, RatingTableModelDetailsResponse)


@responses.activate
def test_rating_tables_api_projects_rating_tables_create(unittest_endpoint, temporary_file):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/ratingTables/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", parentModelId="parent_model_id_example", ratingTableFile=open(temporary_file, 'rb'), ratingTableName="rating_table_name_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "ratingTableName" : "ratingTableName",
  "ratingTableId" : "ratingTableId"
})
    )
    result = RatingTablesApi.projects_rating_tables_create(project_id="projectId_example", parent_model_id="parent_model_id_example", rating_table_file=open(temporary_file, 'rb'), rating_table_name="rating_table_name_example", )
    assert isinstance(result, RatingTableCreateResponse)


@responses.activate
def test_rating_tables_api_projects_rating_tables_file_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/ratingTables/{ratingTableId}/file/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ratingTableId="ratingTableId_example", ),
        status=200,
        content_type='',
    )
    result = RatingTablesApi.projects_rating_tables_file_list(project_id="projectId_example", rating_table_id="ratingTableId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_rating_tables_api_projects_rating_tables_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/ratingTables/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "modelJobId" : 1,
    "validationWarnings" : "validationWarnings",
    "parentModelId" : "parentModelId",
    "modelId" : "modelId",
    "created" : 6.027456183070403,
    "ratingTableName" : "ratingTableName",
    "validationJobId" : "validationJobId",
    "id" : "id",
    "projectId" : "projectId",
    "originalFilename" : "originalFilename",
    "validationError" : "validationError"
  }, {
    "modelJobId" : 1,
    "validationWarnings" : "validationWarnings",
    "parentModelId" : "parentModelId",
    "modelId" : "modelId",
    "created" : 6.027456183070403,
    "ratingTableName" : "ratingTableName",
    "validationJobId" : "validationJobId",
    "id" : "id",
    "projectId" : "projectId",
    "originalFilename" : "originalFilename",
    "validationError" : "validationError"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = RatingTablesApi.projects_rating_tables_list(project_id="projectId_example", )
    assert isinstance(result, RatingTableListResponse)


@responses.activate
def test_rating_tables_api_projects_rating_tables_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/projects/{projectId}/ratingTables/{ratingTableId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ratingTableId="ratingTableId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelJobId" : 1,
  "validationWarnings" : "validationWarnings",
  "parentModelId" : "parentModelId",
  "modelId" : "modelId",
  "created" : 6.027456183070403,
  "ratingTableName" : "ratingTableName",
  "validationJobId" : "validationJobId",
  "id" : "id",
  "projectId" : "projectId",
  "originalFilename" : "originalFilename",
  "validationError" : "validationError"
})
    )
    result = RatingTablesApi.projects_rating_tables_patch(project_id="projectId_example", rating_table_id="ratingTableId_example", )
    assert isinstance(result, RatingTableRetrieveResponse)


@responses.activate
def test_rating_tables_api_projects_rating_tables_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/ratingTables/{ratingTableId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ratingTableId="ratingTableId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelJobId" : 1,
  "validationWarnings" : "validationWarnings",
  "parentModelId" : "parentModelId",
  "modelId" : "modelId",
  "created" : 6.027456183070403,
  "ratingTableName" : "ratingTableName",
  "validationJobId" : "validationJobId",
  "id" : "id",
  "projectId" : "projectId",
  "originalFilename" : "originalFilename",
  "validationError" : "validationError"
})
    )
    result = RatingTablesApi.projects_rating_tables_retrieve(project_id="projectId_example", rating_table_id="ratingTableId_example", )
    assert isinstance(result, RatingTableRetrieveResponse)

