#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.multiseries_histograms_retrieve_response import MultiseriesHistogramsRetrieveResponse
from datarobot.models.testing_list.generated.model.series_accuracy_compute import SeriesAccuracyCompute
from datarobot.models.testing_list.generated.model.series_accuracy_retrieve_response import SeriesAccuracyRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.series_insights_api import SeriesInsightsApi




@responses.activate
def test_series_insights_api_projects_datetime_models_multiseries_histograms_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/datetimeModels/{modelId}/multiseriesHistograms/'.format(endpoint=unittest_endpoint,
        attribute="rowCount", bins="10", projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "bins" : [ {
    "left" : "",
    "count" : 0,
    "right" : ""
  }, {
    "left" : "",
    "count" : 0,
    "right" : ""
  } ]
})
    )
    result = SeriesInsightsApi.projects_datetime_models_multiseries_histograms_list(attribute="rowCount", bins="10", project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, MultiseriesHistogramsRetrieveResponse)


@responses.activate
def test_series_insights_api_projects_datetime_models_multiseries_scores_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/projects/{projectId}/datetimeModels/{modelId}/multiseriesScores/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = SeriesInsightsApi.projects_datetime_models_multiseries_scores_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_series_insights_api_projects_datetime_models_multiseries_scores_file_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/datetimeModels/{modelId}/multiseriesScores/file/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='',
    )
    result = SeriesInsightsApi.projects_datetime_models_multiseries_scores_file_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_series_insights_api_projects_datetime_models_multiseries_scores_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/projects/{projectId}/datetimeModels/{modelId}/multiseriesScores/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "duration" : "duration",
    "backtestingScore" : 0.8008281904610115,
    "multiseriesId" : "multiseriesId",
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "multiseriesValues" : [ "multiseriesValues", "multiseriesValues" ],
    "validationScore" : 5.962133916683182,
    "holdoutScore" : 6.027456183070403,
    "rowCount" : 1,
    "targetAverage" : "",
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "duration" : "duration",
    "backtestingScore" : 0.8008281904610115,
    "multiseriesId" : "multiseriesId",
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "multiseriesValues" : [ "multiseriesValues", "multiseriesValues" ],
    "validationScore" : 5.962133916683182,
    "holdoutScore" : 6.027456183070403,
    "rowCount" : 1,
    "targetAverage" : "",
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "previous" : "previous",
  "querySeriesCount" : 5,
  "totalSeriesCount" : 2
})
    )
    result = SeriesInsightsApi.projects_datetime_models_multiseries_scores_list(offset=0, limit=100, project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, SeriesAccuracyRetrieveResponse)

