#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.status_list_response import StatusListResponse
from datarobot.models.testing_list.generated.model.status_retrieve_response import StatusRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.status_api import StatusApi




@responses.activate
def test_status_api_status_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/status/{statusId}/'.format(endpoint=unittest_endpoint,
        statusId="statusId_example", ),
        status=204,
        content_type='',
    )
    result = StatusApi.status_delete(status_id="statusId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_status_api_status_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/status/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "code" : 6,
    "statusId" : "statusId",
    "statusType" : "statusType",
    "created" : "2000-01-23T04:56:07.000+00:00",
    "description" : "description",
    "message" : "message",
    "type" : "LearningSession",
    "status" : "EXPIRED"
  }, {
    "code" : 6,
    "statusId" : "statusId",
    "statusType" : "statusType",
    "created" : "2000-01-23T04:56:07.000+00:00",
    "description" : "description",
    "message" : "message",
    "type" : "LearningSession",
    "status" : "EXPIRED"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = StatusApi.status_list(offset=0, limit=0, )
    assert isinstance(result, StatusListResponse)


@responses.activate
def test_status_api_status_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/status/{statusId}/'.format(endpoint=unittest_endpoint,
        statusId="statusId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "code" : 6,
  "statusId" : "statusId",
  "statusType" : "statusType",
  "created" : "2000-01-23T04:56:07.000+00:00",
  "description" : "description",
  "message" : "message",
  "type" : "LearningSession",
  "status" : "EXPIRED"
})
    )
    result = StatusApi.status_retrieve(status_id="statusId_example", )
    assert isinstance(result, StatusRetrieveResponse)

