#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing_list.generated.model.create_remote_event_response import CreateRemoteEventResponse
from datarobot.models.testing_list.generated.model.notification_channel_create import NotificationChannelCreate
from datarobot.models.testing_list.generated.model.notification_channel_response import NotificationChannelResponse
from datarobot.models.testing_list.generated.model.notification_channel_update import NotificationChannelUpdate
from datarobot.models.testing_list.generated.model.notification_channels_list_response import NotificationChannelsListResponse
from datarobot.models.testing_list.generated.model.notification_email_channel_verification import NotificationEmailChannelVerification
from datarobot.models.testing_list.generated.model.notification_email_channel_verification_response import NotificationEmailChannelVerificationResponse
from datarobot.models.testing_list.generated.model.notification_email_channel_verification_status import NotificationEmailChannelVerificationStatus
from datarobot.models.testing_list.generated.model.notification_email_channel_verification_status_response import NotificationEmailChannelVerificationStatusResponse
from datarobot.models.testing_list.generated.model.notification_policies_list_response import NotificationPoliciesListResponse
from datarobot.models.testing_list.generated.model.notification_policy_create import NotificationPolicyCreate
from datarobot.models.testing_list.generated.model.notification_policy_response import NotificationPolicyResponse
from datarobot.models.testing_list.generated.model.notification_policy_update import NotificationPolicyUpdate
from datarobot.models.testing_list.generated.model.notification_webhook_channel_status_response import NotificationWebhookChannelStatusResponse
from datarobot.models.testing_list.generated.model.notification_webhook_channel_test_create import NotificationWebhookChannelTestCreate
from datarobot.models.testing_list.generated.model.notification_webhook_channel_test_id import NotificationWebhookChannelTestId
from datarobot.models.testing_list.generated.model.remote_event_create import RemoteEventCreate
from datarobot.models.testing_list.generated.model.user_notification_list_response import UserNotificationListResponse
from datarobot.utils import from_api
from datarobot.models.testing_list.generated.model import *

from datarobot.models.testing_list.generated.api.user_notifications_api import UserNotificationsApi




@responses.activate
def test_user_notifications_api_notification_channels_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/notificationChannels/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "secretToken" : "secretToken",
  "validateSsl" : True,
  "channelType" : "Database",
  "lastNotificationAt" : "2000-01-23T04:56:07.000+00:00",
  "languageCode" : "en",
  "orgId" : "orgId",
  "payloadUrl" : "https://openapi-generator.tech",
  "createdAt" : "2000-01-23T04:56:07.000+00:00",
  "uid" : "uid",
  "emailAddress" : "emailAddress",
  "policyCount" : 6,
  "name" : "name",
  "id" : "id",
  "contentType" : "application/x-www-form-urlencoded",
  "customHeaders" : [ {
    "name" : "name",
    "value" : "value"
  }, {
    "name" : "name",
    "value" : "value"
  } ]
})
    )
    result = UserNotificationsApi.notification_channels_create()
    assert isinstance(result, NotificationChannelResponse)


@responses.activate
def test_user_notifications_api_notification_channels_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/notificationChannels/{channelId}/'.format(endpoint=unittest_endpoint,
        channelId="channelId_example", ),
        status=204,
        content_type='',
    )
    result = UserNotificationsApi.notification_channels_delete(channel_id="channelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_user_notifications_api_notification_channels_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/notificationChannels/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "secretToken" : "secretToken",
    "validateSsl" : True,
    "channelType" : "Database",
    "lastNotificationAt" : "2000-01-23T04:56:07.000+00:00",
    "languageCode" : "en",
    "orgId" : "orgId",
    "payloadUrl" : "https://openapi-generator.tech",
    "createdAt" : "2000-01-23T04:56:07.000+00:00",
    "uid" : "uid",
    "emailAddress" : "emailAddress",
    "policyCount" : 6,
    "name" : "name",
    "id" : "id",
    "contentType" : "application/x-www-form-urlencoded",
    "customHeaders" : [ {
      "name" : "name",
      "value" : "value"
    }, {
      "name" : "name",
      "value" : "value"
    } ]
  }, {
    "secretToken" : "secretToken",
    "validateSsl" : True,
    "channelType" : "Database",
    "lastNotificationAt" : "2000-01-23T04:56:07.000+00:00",
    "languageCode" : "en",
    "orgId" : "orgId",
    "payloadUrl" : "https://openapi-generator.tech",
    "createdAt" : "2000-01-23T04:56:07.000+00:00",
    "uid" : "uid",
    "emailAddress" : "emailAddress",
    "policyCount" : 6,
    "name" : "name",
    "id" : "id",
    "contentType" : "application/x-www-form-urlencoded",
    "customHeaders" : [ {
      "name" : "name",
      "value" : "value"
    }, {
      "name" : "name",
      "value" : "value"
    } ]
  } ],
  "previous" : "previous",
  "count" : 0,
  "totalCount" : 1
})
    )
    result = UserNotificationsApi.notification_channels_list(offset=0, limit=100, )
    assert isinstance(result, NotificationChannelsListResponse)


@responses.activate
def test_user_notifications_api_notification_channels_put(unittest_endpoint):
    responses.add(
        responses.PUT,
        '{endpoint}/notificationChannels/{channelId}/'.format(endpoint=unittest_endpoint,
        channelId="channelId_example", ),
        status=204,
        content_type='',
    )
    result = UserNotificationsApi.notification_channels_put(channel_id="channelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_user_notifications_api_notification_channels_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/notificationChannels/{channelId}/'.format(endpoint=unittest_endpoint,
        channelId="channelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "secretToken" : "secretToken",
  "validateSsl" : True,
  "channelType" : "Database",
  "lastNotificationAt" : "2000-01-23T04:56:07.000+00:00",
  "languageCode" : "en",
  "orgId" : "orgId",
  "payloadUrl" : "https://openapi-generator.tech",
  "createdAt" : "2000-01-23T04:56:07.000+00:00",
  "uid" : "uid",
  "emailAddress" : "emailAddress",
  "policyCount" : 6,
  "name" : "name",
  "id" : "id",
  "contentType" : "application/x-www-form-urlencoded",
  "customHeaders" : [ {
    "name" : "name",
    "value" : "value"
  }, {
    "name" : "name",
    "value" : "value"
  } ]
})
    )
    result = UserNotificationsApi.notification_channels_retrieve(channel_id="channelId_example", )
    assert isinstance(result, NotificationChannelResponse)


@responses.activate
def test_user_notifications_api_notification_email_channel_verification_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/notificationEmailChannelVerification/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "notificationId" : "notificationId"
})
    )
    result = UserNotificationsApi.notification_email_channel_verification_create()
    assert isinstance(result, NotificationEmailChannelVerificationResponse)


@responses.activate
def test_user_notifications_api_notification_email_channel_verification_status_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/notificationEmailChannelVerificationStatus/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "status" : True
})
    )
    result = UserNotificationsApi.notification_email_channel_verification_status_create()
    assert isinstance(result, NotificationEmailChannelVerificationStatusResponse)


@responses.activate
def test_user_notifications_api_notification_policies_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/notificationPolicies/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "lastTriggered" : "2000-01-23T04:56:07.000+00:00",
  "uid" : "uid",
  "created" : "2000-01-23T04:56:07.000+00:00",
  "channel" : {
    "secretToken" : "secretToken",
    "validateSsl" : True,
    "channelType" : "Database",
    "languageCode" : "en",
    "orgId" : "orgId",
    "payloadUrl" : "https://openapi-generator.tech",
    "createdAt" : "2000-01-23T04:56:07.000+00:00",
    "uid" : "uid",
    "emailAddress" : "emailAddress",
    "name" : "name",
    "id" : "id",
    "contentType" : "application/x-www-form-urlencoded",
    "customHeaders" : [ {
      "name" : "name",
      "value" : "value"
    }, {
      "name" : "name",
      "value" : "value"
    } ]
  },
  "name" : "name",
  "active" : True,
  "eventType" : {
    "id" : "id",
    "label" : "label"
  },
  "id" : "id",
  "eventGroup" : {
    "id" : "id",
    "label" : "label",
    "events" : [ {
      "id" : "id",
      "label" : "label"
    }, {
      "id" : "id",
      "label" : "label"
    } ]
  },
  "channelId" : "channelId",
  "orgId" : "orgId"
})
    )
    result = UserNotificationsApi.notification_policies_create()
    assert isinstance(result, NotificationPolicyResponse)


@responses.activate
def test_user_notifications_api_notification_policies_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/notificationPolicies/{policyId}/'.format(endpoint=unittest_endpoint,
        policyId="policyId_example", ),
        status=204,
        content_type='',
    )
    result = UserNotificationsApi.notification_policies_delete(policy_id="policyId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_user_notifications_api_notification_policies_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/notificationPolicies/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "lastTriggered" : "2000-01-23T04:56:07.000+00:00",
    "uid" : "uid",
    "created" : "2000-01-23T04:56:07.000+00:00",
    "channel" : {
      "secretToken" : "secretToken",
      "validateSsl" : True,
      "channelType" : "Database",
      "languageCode" : "en",
      "orgId" : "orgId",
      "payloadUrl" : "https://openapi-generator.tech",
      "createdAt" : "2000-01-23T04:56:07.000+00:00",
      "uid" : "uid",
      "emailAddress" : "emailAddress",
      "name" : "name",
      "id" : "id",
      "contentType" : "application/x-www-form-urlencoded",
      "customHeaders" : [ {
        "name" : "name",
        "value" : "value"
      }, {
        "name" : "name",
        "value" : "value"
      } ]
    },
    "name" : "name",
    "active" : True,
    "eventType" : {
      "id" : "id",
      "label" : "label"
    },
    "id" : "id",
    "eventGroup" : {
      "id" : "id",
      "label" : "label",
      "events" : [ {
        "id" : "id",
        "label" : "label"
      }, {
        "id" : "id",
        "label" : "label"
      } ]
    },
    "channelId" : "channelId",
    "orgId" : "orgId"
  }, {
    "lastTriggered" : "2000-01-23T04:56:07.000+00:00",
    "uid" : "uid",
    "created" : "2000-01-23T04:56:07.000+00:00",
    "channel" : {
      "secretToken" : "secretToken",
      "validateSsl" : True,
      "channelType" : "Database",
      "languageCode" : "en",
      "orgId" : "orgId",
      "payloadUrl" : "https://openapi-generator.tech",
      "createdAt" : "2000-01-23T04:56:07.000+00:00",
      "uid" : "uid",
      "emailAddress" : "emailAddress",
      "name" : "name",
      "id" : "id",
      "contentType" : "application/x-www-form-urlencoded",
      "customHeaders" : [ {
        "name" : "name",
        "value" : "value"
      }, {
        "name" : "name",
        "value" : "value"
      } ]
    },
    "name" : "name",
    "active" : True,
    "eventType" : {
      "id" : "id",
      "label" : "label"
    },
    "id" : "id",
    "eventGroup" : {
      "id" : "id",
      "label" : "label",
      "events" : [ {
        "id" : "id",
        "label" : "label"
      }, {
        "id" : "id",
        "label" : "label"
      } ]
    },
    "channelId" : "channelId",
    "orgId" : "orgId"
  } ],
  "previous" : "previous",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = UserNotificationsApi.notification_policies_list(offset=0, limit=100, )
    assert isinstance(result, NotificationPoliciesListResponse)


@responses.activate
def test_user_notifications_api_notification_policies_put(unittest_endpoint):
    responses.add(
        responses.PUT,
        '{endpoint}/notificationPolicies/{policyId}/'.format(endpoint=unittest_endpoint,
        policyId="policyId_example", ),
        status=204,
        content_type='',
    )
    result = UserNotificationsApi.notification_policies_put(policy_id="policyId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_user_notifications_api_notification_policies_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/notificationPolicies/{policyId}/'.format(endpoint=unittest_endpoint,
        policyId="policyId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "lastTriggered" : "2000-01-23T04:56:07.000+00:00",
  "uid" : "uid",
  "created" : "2000-01-23T04:56:07.000+00:00",
  "channel" : {
    "secretToken" : "secretToken",
    "validateSsl" : True,
    "channelType" : "Database",
    "languageCode" : "en",
    "orgId" : "orgId",
    "payloadUrl" : "https://openapi-generator.tech",
    "createdAt" : "2000-01-23T04:56:07.000+00:00",
    "uid" : "uid",
    "emailAddress" : "emailAddress",
    "name" : "name",
    "id" : "id",
    "contentType" : "application/x-www-form-urlencoded",
    "customHeaders" : [ {
      "name" : "name",
      "value" : "value"
    }, {
      "name" : "name",
      "value" : "value"
    } ]
  },
  "name" : "name",
  "active" : True,
  "eventType" : {
    "id" : "id",
    "label" : "label"
  },
  "id" : "id",
  "eventGroup" : {
    "id" : "id",
    "label" : "label",
    "events" : [ {
      "id" : "id",
      "label" : "label"
    }, {
      "id" : "id",
      "label" : "label"
    } ]
  },
  "channelId" : "channelId",
  "orgId" : "orgId"
})
    )
    result = UserNotificationsApi.notification_policies_retrieve(policy_id="policyId_example", )
    assert isinstance(result, NotificationPolicyResponse)


@responses.activate
def test_user_notifications_api_notification_webhook_channel_tests_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/notificationWebhookChannelTests/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "notificationId" : "notificationId"
})
    )
    result = UserNotificationsApi.notification_webhook_channel_tests_create()
    assert isinstance(result, NotificationWebhookChannelTestId)


@responses.activate
def test_user_notifications_api_notification_webhook_channel_tests_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/notificationWebhookChannelTests/{notificationId}/'.format(endpoint=unittest_endpoint,
        notificationId="notificationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "notificationLog" : {
    "request" : "request",
    "parentNotificationId" : "parentNotificationId",
    "policyId" : "policyId",
    "response" : "response",
    "retryCount" : 0,
    "id" : "id",
    "emailSubject" : "emailSubject",
    "channelId" : "channelId",
    "status" : "status",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  },
  "status" : "status"
})
    )
    result = UserNotificationsApi.notification_webhook_channel_tests_retrieve(notification_id="notificationId_example", )
    assert isinstance(result, NotificationWebhookChannelStatusResponse)


@responses.activate
def test_user_notifications_api_remote_events_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/remoteEvents/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = UserNotificationsApi.remote_events_create()
    assert isinstance(result, CreateRemoteEventResponse)


@responses.activate
def test_user_notifications_api_user_notifications_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/userNotifications/{userNotificationId}/'.format(endpoint=unittest_endpoint,
        userNotificationId="userNotificationId_example", ),
        status=204,
        content_type='',
    )
    result = UserNotificationsApi.user_notifications_delete(user_notification_id="userNotificationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_user_notifications_api_user_notifications_delete_many(unittest_endpoint):
    responses.add(
        responses.DELETE,
       '{endpoint}/userNotifications/'.format(endpoint=unittest_endpoint),
        status=204,
        content_type='',
    )
    result = UserNotificationsApi.user_notifications_delete_many()
    assert isinstance(result, type(None))


@responses.activate
def test_user_notifications_api_user_notifications_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/userNotifications/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "relatedUsersDelete" : {
      "usersToDeleteCount" : "usersToDeleteCount",
      "reportId" : "reportId",
      "statusId" : "statusId"
    },
    "sharedUsers" : [ {
      "gravatarHash" : "gravatarHash",
      "uid" : "uid",
      "inactive" : True,
      "fullName" : "fullName",
      "username" : "username"
    }, {
      "gravatarHash" : "gravatarHash",
      "uid" : "uid",
      "inactive" : True,
      "fullName" : "fullName",
      "username" : "username"
    } ],
    "created" : "2000-01-23T04:56:07.000+00:00",
    "isRead" : True,
    "link" : "link",
    "description" : "description",
    "callerUser" : {
      "gravatarHash" : "gravatarHash",
      "uid" : "uid",
      "inactive" : True,
      "fullName" : "fullName",
      "username" : "username"
    },
    "eventType" : "autopilot.complete",
    "title" : "title",
    "userNotificationId" : "userNotificationId",
    "relatedDeployment" : {
      "inactive" : True,
      "modelId" : "modelId",
      "deploymentId" : "deploymentId",
      "deploymentUrl" : "deploymentUrl",
      "deploymentName" : "deploymentName",
      "projectId" : "projectId",
      "userId" : "userId"
    },
    "statusId" : "statusId",
    "pushNotificationSent" : True,
    "relatedProject" : {
      "inactive" : True,
      "projectLink" : "projectLink",
      "pid" : "pid",
      "projectName" : "projectName"
    },
    "relatedComment" : {
      "inactive" : True,
      "commentLink" : "commentLink",
      "entityType" : "useCase",
      "commentId" : "commentId",
      "entityId" : "entityId"
    },
    "updated" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "relatedUsersDelete" : {
      "usersToDeleteCount" : "usersToDeleteCount",
      "reportId" : "reportId",
      "statusId" : "statusId"
    },
    "sharedUsers" : [ {
      "gravatarHash" : "gravatarHash",
      "uid" : "uid",
      "inactive" : True,
      "fullName" : "fullName",
      "username" : "username"
    }, {
      "gravatarHash" : "gravatarHash",
      "uid" : "uid",
      "inactive" : True,
      "fullName" : "fullName",
      "username" : "username"
    } ],
    "created" : "2000-01-23T04:56:07.000+00:00",
    "isRead" : True,
    "link" : "link",
    "description" : "description",
    "callerUser" : {
      "gravatarHash" : "gravatarHash",
      "uid" : "uid",
      "inactive" : True,
      "fullName" : "fullName",
      "username" : "username"
    },
    "eventType" : "autopilot.complete",
    "title" : "title",
    "userNotificationId" : "userNotificationId",
    "relatedDeployment" : {
      "inactive" : True,
      "modelId" : "modelId",
      "deploymentId" : "deploymentId",
      "deploymentUrl" : "deploymentUrl",
      "deploymentName" : "deploymentName",
      "projectId" : "projectId",
      "userId" : "userId"
    },
    "statusId" : "statusId",
    "pushNotificationSent" : True,
    "relatedProject" : {
      "inactive" : True,
      "projectLink" : "projectLink",
      "pid" : "pid",
      "projectName" : "projectName"
    },
    "relatedComment" : {
      "inactive" : True,
      "commentLink" : "commentLink",
      "entityType" : "useCase",
      "commentId" : "commentId",
      "entityId" : "entityId"
    },
    "updated" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = UserNotificationsApi.user_notifications_list()
    assert isinstance(result, UserNotificationListResponse)


@responses.activate
def test_user_notifications_api_user_notifications_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/userNotifications/{userNotificationId}/'.format(endpoint=unittest_endpoint,
        userNotificationId="userNotificationId_example", ),
        status=204,
        content_type='',
    )
    result = UserNotificationsApi.user_notifications_patch(user_notification_id="userNotificationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_user_notifications_api_user_notifications_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
       '{endpoint}/userNotifications/'.format(endpoint=unittest_endpoint),
        status=204,
        content_type='',
    )
    result = UserNotificationsApi.user_notifications_patch_many()
    assert isinstance(result, type(None))
