import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export interface CfnListenerProps {
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions
     */
    readonly defaultActions: Array<CfnListener.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.LoadBalancerArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-loadbalancerarn
     */
    readonly loadBalancerArn: string;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.AlpnPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-alpnpolicy
     */
    readonly alpnPolicy?: string[];
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Certificates`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates
     */
    readonly certificates?: Array<CfnListener.CertificateProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-port
     */
    readonly port?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-protocol
     */
    readonly protocol?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.SslPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-sslpolicy
     */
    readonly sslPolicy?: string;
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export declare class CfnListener extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancingV2::Listener";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnListener;
    /**
     * @external
     * @cloudformationAttribute ListenerArn
     */
    readonly attrListenerArn: string;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions
     */
    defaultActions: Array<CfnListener.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.LoadBalancerArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-loadbalancerarn
     */
    loadBalancerArn: string;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.AlpnPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-alpnpolicy
     */
    alpnPolicy: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Certificates`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates
     */
    certificates: Array<CfnListener.CertificateProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-port
     */
    port: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-protocol
     */
    protocol: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.SslPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-sslpolicy
     */
    sslPolicy: string | undefined;
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::Listener`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnListenerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export declare namespace CfnListener {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html
     */
    interface ActionProperty {
        /**
         * `CfnListener.ActionProperty.AuthenticateCognitoConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
         */
        readonly authenticateCognitoConfig?: CfnListener.AuthenticateCognitoConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ActionProperty.AuthenticateOidcConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
         */
        readonly authenticateOidcConfig?: CfnListener.AuthenticateOidcConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ActionProperty.FixedResponseConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
         */
        readonly fixedResponseConfig?: CfnListener.FixedResponseConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ActionProperty.ForwardConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-forwardconfig
         */
        readonly forwardConfig?: CfnListener.ForwardConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ActionProperty.Order`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-order
         */
        readonly order?: number;
        /**
         * `CfnListener.ActionProperty.RedirectConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
         */
        readonly redirectConfig?: CfnListener.RedirectConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ActionProperty.TargetGroupArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-targetgrouparn
         */
        readonly targetGroupArn?: string;
        /**
         * `CfnListener.ActionProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export declare namespace CfnListener {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html
     */
    interface AuthenticateCognitoConfigProperty {
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
         */
        readonly authenticationRequestExtraParams?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
         */
        readonly onUnauthenticatedRequest?: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.Scope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
         */
        readonly scope?: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.SessionCookieName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
         */
        readonly sessionCookieName?: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.SessionTimeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
         */
        readonly sessionTimeout?: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
         */
        readonly userPoolArn: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolClientId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
         */
        readonly userPoolClientId: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolDomain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
         */
        readonly userPoolDomain: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export declare namespace CfnListener {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html
     */
    interface AuthenticateOidcConfigProperty {
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
         */
        readonly authenticationRequestExtraParams?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
         */
        readonly authorizationEndpoint: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.ClientId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
         */
        readonly clientId: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.ClientSecret`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
         */
        readonly clientSecret: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.Issuer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
         */
        readonly issuer: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
         */
        readonly onUnauthenticatedRequest?: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.Scope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
         */
        readonly scope?: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.SessionCookieName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
         */
        readonly sessionCookieName?: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.SessionTimeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
         */
        readonly sessionTimeout?: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.TokenEndpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
         */
        readonly tokenEndpoint: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
         */
        readonly userInfoEndpoint: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export declare namespace CfnListener {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificate.html
     */
    interface CertificateProperty {
        /**
         * `CfnListener.CertificateProperty.CertificateArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificate.html#cfn-elasticloadbalancingv2-listener-certificate-certificatearn
         */
        readonly certificateArn?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export declare namespace CfnListener {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html
     */
    interface FixedResponseConfigProperty {
        /**
         * `CfnListener.FixedResponseConfigProperty.ContentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
         */
        readonly contentType?: string;
        /**
         * `CfnListener.FixedResponseConfigProperty.MessageBody`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
         */
        readonly messageBody?: string;
        /**
         * `CfnListener.FixedResponseConfigProperty.StatusCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
         */
        readonly statusCode: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export declare namespace CfnListener {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html
     */
    interface ForwardConfigProperty {
        /**
         * `CfnListener.ForwardConfigProperty.TargetGroupStickinessConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html#cfn-elasticloadbalancingv2-listener-forwardconfig-targetgroupstickinessconfig
         */
        readonly targetGroupStickinessConfig?: CfnListener.TargetGroupStickinessConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ForwardConfigProperty.TargetGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html#cfn-elasticloadbalancingv2-listener-forwardconfig-targetgroups
         */
        readonly targetGroups?: Array<CfnListener.TargetGroupTupleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export declare namespace CfnListener {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html
     */
    interface RedirectConfigProperty {
        /**
         * `CfnListener.RedirectConfigProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
         */
        readonly host?: string;
        /**
         * `CfnListener.RedirectConfigProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
         */
        readonly path?: string;
        /**
         * `CfnListener.RedirectConfigProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
         */
        readonly port?: string;
        /**
         * `CfnListener.RedirectConfigProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
         */
        readonly protocol?: string;
        /**
         * `CfnListener.RedirectConfigProperty.Query`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
         */
        readonly query?: string;
        /**
         * `CfnListener.RedirectConfigProperty.StatusCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
         */
        readonly statusCode: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export declare namespace CfnListener {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html
     */
    interface TargetGroupStickinessConfigProperty {
        /**
         * `CfnListener.TargetGroupStickinessConfigProperty.DurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listener-targetgroupstickinessconfig-durationseconds
         */
        readonly durationSeconds?: number;
        /**
         * `CfnListener.TargetGroupStickinessConfigProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listener-targetgroupstickinessconfig-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
export declare namespace CfnListener {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html
     */
    interface TargetGroupTupleProperty {
        /**
         * `CfnListener.TargetGroupTupleProperty.TargetGroupArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html#cfn-elasticloadbalancingv2-listener-targetgrouptuple-targetgrouparn
         */
        readonly targetGroupArn?: string;
        /**
         * `CfnListener.TargetGroupTupleProperty.Weight`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html#cfn-elasticloadbalancingv2-listener-targetgrouptuple-weight
         */
        readonly weight?: number;
    }
}
/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::ListenerCertificate`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html
 */
export interface CfnListenerCertificateProps {
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
     */
    readonly certificates: Array<CfnListenerCertificate.CertificateProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
     */
    readonly listenerArn: string;
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerCertificate`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerCertificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html
 */
export declare class CfnListenerCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancingV2::ListenerCertificate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnListenerCertificate;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
     */
    certificates: Array<CfnListenerCertificate.CertificateProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
     */
    listenerArn: string;
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::ListenerCertificate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnListenerCertificateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerCertificate`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerCertificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html
 */
export declare namespace CfnListenerCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html
     */
    interface CertificateProperty {
        /**
         * `CfnListenerCertificate.CertificateProperty.CertificateArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         */
        readonly certificateArn?: string;
    }
}
/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export interface CfnListenerRuleProps {
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     */
    readonly actions: Array<CfnListenerRule.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     */
    readonly conditions: Array<CfnListenerRule.RuleConditionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn
     */
    readonly listenerArn: string;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority
     */
    readonly priority: number;
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare class CfnListenerRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancingV2::ListenerRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnListenerRule;
    /**
     * @external
     * @cloudformationAttribute IsDefault
     */
    readonly attrIsDefault: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute RuleArn
     */
    readonly attrRuleArn: string;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     */
    actions: Array<CfnListenerRule.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     */
    conditions: Array<CfnListenerRule.RuleConditionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn
     */
    listenerArn: string;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority
     */
    priority: number;
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::ListenerRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnListenerRuleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html
     */
    interface ActionProperty {
        /**
         * `CfnListenerRule.ActionProperty.AuthenticateCognitoConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticatecognitoconfig
         */
        readonly authenticateCognitoConfig?: CfnListenerRule.AuthenticateCognitoConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ActionProperty.AuthenticateOidcConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticateoidcconfig
         */
        readonly authenticateOidcConfig?: CfnListenerRule.AuthenticateOidcConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ActionProperty.FixedResponseConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-fixedresponseconfig
         */
        readonly fixedResponseConfig?: CfnListenerRule.FixedResponseConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ActionProperty.ForwardConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-forwardconfig
         */
        readonly forwardConfig?: CfnListenerRule.ForwardConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ActionProperty.Order`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-order
         */
        readonly order?: number;
        /**
         * `CfnListenerRule.ActionProperty.RedirectConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-redirectconfig
         */
        readonly redirectConfig?: CfnListenerRule.RedirectConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ActionProperty.TargetGroupArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-targetgrouparn
         */
        readonly targetGroupArn?: string;
        /**
         * `CfnListenerRule.ActionProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html
     */
    interface AuthenticateCognitoConfigProperty {
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-authenticationrequestextraparams
         */
        readonly authenticationRequestExtraParams?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-onunauthenticatedrequest
         */
        readonly onUnauthenticatedRequest?: string;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.Scope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-scope
         */
        readonly scope?: string;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionCookieName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessioncookiename
         */
        readonly sessionCookieName?: string;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionTimeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessiontimeout
         */
        readonly sessionTimeout?: number;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolarn
         */
        readonly userPoolArn: string;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolClientId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolclientid
         */
        readonly userPoolClientId: string;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolDomain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpooldomain
         */
        readonly userPoolDomain: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html
     */
    interface AuthenticateOidcConfigProperty {
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authenticationrequestextraparams
         */
        readonly authenticationRequestExtraParams?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authorizationendpoint
         */
        readonly authorizationEndpoint: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.ClientId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientid
         */
        readonly clientId: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.ClientSecret`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientsecret
         */
        readonly clientSecret: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.Issuer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-issuer
         */
        readonly issuer: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-onunauthenticatedrequest
         */
        readonly onUnauthenticatedRequest?: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.Scope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-scope
         */
        readonly scope?: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.SessionCookieName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessioncookiename
         */
        readonly sessionCookieName?: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.SessionTimeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessiontimeout
         */
        readonly sessionTimeout?: number;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.TokenEndpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-tokenendpoint
         */
        readonly tokenEndpoint: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.UseExistingClientSecret`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-useexistingclientsecret
         */
        readonly useExistingClientSecret?: boolean | cdk.IResolvable;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-userinfoendpoint
         */
        readonly userInfoEndpoint: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html
     */
    interface FixedResponseConfigProperty {
        /**
         * `CfnListenerRule.FixedResponseConfigProperty.ContentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-contenttype
         */
        readonly contentType?: string;
        /**
         * `CfnListenerRule.FixedResponseConfigProperty.MessageBody`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-messagebody
         */
        readonly messageBody?: string;
        /**
         * `CfnListenerRule.FixedResponseConfigProperty.StatusCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-statuscode
         */
        readonly statusCode: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html
     */
    interface ForwardConfigProperty {
        /**
         * `CfnListenerRule.ForwardConfigProperty.TargetGroupStickinessConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html#cfn-elasticloadbalancingv2-listenerrule-forwardconfig-targetgroupstickinessconfig
         */
        readonly targetGroupStickinessConfig?: CfnListenerRule.TargetGroupStickinessConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ForwardConfigProperty.TargetGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html#cfn-elasticloadbalancingv2-listenerrule-forwardconfig-targetgroups
         */
        readonly targetGroups?: Array<CfnListenerRule.TargetGroupTupleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html
     */
    interface HostHeaderConfigProperty {
        /**
         * `CfnListenerRule.HostHeaderConfigProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-hostheaderconfig-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html
     */
    interface HttpHeaderConfigProperty {
        /**
         * `CfnListenerRule.HttpHeaderConfigProperty.HttpHeaderName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-httpheadername
         */
        readonly httpHeaderName?: string;
        /**
         * `CfnListenerRule.HttpHeaderConfigProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html
     */
    interface HttpRequestMethodConfigProperty {
        /**
         * `CfnListenerRule.HttpRequestMethodConfigProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html#cfn-elasticloadbalancingv2-listenerrule-httprequestmethodconfig-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html
     */
    interface PathPatternConfigProperty {
        /**
         * `CfnListenerRule.PathPatternConfigProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html#cfn-elasticloadbalancingv2-listenerrule-pathpatternconfig-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html
     */
    interface QueryStringConfigProperty {
        /**
         * `CfnListenerRule.QueryStringConfigProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html#cfn-elasticloadbalancingv2-listenerrule-querystringconfig-values
         */
        readonly values?: Array<CfnListenerRule.QueryStringKeyValueProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html
     */
    interface QueryStringKeyValueProperty {
        /**
         * `CfnListenerRule.QueryStringKeyValueProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-key
         */
        readonly key?: string;
        /**
         * `CfnListenerRule.QueryStringKeyValueProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html
     */
    interface RedirectConfigProperty {
        /**
         * `CfnListenerRule.RedirectConfigProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-host
         */
        readonly host?: string;
        /**
         * `CfnListenerRule.RedirectConfigProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-path
         */
        readonly path?: string;
        /**
         * `CfnListenerRule.RedirectConfigProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-port
         */
        readonly port?: string;
        /**
         * `CfnListenerRule.RedirectConfigProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-protocol
         */
        readonly protocol?: string;
        /**
         * `CfnListenerRule.RedirectConfigProperty.Query`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-query
         */
        readonly query?: string;
        /**
         * `CfnListenerRule.RedirectConfigProperty.StatusCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-statuscode
         */
        readonly statusCode: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html
     */
    interface RuleConditionProperty {
        /**
         * `CfnListenerRule.RuleConditionProperty.Field`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-field
         */
        readonly field?: string;
        /**
         * `CfnListenerRule.RuleConditionProperty.HostHeaderConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-hostheaderconfig
         */
        readonly hostHeaderConfig?: CfnListenerRule.HostHeaderConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.HttpHeaderConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httpheaderconfig
         */
        readonly httpHeaderConfig?: CfnListenerRule.HttpHeaderConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.HttpRequestMethodConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httprequestmethodconfig
         */
        readonly httpRequestMethodConfig?: CfnListenerRule.HttpRequestMethodConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.PathPatternConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-pathpatternconfig
         */
        readonly pathPatternConfig?: CfnListenerRule.PathPatternConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.QueryStringConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-querystringconfig
         */
        readonly queryStringConfig?: CfnListenerRule.QueryStringConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.SourceIpConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-sourceipconfig
         */
        readonly sourceIpConfig?: CfnListenerRule.SourceIpConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html
     */
    interface SourceIpConfigProperty {
        /**
         * `CfnListenerRule.SourceIpConfigProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html#cfn-elasticloadbalancingv2-listenerrule-sourceipconfig-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html
     */
    interface TargetGroupStickinessConfigProperty {
        /**
         * `CfnListenerRule.TargetGroupStickinessConfigProperty.DurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig-durationseconds
         */
        readonly durationSeconds?: number;
        /**
         * `CfnListenerRule.TargetGroupStickinessConfigProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
export declare namespace CfnListenerRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html
     */
    interface TargetGroupTupleProperty {
        /**
         * `CfnListenerRule.TargetGroupTupleProperty.TargetGroupArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html#cfn-elasticloadbalancingv2-listenerrule-targetgrouptuple-targetgrouparn
         */
        readonly targetGroupArn?: string;
        /**
         * `CfnListenerRule.TargetGroupTupleProperty.Weight`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html#cfn-elasticloadbalancingv2-listenerrule-targetgrouptuple-weight
         */
        readonly weight?: number;
    }
}
/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 */
export interface CfnLoadBalancerProps {
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.IpAddressType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipaddresstype
     */
    readonly ipAddressType?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttributes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes
     */
    readonly loadBalancerAttributes?: Array<CfnLoadBalancer.LoadBalancerAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-name
     */
    readonly name?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Scheme`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-scheme
     */
    readonly scheme?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-securitygroups
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMappings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmappings
     */
    readonly subnetMappings?: Array<CfnLoadBalancer.SubnetMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Subnets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnets
     */
    readonly subnets?: string[];
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-type
     */
    readonly type?: string;
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::LoadBalancer
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 */
export declare class CfnLoadBalancer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancingV2::LoadBalancer";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLoadBalancer;
    /**
     * @external
     * @cloudformationAttribute CanonicalHostedZoneID
     */
    readonly attrCanonicalHostedZoneId: string;
    /**
     * @external
     * @cloudformationAttribute DNSName
     */
    readonly attrDnsName: string;
    /**
     * @external
     * @cloudformationAttribute LoadBalancerFullName
     */
    readonly attrLoadBalancerFullName: string;
    /**
     * @external
     * @cloudformationAttribute LoadBalancerName
     */
    readonly attrLoadBalancerName: string;
    /**
     * @external
     * @cloudformationAttribute SecurityGroups
     */
    readonly attrSecurityGroups: string[];
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.IpAddressType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipaddresstype
     */
    ipAddressType: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttributes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes
     */
    loadBalancerAttributes: Array<CfnLoadBalancer.LoadBalancerAttributeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-name
     */
    name: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Scheme`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-scheme
     */
    scheme: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-securitygroups
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMappings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmappings
     */
    subnetMappings: Array<CfnLoadBalancer.SubnetMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Subnets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnets
     */
    subnets: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-type
     */
    type: string | undefined;
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::LoadBalancer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnLoadBalancerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::LoadBalancer
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 */
export declare namespace CfnLoadBalancer {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html
     */
    interface LoadBalancerAttributeProperty {
        /**
         * `CfnLoadBalancer.LoadBalancerAttributeProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
         */
        readonly key?: string;
        /**
         * `CfnLoadBalancer.LoadBalancerAttributeProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::LoadBalancer
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 */
export declare namespace CfnLoadBalancer {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html
     */
    interface SubnetMappingProperty {
        /**
         * `CfnLoadBalancer.SubnetMappingProperty.AllocationId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
         */
        readonly allocationId?: string;
        /**
         * `CfnLoadBalancer.SubnetMappingProperty.IPv6Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-ipv6address
         */
        readonly iPv6Address?: string;
        /**
         * `CfnLoadBalancer.SubnetMappingProperty.PrivateIPv4Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-privateipv4address
         */
        readonly privateIPv4Address?: string;
        /**
         * `CfnLoadBalancer.SubnetMappingProperty.SubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
         */
        readonly subnetId: string;
    }
}
/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::TargetGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 */
export interface CfnTargetGroupProps {
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckenabled
     */
    readonly healthCheckEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckIntervalSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckintervalseconds
     */
    readonly healthCheckIntervalSeconds?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckPath`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckpath
     */
    readonly healthCheckPath?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckport
     */
    readonly healthCheckPort?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckProtocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckprotocol
     */
    readonly healthCheckProtocol?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckTimeoutSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthchecktimeoutseconds
     */
    readonly healthCheckTimeoutSeconds?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthyThresholdCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthythresholdcount
     */
    readonly healthyThresholdCount?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Matcher`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-matcher
     */
    readonly matcher?: CfnTargetGroup.MatcherProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-name
     */
    readonly name?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-port
     */
    readonly port?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-protocol
     */
    readonly protocol?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.TargetGroupAttributes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattributes
     */
    readonly targetGroupAttributes?: Array<CfnTargetGroup.TargetGroupAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Targets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targets
     */
    readonly targets?: Array<CfnTargetGroup.TargetDescriptionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.TargetType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targettype
     */
    readonly targetType?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.UnhealthyThresholdCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-unhealthythresholdcount
     */
    readonly unhealthyThresholdCount?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-vpcid
     */
    readonly vpcId?: string;
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::TargetGroup`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::TargetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 */
export declare class CfnTargetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancingV2::TargetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTargetGroup;
    /**
     * @external
     * @cloudformationAttribute LoadBalancerArns
     */
    readonly attrLoadBalancerArns: string[];
    /**
     * @external
     * @cloudformationAttribute TargetGroupFullName
     */
    readonly attrTargetGroupFullName: string;
    /**
     * @external
     * @cloudformationAttribute TargetGroupName
     */
    readonly attrTargetGroupName: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckenabled
     */
    healthCheckEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckIntervalSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckintervalseconds
     */
    healthCheckIntervalSeconds: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckPath`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckpath
     */
    healthCheckPath: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckport
     */
    healthCheckPort: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckProtocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckprotocol
     */
    healthCheckProtocol: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckTimeoutSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthchecktimeoutseconds
     */
    healthCheckTimeoutSeconds: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthyThresholdCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthythresholdcount
     */
    healthyThresholdCount: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Matcher`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-matcher
     */
    matcher: CfnTargetGroup.MatcherProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-name
     */
    name: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-port
     */
    port: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-protocol
     */
    protocol: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.TargetGroupAttributes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattributes
     */
    targetGroupAttributes: Array<CfnTargetGroup.TargetGroupAttributeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Targets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targets
     */
    targets: Array<CfnTargetGroup.TargetDescriptionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.TargetType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targettype
     */
    targetType: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.UnhealthyThresholdCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-unhealthythresholdcount
     */
    unhealthyThresholdCount: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-vpcid
     */
    vpcId: string | undefined;
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::TargetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTargetGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::TargetGroup`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::TargetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 */
export declare namespace CfnTargetGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html
     */
    interface MatcherProperty {
        /**
         * `CfnTargetGroup.MatcherProperty.HttpCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
         */
        readonly httpCode?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::TargetGroup`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::TargetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 */
export declare namespace CfnTargetGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html
     */
    interface TargetDescriptionProperty {
        /**
         * `CfnTargetGroup.TargetDescriptionProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnTargetGroup.TargetDescriptionProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
         */
        readonly id: string;
        /**
         * `CfnTargetGroup.TargetDescriptionProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
         */
        readonly port?: number;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::TargetGroup`.
 *
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::TargetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 */
export declare namespace CfnTargetGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html
     */
    interface TargetGroupAttributeProperty {
        /**
         * `CfnTargetGroup.TargetGroupAttributeProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-key
         */
        readonly key?: string;
        /**
         * `CfnTargetGroup.TargetGroupAttributeProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-value
         */
        readonly value?: string;
    }
}
