# -*- coding:utf-8 -*-
# Author: hankcs
# Date: 2020-12-07 21:03
import glob
import os

from hanlp.utils.io_util import uncompress, get_resource

_UD_210_URL = "https://lindat.mff.cuni.cz/repository/xmlui/handle/11234/1-4758/allzip"
_UD_210_HOME = _UD_210_URL + '#ud-treebanks-v2.10/'
_path = get_resource(_UD_210_URL)
if os.path.isfile(_path):
    os.rename(_path, _path + '.zip')
    uncompress(_path + '.zip')
    uncompress(os.path.join(_path, 'ud-treebanks-v2.10.tgz'))


# noinspection PyShadowingNames
def _list_dir(path, home):
    prefix = home.lstrip('_').replace('_HOME', '')

    path = get_resource(path)
    with open('ud210.py', 'a') as out:
        for f in sorted(glob.glob(path + '/ud-treebanks-v2.10/UD_*')):
            basename = os.path.basename(f)
            name = basename[len('UD_'):]
            name = name.upper().replace('-', '_')
            for split in 'train', 'dev', 'test':
                sp = glob.glob(f + f'/*{split}.conllu')
                if not sp:
                    continue
                sp = os.path.basename(sp[0])
                out.write(f'{prefix}_{name}_{split.upper()} = {home} + "{basename}/{sp}"\n')
                out.write(f'"{prefix} {split} set of {name}."\n')


def main():
    _list_dir(_UD_210_URL, '_UD_210_HOME')
    pass


if __name__ == '__main__':
    main()
UD_210_AFRIKAANS_AFRIBOOMS_TRAIN = _UD_210_HOME + "UD_Afrikaans-AfriBooms/af_afribooms-ud-train.conllu"
"UD_210 train set of AFRIKAANS_AFRIBOOMS."
UD_210_AFRIKAANS_AFRIBOOMS_DEV = _UD_210_HOME + "UD_Afrikaans-AfriBooms/af_afribooms-ud-dev.conllu"
"UD_210 dev set of AFRIKAANS_AFRIBOOMS."
UD_210_AFRIKAANS_AFRIBOOMS_TEST = _UD_210_HOME + "UD_Afrikaans-AfriBooms/af_afribooms-ud-test.conllu"
"UD_210 test set of AFRIKAANS_AFRIBOOMS."
UD_210_AKKADIAN_PISANDUB_TEST = _UD_210_HOME + "UD_Akkadian-PISANDUB/akk_pisandub-ud-test.conllu"
"UD_210 test set of AKKADIAN_PISANDUB."
UD_210_AKKADIAN_RIAO_TEST = _UD_210_HOME + "UD_Akkadian-RIAO/akk_riao-ud-test.conllu"
"UD_210 test set of AKKADIAN_RIAO."
UD_210_AKUNTSU_TUDET_TEST = _UD_210_HOME + "UD_Akuntsu-TuDeT/aqz_tudet-ud-test.conllu"
"UD_210 test set of AKUNTSU_TUDET."
UD_210_ALBANIAN_TSA_TEST = _UD_210_HOME + "UD_Albanian-TSA/sq_tsa-ud-test.conllu"
"UD_210 test set of ALBANIAN_TSA."
UD_210_AMHARIC_ATT_TEST = _UD_210_HOME + "UD_Amharic-ATT/am_att-ud-test.conllu"
"UD_210 test set of AMHARIC_ATT."
UD_210_ANCIENT_GREEK_PROIEL_TRAIN = _UD_210_HOME + "UD_Ancient_Greek-PROIEL/grc_proiel-ud-train.conllu"
"UD_210 train set of ANCIENT_GREEK_PROIEL."
UD_210_ANCIENT_GREEK_PROIEL_DEV = _UD_210_HOME + "UD_Ancient_Greek-PROIEL/grc_proiel-ud-dev.conllu"
"UD_210 dev set of ANCIENT_GREEK_PROIEL."
UD_210_ANCIENT_GREEK_PROIEL_TEST = _UD_210_HOME + "UD_Ancient_Greek-PROIEL/grc_proiel-ud-test.conllu"
"UD_210 test set of ANCIENT_GREEK_PROIEL."
UD_210_ANCIENT_GREEK_PERSEUS_TRAIN = _UD_210_HOME + "UD_Ancient_Greek-Perseus/grc_perseus-ud-train.conllu"
"UD_210 train set of ANCIENT_GREEK_PERSEUS."
UD_210_ANCIENT_GREEK_PERSEUS_DEV = _UD_210_HOME + "UD_Ancient_Greek-Perseus/grc_perseus-ud-dev.conllu"
"UD_210 dev set of ANCIENT_GREEK_PERSEUS."
UD_210_ANCIENT_GREEK_PERSEUS_TEST = _UD_210_HOME + "UD_Ancient_Greek-Perseus/grc_perseus-ud-test.conllu"
"UD_210 test set of ANCIENT_GREEK_PERSEUS."
UD_210_ANCIENT_HEBREW_PTNK_TRAIN = _UD_210_HOME + "UD_Ancient_Hebrew-PTNK/hbo_ptnk-ud-train.conllu"
"UD_210 train set of ANCIENT_HEBREW_PTNK."
UD_210_ANCIENT_HEBREW_PTNK_DEV = _UD_210_HOME + "UD_Ancient_Hebrew-PTNK/hbo_ptnk-ud-dev.conllu"
"UD_210 dev set of ANCIENT_HEBREW_PTNK."
UD_210_ANCIENT_HEBREW_PTNK_TEST = _UD_210_HOME + "UD_Ancient_Hebrew-PTNK/hbo_ptnk-ud-test.conllu"
"UD_210 test set of ANCIENT_HEBREW_PTNK."
UD_210_APURINA_UFPA_TEST = _UD_210_HOME + "UD_Apurina-UFPA/apu_ufpa-ud-test.conllu"
"UD_210 test set of APURINA_UFPA."
UD_210_ARABIC_NYUAD_TRAIN = _UD_210_HOME + "UD_Arabic-NYUAD/ar_nyuad-ud-train.conllu"
"UD_210 train set of ARABIC_NYUAD."
UD_210_ARABIC_NYUAD_DEV = _UD_210_HOME + "UD_Arabic-NYUAD/ar_nyuad-ud-dev.conllu"
"UD_210 dev set of ARABIC_NYUAD."
UD_210_ARABIC_NYUAD_TEST = _UD_210_HOME + "UD_Arabic-NYUAD/ar_nyuad-ud-test.conllu"
"UD_210 test set of ARABIC_NYUAD."
UD_210_ARABIC_PADT_TRAIN = _UD_210_HOME + "UD_Arabic-PADT/ar_padt-ud-train.conllu"
"UD_210 train set of ARABIC_PADT."
UD_210_ARABIC_PADT_DEV = _UD_210_HOME + "UD_Arabic-PADT/ar_padt-ud-dev.conllu"
"UD_210 dev set of ARABIC_PADT."
UD_210_ARABIC_PADT_TEST = _UD_210_HOME + "UD_Arabic-PADT/ar_padt-ud-test.conllu"
"UD_210 test set of ARABIC_PADT."
UD_210_ARABIC_PUD_TEST = _UD_210_HOME + "UD_Arabic-PUD/ar_pud-ud-test.conllu"
"UD_210 test set of ARABIC_PUD."
UD_210_ARMENIAN_ARMTDP_TRAIN = _UD_210_HOME + "UD_Armenian-ArmTDP/hy_armtdp-ud-train.conllu"
"UD_210 train set of ARMENIAN_ARMTDP."
UD_210_ARMENIAN_ARMTDP_DEV = _UD_210_HOME + "UD_Armenian-ArmTDP/hy_armtdp-ud-dev.conllu"
"UD_210 dev set of ARMENIAN_ARMTDP."
UD_210_ARMENIAN_ARMTDP_TEST = _UD_210_HOME + "UD_Armenian-ArmTDP/hy_armtdp-ud-test.conllu"
"UD_210 test set of ARMENIAN_ARMTDP."
UD_210_ARMENIAN_BSUT_TRAIN = _UD_210_HOME + "UD_Armenian-BSUT/hy_bsut-ud-train.conllu"
"UD_210 train set of ARMENIAN_BSUT."
UD_210_ARMENIAN_BSUT_DEV = _UD_210_HOME + "UD_Armenian-BSUT/hy_bsut-ud-dev.conllu"
"UD_210 dev set of ARMENIAN_BSUT."
UD_210_ARMENIAN_BSUT_TEST = _UD_210_HOME + "UD_Armenian-BSUT/hy_bsut-ud-test.conllu"
"UD_210 test set of ARMENIAN_BSUT."
UD_210_ASSYRIAN_AS_TEST = _UD_210_HOME + "UD_Assyrian-AS/aii_as-ud-test.conllu"
"UD_210 test set of ASSYRIAN_AS."
UD_210_BAMBARA_CRB_TEST = _UD_210_HOME + "UD_Bambara-CRB/bm_crb-ud-test.conllu"
"UD_210 test set of BAMBARA_CRB."
UD_210_BASQUE_BDT_TRAIN = _UD_210_HOME + "UD_Basque-BDT/eu_bdt-ud-train.conllu"
"UD_210 train set of BASQUE_BDT."
UD_210_BASQUE_BDT_DEV = _UD_210_HOME + "UD_Basque-BDT/eu_bdt-ud-dev.conllu"
"UD_210 dev set of BASQUE_BDT."
UD_210_BASQUE_BDT_TEST = _UD_210_HOME + "UD_Basque-BDT/eu_bdt-ud-test.conllu"
"UD_210 test set of BASQUE_BDT."
UD_210_BEJA_NSC_TEST = _UD_210_HOME + "UD_Beja-NSC/bej_nsc-ud-test.conllu"
"UD_210 test set of BEJA_NSC."
UD_210_BELARUSIAN_HSE_TRAIN = _UD_210_HOME + "UD_Belarusian-HSE/be_hse-ud-train.conllu"
"UD_210 train set of BELARUSIAN_HSE."
UD_210_BELARUSIAN_HSE_DEV = _UD_210_HOME + "UD_Belarusian-HSE/be_hse-ud-dev.conllu"
"UD_210 dev set of BELARUSIAN_HSE."
UD_210_BELARUSIAN_HSE_TEST = _UD_210_HOME + "UD_Belarusian-HSE/be_hse-ud-test.conllu"
"UD_210 test set of BELARUSIAN_HSE."
UD_210_BENGALI_BRU_TEST = _UD_210_HOME + "UD_Bengali-BRU/bn_bru-ud-test.conllu"
"UD_210 test set of BENGALI_BRU."
UD_210_BHOJPURI_BHTB_TEST = _UD_210_HOME + "UD_Bhojpuri-BHTB/bho_bhtb-ud-test.conllu"
"UD_210 test set of BHOJPURI_BHTB."
UD_210_BRETON_KEB_TEST = _UD_210_HOME + "UD_Breton-KEB/br_keb-ud-test.conllu"
"UD_210 test set of BRETON_KEB."
UD_210_BULGARIAN_BTB_TRAIN = _UD_210_HOME + "UD_Bulgarian-BTB/bg_btb-ud-train.conllu"
"UD_210 train set of BULGARIAN_BTB."
UD_210_BULGARIAN_BTB_DEV = _UD_210_HOME + "UD_Bulgarian-BTB/bg_btb-ud-dev.conllu"
"UD_210 dev set of BULGARIAN_BTB."
UD_210_BULGARIAN_BTB_TEST = _UD_210_HOME + "UD_Bulgarian-BTB/bg_btb-ud-test.conllu"
"UD_210 test set of BULGARIAN_BTB."
UD_210_BURYAT_BDT_TRAIN = _UD_210_HOME + "UD_Buryat-BDT/bxr_bdt-ud-train.conllu"
"UD_210 train set of BURYAT_BDT."
UD_210_BURYAT_BDT_TEST = _UD_210_HOME + "UD_Buryat-BDT/bxr_bdt-ud-test.conllu"
"UD_210 test set of BURYAT_BDT."
UD_210_CANTONESE_HK_TEST = _UD_210_HOME + "UD_Cantonese-HK/yue_hk-ud-test.conllu"
"UD_210 test set of CANTONESE_HK."
UD_210_CATALAN_ANCORA_TRAIN = _UD_210_HOME + "UD_Catalan-AnCora/ca_ancora-ud-train.conllu"
"UD_210 train set of CATALAN_ANCORA."
UD_210_CATALAN_ANCORA_DEV = _UD_210_HOME + "UD_Catalan-AnCora/ca_ancora-ud-dev.conllu"
"UD_210 dev set of CATALAN_ANCORA."
UD_210_CATALAN_ANCORA_TEST = _UD_210_HOME + "UD_Catalan-AnCora/ca_ancora-ud-test.conllu"
"UD_210 test set of CATALAN_ANCORA."
UD_210_CEBUANO_GJA_TEST = _UD_210_HOME + "UD_Cebuano-GJA/ceb_gja-ud-test.conllu"
"UD_210 test set of CEBUANO_GJA."
UD_210_CHINESE_CFL_TEST = _UD_210_HOME + "UD_Chinese-CFL/zh_cfl-ud-test.conllu"
"UD_210 test set of CHINESE_CFL."
UD_210_CHINESE_GSD_TRAIN = _UD_210_HOME + "UD_Chinese-GSD/zh_gsd-ud-train.conllu"
"UD_210 train set of CHINESE_GSD."
UD_210_CHINESE_GSD_DEV = _UD_210_HOME + "UD_Chinese-GSD/zh_gsd-ud-dev.conllu"
"UD_210 dev set of CHINESE_GSD."
UD_210_CHINESE_GSD_TEST = _UD_210_HOME + "UD_Chinese-GSD/zh_gsd-ud-test.conllu"
"UD_210 test set of CHINESE_GSD."
UD_210_CHINESE_GSDSIMP_TRAIN = _UD_210_HOME + "UD_Chinese-GSDSimp/zh_gsdsimp-ud-train.conllu"
"UD_210 train set of CHINESE_GSDSIMP."
UD_210_CHINESE_GSDSIMP_DEV = _UD_210_HOME + "UD_Chinese-GSDSimp/zh_gsdsimp-ud-dev.conllu"
"UD_210 dev set of CHINESE_GSDSIMP."
UD_210_CHINESE_GSDSIMP_TEST = _UD_210_HOME + "UD_Chinese-GSDSimp/zh_gsdsimp-ud-test.conllu"
"UD_210 test set of CHINESE_GSDSIMP."
UD_210_CHINESE_HK_TEST = _UD_210_HOME + "UD_Chinese-HK/zh_hk-ud-test.conllu"
"UD_210 test set of CHINESE_HK."
UD_210_CHINESE_PUD_TEST = _UD_210_HOME + "UD_Chinese-PUD/zh_pud-ud-test.conllu"
"UD_210 test set of CHINESE_PUD."
UD_210_CHUKCHI_HSE_TEST = _UD_210_HOME + "UD_Chukchi-HSE/ckt_hse-ud-test.conllu"
"UD_210 test set of CHUKCHI_HSE."
UD_210_CLASSICAL_CHINESE_KYOTO_TRAIN = _UD_210_HOME + "UD_Classical_Chinese-Kyoto/lzh_kyoto-ud-train.conllu"
"UD_210 train set of CLASSICAL_CHINESE_KYOTO."
UD_210_CLASSICAL_CHINESE_KYOTO_DEV = _UD_210_HOME + "UD_Classical_Chinese-Kyoto/lzh_kyoto-ud-dev.conllu"
"UD_210 dev set of CLASSICAL_CHINESE_KYOTO."
UD_210_CLASSICAL_CHINESE_KYOTO_TEST = _UD_210_HOME + "UD_Classical_Chinese-Kyoto/lzh_kyoto-ud-test.conllu"
"UD_210 test set of CLASSICAL_CHINESE_KYOTO."
UD_210_COPTIC_SCRIPTORIUM_TRAIN = _UD_210_HOME + "UD_Coptic-Scriptorium/cop_scriptorium-ud-train.conllu"
"UD_210 train set of COPTIC_SCRIPTORIUM."
UD_210_COPTIC_SCRIPTORIUM_DEV = _UD_210_HOME + "UD_Coptic-Scriptorium/cop_scriptorium-ud-dev.conllu"
"UD_210 dev set of COPTIC_SCRIPTORIUM."
UD_210_COPTIC_SCRIPTORIUM_TEST = _UD_210_HOME + "UD_Coptic-Scriptorium/cop_scriptorium-ud-test.conllu"
"UD_210 test set of COPTIC_SCRIPTORIUM."
UD_210_CROATIAN_SET_TRAIN = _UD_210_HOME + "UD_Croatian-SET/hr_set-ud-train.conllu"
"UD_210 train set of CROATIAN_SET."
UD_210_CROATIAN_SET_DEV = _UD_210_HOME + "UD_Croatian-SET/hr_set-ud-dev.conllu"
"UD_210 dev set of CROATIAN_SET."
UD_210_CROATIAN_SET_TEST = _UD_210_HOME + "UD_Croatian-SET/hr_set-ud-test.conllu"
"UD_210 test set of CROATIAN_SET."
UD_210_CZECH_CAC_TRAIN = _UD_210_HOME + "UD_Czech-CAC/cs_cac-ud-train.conllu"
"UD_210 train set of CZECH_CAC."
UD_210_CZECH_CAC_DEV = _UD_210_HOME + "UD_Czech-CAC/cs_cac-ud-dev.conllu"
"UD_210 dev set of CZECH_CAC."
UD_210_CZECH_CAC_TEST = _UD_210_HOME + "UD_Czech-CAC/cs_cac-ud-test.conllu"
"UD_210 test set of CZECH_CAC."
UD_210_CZECH_CLTT_TRAIN = _UD_210_HOME + "UD_Czech-CLTT/cs_cltt-ud-train.conllu"
"UD_210 train set of CZECH_CLTT."
UD_210_CZECH_CLTT_DEV = _UD_210_HOME + "UD_Czech-CLTT/cs_cltt-ud-dev.conllu"
"UD_210 dev set of CZECH_CLTT."
UD_210_CZECH_CLTT_TEST = _UD_210_HOME + "UD_Czech-CLTT/cs_cltt-ud-test.conllu"
"UD_210 test set of CZECH_CLTT."
UD_210_CZECH_FICTREE_TRAIN = _UD_210_HOME + "UD_Czech-FicTree/cs_fictree-ud-train.conllu"
"UD_210 train set of CZECH_FICTREE."
UD_210_CZECH_FICTREE_DEV = _UD_210_HOME + "UD_Czech-FicTree/cs_fictree-ud-dev.conllu"
"UD_210 dev set of CZECH_FICTREE."
UD_210_CZECH_FICTREE_TEST = _UD_210_HOME + "UD_Czech-FicTree/cs_fictree-ud-test.conllu"
"UD_210 test set of CZECH_FICTREE."
UD_210_CZECH_PDT_TRAIN = _UD_210_HOME + "UD_Czech-PDT/cs_pdt-ud-train.conllu"
"UD_210 train set of CZECH_PDT."
UD_210_CZECH_PDT_DEV = _UD_210_HOME + "UD_Czech-PDT/cs_pdt-ud-dev.conllu"
"UD_210 dev set of CZECH_PDT."
UD_210_CZECH_PDT_TEST = _UD_210_HOME + "UD_Czech-PDT/cs_pdt-ud-test.conllu"
"UD_210 test set of CZECH_PDT."
UD_210_CZECH_PUD_TEST = _UD_210_HOME + "UD_Czech-PUD/cs_pud-ud-test.conllu"
"UD_210 test set of CZECH_PUD."
UD_210_DANISH_DDT_TRAIN = _UD_210_HOME + "UD_Danish-DDT/da_ddt-ud-train.conllu"
"UD_210 train set of DANISH_DDT."
UD_210_DANISH_DDT_DEV = _UD_210_HOME + "UD_Danish-DDT/da_ddt-ud-dev.conllu"
"UD_210 dev set of DANISH_DDT."
UD_210_DANISH_DDT_TEST = _UD_210_HOME + "UD_Danish-DDT/da_ddt-ud-test.conllu"
"UD_210 test set of DANISH_DDT."
UD_210_DUTCH_ALPINO_TRAIN = _UD_210_HOME + "UD_Dutch-Alpino/nl_alpino-ud-train.conllu"
"UD_210 train set of DUTCH_ALPINO."
UD_210_DUTCH_ALPINO_DEV = _UD_210_HOME + "UD_Dutch-Alpino/nl_alpino-ud-dev.conllu"
"UD_210 dev set of DUTCH_ALPINO."
UD_210_DUTCH_ALPINO_TEST = _UD_210_HOME + "UD_Dutch-Alpino/nl_alpino-ud-test.conllu"
"UD_210 test set of DUTCH_ALPINO."
UD_210_DUTCH_LASSYSMALL_TRAIN = _UD_210_HOME + "UD_Dutch-LassySmall/nl_lassysmall-ud-train.conllu"
"UD_210 train set of DUTCH_LASSYSMALL."
UD_210_DUTCH_LASSYSMALL_DEV = _UD_210_HOME + "UD_Dutch-LassySmall/nl_lassysmall-ud-dev.conllu"
"UD_210 dev set of DUTCH_LASSYSMALL."
UD_210_DUTCH_LASSYSMALL_TEST = _UD_210_HOME + "UD_Dutch-LassySmall/nl_lassysmall-ud-test.conllu"
"UD_210 test set of DUTCH_LASSYSMALL."
UD_210_ENGLISH_ATIS_TRAIN = _UD_210_HOME + "UD_English-Atis/en_atis-ud-train.conllu"
"UD_210 train set of ENGLISH_ATIS."
UD_210_ENGLISH_ATIS_DEV = _UD_210_HOME + "UD_English-Atis/en_atis-ud-dev.conllu"
"UD_210 dev set of ENGLISH_ATIS."
UD_210_ENGLISH_ATIS_TEST = _UD_210_HOME + "UD_English-Atis/en_atis-ud-test.conllu"
"UD_210 test set of ENGLISH_ATIS."
UD_210_ENGLISH_ESL_TRAIN = _UD_210_HOME + "UD_English-ESL/en_esl-ud-train.conllu"
"UD_210 train set of ENGLISH_ESL."
UD_210_ENGLISH_ESL_DEV = _UD_210_HOME + "UD_English-ESL/en_esl-ud-dev.conllu"
"UD_210 dev set of ENGLISH_ESL."
UD_210_ENGLISH_ESL_TEST = _UD_210_HOME + "UD_English-ESL/en_esl-ud-test.conllu"
"UD_210 test set of ENGLISH_ESL."
UD_210_ENGLISH_EWT_TRAIN = _UD_210_HOME + "UD_English-EWT/en_ewt-ud-train.conllu"
"UD_210 train set of ENGLISH_EWT."
UD_210_ENGLISH_EWT_DEV = _UD_210_HOME + "UD_English-EWT/en_ewt-ud-dev.conllu"
"UD_210 dev set of ENGLISH_EWT."
UD_210_ENGLISH_EWT_TEST = _UD_210_HOME + "UD_English-EWT/en_ewt-ud-test.conllu"
"UD_210 test set of ENGLISH_EWT."
UD_210_ENGLISH_GUM_TRAIN = _UD_210_HOME + "UD_English-GUM/en_gum-ud-train.conllu"
"UD_210 train set of ENGLISH_GUM."
UD_210_ENGLISH_GUM_DEV = _UD_210_HOME + "UD_English-GUM/en_gum-ud-dev.conllu"
"UD_210 dev set of ENGLISH_GUM."
UD_210_ENGLISH_GUM_TEST = _UD_210_HOME + "UD_English-GUM/en_gum-ud-test.conllu"
"UD_210 test set of ENGLISH_GUM."
UD_210_ENGLISH_GUMREDDIT_TRAIN = _UD_210_HOME + "UD_English-GUMReddit/en_gumreddit-ud-train.conllu"
"UD_210 train set of ENGLISH_GUMREDDIT."
UD_210_ENGLISH_GUMREDDIT_DEV = _UD_210_HOME + "UD_English-GUMReddit/en_gumreddit-ud-dev.conllu"
"UD_210 dev set of ENGLISH_GUMREDDIT."
UD_210_ENGLISH_GUMREDDIT_TEST = _UD_210_HOME + "UD_English-GUMReddit/en_gumreddit-ud-test.conllu"
"UD_210 test set of ENGLISH_GUMREDDIT."
UD_210_ENGLISH_LINES_TRAIN = _UD_210_HOME + "UD_English-LinES/en_lines-ud-train.conllu"
"UD_210 train set of ENGLISH_LINES."
UD_210_ENGLISH_LINES_DEV = _UD_210_HOME + "UD_English-LinES/en_lines-ud-dev.conllu"
"UD_210 dev set of ENGLISH_LINES."
UD_210_ENGLISH_LINES_TEST = _UD_210_HOME + "UD_English-LinES/en_lines-ud-test.conllu"
"UD_210 test set of ENGLISH_LINES."
UD_210_ENGLISH_PUD_TEST = _UD_210_HOME + "UD_English-PUD/en_pud-ud-test.conllu"
"UD_210 test set of ENGLISH_PUD."
UD_210_ENGLISH_PARTUT_TRAIN = _UD_210_HOME + "UD_English-ParTUT/en_partut-ud-train.conllu"
"UD_210 train set of ENGLISH_PARTUT."
UD_210_ENGLISH_PARTUT_DEV = _UD_210_HOME + "UD_English-ParTUT/en_partut-ud-dev.conllu"
"UD_210 dev set of ENGLISH_PARTUT."
UD_210_ENGLISH_PARTUT_TEST = _UD_210_HOME + "UD_English-ParTUT/en_partut-ud-test.conllu"
"UD_210 test set of ENGLISH_PARTUT."
UD_210_ENGLISH_PRONOUNS_TEST = _UD_210_HOME + "UD_English-Pronouns/en_pronouns-ud-test.conllu"
"UD_210 test set of ENGLISH_PRONOUNS."
UD_210_ERZYA_JR_TEST = _UD_210_HOME + "UD_Erzya-JR/myv_jr-ud-test.conllu"
"UD_210 test set of ERZYA_JR."
UD_210_ESTONIAN_EDT_TRAIN = _UD_210_HOME + "UD_Estonian-EDT/et_edt-ud-train.conllu"
"UD_210 train set of ESTONIAN_EDT."
UD_210_ESTONIAN_EDT_DEV = _UD_210_HOME + "UD_Estonian-EDT/et_edt-ud-dev.conllu"
"UD_210 dev set of ESTONIAN_EDT."
UD_210_ESTONIAN_EDT_TEST = _UD_210_HOME + "UD_Estonian-EDT/et_edt-ud-test.conllu"
"UD_210 test set of ESTONIAN_EDT."
UD_210_ESTONIAN_EWT_TRAIN = _UD_210_HOME + "UD_Estonian-EWT/et_ewt-ud-train.conllu"
"UD_210 train set of ESTONIAN_EWT."
UD_210_ESTONIAN_EWT_DEV = _UD_210_HOME + "UD_Estonian-EWT/et_ewt-ud-dev.conllu"
"UD_210 dev set of ESTONIAN_EWT."
UD_210_ESTONIAN_EWT_TEST = _UD_210_HOME + "UD_Estonian-EWT/et_ewt-ud-test.conllu"
"UD_210 test set of ESTONIAN_EWT."
UD_210_FAROESE_FARPAHC_TRAIN = _UD_210_HOME + "UD_Faroese-FarPaHC/fo_farpahc-ud-train.conllu"
"UD_210 train set of FAROESE_FARPAHC."
UD_210_FAROESE_FARPAHC_DEV = _UD_210_HOME + "UD_Faroese-FarPaHC/fo_farpahc-ud-dev.conllu"
"UD_210 dev set of FAROESE_FARPAHC."
UD_210_FAROESE_FARPAHC_TEST = _UD_210_HOME + "UD_Faroese-FarPaHC/fo_farpahc-ud-test.conllu"
"UD_210 test set of FAROESE_FARPAHC."
UD_210_FAROESE_OFT_TEST = _UD_210_HOME + "UD_Faroese-OFT/fo_oft-ud-test.conllu"
"UD_210 test set of FAROESE_OFT."
UD_210_FINNISH_FTB_TRAIN = _UD_210_HOME + "UD_Finnish-FTB/fi_ftb-ud-train.conllu"
"UD_210 train set of FINNISH_FTB."
UD_210_FINNISH_FTB_DEV = _UD_210_HOME + "UD_Finnish-FTB/fi_ftb-ud-dev.conllu"
"UD_210 dev set of FINNISH_FTB."
UD_210_FINNISH_FTB_TEST = _UD_210_HOME + "UD_Finnish-FTB/fi_ftb-ud-test.conllu"
"UD_210 test set of FINNISH_FTB."
UD_210_FINNISH_OOD_TEST = _UD_210_HOME + "UD_Finnish-OOD/fi_ood-ud-test.conllu"
"UD_210 test set of FINNISH_OOD."
UD_210_FINNISH_PUD_TEST = _UD_210_HOME + "UD_Finnish-PUD/fi_pud-ud-test.conllu"
"UD_210 test set of FINNISH_PUD."
UD_210_FINNISH_TDT_TRAIN = _UD_210_HOME + "UD_Finnish-TDT/fi_tdt-ud-train.conllu"
"UD_210 train set of FINNISH_TDT."
UD_210_FINNISH_TDT_DEV = _UD_210_HOME + "UD_Finnish-TDT/fi_tdt-ud-dev.conllu"
"UD_210 dev set of FINNISH_TDT."
UD_210_FINNISH_TDT_TEST = _UD_210_HOME + "UD_Finnish-TDT/fi_tdt-ud-test.conllu"
"UD_210 test set of FINNISH_TDT."
UD_210_FRENCH_FQB_TEST = _UD_210_HOME + "UD_French-FQB/fr_fqb-ud-test.conllu"
"UD_210 test set of FRENCH_FQB."
UD_210_FRENCH_FTB_TRAIN = _UD_210_HOME + "UD_French-FTB/fr_ftb-ud-train.conllu"
"UD_210 train set of FRENCH_FTB."
UD_210_FRENCH_FTB_DEV = _UD_210_HOME + "UD_French-FTB/fr_ftb-ud-dev.conllu"
"UD_210 dev set of FRENCH_FTB."
UD_210_FRENCH_FTB_TEST = _UD_210_HOME + "UD_French-FTB/fr_ftb-ud-test.conllu"
"UD_210 test set of FRENCH_FTB."
UD_210_FRENCH_GSD_TRAIN = _UD_210_HOME + "UD_French-GSD/fr_gsd-ud-train.conllu"
"UD_210 train set of FRENCH_GSD."
UD_210_FRENCH_GSD_DEV = _UD_210_HOME + "UD_French-GSD/fr_gsd-ud-dev.conllu"
"UD_210 dev set of FRENCH_GSD."
UD_210_FRENCH_GSD_TEST = _UD_210_HOME + "UD_French-GSD/fr_gsd-ud-test.conllu"
"UD_210 test set of FRENCH_GSD."
UD_210_FRENCH_PUD_TEST = _UD_210_HOME + "UD_French-PUD/fr_pud-ud-test.conllu"
"UD_210 test set of FRENCH_PUD."
UD_210_FRENCH_PARTUT_TRAIN = _UD_210_HOME + "UD_French-ParTUT/fr_partut-ud-train.conllu"
"UD_210 train set of FRENCH_PARTUT."
UD_210_FRENCH_PARTUT_DEV = _UD_210_HOME + "UD_French-ParTUT/fr_partut-ud-dev.conllu"
"UD_210 dev set of FRENCH_PARTUT."
UD_210_FRENCH_PARTUT_TEST = _UD_210_HOME + "UD_French-ParTUT/fr_partut-ud-test.conllu"
"UD_210 test set of FRENCH_PARTUT."
UD_210_FRENCH_PARISSTORIES_TRAIN = _UD_210_HOME + "UD_French-ParisStories/fr_parisstories-ud-train.conllu"
"UD_210 train set of FRENCH_PARISSTORIES."
UD_210_FRENCH_PARISSTORIES_TEST = _UD_210_HOME + "UD_French-ParisStories/fr_parisstories-ud-test.conllu"
"UD_210 test set of FRENCH_PARISSTORIES."
UD_210_FRENCH_RHAPSODIE_TRAIN = _UD_210_HOME + "UD_French-Rhapsodie/fr_rhapsodie-ud-train.conllu"
"UD_210 train set of FRENCH_RHAPSODIE."
UD_210_FRENCH_RHAPSODIE_DEV = _UD_210_HOME + "UD_French-Rhapsodie/fr_rhapsodie-ud-dev.conllu"
"UD_210 dev set of FRENCH_RHAPSODIE."
UD_210_FRENCH_RHAPSODIE_TEST = _UD_210_HOME + "UD_French-Rhapsodie/fr_rhapsodie-ud-test.conllu"
"UD_210 test set of FRENCH_RHAPSODIE."
UD_210_FRENCH_SEQUOIA_TRAIN = _UD_210_HOME + "UD_French-Sequoia/fr_sequoia-ud-train.conllu"
"UD_210 train set of FRENCH_SEQUOIA."
UD_210_FRENCH_SEQUOIA_DEV = _UD_210_HOME + "UD_French-Sequoia/fr_sequoia-ud-dev.conllu"
"UD_210 dev set of FRENCH_SEQUOIA."
UD_210_FRENCH_SEQUOIA_TEST = _UD_210_HOME + "UD_French-Sequoia/fr_sequoia-ud-test.conllu"
"UD_210 test set of FRENCH_SEQUOIA."
UD_210_FRISIAN_DUTCH_FAME_TEST = _UD_210_HOME + "UD_Frisian_Dutch-Fame/qfn_fame-ud-test.conllu"
"UD_210 test set of FRISIAN_DUTCH_FAME."
UD_210_GALICIAN_CTG_TRAIN = _UD_210_HOME + "UD_Galician-CTG/gl_ctg-ud-train.conllu"
"UD_210 train set of GALICIAN_CTG."
UD_210_GALICIAN_CTG_DEV = _UD_210_HOME + "UD_Galician-CTG/gl_ctg-ud-dev.conllu"
"UD_210 dev set of GALICIAN_CTG."
UD_210_GALICIAN_CTG_TEST = _UD_210_HOME + "UD_Galician-CTG/gl_ctg-ud-test.conllu"
"UD_210 test set of GALICIAN_CTG."
UD_210_GALICIAN_TREEGAL_TRAIN = _UD_210_HOME + "UD_Galician-TreeGal/gl_treegal-ud-train.conllu"
"UD_210 train set of GALICIAN_TREEGAL."
UD_210_GALICIAN_TREEGAL_TEST = _UD_210_HOME + "UD_Galician-TreeGal/gl_treegal-ud-test.conllu"
"UD_210 test set of GALICIAN_TREEGAL."
UD_210_GERMAN_GSD_TRAIN = _UD_210_HOME + "UD_German-GSD/de_gsd-ud-train.conllu"
"UD_210 train set of GERMAN_GSD."
UD_210_GERMAN_GSD_DEV = _UD_210_HOME + "UD_German-GSD/de_gsd-ud-dev.conllu"
"UD_210 dev set of GERMAN_GSD."
UD_210_GERMAN_GSD_TEST = _UD_210_HOME + "UD_German-GSD/de_gsd-ud-test.conllu"
"UD_210 test set of GERMAN_GSD."
UD_210_GERMAN_HDT_TRAIN = _UD_210_HOME + "UD_German-HDT/de_hdt-ud-train.conllu"
"UD_210 train set of GERMAN_HDT."
UD_210_GERMAN_HDT_DEV = _UD_210_HOME + "UD_German-HDT/de_hdt-ud-dev.conllu"
"UD_210 dev set of GERMAN_HDT."
UD_210_GERMAN_HDT_TEST = _UD_210_HOME + "UD_German-HDT/de_hdt-ud-test.conllu"
"UD_210 test set of GERMAN_HDT."
UD_210_GERMAN_LIT_TEST = _UD_210_HOME + "UD_German-LIT/de_lit-ud-test.conllu"
"UD_210 test set of GERMAN_LIT."
UD_210_GERMAN_PUD_TEST = _UD_210_HOME + "UD_German-PUD/de_pud-ud-test.conllu"
"UD_210 test set of GERMAN_PUD."
UD_210_GOTHIC_PROIEL_TRAIN = _UD_210_HOME + "UD_Gothic-PROIEL/got_proiel-ud-train.conllu"
"UD_210 train set of GOTHIC_PROIEL."
UD_210_GOTHIC_PROIEL_DEV = _UD_210_HOME + "UD_Gothic-PROIEL/got_proiel-ud-dev.conllu"
"UD_210 dev set of GOTHIC_PROIEL."
UD_210_GOTHIC_PROIEL_TEST = _UD_210_HOME + "UD_Gothic-PROIEL/got_proiel-ud-test.conllu"
"UD_210 test set of GOTHIC_PROIEL."
UD_210_GREEK_GDT_TRAIN = _UD_210_HOME + "UD_Greek-GDT/el_gdt-ud-train.conllu"
"UD_210 train set of GREEK_GDT."
UD_210_GREEK_GDT_DEV = _UD_210_HOME + "UD_Greek-GDT/el_gdt-ud-dev.conllu"
"UD_210 dev set of GREEK_GDT."
UD_210_GREEK_GDT_TEST = _UD_210_HOME + "UD_Greek-GDT/el_gdt-ud-test.conllu"
"UD_210 test set of GREEK_GDT."
UD_210_GUAJAJARA_TUDET_TEST = _UD_210_HOME + "UD_Guajajara-TuDeT/gub_tudet-ud-test.conllu"
"UD_210 test set of GUAJAJARA_TUDET."
UD_210_GUARANI_OLDTUDET_TEST = _UD_210_HOME + "UD_Guarani-OldTuDeT/gn_oldtudet-ud-test.conllu"
"UD_210 test set of GUARANI_OLDTUDET."
UD_210_HEBREW_HTB_TRAIN = _UD_210_HOME + "UD_Hebrew-HTB/he_htb-ud-train.conllu"
"UD_210 train set of HEBREW_HTB."
UD_210_HEBREW_HTB_DEV = _UD_210_HOME + "UD_Hebrew-HTB/he_htb-ud-dev.conllu"
"UD_210 dev set of HEBREW_HTB."
UD_210_HEBREW_HTB_TEST = _UD_210_HOME + "UD_Hebrew-HTB/he_htb-ud-test.conllu"
"UD_210 test set of HEBREW_HTB."
UD_210_HEBREW_IAHLTWIKI_TRAIN = _UD_210_HOME + "UD_Hebrew-IAHLTwiki/he_iahltwiki-ud-train.conllu"
"UD_210 train set of HEBREW_IAHLTWIKI."
UD_210_HEBREW_IAHLTWIKI_DEV = _UD_210_HOME + "UD_Hebrew-IAHLTwiki/he_iahltwiki-ud-dev.conllu"
"UD_210 dev set of HEBREW_IAHLTWIKI."
UD_210_HEBREW_IAHLTWIKI_TEST = _UD_210_HOME + "UD_Hebrew-IAHLTwiki/he_iahltwiki-ud-test.conllu"
"UD_210 test set of HEBREW_IAHLTWIKI."
UD_210_HINDI_HDTB_TRAIN = _UD_210_HOME + "UD_Hindi-HDTB/hi_hdtb-ud-train.conllu"
"UD_210 train set of HINDI_HDTB."
UD_210_HINDI_HDTB_DEV = _UD_210_HOME + "UD_Hindi-HDTB/hi_hdtb-ud-dev.conllu"
"UD_210 dev set of HINDI_HDTB."
UD_210_HINDI_HDTB_TEST = _UD_210_HOME + "UD_Hindi-HDTB/hi_hdtb-ud-test.conllu"
"UD_210 test set of HINDI_HDTB."
UD_210_HINDI_PUD_TEST = _UD_210_HOME + "UD_Hindi-PUD/hi_pud-ud-test.conllu"
"UD_210 test set of HINDI_PUD."
UD_210_HINDI_ENGLISH_HIENCS_TRAIN = _UD_210_HOME + "UD_Hindi_English-HIENCS/qhe_hiencs-ud-train.conllu"
"UD_210 train set of HINDI_ENGLISH_HIENCS."
UD_210_HINDI_ENGLISH_HIENCS_DEV = _UD_210_HOME + "UD_Hindi_English-HIENCS/qhe_hiencs-ud-dev.conllu"
"UD_210 dev set of HINDI_ENGLISH_HIENCS."
UD_210_HINDI_ENGLISH_HIENCS_TEST = _UD_210_HOME + "UD_Hindi_English-HIENCS/qhe_hiencs-ud-test.conllu"
"UD_210 test set of HINDI_ENGLISH_HIENCS."
UD_210_HITTITE_HITTB_TEST = _UD_210_HOME + "UD_Hittite-HitTB/hit_hittb-ud-test.conllu"
"UD_210 test set of HITTITE_HITTB."
UD_210_HUNGARIAN_SZEGED_TRAIN = _UD_210_HOME + "UD_Hungarian-Szeged/hu_szeged-ud-train.conllu"
"UD_210 train set of HUNGARIAN_SZEGED."
UD_210_HUNGARIAN_SZEGED_DEV = _UD_210_HOME + "UD_Hungarian-Szeged/hu_szeged-ud-dev.conllu"
"UD_210 dev set of HUNGARIAN_SZEGED."
UD_210_HUNGARIAN_SZEGED_TEST = _UD_210_HOME + "UD_Hungarian-Szeged/hu_szeged-ud-test.conllu"
"UD_210 test set of HUNGARIAN_SZEGED."
UD_210_ICELANDIC_ICEPAHC_TRAIN = _UD_210_HOME + "UD_Icelandic-IcePaHC/is_icepahc-ud-train.conllu"
"UD_210 train set of ICELANDIC_ICEPAHC."
UD_210_ICELANDIC_ICEPAHC_DEV = _UD_210_HOME + "UD_Icelandic-IcePaHC/is_icepahc-ud-dev.conllu"
"UD_210 dev set of ICELANDIC_ICEPAHC."
UD_210_ICELANDIC_ICEPAHC_TEST = _UD_210_HOME + "UD_Icelandic-IcePaHC/is_icepahc-ud-test.conllu"
"UD_210 test set of ICELANDIC_ICEPAHC."
UD_210_ICELANDIC_MODERN_TRAIN = _UD_210_HOME + "UD_Icelandic-Modern/is_modern-ud-train.conllu"
"UD_210 train set of ICELANDIC_MODERN."
UD_210_ICELANDIC_MODERN_DEV = _UD_210_HOME + "UD_Icelandic-Modern/is_modern-ud-dev.conllu"
"UD_210 dev set of ICELANDIC_MODERN."
UD_210_ICELANDIC_MODERN_TEST = _UD_210_HOME + "UD_Icelandic-Modern/is_modern-ud-test.conllu"
"UD_210 test set of ICELANDIC_MODERN."
UD_210_ICELANDIC_PUD_TEST = _UD_210_HOME + "UD_Icelandic-PUD/is_pud-ud-test.conllu"
"UD_210 test set of ICELANDIC_PUD."
UD_210_INDONESIAN_CSUI_TRAIN = _UD_210_HOME + "UD_Indonesian-CSUI/id_csui-ud-train.conllu"
"UD_210 train set of INDONESIAN_CSUI."
UD_210_INDONESIAN_CSUI_TEST = _UD_210_HOME + "UD_Indonesian-CSUI/id_csui-ud-test.conllu"
"UD_210 test set of INDONESIAN_CSUI."
UD_210_INDONESIAN_GSD_TRAIN = _UD_210_HOME + "UD_Indonesian-GSD/id_gsd-ud-train.conllu"
"UD_210 train set of INDONESIAN_GSD."
UD_210_INDONESIAN_GSD_DEV = _UD_210_HOME + "UD_Indonesian-GSD/id_gsd-ud-dev.conllu"
"UD_210 dev set of INDONESIAN_GSD."
UD_210_INDONESIAN_GSD_TEST = _UD_210_HOME + "UD_Indonesian-GSD/id_gsd-ud-test.conllu"
"UD_210 test set of INDONESIAN_GSD."
UD_210_INDONESIAN_PUD_TEST = _UD_210_HOME + "UD_Indonesian-PUD/id_pud-ud-test.conllu"
"UD_210 test set of INDONESIAN_PUD."
UD_210_IRISH_IDT_TRAIN = _UD_210_HOME + "UD_Irish-IDT/ga_idt-ud-train.conllu"
"UD_210 train set of IRISH_IDT."
UD_210_IRISH_IDT_DEV = _UD_210_HOME + "UD_Irish-IDT/ga_idt-ud-dev.conllu"
"UD_210 dev set of IRISH_IDT."
UD_210_IRISH_IDT_TEST = _UD_210_HOME + "UD_Irish-IDT/ga_idt-ud-test.conllu"
"UD_210 test set of IRISH_IDT."
UD_210_IRISH_TWITTIRISH_TEST = _UD_210_HOME + "UD_Irish-TwittIrish/ga_twittirish-ud-test.conllu"
"UD_210 test set of IRISH_TWITTIRISH."
UD_210_ITALIAN_ISDT_TRAIN = _UD_210_HOME + "UD_Italian-ISDT/it_isdt-ud-train.conllu"
"UD_210 train set of ITALIAN_ISDT."
UD_210_ITALIAN_ISDT_DEV = _UD_210_HOME + "UD_Italian-ISDT/it_isdt-ud-dev.conllu"
"UD_210 dev set of ITALIAN_ISDT."
UD_210_ITALIAN_ISDT_TEST = _UD_210_HOME + "UD_Italian-ISDT/it_isdt-ud-test.conllu"
"UD_210 test set of ITALIAN_ISDT."
UD_210_ITALIAN_MARKIT_TRAIN = _UD_210_HOME + "UD_Italian-MarkIT/it_markit-ud-train.conllu"
"UD_210 train set of ITALIAN_MARKIT."
UD_210_ITALIAN_MARKIT_DEV = _UD_210_HOME + "UD_Italian-MarkIT/it_markit-ud-dev.conllu"
"UD_210 dev set of ITALIAN_MARKIT."
UD_210_ITALIAN_MARKIT_TEST = _UD_210_HOME + "UD_Italian-MarkIT/it_markit-ud-test.conllu"
"UD_210 test set of ITALIAN_MARKIT."
UD_210_ITALIAN_PUD_TEST = _UD_210_HOME + "UD_Italian-PUD/it_pud-ud-test.conllu"
"UD_210 test set of ITALIAN_PUD."
UD_210_ITALIAN_PARTUT_TRAIN = _UD_210_HOME + "UD_Italian-ParTUT/it_partut-ud-train.conllu"
"UD_210 train set of ITALIAN_PARTUT."
UD_210_ITALIAN_PARTUT_DEV = _UD_210_HOME + "UD_Italian-ParTUT/it_partut-ud-dev.conllu"
"UD_210 dev set of ITALIAN_PARTUT."
UD_210_ITALIAN_PARTUT_TEST = _UD_210_HOME + "UD_Italian-ParTUT/it_partut-ud-test.conllu"
"UD_210 test set of ITALIAN_PARTUT."
UD_210_ITALIAN_POSTWITA_TRAIN = _UD_210_HOME + "UD_Italian-PoSTWITA/it_postwita-ud-train.conllu"
"UD_210 train set of ITALIAN_POSTWITA."
UD_210_ITALIAN_POSTWITA_DEV = _UD_210_HOME + "UD_Italian-PoSTWITA/it_postwita-ud-dev.conllu"
"UD_210 dev set of ITALIAN_POSTWITA."
UD_210_ITALIAN_POSTWITA_TEST = _UD_210_HOME + "UD_Italian-PoSTWITA/it_postwita-ud-test.conllu"
"UD_210 test set of ITALIAN_POSTWITA."
UD_210_ITALIAN_TWITTIRO_TRAIN = _UD_210_HOME + "UD_Italian-TWITTIRO/it_twittiro-ud-train.conllu"
"UD_210 train set of ITALIAN_TWITTIRO."
UD_210_ITALIAN_TWITTIRO_DEV = _UD_210_HOME + "UD_Italian-TWITTIRO/it_twittiro-ud-dev.conllu"
"UD_210 dev set of ITALIAN_TWITTIRO."
UD_210_ITALIAN_TWITTIRO_TEST = _UD_210_HOME + "UD_Italian-TWITTIRO/it_twittiro-ud-test.conllu"
"UD_210 test set of ITALIAN_TWITTIRO."
UD_210_ITALIAN_VIT_TRAIN = _UD_210_HOME + "UD_Italian-VIT/it_vit-ud-train.conllu"
"UD_210 train set of ITALIAN_VIT."
UD_210_ITALIAN_VIT_DEV = _UD_210_HOME + "UD_Italian-VIT/it_vit-ud-dev.conllu"
"UD_210 dev set of ITALIAN_VIT."
UD_210_ITALIAN_VIT_TEST = _UD_210_HOME + "UD_Italian-VIT/it_vit-ud-test.conllu"
"UD_210 test set of ITALIAN_VIT."
UD_210_ITALIAN_VALICO_TEST = _UD_210_HOME + "UD_Italian-Valico/it_valico-ud-test.conllu"
"UD_210 test set of ITALIAN_VALICO."
UD_210_JAPANESE_BCCWJ_TRAIN = _UD_210_HOME + "UD_Japanese-BCCWJ/ja_bccwj-ud-train.conllu"
"UD_210 train set of JAPANESE_BCCWJ."
UD_210_JAPANESE_BCCWJ_DEV = _UD_210_HOME + "UD_Japanese-BCCWJ/ja_bccwj-ud-dev.conllu"
"UD_210 dev set of JAPANESE_BCCWJ."
UD_210_JAPANESE_BCCWJ_TEST = _UD_210_HOME + "UD_Japanese-BCCWJ/ja_bccwj-ud-test.conllu"
"UD_210 test set of JAPANESE_BCCWJ."
UD_210_JAPANESE_BCCWJLUW_TRAIN = _UD_210_HOME + "UD_Japanese-BCCWJLUW/ja_bccwjluw-ud-train.conllu"
"UD_210 train set of JAPANESE_BCCWJLUW."
UD_210_JAPANESE_BCCWJLUW_DEV = _UD_210_HOME + "UD_Japanese-BCCWJLUW/ja_bccwjluw-ud-dev.conllu"
"UD_210 dev set of JAPANESE_BCCWJLUW."
UD_210_JAPANESE_BCCWJLUW_TEST = _UD_210_HOME + "UD_Japanese-BCCWJLUW/ja_bccwjluw-ud-test.conllu"
"UD_210 test set of JAPANESE_BCCWJLUW."
UD_210_JAPANESE_GSD_TRAIN = _UD_210_HOME + "UD_Japanese-GSD/ja_gsd-ud-train.conllu"
"UD_210 train set of JAPANESE_GSD."
UD_210_JAPANESE_GSD_DEV = _UD_210_HOME + "UD_Japanese-GSD/ja_gsd-ud-dev.conllu"
"UD_210 dev set of JAPANESE_GSD."
UD_210_JAPANESE_GSD_TEST = _UD_210_HOME + "UD_Japanese-GSD/ja_gsd-ud-test.conllu"
"UD_210 test set of JAPANESE_GSD."
UD_210_JAPANESE_GSDLUW_TRAIN = _UD_210_HOME + "UD_Japanese-GSDLUW/ja_gsdluw-ud-train.conllu"
"UD_210 train set of JAPANESE_GSDLUW."
UD_210_JAPANESE_GSDLUW_DEV = _UD_210_HOME + "UD_Japanese-GSDLUW/ja_gsdluw-ud-dev.conllu"
"UD_210 dev set of JAPANESE_GSDLUW."
UD_210_JAPANESE_GSDLUW_TEST = _UD_210_HOME + "UD_Japanese-GSDLUW/ja_gsdluw-ud-test.conllu"
"UD_210 test set of JAPANESE_GSDLUW."
UD_210_JAPANESE_MODERN_TEST = _UD_210_HOME + "UD_Japanese-Modern/ja_modern-ud-test.conllu"
"UD_210 test set of JAPANESE_MODERN."
UD_210_JAPANESE_PUD_TEST = _UD_210_HOME + "UD_Japanese-PUD/ja_pud-ud-test.conllu"
"UD_210 test set of JAPANESE_PUD."
UD_210_JAPANESE_PUDLUW_TEST = _UD_210_HOME + "UD_Japanese-PUDLUW/ja_pudluw-ud-test.conllu"
"UD_210 test set of JAPANESE_PUDLUW."
UD_210_JAVANESE_CSUI_TEST = _UD_210_HOME + "UD_Javanese-CSUI/jv_csui-ud-test.conllu"
"UD_210 test set of JAVANESE_CSUI."
UD_210_KAAPOR_TUDET_TEST = _UD_210_HOME + "UD_Kaapor-TuDeT/urb_tudet-ud-test.conllu"
"UD_210 test set of KAAPOR_TUDET."
UD_210_KANGRI_KDTB_TEST = _UD_210_HOME + "UD_Kangri-KDTB/xnr_kdtb-ud-test.conllu"
"UD_210 test set of KANGRI_KDTB."
UD_210_KARELIAN_KKPP_TEST = _UD_210_HOME + "UD_Karelian-KKPP/krl_kkpp-ud-test.conllu"
"UD_210 test set of KARELIAN_KKPP."
UD_210_KARO_TUDET_TEST = _UD_210_HOME + "UD_Karo-TuDeT/arr_tudet-ud-test.conllu"
"UD_210 test set of KARO_TUDET."
UD_210_KAZAKH_KTB_TRAIN = _UD_210_HOME + "UD_Kazakh-KTB/kk_ktb-ud-train.conllu"
"UD_210 train set of KAZAKH_KTB."
UD_210_KAZAKH_KTB_TEST = _UD_210_HOME + "UD_Kazakh-KTB/kk_ktb-ud-test.conllu"
"UD_210 test set of KAZAKH_KTB."
UD_210_KHUNSARI_AHA_TEST = _UD_210_HOME + "UD_Khunsari-AHA/kfm_aha-ud-test.conllu"
"UD_210 test set of KHUNSARI_AHA."
UD_210_KICHE_IU_TEST = _UD_210_HOME + "UD_Kiche-IU/quc_iu-ud-test.conllu"
"UD_210 test set of KICHE_IU."
UD_210_KOMI_PERMYAK_UH_TEST = _UD_210_HOME + "UD_Komi_Permyak-UH/koi_uh-ud-test.conllu"
"UD_210 test set of KOMI_PERMYAK_UH."
UD_210_KOMI_ZYRIAN_IKDP_TEST = _UD_210_HOME + "UD_Komi_Zyrian-IKDP/kpv_ikdp-ud-test.conllu"
"UD_210 test set of KOMI_ZYRIAN_IKDP."
UD_210_KOMI_ZYRIAN_LATTICE_TEST = _UD_210_HOME + "UD_Komi_Zyrian-Lattice/kpv_lattice-ud-test.conllu"
"UD_210 test set of KOMI_ZYRIAN_LATTICE."
UD_210_KOREAN_GSD_TRAIN = _UD_210_HOME + "UD_Korean-GSD/ko_gsd-ud-train.conllu"
"UD_210 train set of KOREAN_GSD."
UD_210_KOREAN_GSD_DEV = _UD_210_HOME + "UD_Korean-GSD/ko_gsd-ud-dev.conllu"
"UD_210 dev set of KOREAN_GSD."
UD_210_KOREAN_GSD_TEST = _UD_210_HOME + "UD_Korean-GSD/ko_gsd-ud-test.conllu"
"UD_210 test set of KOREAN_GSD."
UD_210_KOREAN_KAIST_TRAIN = _UD_210_HOME + "UD_Korean-Kaist/ko_kaist-ud-train.conllu"
"UD_210 train set of KOREAN_KAIST."
UD_210_KOREAN_KAIST_DEV = _UD_210_HOME + "UD_Korean-Kaist/ko_kaist-ud-dev.conllu"
"UD_210 dev set of KOREAN_KAIST."
UD_210_KOREAN_KAIST_TEST = _UD_210_HOME + "UD_Korean-Kaist/ko_kaist-ud-test.conllu"
"UD_210 test set of KOREAN_KAIST."
UD_210_KOREAN_PUD_TEST = _UD_210_HOME + "UD_Korean-PUD/ko_pud-ud-test.conllu"
"UD_210 test set of KOREAN_PUD."
UD_210_KURMANJI_MG_TRAIN = _UD_210_HOME + "UD_Kurmanji-MG/kmr_mg-ud-train.conllu"
"UD_210 train set of KURMANJI_MG."
UD_210_KURMANJI_MG_TEST = _UD_210_HOME + "UD_Kurmanji-MG/kmr_mg-ud-test.conllu"
"UD_210 test set of KURMANJI_MG."
UD_210_LATIN_ITTB_TRAIN = _UD_210_HOME + "UD_Latin-ITTB/la_ittb-ud-train.conllu"
"UD_210 train set of LATIN_ITTB."
UD_210_LATIN_ITTB_DEV = _UD_210_HOME + "UD_Latin-ITTB/la_ittb-ud-dev.conllu"
"UD_210 dev set of LATIN_ITTB."
UD_210_LATIN_ITTB_TEST = _UD_210_HOME + "UD_Latin-ITTB/la_ittb-ud-test.conllu"
"UD_210 test set of LATIN_ITTB."
UD_210_LATIN_LLCT_TRAIN = _UD_210_HOME + "UD_Latin-LLCT/la_llct-ud-train.conllu"
"UD_210 train set of LATIN_LLCT."
UD_210_LATIN_LLCT_DEV = _UD_210_HOME + "UD_Latin-LLCT/la_llct-ud-dev.conllu"
"UD_210 dev set of LATIN_LLCT."
UD_210_LATIN_LLCT_TEST = _UD_210_HOME + "UD_Latin-LLCT/la_llct-ud-test.conllu"
"UD_210 test set of LATIN_LLCT."
UD_210_LATIN_PROIEL_TRAIN = _UD_210_HOME + "UD_Latin-PROIEL/la_proiel-ud-train.conllu"
"UD_210 train set of LATIN_PROIEL."
UD_210_LATIN_PROIEL_DEV = _UD_210_HOME + "UD_Latin-PROIEL/la_proiel-ud-dev.conllu"
"UD_210 dev set of LATIN_PROIEL."
UD_210_LATIN_PROIEL_TEST = _UD_210_HOME + "UD_Latin-PROIEL/la_proiel-ud-test.conllu"
"UD_210 test set of LATIN_PROIEL."
UD_210_LATIN_PERSEUS_TRAIN = _UD_210_HOME + "UD_Latin-Perseus/la_perseus-ud-train.conllu"
"UD_210 train set of LATIN_PERSEUS."
UD_210_LATIN_PERSEUS_TEST = _UD_210_HOME + "UD_Latin-Perseus/la_perseus-ud-test.conllu"
"UD_210 test set of LATIN_PERSEUS."
UD_210_LATIN_UDANTE_TRAIN = _UD_210_HOME + "UD_Latin-UDante/la_udante-ud-train.conllu"
"UD_210 train set of LATIN_UDANTE."
UD_210_LATIN_UDANTE_DEV = _UD_210_HOME + "UD_Latin-UDante/la_udante-ud-dev.conllu"
"UD_210 dev set of LATIN_UDANTE."
UD_210_LATIN_UDANTE_TEST = _UD_210_HOME + "UD_Latin-UDante/la_udante-ud-test.conllu"
"UD_210 test set of LATIN_UDANTE."
UD_210_LATVIAN_LVTB_TRAIN = _UD_210_HOME + "UD_Latvian-LVTB/lv_lvtb-ud-train.conllu"
"UD_210 train set of LATVIAN_LVTB."
UD_210_LATVIAN_LVTB_DEV = _UD_210_HOME + "UD_Latvian-LVTB/lv_lvtb-ud-dev.conllu"
"UD_210 dev set of LATVIAN_LVTB."
UD_210_LATVIAN_LVTB_TEST = _UD_210_HOME + "UD_Latvian-LVTB/lv_lvtb-ud-test.conllu"
"UD_210 test set of LATVIAN_LVTB."
UD_210_LIGURIAN_GLT_TRAIN = _UD_210_HOME + "UD_Ligurian-GLT/lij_glt-ud-train.conllu"
"UD_210 train set of LIGURIAN_GLT."
UD_210_LIGURIAN_GLT_TEST = _UD_210_HOME + "UD_Ligurian-GLT/lij_glt-ud-test.conllu"
"UD_210 test set of LIGURIAN_GLT."
UD_210_LITHUANIAN_ALKSNIS_TRAIN = _UD_210_HOME + "UD_Lithuanian-ALKSNIS/lt_alksnis-ud-train.conllu"
"UD_210 train set of LITHUANIAN_ALKSNIS."
UD_210_LITHUANIAN_ALKSNIS_DEV = _UD_210_HOME + "UD_Lithuanian-ALKSNIS/lt_alksnis-ud-dev.conllu"
"UD_210 dev set of LITHUANIAN_ALKSNIS."
UD_210_LITHUANIAN_ALKSNIS_TEST = _UD_210_HOME + "UD_Lithuanian-ALKSNIS/lt_alksnis-ud-test.conllu"
"UD_210 test set of LITHUANIAN_ALKSNIS."
UD_210_LITHUANIAN_HSE_TRAIN = _UD_210_HOME + "UD_Lithuanian-HSE/lt_hse-ud-train.conllu"
"UD_210 train set of LITHUANIAN_HSE."
UD_210_LITHUANIAN_HSE_DEV = _UD_210_HOME + "UD_Lithuanian-HSE/lt_hse-ud-dev.conllu"
"UD_210 dev set of LITHUANIAN_HSE."
UD_210_LITHUANIAN_HSE_TEST = _UD_210_HOME + "UD_Lithuanian-HSE/lt_hse-ud-test.conllu"
"UD_210 test set of LITHUANIAN_HSE."
UD_210_LIVVI_KKPP_TRAIN = _UD_210_HOME + "UD_Livvi-KKPP/olo_kkpp-ud-train.conllu"
"UD_210 train set of LIVVI_KKPP."
UD_210_LIVVI_KKPP_TEST = _UD_210_HOME + "UD_Livvi-KKPP/olo_kkpp-ud-test.conllu"
"UD_210 test set of LIVVI_KKPP."
UD_210_LOW_SAXON_LSDC_TEST = _UD_210_HOME + "UD_Low_Saxon-LSDC/nds_lsdc-ud-test.conllu"
"UD_210 test set of LOW_SAXON_LSDC."
UD_210_MADI_JARAWARA_TEST = _UD_210_HOME + "UD_Madi-Jarawara/jaa_jarawara-ud-test.conllu"
"UD_210 test set of MADI_JARAWARA."
UD_210_MAKURAP_TUDET_TEST = _UD_210_HOME + "UD_Makurap-TuDeT/mpu_tudet-ud-test.conllu"
"UD_210 test set of MAKURAP_TUDET."
UD_210_MALTESE_MUDT_TRAIN = _UD_210_HOME + "UD_Maltese-MUDT/mt_mudt-ud-train.conllu"
"UD_210 train set of MALTESE_MUDT."
UD_210_MALTESE_MUDT_DEV = _UD_210_HOME + "UD_Maltese-MUDT/mt_mudt-ud-dev.conllu"
"UD_210 dev set of MALTESE_MUDT."
UD_210_MALTESE_MUDT_TEST = _UD_210_HOME + "UD_Maltese-MUDT/mt_mudt-ud-test.conllu"
"UD_210 test set of MALTESE_MUDT."
UD_210_MANX_CADHAN_TEST = _UD_210_HOME + "UD_Manx-Cadhan/gv_cadhan-ud-test.conllu"
"UD_210 test set of MANX_CADHAN."
UD_210_MARATHI_UFAL_TRAIN = _UD_210_HOME + "UD_Marathi-UFAL/mr_ufal-ud-train.conllu"
"UD_210 train set of MARATHI_UFAL."
UD_210_MARATHI_UFAL_DEV = _UD_210_HOME + "UD_Marathi-UFAL/mr_ufal-ud-dev.conllu"
"UD_210 dev set of MARATHI_UFAL."
UD_210_MARATHI_UFAL_TEST = _UD_210_HOME + "UD_Marathi-UFAL/mr_ufal-ud-test.conllu"
"UD_210 test set of MARATHI_UFAL."
UD_210_MBYA_GUARANI_DOOLEY_TEST = _UD_210_HOME + "UD_Mbya_Guarani-Dooley/gun_dooley-ud-test.conllu"
"UD_210 test set of MBYA_GUARANI_DOOLEY."
UD_210_MBYA_GUARANI_THOMAS_TEST = _UD_210_HOME + "UD_Mbya_Guarani-Thomas/gun_thomas-ud-test.conllu"
"UD_210 test set of MBYA_GUARANI_THOMAS."
UD_210_MOKSHA_JR_TEST = _UD_210_HOME + "UD_Moksha-JR/mdf_jr-ud-test.conllu"
"UD_210 test set of MOKSHA_JR."
UD_210_MUNDURUKU_TUDET_TEST = _UD_210_HOME + "UD_Munduruku-TuDeT/myu_tudet-ud-test.conllu"
"UD_210 test set of MUNDURUKU_TUDET."
UD_210_NAIJA_NSC_TRAIN = _UD_210_HOME + "UD_Naija-NSC/pcm_nsc-ud-train.conllu"
"UD_210 train set of NAIJA_NSC."
UD_210_NAIJA_NSC_DEV = _UD_210_HOME + "UD_Naija-NSC/pcm_nsc-ud-dev.conllu"
"UD_210 dev set of NAIJA_NSC."
UD_210_NAIJA_NSC_TEST = _UD_210_HOME + "UD_Naija-NSC/pcm_nsc-ud-test.conllu"
"UD_210 test set of NAIJA_NSC."
UD_210_NAYINI_AHA_TEST = _UD_210_HOME + "UD_Nayini-AHA/nyq_aha-ud-test.conllu"
"UD_210 test set of NAYINI_AHA."
UD_210_NEAPOLITAN_RB_TEST = _UD_210_HOME + "UD_Neapolitan-RB/nap_rb-ud-test.conllu"
"UD_210 test set of NEAPOLITAN_RB."
UD_210_NORTH_SAMI_GIELLA_TRAIN = _UD_210_HOME + "UD_North_Sami-Giella/sme_giella-ud-train.conllu"
"UD_210 train set of NORTH_SAMI_GIELLA."
UD_210_NORTH_SAMI_GIELLA_TEST = _UD_210_HOME + "UD_North_Sami-Giella/sme_giella-ud-test.conllu"
"UD_210 test set of NORTH_SAMI_GIELLA."
UD_210_NORWEGIAN_BOKMAAL_TRAIN = _UD_210_HOME + "UD_Norwegian-Bokmaal/no_bokmaal-ud-train.conllu"
"UD_210 train set of NORWEGIAN_BOKMAAL."
UD_210_NORWEGIAN_BOKMAAL_DEV = _UD_210_HOME + "UD_Norwegian-Bokmaal/no_bokmaal-ud-dev.conllu"
"UD_210 dev set of NORWEGIAN_BOKMAAL."
UD_210_NORWEGIAN_BOKMAAL_TEST = _UD_210_HOME + "UD_Norwegian-Bokmaal/no_bokmaal-ud-test.conllu"
"UD_210 test set of NORWEGIAN_BOKMAAL."
UD_210_NORWEGIAN_NYNORSK_TRAIN = _UD_210_HOME + "UD_Norwegian-Nynorsk/no_nynorsk-ud-train.conllu"
"UD_210 train set of NORWEGIAN_NYNORSK."
UD_210_NORWEGIAN_NYNORSK_DEV = _UD_210_HOME + "UD_Norwegian-Nynorsk/no_nynorsk-ud-dev.conllu"
"UD_210 dev set of NORWEGIAN_NYNORSK."
UD_210_NORWEGIAN_NYNORSK_TEST = _UD_210_HOME + "UD_Norwegian-Nynorsk/no_nynorsk-ud-test.conllu"
"UD_210 test set of NORWEGIAN_NYNORSK."
UD_210_NORWEGIAN_NYNORSKLIA_TRAIN = _UD_210_HOME + "UD_Norwegian-NynorskLIA/no_nynorsklia-ud-train.conllu"
"UD_210 train set of NORWEGIAN_NYNORSKLIA."
UD_210_NORWEGIAN_NYNORSKLIA_DEV = _UD_210_HOME + "UD_Norwegian-NynorskLIA/no_nynorsklia-ud-dev.conllu"
"UD_210 dev set of NORWEGIAN_NYNORSKLIA."
UD_210_NORWEGIAN_NYNORSKLIA_TEST = _UD_210_HOME + "UD_Norwegian-NynorskLIA/no_nynorsklia-ud-test.conllu"
"UD_210 test set of NORWEGIAN_NYNORSKLIA."
UD_210_OLD_CHURCH_SLAVONIC_PROIEL_TRAIN = _UD_210_HOME + "UD_Old_Church_Slavonic-PROIEL/cu_proiel-ud-train.conllu"
"UD_210 train set of OLD_CHURCH_SLAVONIC_PROIEL."
UD_210_OLD_CHURCH_SLAVONIC_PROIEL_DEV = _UD_210_HOME + "UD_Old_Church_Slavonic-PROIEL/cu_proiel-ud-dev.conllu"
"UD_210 dev set of OLD_CHURCH_SLAVONIC_PROIEL."
UD_210_OLD_CHURCH_SLAVONIC_PROIEL_TEST = _UD_210_HOME + "UD_Old_Church_Slavonic-PROIEL/cu_proiel-ud-test.conllu"
"UD_210 test set of OLD_CHURCH_SLAVONIC_PROIEL."
UD_210_OLD_EAST_SLAVIC_BIRCHBARK_TRAIN = _UD_210_HOME + "UD_Old_East_Slavic-Birchbark/orv_birchbark-ud-train.conllu"
"UD_210 train set of OLD_EAST_SLAVIC_BIRCHBARK."
UD_210_OLD_EAST_SLAVIC_BIRCHBARK_DEV = _UD_210_HOME + "UD_Old_East_Slavic-Birchbark/orv_birchbark-ud-dev.conllu"
"UD_210 dev set of OLD_EAST_SLAVIC_BIRCHBARK."
UD_210_OLD_EAST_SLAVIC_BIRCHBARK_TEST = _UD_210_HOME + "UD_Old_East_Slavic-Birchbark/orv_birchbark-ud-test.conllu"
"UD_210 test set of OLD_EAST_SLAVIC_BIRCHBARK."
UD_210_OLD_EAST_SLAVIC_RNC_TRAIN = _UD_210_HOME + "UD_Old_East_Slavic-RNC/orv_rnc-ud-train.conllu"
"UD_210 train set of OLD_EAST_SLAVIC_RNC."
UD_210_OLD_EAST_SLAVIC_RNC_TEST = _UD_210_HOME + "UD_Old_East_Slavic-RNC/orv_rnc-ud-test.conllu"
"UD_210 test set of OLD_EAST_SLAVIC_RNC."
UD_210_OLD_EAST_SLAVIC_TOROT_TRAIN = _UD_210_HOME + "UD_Old_East_Slavic-TOROT/orv_torot-ud-train.conllu"
"UD_210 train set of OLD_EAST_SLAVIC_TOROT."
UD_210_OLD_EAST_SLAVIC_TOROT_DEV = _UD_210_HOME + "UD_Old_East_Slavic-TOROT/orv_torot-ud-dev.conllu"
"UD_210 dev set of OLD_EAST_SLAVIC_TOROT."
UD_210_OLD_EAST_SLAVIC_TOROT_TEST = _UD_210_HOME + "UD_Old_East_Slavic-TOROT/orv_torot-ud-test.conllu"
"UD_210 test set of OLD_EAST_SLAVIC_TOROT."
UD_210_OLD_FRENCH_SRCMF_TRAIN = _UD_210_HOME + "UD_Old_French-SRCMF/fro_srcmf-ud-train.conllu"
"UD_210 train set of OLD_FRENCH_SRCMF."
UD_210_OLD_FRENCH_SRCMF_DEV = _UD_210_HOME + "UD_Old_French-SRCMF/fro_srcmf-ud-dev.conllu"
"UD_210 dev set of OLD_FRENCH_SRCMF."
UD_210_OLD_FRENCH_SRCMF_TEST = _UD_210_HOME + "UD_Old_French-SRCMF/fro_srcmf-ud-test.conllu"
"UD_210 test set of OLD_FRENCH_SRCMF."
UD_210_OLD_TURKISH_TONQQ_TEST = _UD_210_HOME + "UD_Old_Turkish-Tonqq/otk_tonqq-ud-test.conllu"
"UD_210 test set of OLD_TURKISH_TONQQ."
UD_210_PERSIAN_PERDT_TRAIN = _UD_210_HOME + "UD_Persian-PerDT/fa_perdt-ud-train.conllu"
"UD_210 train set of PERSIAN_PERDT."
UD_210_PERSIAN_PERDT_DEV = _UD_210_HOME + "UD_Persian-PerDT/fa_perdt-ud-dev.conllu"
"UD_210 dev set of PERSIAN_PERDT."
UD_210_PERSIAN_PERDT_TEST = _UD_210_HOME + "UD_Persian-PerDT/fa_perdt-ud-test.conllu"
"UD_210 test set of PERSIAN_PERDT."
UD_210_PERSIAN_SERAJI_TRAIN = _UD_210_HOME + "UD_Persian-Seraji/fa_seraji-ud-train.conllu"
"UD_210 train set of PERSIAN_SERAJI."
UD_210_PERSIAN_SERAJI_DEV = _UD_210_HOME + "UD_Persian-Seraji/fa_seraji-ud-dev.conllu"
"UD_210 dev set of PERSIAN_SERAJI."
UD_210_PERSIAN_SERAJI_TEST = _UD_210_HOME + "UD_Persian-Seraji/fa_seraji-ud-test.conllu"
"UD_210 test set of PERSIAN_SERAJI."
UD_210_POLISH_LFG_TRAIN = _UD_210_HOME + "UD_Polish-LFG/pl_lfg-ud-train.conllu"
"UD_210 train set of POLISH_LFG."
UD_210_POLISH_LFG_DEV = _UD_210_HOME + "UD_Polish-LFG/pl_lfg-ud-dev.conllu"
"UD_210 dev set of POLISH_LFG."
UD_210_POLISH_LFG_TEST = _UD_210_HOME + "UD_Polish-LFG/pl_lfg-ud-test.conllu"
"UD_210 test set of POLISH_LFG."
UD_210_POLISH_PDB_TRAIN = _UD_210_HOME + "UD_Polish-PDB/pl_pdb-ud-train.conllu"
"UD_210 train set of POLISH_PDB."
UD_210_POLISH_PDB_DEV = _UD_210_HOME + "UD_Polish-PDB/pl_pdb-ud-dev.conllu"
"UD_210 dev set of POLISH_PDB."
UD_210_POLISH_PDB_TEST = _UD_210_HOME + "UD_Polish-PDB/pl_pdb-ud-test.conllu"
"UD_210 test set of POLISH_PDB."
UD_210_POLISH_PUD_TEST = _UD_210_HOME + "UD_Polish-PUD/pl_pud-ud-test.conllu"
"UD_210 test set of POLISH_PUD."
UD_210_POMAK_PHILOTIS_TRAIN = _UD_210_HOME + "UD_Pomak-Philotis/qpm_philotis-ud-train.conllu"
"UD_210 train set of POMAK_PHILOTIS."
UD_210_POMAK_PHILOTIS_DEV = _UD_210_HOME + "UD_Pomak-Philotis/qpm_philotis-ud-dev.conllu"
"UD_210 dev set of POMAK_PHILOTIS."
UD_210_POMAK_PHILOTIS_TEST = _UD_210_HOME + "UD_Pomak-Philotis/qpm_philotis-ud-test.conllu"
"UD_210 test set of POMAK_PHILOTIS."
UD_210_PORTUGUESE_BOSQUE_TRAIN = _UD_210_HOME + "UD_Portuguese-Bosque/pt_bosque-ud-train.conllu"
"UD_210 train set of PORTUGUESE_BOSQUE."
UD_210_PORTUGUESE_BOSQUE_DEV = _UD_210_HOME + "UD_Portuguese-Bosque/pt_bosque-ud-dev.conllu"
"UD_210 dev set of PORTUGUESE_BOSQUE."
UD_210_PORTUGUESE_BOSQUE_TEST = _UD_210_HOME + "UD_Portuguese-Bosque/pt_bosque-ud-test.conllu"
"UD_210 test set of PORTUGUESE_BOSQUE."
UD_210_PORTUGUESE_GSD_TRAIN = _UD_210_HOME + "UD_Portuguese-GSD/pt_gsd-ud-train.conllu"
"UD_210 train set of PORTUGUESE_GSD."
UD_210_PORTUGUESE_GSD_DEV = _UD_210_HOME + "UD_Portuguese-GSD/pt_gsd-ud-dev.conllu"
"UD_210 dev set of PORTUGUESE_GSD."
UD_210_PORTUGUESE_GSD_TEST = _UD_210_HOME + "UD_Portuguese-GSD/pt_gsd-ud-test.conllu"
"UD_210 test set of PORTUGUESE_GSD."
UD_210_PORTUGUESE_PUD_TEST = _UD_210_HOME + "UD_Portuguese-PUD/pt_pud-ud-test.conllu"
"UD_210 test set of PORTUGUESE_PUD."
UD_210_ROMANIAN_ART_TEST = _UD_210_HOME + "UD_Romanian-ArT/ro_art-ud-test.conllu"
"UD_210 test set of ROMANIAN_ART."
UD_210_ROMANIAN_NONSTANDARD_TRAIN = _UD_210_HOME + "UD_Romanian-Nonstandard/ro_nonstandard-ud-train.conllu"
"UD_210 train set of ROMANIAN_NONSTANDARD."
UD_210_ROMANIAN_NONSTANDARD_DEV = _UD_210_HOME + "UD_Romanian-Nonstandard/ro_nonstandard-ud-dev.conllu"
"UD_210 dev set of ROMANIAN_NONSTANDARD."
UD_210_ROMANIAN_NONSTANDARD_TEST = _UD_210_HOME + "UD_Romanian-Nonstandard/ro_nonstandard-ud-test.conllu"
"UD_210 test set of ROMANIAN_NONSTANDARD."
UD_210_ROMANIAN_RRT_TRAIN = _UD_210_HOME + "UD_Romanian-RRT/ro_rrt-ud-train.conllu"
"UD_210 train set of ROMANIAN_RRT."
UD_210_ROMANIAN_RRT_DEV = _UD_210_HOME + "UD_Romanian-RRT/ro_rrt-ud-dev.conllu"
"UD_210 dev set of ROMANIAN_RRT."
UD_210_ROMANIAN_RRT_TEST = _UD_210_HOME + "UD_Romanian-RRT/ro_rrt-ud-test.conllu"
"UD_210 test set of ROMANIAN_RRT."
UD_210_ROMANIAN_SIMONERO_TRAIN = _UD_210_HOME + "UD_Romanian-SiMoNERo/ro_simonero-ud-train.conllu"
"UD_210 train set of ROMANIAN_SIMONERO."
UD_210_ROMANIAN_SIMONERO_DEV = _UD_210_HOME + "UD_Romanian-SiMoNERo/ro_simonero-ud-dev.conllu"
"UD_210 dev set of ROMANIAN_SIMONERO."
UD_210_ROMANIAN_SIMONERO_TEST = _UD_210_HOME + "UD_Romanian-SiMoNERo/ro_simonero-ud-test.conllu"
"UD_210 test set of ROMANIAN_SIMONERO."
UD_210_RUSSIAN_GSD_TRAIN = _UD_210_HOME + "UD_Russian-GSD/ru_gsd-ud-train.conllu"
"UD_210 train set of RUSSIAN_GSD."
UD_210_RUSSIAN_GSD_DEV = _UD_210_HOME + "UD_Russian-GSD/ru_gsd-ud-dev.conllu"
"UD_210 dev set of RUSSIAN_GSD."
UD_210_RUSSIAN_GSD_TEST = _UD_210_HOME + "UD_Russian-GSD/ru_gsd-ud-test.conllu"
"UD_210 test set of RUSSIAN_GSD."
UD_210_RUSSIAN_PUD_TEST = _UD_210_HOME + "UD_Russian-PUD/ru_pud-ud-test.conllu"
"UD_210 test set of RUSSIAN_PUD."
UD_210_RUSSIAN_SYNTAGRUS_TRAIN = _UD_210_HOME + "UD_Russian-SynTagRus/ru_syntagrus-ud-train.conllu"
"UD_210 train set of RUSSIAN_SYNTAGRUS."
UD_210_RUSSIAN_SYNTAGRUS_DEV = _UD_210_HOME + "UD_Russian-SynTagRus/ru_syntagrus-ud-dev.conllu"
"UD_210 dev set of RUSSIAN_SYNTAGRUS."
UD_210_RUSSIAN_SYNTAGRUS_TEST = _UD_210_HOME + "UD_Russian-SynTagRus/ru_syntagrus-ud-test.conllu"
"UD_210 test set of RUSSIAN_SYNTAGRUS."
UD_210_RUSSIAN_TAIGA_TRAIN = _UD_210_HOME + "UD_Russian-Taiga/ru_taiga-ud-train.conllu"
"UD_210 train set of RUSSIAN_TAIGA."
UD_210_RUSSIAN_TAIGA_DEV = _UD_210_HOME + "UD_Russian-Taiga/ru_taiga-ud-dev.conllu"
"UD_210 dev set of RUSSIAN_TAIGA."
UD_210_RUSSIAN_TAIGA_TEST = _UD_210_HOME + "UD_Russian-Taiga/ru_taiga-ud-test.conllu"
"UD_210 test set of RUSSIAN_TAIGA."
UD_210_SANSKRIT_UFAL_TEST = _UD_210_HOME + "UD_Sanskrit-UFAL/sa_ufal-ud-test.conllu"
"UD_210 test set of SANSKRIT_UFAL."
UD_210_SANSKRIT_VEDIC_TRAIN = _UD_210_HOME + "UD_Sanskrit-Vedic/sa_vedic-ud-train.conllu"
"UD_210 train set of SANSKRIT_VEDIC."
UD_210_SANSKRIT_VEDIC_TEST = _UD_210_HOME + "UD_Sanskrit-Vedic/sa_vedic-ud-test.conllu"
"UD_210 test set of SANSKRIT_VEDIC."
UD_210_SCOTTISH_GAELIC_ARCOSG_TRAIN = _UD_210_HOME + "UD_Scottish_Gaelic-ARCOSG/gd_arcosg-ud-train.conllu"
"UD_210 train set of SCOTTISH_GAELIC_ARCOSG."
UD_210_SCOTTISH_GAELIC_ARCOSG_DEV = _UD_210_HOME + "UD_Scottish_Gaelic-ARCOSG/gd_arcosg-ud-dev.conllu"
"UD_210 dev set of SCOTTISH_GAELIC_ARCOSG."
UD_210_SCOTTISH_GAELIC_ARCOSG_TEST = _UD_210_HOME + "UD_Scottish_Gaelic-ARCOSG/gd_arcosg-ud-test.conllu"
"UD_210 test set of SCOTTISH_GAELIC_ARCOSG."
UD_210_SERBIAN_SET_TRAIN = _UD_210_HOME + "UD_Serbian-SET/sr_set-ud-train.conllu"
"UD_210 train set of SERBIAN_SET."
UD_210_SERBIAN_SET_DEV = _UD_210_HOME + "UD_Serbian-SET/sr_set-ud-dev.conllu"
"UD_210 dev set of SERBIAN_SET."
UD_210_SERBIAN_SET_TEST = _UD_210_HOME + "UD_Serbian-SET/sr_set-ud-test.conllu"
"UD_210 test set of SERBIAN_SET."
UD_210_SKOLT_SAMI_GIELLAGAS_TEST = _UD_210_HOME + "UD_Skolt_Sami-Giellagas/sms_giellagas-ud-test.conllu"
"UD_210 test set of SKOLT_SAMI_GIELLAGAS."
UD_210_SLOVAK_SNK_TRAIN = _UD_210_HOME + "UD_Slovak-SNK/sk_snk-ud-train.conllu"
"UD_210 train set of SLOVAK_SNK."
UD_210_SLOVAK_SNK_DEV = _UD_210_HOME + "UD_Slovak-SNK/sk_snk-ud-dev.conllu"
"UD_210 dev set of SLOVAK_SNK."
UD_210_SLOVAK_SNK_TEST = _UD_210_HOME + "UD_Slovak-SNK/sk_snk-ud-test.conllu"
"UD_210 test set of SLOVAK_SNK."
UD_210_SLOVENIAN_SSJ_TRAIN = _UD_210_HOME + "UD_Slovenian-SSJ/sl_ssj-ud-train.conllu"
"UD_210 train set of SLOVENIAN_SSJ."
UD_210_SLOVENIAN_SSJ_DEV = _UD_210_HOME + "UD_Slovenian-SSJ/sl_ssj-ud-dev.conllu"
"UD_210 dev set of SLOVENIAN_SSJ."
UD_210_SLOVENIAN_SSJ_TEST = _UD_210_HOME + "UD_Slovenian-SSJ/sl_ssj-ud-test.conllu"
"UD_210 test set of SLOVENIAN_SSJ."
UD_210_SLOVENIAN_SST_TRAIN = _UD_210_HOME + "UD_Slovenian-SST/sl_sst-ud-train.conllu"
"UD_210 train set of SLOVENIAN_SST."
UD_210_SLOVENIAN_SST_TEST = _UD_210_HOME + "UD_Slovenian-SST/sl_sst-ud-test.conllu"
"UD_210 test set of SLOVENIAN_SST."
UD_210_SOI_AHA_TEST = _UD_210_HOME + "UD_Soi-AHA/soj_aha-ud-test.conllu"
"UD_210 test set of SOI_AHA."
UD_210_SOUTH_LEVANTINE_ARABIC_MADAR_TEST = _UD_210_HOME + "UD_South_Levantine_Arabic-MADAR/ajp_madar-ud-test.conllu"
"UD_210 test set of SOUTH_LEVANTINE_ARABIC_MADAR."
UD_210_SPANISH_ANCORA_TRAIN = _UD_210_HOME + "UD_Spanish-AnCora/es_ancora-ud-train.conllu"
"UD_210 train set of SPANISH_ANCORA."
UD_210_SPANISH_ANCORA_DEV = _UD_210_HOME + "UD_Spanish-AnCora/es_ancora-ud-dev.conllu"
"UD_210 dev set of SPANISH_ANCORA."
UD_210_SPANISH_ANCORA_TEST = _UD_210_HOME + "UD_Spanish-AnCora/es_ancora-ud-test.conllu"
"UD_210 test set of SPANISH_ANCORA."
UD_210_SPANISH_GSD_TRAIN = _UD_210_HOME + "UD_Spanish-GSD/es_gsd-ud-train.conllu"
"UD_210 train set of SPANISH_GSD."
UD_210_SPANISH_GSD_DEV = _UD_210_HOME + "UD_Spanish-GSD/es_gsd-ud-dev.conllu"
"UD_210 dev set of SPANISH_GSD."
UD_210_SPANISH_GSD_TEST = _UD_210_HOME + "UD_Spanish-GSD/es_gsd-ud-test.conllu"
"UD_210 test set of SPANISH_GSD."
UD_210_SPANISH_PUD_TEST = _UD_210_HOME + "UD_Spanish-PUD/es_pud-ud-test.conllu"
"UD_210 test set of SPANISH_PUD."
UD_210_SWEDISH_LINES_TRAIN = _UD_210_HOME + "UD_Swedish-LinES/sv_lines-ud-train.conllu"
"UD_210 train set of SWEDISH_LINES."
UD_210_SWEDISH_LINES_DEV = _UD_210_HOME + "UD_Swedish-LinES/sv_lines-ud-dev.conllu"
"UD_210 dev set of SWEDISH_LINES."
UD_210_SWEDISH_LINES_TEST = _UD_210_HOME + "UD_Swedish-LinES/sv_lines-ud-test.conllu"
"UD_210 test set of SWEDISH_LINES."
UD_210_SWEDISH_PUD_TEST = _UD_210_HOME + "UD_Swedish-PUD/sv_pud-ud-test.conllu"
"UD_210 test set of SWEDISH_PUD."
UD_210_SWEDISH_TALBANKEN_TRAIN = _UD_210_HOME + "UD_Swedish-Talbanken/sv_talbanken-ud-train.conllu"
"UD_210 train set of SWEDISH_TALBANKEN."
UD_210_SWEDISH_TALBANKEN_DEV = _UD_210_HOME + "UD_Swedish-Talbanken/sv_talbanken-ud-dev.conllu"
"UD_210 dev set of SWEDISH_TALBANKEN."
UD_210_SWEDISH_TALBANKEN_TEST = _UD_210_HOME + "UD_Swedish-Talbanken/sv_talbanken-ud-test.conllu"
"UD_210 test set of SWEDISH_TALBANKEN."
UD_210_SWEDISH_SIGN_LANGUAGE_SSLC_TRAIN = _UD_210_HOME + "UD_Swedish_Sign_Language-SSLC/swl_sslc-ud-train.conllu"
"UD_210 train set of SWEDISH_SIGN_LANGUAGE_SSLC."
UD_210_SWEDISH_SIGN_LANGUAGE_SSLC_DEV = _UD_210_HOME + "UD_Swedish_Sign_Language-SSLC/swl_sslc-ud-dev.conllu"
"UD_210 dev set of SWEDISH_SIGN_LANGUAGE_SSLC."
UD_210_SWEDISH_SIGN_LANGUAGE_SSLC_TEST = _UD_210_HOME + "UD_Swedish_Sign_Language-SSLC/swl_sslc-ud-test.conllu"
"UD_210 test set of SWEDISH_SIGN_LANGUAGE_SSLC."
UD_210_SWISS_GERMAN_UZH_TEST = _UD_210_HOME + "UD_Swiss_German-UZH/gsw_uzh-ud-test.conllu"
"UD_210 test set of SWISS_GERMAN_UZH."
UD_210_TAGALOG_TRG_TEST = _UD_210_HOME + "UD_Tagalog-TRG/tl_trg-ud-test.conllu"
"UD_210 test set of TAGALOG_TRG."
UD_210_TAGALOG_UGNAYAN_TEST = _UD_210_HOME + "UD_Tagalog-Ugnayan/tl_ugnayan-ud-test.conllu"
"UD_210 test set of TAGALOG_UGNAYAN."
UD_210_TAMIL_MWTT_TEST = _UD_210_HOME + "UD_Tamil-MWTT/ta_mwtt-ud-test.conllu"
"UD_210 test set of TAMIL_MWTT."
UD_210_TAMIL_TTB_TRAIN = _UD_210_HOME + "UD_Tamil-TTB/ta_ttb-ud-train.conllu"
"UD_210 train set of TAMIL_TTB."
UD_210_TAMIL_TTB_DEV = _UD_210_HOME + "UD_Tamil-TTB/ta_ttb-ud-dev.conllu"
"UD_210 dev set of TAMIL_TTB."
UD_210_TAMIL_TTB_TEST = _UD_210_HOME + "UD_Tamil-TTB/ta_ttb-ud-test.conllu"
"UD_210 test set of TAMIL_TTB."
UD_210_TATAR_NMCTT_TEST = _UD_210_HOME + "UD_Tatar-NMCTT/tt_nmctt-ud-test.conllu"
"UD_210 test set of TATAR_NMCTT."
UD_210_TEKO_TUDET_TEST = _UD_210_HOME + "UD_Teko-TuDeT/eme_tudet-ud-test.conllu"
"UD_210 test set of TEKO_TUDET."
UD_210_TELUGU_MTG_TRAIN = _UD_210_HOME + "UD_Telugu-MTG/te_mtg-ud-train.conllu"
"UD_210 train set of TELUGU_MTG."
UD_210_TELUGU_MTG_DEV = _UD_210_HOME + "UD_Telugu-MTG/te_mtg-ud-dev.conllu"
"UD_210 dev set of TELUGU_MTG."
UD_210_TELUGU_MTG_TEST = _UD_210_HOME + "UD_Telugu-MTG/te_mtg-ud-test.conllu"
"UD_210 test set of TELUGU_MTG."
UD_210_THAI_PUD_TEST = _UD_210_HOME + "UD_Thai-PUD/th_pud-ud-test.conllu"
"UD_210 test set of THAI_PUD."
UD_210_TUPINAMBA_TUDET_TEST = _UD_210_HOME + "UD_Tupinamba-TuDeT/tpn_tudet-ud-test.conllu"
"UD_210 test set of TUPINAMBA_TUDET."
UD_210_TURKISH_ATIS_TRAIN = _UD_210_HOME + "UD_Turkish-Atis/tr_atis-ud-train.conllu"
"UD_210 train set of TURKISH_ATIS."
UD_210_TURKISH_ATIS_DEV = _UD_210_HOME + "UD_Turkish-Atis/tr_atis-ud-dev.conllu"
"UD_210 dev set of TURKISH_ATIS."
UD_210_TURKISH_ATIS_TEST = _UD_210_HOME + "UD_Turkish-Atis/tr_atis-ud-test.conllu"
"UD_210 test set of TURKISH_ATIS."
UD_210_TURKISH_BOUN_TRAIN = _UD_210_HOME + "UD_Turkish-BOUN/tr_boun-ud-train.conllu"
"UD_210 train set of TURKISH_BOUN."
UD_210_TURKISH_BOUN_DEV = _UD_210_HOME + "UD_Turkish-BOUN/tr_boun-ud-dev.conllu"
"UD_210 dev set of TURKISH_BOUN."
UD_210_TURKISH_BOUN_TEST = _UD_210_HOME + "UD_Turkish-BOUN/tr_boun-ud-test.conllu"
"UD_210 test set of TURKISH_BOUN."
UD_210_TURKISH_FRAMENET_TRAIN = _UD_210_HOME + "UD_Turkish-FrameNet/tr_framenet-ud-train.conllu"
"UD_210 train set of TURKISH_FRAMENET."
UD_210_TURKISH_FRAMENET_DEV = _UD_210_HOME + "UD_Turkish-FrameNet/tr_framenet-ud-dev.conllu"
"UD_210 dev set of TURKISH_FRAMENET."
UD_210_TURKISH_FRAMENET_TEST = _UD_210_HOME + "UD_Turkish-FrameNet/tr_framenet-ud-test.conllu"
"UD_210 test set of TURKISH_FRAMENET."
UD_210_TURKISH_GB_TEST = _UD_210_HOME + "UD_Turkish-GB/tr_gb-ud-test.conllu"
"UD_210 test set of TURKISH_GB."
UD_210_TURKISH_IMST_TRAIN = _UD_210_HOME + "UD_Turkish-IMST/tr_imst-ud-train.conllu"
"UD_210 train set of TURKISH_IMST."
UD_210_TURKISH_IMST_DEV = _UD_210_HOME + "UD_Turkish-IMST/tr_imst-ud-dev.conllu"
"UD_210 dev set of TURKISH_IMST."
UD_210_TURKISH_IMST_TEST = _UD_210_HOME + "UD_Turkish-IMST/tr_imst-ud-test.conllu"
"UD_210 test set of TURKISH_IMST."
UD_210_TURKISH_KENET_TRAIN = _UD_210_HOME + "UD_Turkish-Kenet/tr_kenet-ud-train.conllu"
"UD_210 train set of TURKISH_KENET."
UD_210_TURKISH_KENET_DEV = _UD_210_HOME + "UD_Turkish-Kenet/tr_kenet-ud-dev.conllu"
"UD_210 dev set of TURKISH_KENET."
UD_210_TURKISH_KENET_TEST = _UD_210_HOME + "UD_Turkish-Kenet/tr_kenet-ud-test.conllu"
"UD_210 test set of TURKISH_KENET."
UD_210_TURKISH_PUD_TEST = _UD_210_HOME + "UD_Turkish-PUD/tr_pud-ud-test.conllu"
"UD_210 test set of TURKISH_PUD."
UD_210_TURKISH_PENN_TRAIN = _UD_210_HOME + "UD_Turkish-Penn/tr_penn-ud-train.conllu"
"UD_210 train set of TURKISH_PENN."
UD_210_TURKISH_PENN_DEV = _UD_210_HOME + "UD_Turkish-Penn/tr_penn-ud-dev.conllu"
"UD_210 dev set of TURKISH_PENN."
UD_210_TURKISH_PENN_TEST = _UD_210_HOME + "UD_Turkish-Penn/tr_penn-ud-test.conllu"
"UD_210 test set of TURKISH_PENN."
UD_210_TURKISH_TOURISM_TRAIN = _UD_210_HOME + "UD_Turkish-Tourism/tr_tourism-ud-train.conllu"
"UD_210 train set of TURKISH_TOURISM."
UD_210_TURKISH_TOURISM_DEV = _UD_210_HOME + "UD_Turkish-Tourism/tr_tourism-ud-dev.conllu"
"UD_210 dev set of TURKISH_TOURISM."
UD_210_TURKISH_TOURISM_TEST = _UD_210_HOME + "UD_Turkish-Tourism/tr_tourism-ud-test.conllu"
"UD_210 test set of TURKISH_TOURISM."
UD_210_TURKISH_GERMAN_SAGT_TRAIN = _UD_210_HOME + "UD_Turkish_German-SAGT/qtd_sagt-ud-train.conllu"
"UD_210 train set of TURKISH_GERMAN_SAGT."
UD_210_TURKISH_GERMAN_SAGT_DEV = _UD_210_HOME + "UD_Turkish_German-SAGT/qtd_sagt-ud-dev.conllu"
"UD_210 dev set of TURKISH_GERMAN_SAGT."
UD_210_TURKISH_GERMAN_SAGT_TEST = _UD_210_HOME + "UD_Turkish_German-SAGT/qtd_sagt-ud-test.conllu"
"UD_210 test set of TURKISH_GERMAN_SAGT."
UD_210_UKRAINIAN_IU_TRAIN = _UD_210_HOME + "UD_Ukrainian-IU/uk_iu-ud-train.conllu"
"UD_210 train set of UKRAINIAN_IU."
UD_210_UKRAINIAN_IU_DEV = _UD_210_HOME + "UD_Ukrainian-IU/uk_iu-ud-dev.conllu"
"UD_210 dev set of UKRAINIAN_IU."
UD_210_UKRAINIAN_IU_TEST = _UD_210_HOME + "UD_Ukrainian-IU/uk_iu-ud-test.conllu"
"UD_210 test set of UKRAINIAN_IU."
UD_210_UMBRIAN_IKUVINA_TEST = _UD_210_HOME + "UD_Umbrian-IKUVINA/xum_ikuvina-ud-test.conllu"
"UD_210 test set of UMBRIAN_IKUVINA."
UD_210_UPPER_SORBIAN_UFAL_TRAIN = _UD_210_HOME + "UD_Upper_Sorbian-UFAL/hsb_ufal-ud-train.conllu"
"UD_210 train set of UPPER_SORBIAN_UFAL."
UD_210_UPPER_SORBIAN_UFAL_TEST = _UD_210_HOME + "UD_Upper_Sorbian-UFAL/hsb_ufal-ud-test.conllu"
"UD_210 test set of UPPER_SORBIAN_UFAL."
UD_210_URDU_UDTB_TRAIN = _UD_210_HOME + "UD_Urdu-UDTB/ur_udtb-ud-train.conllu"
"UD_210 train set of URDU_UDTB."
UD_210_URDU_UDTB_DEV = _UD_210_HOME + "UD_Urdu-UDTB/ur_udtb-ud-dev.conllu"
"UD_210 dev set of URDU_UDTB."
UD_210_URDU_UDTB_TEST = _UD_210_HOME + "UD_Urdu-UDTB/ur_udtb-ud-test.conllu"
"UD_210 test set of URDU_UDTB."
UD_210_UYGHUR_UDT_TRAIN = _UD_210_HOME + "UD_Uyghur-UDT/ug_udt-ud-train.conllu"
"UD_210 train set of UYGHUR_UDT."
UD_210_UYGHUR_UDT_DEV = _UD_210_HOME + "UD_Uyghur-UDT/ug_udt-ud-dev.conllu"
"UD_210 dev set of UYGHUR_UDT."
UD_210_UYGHUR_UDT_TEST = _UD_210_HOME + "UD_Uyghur-UDT/ug_udt-ud-test.conllu"
"UD_210 test set of UYGHUR_UDT."
UD_210_VIETNAMESE_VTB_TRAIN = _UD_210_HOME + "UD_Vietnamese-VTB/vi_vtb-ud-train.conllu"
"UD_210 train set of VIETNAMESE_VTB."
UD_210_VIETNAMESE_VTB_DEV = _UD_210_HOME + "UD_Vietnamese-VTB/vi_vtb-ud-dev.conllu"
"UD_210 dev set of VIETNAMESE_VTB."
UD_210_VIETNAMESE_VTB_TEST = _UD_210_HOME + "UD_Vietnamese-VTB/vi_vtb-ud-test.conllu"
"UD_210 test set of VIETNAMESE_VTB."
UD_210_WARLPIRI_UFAL_TEST = _UD_210_HOME + "UD_Warlpiri-UFAL/wbp_ufal-ud-test.conllu"
"UD_210 test set of WARLPIRI_UFAL."
UD_210_WELSH_CCG_TRAIN = _UD_210_HOME + "UD_Welsh-CCG/cy_ccg-ud-train.conllu"
"UD_210 train set of WELSH_CCG."
UD_210_WELSH_CCG_DEV = _UD_210_HOME + "UD_Welsh-CCG/cy_ccg-ud-dev.conllu"
"UD_210 dev set of WELSH_CCG."
UD_210_WELSH_CCG_TEST = _UD_210_HOME + "UD_Welsh-CCG/cy_ccg-ud-test.conllu"
"UD_210 test set of WELSH_CCG."
UD_210_WESTERN_ARMENIAN_ARMTDP_TRAIN = _UD_210_HOME + "UD_Western_Armenian-ArmTDP/hyw_armtdp-ud-train.conllu"
"UD_210 train set of WESTERN_ARMENIAN_ARMTDP."
UD_210_WESTERN_ARMENIAN_ARMTDP_DEV = _UD_210_HOME + "UD_Western_Armenian-ArmTDP/hyw_armtdp-ud-dev.conllu"
"UD_210 dev set of WESTERN_ARMENIAN_ARMTDP."
UD_210_WESTERN_ARMENIAN_ARMTDP_TEST = _UD_210_HOME + "UD_Western_Armenian-ArmTDP/hyw_armtdp-ud-test.conllu"
"UD_210 test set of WESTERN_ARMENIAN_ARMTDP."
UD_210_WOLOF_WTB_TRAIN = _UD_210_HOME + "UD_Wolof-WTB/wo_wtb-ud-train.conllu"
"UD_210 train set of WOLOF_WTB."
UD_210_WOLOF_WTB_DEV = _UD_210_HOME + "UD_Wolof-WTB/wo_wtb-ud-dev.conllu"
"UD_210 dev set of WOLOF_WTB."
UD_210_WOLOF_WTB_TEST = _UD_210_HOME + "UD_Wolof-WTB/wo_wtb-ud-test.conllu"
"UD_210 test set of WOLOF_WTB."
UD_210_XIBE_XDT_TEST = _UD_210_HOME + "UD_Xibe-XDT/sjo_xdt-ud-test.conllu"
"UD_210 test set of XIBE_XDT."
UD_210_YAKUT_YKTDT_TEST = _UD_210_HOME + "UD_Yakut-YKTDT/sah_yktdt-ud-test.conllu"
"UD_210 test set of YAKUT_YKTDT."
UD_210_YORUBA_YTB_TEST = _UD_210_HOME + "UD_Yoruba-YTB/yo_ytb-ud-test.conllu"
"UD_210 test set of YORUBA_YTB."
UD_210_YUPIK_SLI_TEST = _UD_210_HOME + "UD_Yupik-SLI/ess_sli-ud-test.conllu"
"UD_210 test set of YUPIK_SLI."
