# cz-git-jira-conventional

**cz-git-jira-conventional** is a plugin for the [**commitizen tools**](https://github.com/commitizen-tools/commitizen), a toolset that helps you to create [**conventional commit messages**](https://www.conventionalcommits.org/en/v1.0.0/). Since the structure of conventional commits messages is standardized they are machine readable and allow commitizen to automaticially calculate and tag [**semantic version numbers**](https://semver.org/) as well as create **CHANGELOG.md** files for your releases.

This plugin extends the commitizen tools by:
- **require a Jira issue id** in the commit message
- **create links to Git** commits in the CHANGELOG.md
- **create links to Jira** issues in the CHANGELOG.md

When you call commitizen `commit` you will be required you to enter the scope of your commit as a Jira issue id (or multiple issue ids, prefixed or without prefix, see config below).
```
> cz commit
? Select the type of change you are committing feat: A new feature. Correlates with MINOR in SemVer
? JIRA issues (multiple "XX-101, XY-102"):  BILL-1000
? Write a short and imperative summary of the code changes: (lower case and no period)
 Add a new feature
? Provide additional contextual information about the code changes: (press [enter] to skip)
 - Add new params xyz to method xyz
? Is this a BREAKING CHANGE? Correlates with MAJOR in SemVer No
? Footer. Information about Breaking Changes and reference issues that this commit closes: (press [enter] to skip)
 

feat(BILL-1000): Add a new feature

- Add new params xyz to method xyz


[main cc751fb] feat(BILL-1000): Add a new feature
 1 file changed, 248 insertions(+)
 create mode 100644 cz_git_jira_conventional.py

Commit successful!
```

The changelog created by cz (`cz bump --changelog`)will contain links to the commits in Github and the Jira issues.
```markdown
## v1.2.0 (2021-10-06)

### New

- **[BILL-101](https://jira.yourdomain.com/browse/BILL-101)**: ([e5c91](vuonglv1612/cz-git-jira-conventional/commit/e5c91d059f0646f19deceb8d5008486c7d70f6fe)) - add ahihi something

## v1.1.1 (2021-10-06)

### Fix

- **[BILL-121](https://jira.yourdomain.com/browse/BILL-121) [BILL-111](https://jira.yourdomain.com/browse/BILL-111)**: mlem mlem ([ea2a5](vuonglv1612/cz-git-jira-conventional/commit/ea2a5640325b3d7cc6d439a14fe68b0fdd142113))
``` 


## Installation

Install with pip
`python -m pip install cz-git-jira-conventional` 

You need to use a cz config file that has the **required** additional values `jira_base_url` and `git_repo` and may contain the **optional** value `jira_prefix` if you are only using one Jira project (then the prefix for this project will be added automatically).

Example `.cz.yaml` config for this repository
```yaml
commitizen:
  name: cz_git_jira_conventional
  tag_format: v$version
  version: 1.0.0
  jira_base_url: https://myproject.atlassian.net
  git_repo: https://yourgit.com/username/project
```

### pre-commit
Add this plugin to the dependencies of your commit message linting with `pre-commit`. 

Example `.pre-commit-config.yaml` file.
```yaml
repos:
  - repo: https://github.com/commitizen-tools/commitizen
    rev: v2.17.13
    hooks:
      - id: commitizen
        stages: [commit-msg]
        additional_dependencies: [cz-git-jira-conventional]
```
Install the hook with 
```bash
pre-commit install --hook-type commit-msg
```

<!-- LICENSE -->
## License

Distributed under the MIT License. See `LICENSE` for more information.

<!-- ACKNOWLEDGEMENTS -->
## Acknowledgements
This plugin would not have been possible without the fantastic work from:
* [commitizen tools](https://github.com/commitizen-tools/commitizen)
* [conventional_JIRA](https://github.com/Crystalix007/conventional_jira)
* [cz-git-jira-conventional](https://github.com/apheris/cz-git-jira-conventional)
