# -*- coding: utf-8 -*-

from ..enums import IntEnum as IntEnum

__all__ = ("EMsg",)


# fmt: off

class EMsg(IntEnum):
    Invalid: "EMsg"                                                  = 0
    Multi: "EMsg"                                                    = 1
    ProtobufWrapped: "EMsg"                                          = 2

    GenericReply: "EMsg"                                             = 100
    BaseGeneral: "EMsg"                                              = 100
    DestJobFailed: "EMsg"                                            = 113
    Alert: "EMsg"                                                    = 115
    SCIDRequest: "EMsg"                                              = 120
    SCIDResponse: "EMsg"                                             = 121
    JobHeartbeat: "EMsg"                                             = 123
    HubConnect: "EMsg"                                               = 124
    Subscribe: "EMsg"                                                = 126
    RouteMessage: "EMsg"                                             = 127
    WGRequest: "EMsg"                                                = 130
    WGResponse: "EMsg"                                               = 131
    KeepAlive: "EMsg"                                                = 132
    WebAPIJobRequest: "EMsg"                                         = 133
    WebAPIJobResponse: "EMsg"                                        = 134
    ClientSessionStart: "EMsg"                                       = 135
    ClientSessionEnd: "EMsg"                                         = 136
    ClientSessionUpdate: "EMsg"                                      = 137
    StatsDeprecated: "EMsg"                                          = 138
    Ping: "EMsg"                                                     = 139
    PingResponse: "EMsg"                                             = 140
    Stats: "EMsg"                                                    = 141
    RequestFullStatsBlock: "EMsg"                                    = 142
    LoadDBOCacheItem: "EMsg"                                         = 143
    LoadDBOCacheItemResponse: "EMsg"                                 = 144
    InvalidateDBOCacheItems: "EMsg"                                  = 145
    ServiceMethod: "EMsg"                                            = 146
    ServiceMethodResponse: "EMsg"                                    = 147
    ClientPackageVersions: "EMsg"                                    = 148
    TimestampRequest: "EMsg"                                         = 149
    TimestampResponse: "EMsg"                                        = 150
    ServiceMethodCallFromClient: "EMsg"                              = 151
    ServiceMethodSendToClient: "EMsg"                                = 152

    AssignSysID: "EMsg"                                              = 200
    BaseShell: "EMsg"                                                = 200
    Exit: "EMsg"                                                     = 201
    DirRequest: "EMsg"                                               = 202
    DirResponse: "EMsg"                                              = 203
    ZipRequest: "EMsg"                                               = 204
    ZipResponse: "EMsg"                                              = 205
    UpdateRecordResponse: "EMsg"                                     = 215
    UpdateCreditCardRequest: "EMsg"                                  = 221
    UpdateUserBanResponse: "EMsg"                                    = 225
    PrepareToExit: "EMsg"                                            = 226
    ContentDescriptionUpdate: "EMsg"                                 = 227
    TestResetServer: "EMsg"                                          = 228
    UniverseChanged: "EMsg"                                          = 229
    ShellConfigInfoUpdate: "EMsg"                                    = 230
    RequestWindowsEventLogEntries: "EMsg"                            = 233
    ProvideWindowsEventLogEntries: "EMsg"                            = 234
    ShellSearchLogs: "EMsg"                                          = 235
    ShellSearchLogsResponse: "EMsg"                                  = 236
    ShellCheckWindowsUpdates: "EMsg"                                 = 237
    ShellCheckWindowsUpdatesResponse: "EMsg"                         = 238
    TestFlushDelayedSQL: "EMsg"                                      = 240
    TestFlushDelayedSQLResponse: "EMsg"                              = 241
    EnsureExecuteScheduledTask_TEST: "EMsg"                          = 242
    EnsureExecuteScheduledTaskResponse_TEST: "EMsg"                  = 243
    UpdateScheduledTaskEnableState_TEST: "EMsg"                      = 244
    UpdateScheduledTaskEnableStateResponse_TEST: "EMsg"              = 245
    ContentDescriptionDeltaUpdate: "EMsg"                            = 246

    Heartbeat: "EMsg"                                                = 300
    BaseGM: "EMsg"                                                   = 300
    ShellFailed: "EMsg"                                              = 301
    ExitShells: "EMsg"                                               = 307
    ExitShell: "EMsg"                                                = 308
    GracefulExitShell: "EMsg"                                        = 309
    LicenseProcessingComplete: "EMsg"                                = 316
    SetTestFlag: "EMsg"                                              = 317
    QueuedEmailsComplete: "EMsg"                                     = 318
    GMReportPHPError: "EMsg"                                         = 319
    GMDRMSync: "EMsg"                                                = 320
    PhysicalBoxInventory: "EMsg"                                     = 321
    UpdateConfigFile: "EMsg"                                         = 322
    TestInitDB: "EMsg"                                               = 323
    GMWriteConfigToSQL: "EMsg"                                       = 324
    GMLoadActivationCodes: "EMsg"                                    = 325
    GMQueueForFBS: "EMsg"                                            = 326
    GMSchemaConversionResults: "EMsg"                                = 327
    GMWriteShellFailureToSQL: "EMsg"                                 = 329
    GMWriteStatsToSOS: "EMsg"                                        = 330
    GMGetServiceMethodRouting: "EMsg"                                = 331
    GMGetServiceMethodRoutingResponse: "EMsg"                        = 332

    GMTestNextBuildSchemaConversion: "EMsg"                          = 334
    GMTestNextBuildSchemaConversionResponse: "EMsg"                  = 335
    ExpectShellRestart: "EMsg"                                       = 336
    HotFixProgress: "EMsg"                                           = 337

    BaseAIS: "EMsg"                                                  = 400
    AISRequestContentDescription: "EMsg"                             = 402
    AISUpdateAppInfo: "EMsg"                                         = 403
    AISGetPackageChangeNumber: "EMsg"                                = 405
    AISGetPackageChangeNumberResponse: "EMsg"                        = 406
    AIGetAppGCFlags: "EMsg"                                          = 423
    AIGetAppGCFlagsResponse: "EMsg"                                  = 424
    AIGetAppList: "EMsg"                                             = 425
    AIGetAppListResponse: "EMsg"                                     = 426
    AISGetCouponDefinition: "EMsg"                                   = 429
    AISGetCouponDefinitionResponse: "EMsg"                           = 430
    AISUpdateSlaveContentDescription: "EMsg"                         = 431
    AISUpdateSlaveContentDescriptionResponse: "EMsg"                 = 432
    AISTestEnableGC: "EMsg"                                          = 433

    BaseAM: "EMsg"                                                   = 500
    AMUpdateUserBanRequest: "EMsg"                                   = 504
    AMAddLicense: "EMsg"                                             = 505
    AMSendSystemIMToUser: "EMsg"                                     = 508
    AMExtendLicense: "EMsg"                                          = 509
    AMAddMinutesToLicense: "EMsg"                                    = 510
    AMCancelLicense: "EMsg"                                          = 511
    AMInitPurchase: "EMsg"                                           = 512
    AMPurchaseResponse: "EMsg"                                       = 513
    AMGetFinalPrice: "EMsg"                                          = 514
    AMGetFinalPriceResponse: "EMsg"                                  = 515
    AMGetLegacyGameKey: "EMsg"                                       = 516
    AMGetLegacyGameKeyResponse: "EMsg"                               = 517
    AMFindHungTransactions: "EMsg"                                   = 518
    AMSetAccountTrustedRequest: "EMsg"                               = 519
    AMCancelPurchase: "EMsg"                                         = 522
    AMNewChallenge: "EMsg"                                           = 523
    AMLoadOEMTickets: "EMsg"                                         = 524
    AMFixPendingPurchase: "EMsg"                                     = 525
    AMFixPendingPurchaseResponse: "EMsg"                             = 526
    AMIsUserBanned: "EMsg"                                           = 527
    AMRegisterKey: "EMsg"                                            = 528
    AMLoadActivationCodes: "EMsg"                                    = 529
    AMLoadActivationCodesResponse: "EMsg"                            = 530
    AMLookupKeyResponse: "EMsg"                                      = 531
    AMLookupKey: "EMsg"                                              = 532
    AMChatCleanup: "EMsg"                                            = 533
    AMClanCleanup: "EMsg"                                            = 534
    AMFixPendingRefund: "EMsg"                                       = 535
    AMReverseChargeback: "EMsg"                                      = 536
    AMReverseChargebackResponse: "EMsg"                              = 537
    AMClanCleanupList: "EMsg"                                        = 538
    AMGetLicenses: "EMsg"                                            = 539
    AMGetLicensesResponse: "EMsg"                                    = 540
    AMSendCartRepurchase: "EMsg"                                     = 541
    AMSendCartRepurchaseResponse: "EMsg"                             = 542
    AllowUserToPlayQuery: "EMsg"                                     = 550
    AllowUserToPlayResponse: "EMsg"                                  = 551
    AMVerfiyUser: "EMsg"                                             = 552
    AMClientNotPlaying: "EMsg"                                       = 553
    AMClientRequestFriendship: "EMsg"                                = 554
    AMRelayPublishStatus: "EMsg"                                     = 555
    AMInitPurchaseResponse: "EMsg"                                   = 560
    AMRevokePurchaseResponse: "EMsg"                                 = 561
    AMRefreshGuestPasses: "EMsg"                                     = 563
    AMGrantGuestPasses: "EMsg"                                       = 566
    AMClanDataUpdated: "EMsg"                                        = 567
    AMReloadAccount: "EMsg"                                          = 568
    AMClientChatMsgRelay: "EMsg"                                     = 569
    AMChatMulti: "EMsg"                                              = 570
    AMClientChatInviteRelay: "EMsg"                                  = 571
    AMChatInvite: "EMsg"                                             = 572
    AMClientJoinChatRelay: "EMsg"                                    = 573
    AMClientChatMemberInfoRelay: "EMsg"                              = 574
    AMPublishChatMemberInfo: "EMsg"                                  = 575
    AMClientAcceptFriendInvite: "EMsg"                               = 576
    AMChatEnter: "EMsg"                                              = 577
    AMClientPublishRemovalFromSource: "EMsg"                         = 578
    AMChatActionResult: "EMsg"                                       = 579
    AMFindAccounts: "EMsg"                                           = 580
    AMFindAccountsResponse: "EMsg"                                   = 581
    AMRequestAccountData: "EMsg"                                     = 582
    AMRequestAccountDataResponse: "EMsg"                             = 583
    AMSetAccountFlags: "EMsg"                                        = 584
    AMCreateClan: "EMsg"                                             = 586
    AMCreateClanResponse: "EMsg"                                     = 587
    AMGetClanDetails: "EMsg"                                         = 588
    AMGetClanDetailsResponse: "EMsg"                                 = 589
    AMSetPersonaName: "EMsg"                                         = 590
    AMSetAvatar: "EMsg"                                              = 591
    AMAuthenticateUser: "EMsg"                                       = 592
    AMAuthenticateUserResponse: "EMsg"                               = 593
    AMP2PIntroducerMessage: "EMsg"                                   = 596
    ClientChatAction: "EMsg"                                         = 597
    AMClientChatActionRelay: "EMsg"                                  = 598

    ReqChallenge: "EMsg"                                             = 600
    BaseVS: "EMsg"                                                   = 600
    VACResponse: "EMsg"                                              = 601
    ReqChallengeTest: "EMsg"                                         = 602
    VSMarkCheat: "EMsg"                                              = 604
    VSAddCheat: "EMsg"                                               = 605
    VSPurgeCodeModDB: "EMsg"                                         = 606
    VSGetChallengeResults: "EMsg"                                    = 607
    VSChallengeResultText: "EMsg"                                    = 608
    VSReportLingerer: "EMsg"                                         = 609
    VSRequestManagedChallenge: "EMsg"                                = 610
    VSLoadDBFinished: "EMsg"                                         = 611

    BaseDRMS: "EMsg"                                                 = 625
    DRMBuildBlobRequest: "EMsg"                                      = 628
    DRMBuildBlobResponse: "EMsg"                                     = 629
    DRMResolveGuidRequest: "EMsg"                                    = 630
    DRMResolveGuidResponse: "EMsg"                                   = 631
    DRMVariabilityReport: "EMsg"                                     = 633
    DRMVariabilityReportResponse: "EMsg"                             = 634
    DRMStabilityReport: "EMsg"                                       = 635
    DRMStabilityReportResponse: "EMsg"                               = 636
    DRMDetailsReportRequest: "EMsg"                                  = 637
    DRMDetailsReportResponse: "EMsg"                                 = 638
    DRMProcessFile: "EMsg"                                           = 639
    DRMAdminUpdate: "EMsg"                                           = 640
    DRMAdminUpdateResponse: "EMsg"                                   = 641
    DRMSync: "EMsg"                                                  = 642
    DRMSyncResponse: "EMsg"                                          = 643
    DRMProcessFileResponse: "EMsg"                                   = 644
    DRMEmptyGuidCache: "EMsg"                                        = 645
    DRMEmptyGuidCacheResponse: "EMsg"                                = 646

    BaseCS: "EMsg"                                                   = 650

    BaseClient: "EMsg"                                               = 700
    ClientHeartBeat: "EMsg"                                          = 703
    ClientVACResponse: "EMsg"                                        = 704
    ClientLogOff: "EMsg"                                             = 706
    ClientNoUDPConnectivity: "EMsg"                                  = 707
    ClientConnectionStats: "EMsg"                                    = 710
    ClientPingResponse: "EMsg"                                       = 712
    ClientRemoveFriend: "EMsg"                                       = 714
    ClientGamesPlayedNoDataBlob: "EMsg"                              = 715
    ClientChangeStatus: "EMsg"                                       = 716
    ClientVacStatusResponse: "EMsg"                                  = 717
    ClientFriendMsg: "EMsg"                                          = 718
    ClientSystemIM: "EMsg"                                           = 726
    ClientSystemIMAck: "EMsg"                                        = 727
    ClientGetLicenses: "EMsg"                                        = 728
    ClientGetLegacyGameKey: "EMsg"                                   = 730
    ClientAckVACBan2: "EMsg"                                         = 732
    ClientGetPurchaseReceipts: "EMsg"                                = 736
    ClientAckGuestPass: "EMsg"                                       = 740
    ClientRedeemGuestPass: "EMsg"                                    = 741
    ClientGamesPlayed: "EMsg"                                        = 742
    ClientRegisterKey: "EMsg"                                        = 743
    ClientInviteUserToClan: "EMsg"                                   = 744
    ClientAcknowledgeClanInvite: "EMsg"                              = 745
    ClientPurchaseWithMachineID: "EMsg"                              = 746
    ClientAppUsageEvent: "EMsg"                                      = 747
    ClientLogOnResponse: "EMsg"                                      = 751
    ClientSetHeartbeatRate: "EMsg"                                   = 755
    ClientLoggedOff: "EMsg"                                          = 757
    GSApprove: "EMsg"                                                = 758
    GSDeny: "EMsg"                                                   = 759
    GSKick: "EMsg"                                                   = 760
    ClientCreateAcctResponse: "EMsg"                                 = 761
    ClientPurchaseResponse: "EMsg"                                   = 763
    ClientPing: "EMsg"                                               = 764
    ClientNOP: "EMsg"                                                = 765
    ClientPersonaState: "EMsg"                                       = 766
    ClientFriendsList: "EMsg"                                        = 767
    ClientAccountInfo: "EMsg"                                        = 768
    ClientNewsUpdate: "EMsg"                                         = 771
    ClientGameConnectDeny: "EMsg"                                    = 773
    GSStatusReply: "EMsg"                                            = 774
    ClientGameConnectTokens: "EMsg"                                  = 779
    ClientLicenseList: "EMsg"                                        = 780
    ClientVACBanStatus: "EMsg"                                       = 782
    ClientCMList: "EMsg"                                             = 783
    ClientEncryptPct: "EMsg"                                         = 784
    ClientGetLegacyGameKeyResponse: "EMsg"                           = 785
    ClientAddFriend: "EMsg"                                          = 791
    ClientAddFriendResponse: "EMsg"                                  = 792
    ClientAckGuestPassResponse: "EMsg"                               = 796
    ClientRedeemGuestPassResponse: "EMsg"                            = 797
    ClientUpdateGuestPassesList: "EMsg"                              = 798
    ClientChatMsg: "EMsg"                                            = 799
    ClientChatInvite: "EMsg"                                         = 800
    ClientJoinChat: "EMsg"                                           = 801
    ClientChatMemberInfo: "EMsg"                                     = 802
    ClientPasswordChangeResponse: "EMsg"                             = 805
    ClientChatEnter: "EMsg"                                          = 807
    ClientFriendRemovedFromSource: "EMsg"                            = 808
    ClientCreateChat: "EMsg"                                         = 809
    ClientCreateChatResponse: "EMsg"                                 = 810
    ClientP2PIntroducerMessage: "EMsg"                               = 813
    ClientChatActionResult: "EMsg"                                   = 814
    ClientRequestFriendData: "EMsg"                                  = 815
    ClientGetUserStats: "EMsg"                                       = 818
    ClientGetUserStatsResponse: "EMsg"                               = 819
    ClientStoreUserStats: "EMsg"                                     = 820
    ClientStoreUserStatsResponse: "EMsg"                             = 821
    ClientClanState: "EMsg"                                          = 822
    ClientServiceModule: "EMsg"                                      = 830
    ClientServiceCall: "EMsg"                                        = 831
    ClientServiceCallResponse: "EMsg"                                = 832
    ClientNatTraversalStatEvent: "EMsg"                              = 839
    ClientSteamUsageEvent: "EMsg"                                    = 842
    ClientCheckPassword: "EMsg"                                      = 845
    ClientResetPassword: "EMsg"                                      = 846
    ClientCheckPasswordResponse: "EMsg"                              = 848
    ClientResetPasswordResponse: "EMsg"                              = 849
    ClientSessionToken: "EMsg"                                       = 850
    ClientDRMProblemReport: "EMsg"                                   = 851
    ClientSetIgnoreFriend: "EMsg"                                    = 855
    ClientSetIgnoreFriendResponse: "EMsg"                            = 856
    ClientGetAppOwnershipTicket: "EMsg"                              = 857
    ClientGetAppOwnershipTicketResponse: "EMsg"                      = 858
    ClientGetLobbyListResponse: "EMsg"                               = 860
    ClientServerList: "EMsg"                                         = 880
    ClientDRMBlobRequest: "EMsg"                                     = 896
    ClientDRMBlobResponse: "EMsg"                                    = 897

    BaseGameServer: "EMsg"                                           = 900
    GSDisconnectNotice: "EMsg"                                       = 901
    GSStatus: "EMsg"                                                 = 903
    GSUserPlaying: "EMsg"                                            = 905
    GSStatus2: "EMsg"                                                = 906
    GSStatusUpdate_Unused: "EMsg"                                    = 907
    GSServerType: "EMsg"                                             = 908
    GSPlayerList: "EMsg"                                             = 909
    GSGetUserAchievementStatus: "EMsg"                               = 910
    GSGetUserAchievementStatusResponse: "EMsg"                       = 911
    GSGetPlayStats: "EMsg"                                           = 918
    GSGetPlayStatsResponse: "EMsg"                                   = 919
    GSGetUserGroupStatus: "EMsg"                                     = 920
    AMGetUserGroupStatus: "EMsg"                                     = 921
    AMGetUserGroupStatusResponse: "EMsg"                             = 922
    GSGetUserGroupStatusResponse: "EMsg"                             = 923
    GSGetReputation: "EMsg"                                          = 936
    GSGetReputationResponse: "EMsg"                                  = 937
    GSAssociateWithClan: "EMsg"                                      = 938
    GSAssociateWithClanResponse: "EMsg"                              = 939
    GSComputeNewPlayerCompatibility: "EMsg"                          = 940
    GSComputeNewPlayerCompatibilityResponse: "EMsg"                  = 941

    AdminCmd: "EMsg"                                                 = 1000
    BaseAdmin: "EMsg"                                                = 1000
    AdminCmdResponse: "EMsg"                                         = 1004
    AdminLogListenRequest: "EMsg"                                    = 1005
    AdminLogEvent: "EMsg"                                            = 1006
    UniverseData: "EMsg"                                             = 1010
    AdminSpew: "EMsg"                                                = 1019
    AdminConsoleTitle: "EMsg"                                        = 1020
    AdminGCSpew: "EMsg"                                              = 1023
    AdminGCCommand: "EMsg"                                           = 1024
    AdminGCGetCommandList: "EMsg"                                    = 1025
    AdminGCGetCommandListResponse: "EMsg"                            = 1026
    FBSConnectionData: "EMsg"                                        = 1027
    AdminMsgSpew: "EMsg"                                             = 1028

    FBSReqVersion: "EMsg"                                            = 1100
    BaseFBS: "EMsg"                                                  = 1100
    FBSVersionInfo: "EMsg"                                           = 1101
    FBSForceRefresh: "EMsg"                                          = 1102
    FBSForceBounce: "EMsg"                                           = 1103
    FBSDeployPackage: "EMsg"                                         = 1104
    FBSDeployResponse: "EMsg"                                        = 1105
    FBSUpdateBootstrapper: "EMsg"                                    = 1106
    FBSSetState: "EMsg"                                              = 1107
    FBSApplyOSUpdates: "EMsg"                                        = 1108
    FBSRunCMDScript: "EMsg"                                          = 1109
    FBSRebootBox: "EMsg"                                             = 1110
    FBSSetBigBrotherMode: "EMsg"                                     = 1111
    FBSMinidumpServer: "EMsg"                                        = 1112
    FBSDeployHotFixPackage: "EMsg"                                   = 1114
    FBSDeployHotFixResponse: "EMsg"                                  = 1115
    FBSDownloadHotFix: "EMsg"                                        = 1116
    FBSDownloadHotFixResponse: "EMsg"                                = 1117
    FBSUpdateTargetConfigFile: "EMsg"                                = 1118
    FBSApplyAccountCred: "EMsg"                                      = 1119
    FBSApplyAccountCredResponse: "EMsg"                              = 1120
    FBSSetShellCount: "EMsg"                                         = 1121
    FBSTerminateShell: "EMsg"                                        = 1122
    FBSQueryGMForRequest: "EMsg"                                     = 1123
    FBSQueryGMResponse: "EMsg"                                       = 1124
    FBSTerminateZombies: "EMsg"                                      = 1125
    FBSInfoFromBootstrapper: "EMsg"                                  = 1126
    FBSRebootBoxResponse: "EMsg"                                     = 1127
    FBSBootstrapperPackageRequest: "EMsg"                            = 1128
    FBSBootstrapperPackageResponse: "EMsg"                           = 1129
    FBSBootstrapperGetPackageChunk: "EMsg"                           = 1130
    FBSBootstrapperGetPackageChunkResponse: "EMsg"                   = 1131
    FBSBootstrapperPackageTransferProgress: "EMsg"                   = 1132
    FBSRestartBootstrapper: "EMsg"                                   = 1133
    FBSPauseFrozenDumps: "EMsg"                                      = 1134

    FileXferRequest: "EMsg"                                          = 1200
    BaseFileXfer: "EMsg"                                             = 1200
    FileXferResponse: "EMsg"                                         = 1201
    FileXferData: "EMsg"                                             = 1202
    FileXferEnd: "EMsg"                                              = 1203
    FileXferDataAck: "EMsg"                                          = 1204

    ChannelAuthChallenge: "EMsg"                                     = 1300
    BaseChannelAuth: "EMsg"                                          = 1300
    ChannelAuthResponse: "EMsg"                                      = 1301
    ChannelAuthResult: "EMsg"                                        = 1302
    ChannelEncryptRequest: "EMsg"                                    = 1303
    ChannelEncryptResponse: "EMsg"                                   = 1304
    ChannelEncryptResult: "EMsg"                                     = 1305

    BaseBS: "EMsg"                                                   = 1400
    BSPurchaseStart: "EMsg"                                          = 1401
    BSPurchaseResponse: "EMsg"                                       = 1402
    BSAuthenticateCCTrans: "EMsg"                                    = 1403
    BSAuthenticateCCTransResponse: "EMsg"                            = 1404
    BSSettleComplete: "EMsg"                                         = 1406
    BSInitPayPalTxn: "EMsg"                                          = 1408
    BSInitPayPalTxnResponse: "EMsg"                                  = 1409
    BSGetPayPalUserInfo: "EMsg"                                      = 1410
    BSGetPayPalUserInfoResponse: "EMsg"                              = 1411
    BSPaymentInstrBan: "EMsg"                                        = 1417
    BSPaymentInstrBanResponse: "EMsg"                                = 1418
    BSInitGCBankXferTxn: "EMsg"                                      = 1421
    BSInitGCBankXferTxnResponse: "EMsg"                              = 1422
    BSCommitGCTxn: "EMsg"                                            = 1425
    BSQueryTransactionStatus: "EMsg"                                 = 1426
    BSQueryTransactionStatusResponse: "EMsg"                         = 1427
    BSQueryPaymentInstUsage: "EMsg"                                  = 1431
    BSQueryPaymentInstResponse: "EMsg"                               = 1432
    BSQueryTxnExtendedInfo: "EMsg"                                   = 1433
    BSQueryTxnExtendedInfoResponse: "EMsg"                           = 1434
    BSUpdateConversionRates: "EMsg"                                  = 1435
    BSPurchaseRunFraudChecks: "EMsg"                                 = 1437
    BSPurchaseRunFraudChecksResponse: "EMsg"                         = 1438
    BSQueryBankInformation: "EMsg"                                   = 1440
    BSQueryBankInformationResponse: "EMsg"                           = 1441
    BSValidateXsollaSignature: "EMsg"                                = 1445
    BSValidateXsollaSignatureResponse: "EMsg"                        = 1446
    BSQiwiWalletInvoice: "EMsg"                                      = 1448
    BSQiwiWalletInvoiceResponse: "EMsg"                              = 1449
    BSUpdateInventoryFromProPack: "EMsg"                             = 1450
    BSUpdateInventoryFromProPackResponse: "EMsg"                     = 1451
    BSSendShippingRequest: "EMsg"                                    = 1452
    BSSendShippingRequestResponse: "EMsg"                            = 1453
    BSGetProPackOrderStatus: "EMsg"                                  = 1454
    BSGetProPackOrderStatusResponse: "EMsg"                          = 1455
    BSCheckJobRunning: "EMsg"                                        = 1456
    BSCheckJobRunningResponse: "EMsg"                                = 1457
    BSResetPackagePurchaseRateLimit: "EMsg"                          = 1458
    BSResetPackagePurchaseRateLimitResponse: "EMsg"                  = 1459
    BSUpdatePaymentData: "EMsg"                                      = 1460
    BSUpdatePaymentDataResponse: "EMsg"                              = 1461
    BSGetBillingAddress: "EMsg"                                      = 1462
    BSGetBillingAddressResponse: "EMsg"                              = 1463
    BSGetCreditCardInfo: "EMsg"                                      = 1464
    BSGetCreditCardInfoResponse: "EMsg"                              = 1465
    BSRemoveExpiredPaymentData: "EMsg"                               = 1468
    BSRemoveExpiredPaymentDataResponse: "EMsg"                       = 1469
    BSConvertToCurrentKeys: "EMsg"                                   = 1470
    BSConvertToCurrentKeysResponse: "EMsg"                           = 1471
    BSInitPurchase: "EMsg"                                           = 1472
    BSInitPurchaseResponse: "EMsg"                                   = 1473
    BSCompletePurchase: "EMsg"                                       = 1474
    BSCompletePurchaseResponse: "EMsg"                               = 1475
    BSPruneCardUsageStats: "EMsg"                                    = 1476
    BSPruneCardUsageStatsResponse: "EMsg"                            = 1477
    BSStoreBankInformation: "EMsg"                                   = 1478
    BSStoreBankInformationResponse: "EMsg"                           = 1479
    BSVerifyPOSAKey: "EMsg"                                          = 1480
    BSVerifyPOSAKeyResponse: "EMsg"                                  = 1481
    BSReverseRedeemPOSAKey: "EMsg"                                   = 1482
    BSReverseRedeemPOSAKeyResponse: "EMsg"                           = 1483
    BSQueryFindCreditCard: "EMsg"                                    = 1484
    BSQueryFindCreditCardResponse: "EMsg"                            = 1485
    BSStatusInquiryPOSAKey: "EMsg"                                   = 1486
    BSStatusInquiryPOSAKeyResponse: "EMsg"                           = 1487
    BSBoaCompraConfirmProductDelivery: "EMsg"                        = 1494
    BSBoaCompraConfirmProductDeliveryResponse: "EMsg"                = 1495
    BSGenerateBoaCompraMD5: "EMsg"                                   = 1496
    BSGenerateBoaCompraMD5Response: "EMsg"                           = 1497
    BSCommitWPTxn: "EMsg"                                            = 1498
    BSCommitAdyenTxn: "EMsg"                                         = 1499
    BaseATS: "EMsg"                                                  = 1500
    ATSStartStressTest: "EMsg"                                       = 1501
    ATSStopStressTest: "EMsg"                                        = 1502
    ATSRunFailServerTest: "EMsg"                                     = 1503
    ATSUFSPerfTestTask: "EMsg"                                       = 1504
    ATSUFSPerfTestResponse: "EMsg"                                   = 1505
    ATSCycleTCM: "EMsg"                                              = 1506
    ATSInitDRMSStressTest: "EMsg"                                    = 1507
    ATSCallTest: "EMsg"                                              = 1508
    ATSCallTestReply: "EMsg"                                         = 1509
    ATSStartExternalStress: "EMsg"                                   = 1510
    ATSExternalStressJobStart: "EMsg"                                = 1511
    ATSExternalStressJobQueued: "EMsg"                               = 1512
    ATSExternalStressJobRunning: "EMsg"                              = 1513
    ATSExternalStressJobStopped: "EMsg"                              = 1514
    ATSExternalStressJobStopAll: "EMsg"                              = 1515
    ATSExternalStressActionResult: "EMsg"                            = 1516
    ATSStarted: "EMsg"                                               = 1517
    ATSCSPerfTestTask: "EMsg"                                        = 1518
    ATSCSPerfTestResponse: "EMsg"                                    = 1519

    BaseDP: "EMsg"                                                   = 1600
    DPSetPublishingState: "EMsg"                                     = 1601
    DPUniquePlayersStat: "EMsg"                                      = 1603
    DPStreamingUniquePlayersStat: "EMsg"                             = 1604
    DPBlockingStats: "EMsg"                                          = 1607
    DPNatTraversalStats: "EMsg"                                      = 1608
    DPCloudStats: "EMsg"                                             = 1612
    DPAchievementStats: "EMsg"                                       = 1613
    DPGetPlayerCount: "EMsg"                                         = 1615
    DPGetPlayerCountResponse: "EMsg"                                 = 1616
    DPGameServersPlayersStats: "EMsg"                                = 1617
    ClientDPCheckSpecialSurvey: "EMsg"                               = 1620
    ClientDPCheckSpecialSurveyResponse: "EMsg"                       = 1621
    ClientDPSendSpecialSurveyResponse: "EMsg"                        = 1622
    ClientDPSendSpecialSurveyResponseReply: "EMsg"                   = 1623
    DPStoreSaleStatistics: "EMsg"                                    = 1624
    ClientDPUpdateAppJobReport: "EMsg"                               = 1625
    DPUpdateContentEvent: "EMsg"                                     = 1626
    ClientDPUnsignedInstallScript: "EMsg"                            = 1627
    DPPartnerMicroTxns: "EMsg"                                       = 1628
    DPPartnerMicroTxnsResponse: "EMsg"                               = 1629
    ClientDPContentStatsReport: "EMsg"                               = 1630
    DPVRUniquePlayersStat: "EMsg"                                    = 1631

    BaseCM: "EMsg"                                                   = 1700
    CMSetAllowState: "EMsg"                                          = 1701
    CMSpewAllowState: "EMsg"                                         = 1702
    CMSessionRejected: "EMsg"                                        = 1703
    CMSetSecrets: "EMsg"                                             = 1704
    CMGetSecrets: "EMsg"                                             = 1705



    BaseGC: "EMsg"                                                   = 2200
    GCCmdRevive: "EMsg"                                              = 2203
    GCCmdDown: "EMsg"                                                = 2206
    GCCmdDeploy: "EMsg"                                              = 2207
    GCCmdDeployResponse: "EMsg"                                      = 2208
    GCCmdSwitch: "EMsg"                                              = 2209
    AMRefreshSessions: "EMsg"                                        = 2210
    GCAchievementAwarded: "EMsg"                                     = 2212
    GCSystemMessage: "EMsg"                                          = 2213
    GCCmdStatus: "EMsg"                                              = 2216
    GCInterAppMessage: "EMsg"                                        = 2219
    GCGetEmailTemplate: "EMsg"                                       = 2220
    GCGetEmailTemplateResponse: "EMsg"                               = 2221
    GCHRelay: "EMsg"                                                 = 2222
    GCHRelayToClient: "EMsg"                                         = 2223
    GCHUpdateSession: "EMsg"                                         = 2224
    GCHRequestUpdateSession: "EMsg"                                  = 2225
    GCHRequestStatus: "EMsg"                                         = 2226
    GCHRequestStatusResponse: "EMsg"                                 = 2227
    GCHAccountVacStatusChange: "EMsg"                                = 2228
    GCHSpawnGC: "EMsg"                                               = 2229
    GCHSpawnGCResponse: "EMsg"                                       = 2230
    GCHKillGC: "EMsg"                                                = 2231
    GCHKillGCResponse: "EMsg"                                        = 2232
    GCHAccountTradeBanStatusChange: "EMsg"                           = 2233
    GCHAccountLockStatusChange: "EMsg"                               = 2234
    GCHVacVerificationChange: "EMsg"                                 = 2235
    GCHAccountPhoneNumberChange: "EMsg"                              = 2236
    GCHAccountTwoFactorChange: "EMsg"                                = 2237
    GCHInviteUserToLobby: "EMsg"                                     = 2238

    BaseP2P: "EMsg"                                                  = 2500
    P2PIntroducerMessage: "EMsg"                                     = 2502

    BaseSM: "EMsg"                                                   = 2900
    SMExpensiveReport: "EMsg"                                        = 2902
    SMHourlyReport: "EMsg"                                           = 2903
    SMPartitionRenames: "EMsg"                                       = 2905
    SMMonitorSpace: "EMsg"                                           = 2906
    SMTestNextBuildSchemaConversion: "EMsg"                          = 2907
    SMTestNextBuildSchemaConversionResponse: "EMsg"                  = 2908

    BaseTest: "EMsg"                                                 = 3000
    FailServer: "EMsg"                                               = 3000
    JobHeartbeatTest: "EMsg"                                         = 3001
    JobHeartbeatTestResponse: "EMsg"                                 = 3002

    BaseFTSRange: "EMsg"                                             = 3100

    BaseCCSRange: "EMsg"                                             = 3150
    CCSDeleteAllCommentsByAuthor: "EMsg"                             = 3161
    CCSDeleteAllCommentsByAuthorResponse: "EMsg"                     = 3162

    BaseLBSRange: "EMsg"                                             = 3200
    LBSSetScore: "EMsg"                                              = 3201
    LBSSetScoreResponse: "EMsg"                                      = 3202
    LBSFindOrCreateLB: "EMsg"                                        = 3203
    LBSFindOrCreateLBResponse: "EMsg"                                = 3204
    LBSGetLBEntries: "EMsg"                                          = 3205
    LBSGetLBEntriesResponse: "EMsg"                                  = 3206
    LBSGetLBList: "EMsg"                                             = 3207
    LBSGetLBListResponse: "EMsg"                                     = 3208
    LBSSetLBDetails: "EMsg"                                          = 3209
    LBSDeleteLB: "EMsg"                                              = 3210
    LBSDeleteLBEntry: "EMsg"                                         = 3211
    LBSResetLB: "EMsg"                                               = 3212
    LBSResetLBResponse: "EMsg"                                       = 3213
    LBSDeleteLBResponse: "EMsg"                                      = 3214

    BaseOGS: "EMsg"                                                  = 3400
    OGSBeginSession: "EMsg"                                          = 3401
    OGSBeginSessionResponse: "EMsg"                                  = 3402
    OGSEndSession: "EMsg"                                            = 3403
    OGSEndSessionResponse: "EMsg"                                    = 3404
    OGSWriteAppSessionRow: "EMsg"                                    = 3406

    BaseBRP: "EMsg"                                                  = 3600
    BRPStartShippingJobs: "EMsg"                                     = 3601
    BRPProcessUSBankReports: "EMsg"                                  = 3602
    BRPProcessGCReports: "EMsg"                                      = 3603
    BRPProcessPPReports: "EMsg"                                      = 3604
    BRPCommitGC: "EMsg"                                              = 3607
    BRPCommitGCResponse: "EMsg"                                      = 3608
    BRPFindHungTransactions: "EMsg"                                  = 3609
    BRPCheckFinanceCloseOutDate: "EMsg"                              = 3610
    BRPProcessLicenses: "EMsg"                                       = 3611
    BRPProcessLicensesResponse: "EMsg"                               = 3612
    BRPRemoveExpiredPaymentData: "EMsg"                              = 3613
    BRPRemoveExpiredPaymentDataResponse: "EMsg"                      = 3614
    BRPConvertToCurrentKeys: "EMsg"                                  = 3615
    BRPConvertToCurrentKeysResponse: "EMsg"                          = 3616
    BRPPruneCardUsageStats: "EMsg"                                   = 3617
    BRPPruneCardUsageStatsResponse: "EMsg"                           = 3618
    BRPCheckActivationCodes: "EMsg"                                  = 3619
    BRPCheckActivationCodesResponse: "EMsg"                          = 3620
    BRPCommitWP: "EMsg"                                              = 3621
    BRPCommitWPResponse: "EMsg"                                      = 3622
    BRPProcessWPReports: "EMsg"                                      = 3623
    BRPProcessPaymentRules: "EMsg"                                   = 3624
    BRPProcessPartnerPayments: "EMsg"                                = 3625
    BRPCheckSettlementReports: "EMsg"                                = 3626
    BRPPostTaxToAvalara: "EMsg"                                      = 3628
    BRPPostTransactionTax: "EMsg"                                    = 3629
    BRPPostTransactionTaxResponse: "EMsg"                            = 3630
    BRPProcessIMReports: "EMsg"                                      = 3631

    BaseAMRange2: "EMsg"                                             = 4000
    AMCreateChat: "EMsg"                                             = 4001
    AMCreateChatResponse: "EMsg"                                     = 4002
    AMSetProfileURL: "EMsg"                                          = 4005
    AMGetAccountEmailAddress: "EMsg"                                 = 4006
    AMGetAccountEmailAddressResponse: "EMsg"                         = 4007
    AMRequestClanData: "EMsg"                                        = 4008
    AMRouteToClients: "EMsg"                                         = 4009
    AMLeaveClan: "EMsg"                                              = 4010
    AMClanPermissions: "EMsg"                                        = 4011
    AMClanPermissionsResponse: "EMsg"                                = 4012
    AMCreateClanEventDummyForRateLimiting: "EMsg"                    = 4013
    AMUpdateClanEventDummyForRateLimiting: "EMsg"                    = 4015
    AMCreateClanEventResponse: "EMsg"                                = 4014
    AMUpdateClanEvent: "EMsg"                                        = 4015
    AMUpdateClanEventResponse: "EMsg"                                = 4016
    AMGetClanEvents: "EMsg"                                          = 4017
    AMGetClanEventsResponse: "EMsg"                                  = 4018
    AMDeleteClanEvent: "EMsg"                                        = 4019
    AMDeleteClanEventResponse: "EMsg"                                = 4020
    AMSetClanPermissionSettings: "EMsg"                              = 4021
    AMSetClanPermissionSettingsResponse: "EMsg"                      = 4022
    AMGetClanPermissionSettings: "EMsg"                              = 4023
    AMGetClanPermissionSettingsResponse: "EMsg"                      = 4024
    AMPublishChatRoomInfo: "EMsg"                                    = 4025
    ClientChatRoomInfo: "EMsg"                                       = 4026
    AMGetClanHistory: "EMsg"                                         = 4039
    AMGetClanHistoryResponse: "EMsg"                                 = 4040
    AMGetClanPermissionBits: "EMsg"                                  = 4041
    AMGetClanPermissionBitsResponse: "EMsg"                          = 4042
    AMSetClanPermissionBits: "EMsg"                                  = 4043
    AMSetClanPermissionBitsResponse: "EMsg"                          = 4044
    AMSessionInfoRequest: "EMsg"                                     = 4045
    AMSessionInfoResponse: "EMsg"                                    = 4046
    AMValidateWGToken: "EMsg"                                        = 4047
    AMGetSingleClanEvent: "EMsg"                                     = 4048
    AMGetSingleClanEventResponse: "EMsg"                             = 4049
    AMGetClanRank: "EMsg"                                            = 4050
    AMGetClanRankResponse: "EMsg"                                    = 4051
    AMSetClanRank: "EMsg"                                            = 4052
    AMSetClanRankResponse: "EMsg"                                    = 4053
    AMGetClanPOTW: "EMsg"                                            = 4054
    AMGetClanPOTWResponse: "EMsg"                                    = 4055
    AMSetClanPOTW: "EMsg"                                            = 4056
    AMSetClanPOTWResponse: "EMsg"                                    = 4057
    AMDumpUser: "EMsg"                                               = 4059
    AMKickUserFromClan: "EMsg"                                       = 4060
    AMAddFounderToClan: "EMsg"                                       = 4061
    AMValidateWGTokenResponse: "EMsg"                                = 4062
    AMSetCommunityState: "EMsg"                                      = 4063
    AMSetAccountDetails: "EMsg"                                      = 4064
    AMGetChatBanList: "EMsg"                                         = 4065
    AMGetChatBanListResponse: "EMsg"                                 = 4066
    AMUnBanFromChat: "EMsg"                                          = 4067
    AMSetClanDetails: "EMsg"                                         = 4068
    AMGetAccountLinks: "EMsg"                                        = 4069
    AMGetAccountLinksResponse: "EMsg"                                = 4070
    AMSetAccountLinks: "EMsg"                                        = 4071
    AMSetAccountLinksResponse: "EMsg"                                = 4072
    UGSGetUserGameStats: "EMsg"                                      = 4073
    UGSGetUserGameStatsResponse: "EMsg"                              = 4074
    AMCheckClanMembership: "EMsg"                                    = 4075
    AMGetClanMembers: "EMsg"                                         = 4076
    AMGetClanMembersResponse: "EMsg"                                 = 4077
    AMJoinPublicClan: "EMsg"                                         = 4078
    AMNotifyChatOfClanChange: "EMsg"                                 = 4079
    AMResubmitPurchase: "EMsg"                                       = 4080
    AMAddFriend: "EMsg"                                              = 4081
    AMAddFriendResponse: "EMsg"                                      = 4082
    AMRemoveFriend: "EMsg"                                           = 4083
    AMDumpClan: "EMsg"                                               = 4084
    AMChangeClanOwner: "EMsg"                                        = 4085
    AMCancelEasyCollect: "EMsg"                                      = 4086
    AMCancelEasyCollectResponse: "EMsg"                              = 4087
    AMClansInCommon: "EMsg"                                          = 4090
    AMClansInCommonResponse: "EMsg"                                  = 4091
    AMIsValidAccountID: "EMsg"                                       = 4092
    AMConvertClan: "EMsg"                                            = 4093
    AMWipeFriendsList: "EMsg"                                        = 4095
    AMSetIgnored: "EMsg"                                             = 4096
    AMClansInCommonCountResponse: "EMsg"                             = 4097
    AMFriendsList: "EMsg"                                            = 4098
    AMFriendsListResponse: "EMsg"                                    = 4099
    AMFriendsInCommon: "EMsg"                                        = 4100
    AMFriendsInCommonResponse: "EMsg"                                = 4101
    AMFriendsInCommonCountResponse: "EMsg"                           = 4102
    AMClansInCommonCount: "EMsg"                                     = 4103
    AMChallengeVerdict: "EMsg"                                       = 4104
    AMChallengeNotification: "EMsg"                                  = 4105
    AMFindGSByIP: "EMsg"                                             = 4106
    AMFoundGSByIP: "EMsg"                                            = 4107
    AMGiftRevoked: "EMsg"                                            = 4108
    AMCreateAccountRecord: "EMsg"                                    = 4109
    AMUserClanList: "EMsg"                                           = 4110
    AMUserClanListResponse: "EMsg"                                   = 4111
    AMGetAccountDetails2: "EMsg"                                     = 4112
    AMGetAccountDetailsResponse2: "EMsg"                             = 4113
    AMSetCommunityProfileSettings: "EMsg"                            = 4114
    AMSetCommunityProfileSettingsResponse: "EMsg"                    = 4115
    AMGetCommunityPrivacyState: "EMsg"                               = 4116
    AMGetCommunityPrivacyStateResponse: "EMsg"                       = 4117
    AMCheckClanInviteRateLimiting: "EMsg"                            = 4118
    UGSGetUserAchievementStatus: "EMsg"                              = 4119
    AMGetIgnored: "EMsg"                                             = 4120
    AMGetIgnoredResponse: "EMsg"                                     = 4121
    AMSetIgnoredResponse: "EMsg"                                     = 4122
    AMSetFriendRelationshipNone: "EMsg"                              = 4123
    AMGetFriendRelationship: "EMsg"                                  = 4124
    AMGetFriendRelationshipResponse: "EMsg"                          = 4125
    AMServiceModulesCache: "EMsg"                                    = 4126
    AMServiceModulesCall: "EMsg"                                     = 4127
    AMServiceModulesCallResponse: "EMsg"                             = 4128
    AMGetCaptchaDataForIP: "EMsg"                                    = 4129
    AMGetCaptchaDataForIPResponse: "EMsg"                            = 4130
    AMValidateCaptchaDataForIP: "EMsg"                               = 4131
    AMValidateCaptchaDataForIPResponse: "EMsg"                       = 4132
    AMTrackFailedAuthByIP: "EMsg"                                    = 4133
    AMGetCaptchaDataByGID: "EMsg"                                    = 4134
    AMGetCaptchaDataByGIDResponse: "EMsg"                            = 4135
    CommunityAddFriendNews: "EMsg"                                   = 4140
    AMFindClanUser: "EMsg"                                           = 4143
    AMFindClanUserResponse: "EMsg"                                   = 4144
    AMBanFromChat: "EMsg"                                            = 4145
    AMGetUserNewsSubscriptions: "EMsg"                               = 4147
    AMGetUserNewsSubscriptionsResponse: "EMsg"                       = 4148
    AMSetUserNewsSubscriptions: "EMsg"                               = 4149
    AMSendQueuedEmails: "EMsg"                                       = 4152
    AMSetLicenseFlags: "EMsg"                                        = 4153
    CommunityDeleteUserNews: "EMsg"                                  = 4155
    AMAllowUserFilesRequest: "EMsg"                                  = 4156
    AMAllowUserFilesResponse: "EMsg"                                 = 4157
    AMGetAccountStatus: "EMsg"                                       = 4158
    AMGetAccountStatusResponse: "EMsg"                               = 4159
    AMEditBanReason: "EMsg"                                          = 4160
    AMCheckClanMembershipResponse: "EMsg"                            = 4161
    AMProbeClanMembershipList: "EMsg"                                = 4162
    AMProbeClanMembershipListResponse: "EMsg"                        = 4163
    UGSGetUserAchievementStatusResponse: "EMsg"                      = 4164
    AMGetFriendsLobbies: "EMsg"                                      = 4165
    AMGetFriendsLobbiesResponse: "EMsg"                              = 4166
    AMGetUserFriendNewsResponse: "EMsg"                              = 4172
    CommunityGetUserFriendNews: "EMsg"                               = 4173
    AMGetUserClansNewsResponse: "EMsg"                               = 4174
    AMGetUserClansNews: "EMsg"                                       = 4175
    AMGetPreviousCBAccount: "EMsg"                                   = 4184
    AMGetPreviousCBAccountResponse: "EMsg"                           = 4185
    AMGetUserLicenseHistory: "EMsg"                                  = 4190
    AMGetUserLicenseHistoryResponse: "EMsg"                          = 4191
    AMSupportChangePassword: "EMsg"                                  = 4194
    AMSupportChangeEmail: "EMsg"                                     = 4195
    AMResetUserVerificationGSByIP: "EMsg"                            = 4197
    AMUpdateGSPlayStats: "EMsg"                                      = 4198
    AMSupportEnableOrDisable: "EMsg"                                 = 4199
    AMGetPurchaseStatus: "EMsg"                                      = 4206
    AMSupportIsAccountEnabled: "EMsg"                                = 4209
    AMSupportIsAccountEnabledResponse: "EMsg"                        = 4210
    UGSGetUserStats: "EMsg"                                          = 4211
    AMSupportKickSession: "EMsg"                                     = 4212
    AMGSSearch: "EMsg"                                               = 4213
    MarketingMessageUpdate: "EMsg"                                   = 4216
    ChatServerRouteFriendMsg: "EMsg"                                 = 4219
    AMTicketAuthRequestOrResponse: "EMsg"                            = 4220
    AMVerifyDepotManagementRights: "EMsg"                            = 4222
    AMVerifyDepotManagementRightsResponse: "EMsg"                    = 4223
    AMAddFreeLicense: "EMsg"                                         = 4224
    AMValidateEmailLink: "EMsg"                                      = 4231
    AMValidateEmailLinkResponse: "EMsg"                              = 4232
    UGSStoreUserStats: "EMsg"                                        = 4236
    AMDeleteStoredCard: "EMsg"                                       = 4241
    AMRevokeLegacyGameKeys: "EMsg"                                   = 4242
    AMGetWalletDetails: "EMsg"                                       = 4244
    AMGetWalletDetailsResponse: "EMsg"                               = 4245
    AMDeleteStoredPaymentInfo: "EMsg"                                = 4246
    AMGetStoredPaymentSummary: "EMsg"                                = 4247
    AMGetStoredPaymentSummaryResponse: "EMsg"                        = 4248
    AMGetWalletConversionRate: "EMsg"                                = 4249
    AMGetWalletConversionRateResponse: "EMsg"                        = 4250
    AMConvertWallet: "EMsg"                                          = 4251
    AMConvertWalletResponse: "EMsg"                                  = 4252
    AMSetPreApproval: "EMsg"                                         = 4255
    AMSetPreApprovalResponse: "EMsg"                                 = 4256
    AMCreateRefund: "EMsg"                                           = 4258
    AMCreateRefundResponse: "EMsg"                                   = 4259
    AMCreateChargeback: "EMsg"                                       = 4260
    AMCreateChargebackResponse: "EMsg"                               = 4261
    AMCreateDispute: "EMsg"                                          = 4262
    AMCreateDisputeResponse: "EMsg"                                  = 4263
    AMClearDispute: "EMsg"                                           = 4264
    AMCreateFinancialAdjustment: "EMsg"                              = 4265
    AMPlayerNicknameList: "EMsg"                                     = 4266
    AMPlayerNicknameListResponse: "EMsg"                             = 4267
    AMSetDRMTestConfig: "EMsg"                                       = 4268
    AMGetUserCurrentGameInfo: "EMsg"                                 = 4269
    AMGetUserCurrentGameInfoResponse: "EMsg"                         = 4270
    AMGetGSPlayerList: "EMsg"                                        = 4271
    AMGetGSPlayerListResponse: "EMsg"                                = 4272
    AMGetGameMembers: "EMsg"                                         = 4276
    AMGetGameMembersResponse: "EMsg"                                 = 4277
    AMGetSteamIDForMicroTxn: "EMsg"                                  = 4278
    AMGetSteamIDForMicroTxnResponse: "EMsg"                          = 4279
    AMSetPartnerMember: "EMsg"                                       = 4280
    AMRemovePublisherUser: "EMsg"                                    = 4281
    AMGetUserLicenseList: "EMsg"                                     = 4282
    AMGetUserLicenseListResponse: "EMsg"                             = 4283
    AMReloadGameGroupPolicy: "EMsg"                                  = 4284
    AMAddFreeLicenseResponse: "EMsg"                                 = 4285
    AMVACStatusUpdate: "EMsg"                                        = 4286
    AMGetAccountDetails: "EMsg"                                      = 4287
    AMGetAccountDetailsResponse: "EMsg"                              = 4288
    AMGetPlayerLinkDetails: "EMsg"                                   = 4289
    AMGetPlayerLinkDetailsResponse: "EMsg"                           = 4290
    AMGetAccountFlagsForWGSpoofing: "EMsg"                           = 4294
    AMGetAccountFlagsForWGSpoofingResponse: "EMsg"                   = 4295
    AMGetClanOfficers: "EMsg"                                        = 4298
    AMGetClanOfficersResponse: "EMsg"                                = 4299
    AMNameChange: "EMsg"                                             = 4300
    AMGetNameHistory: "EMsg"                                         = 4301
    AMGetNameHistoryResponse: "EMsg"                                 = 4302
    AMUpdateProviderStatus: "EMsg"                                   = 4305
    AMSupportRemoveAccountSecurity: "EMsg"                           = 4307
    AMIsAccountInCaptchaGracePeriod: "EMsg"                          = 4308
    AMIsAccountInCaptchaGracePeriodResponse: "EMsg"                  = 4309
    AMAccountPS3Unlink: "EMsg"                                       = 4310
    AMAccountPS3UnlinkResponse: "EMsg"                               = 4311
    UGSStoreUserStatsResponse: "EMsg"                                = 4312
    AMGetAccountPSNInfo: "EMsg"                                      = 4313
    AMGetAccountPSNInfoResponse: "EMsg"                              = 4314
    AMAuthenticatedPlayerList: "EMsg"                                = 4315
    AMGetUserGifts: "EMsg"                                           = 4316
    AMGetUserGiftsResponse: "EMsg"                                   = 4317
    AMTransferLockedGifts: "EMsg"                                    = 4320
    AMTransferLockedGiftsResponse: "EMsg"                            = 4321
    AMPlayerHostedOnGameServer: "EMsg"                               = 4322
    AMGetAccountBanInfo: "EMsg"                                      = 4323
    AMGetAccountBanInfoResponse: "EMsg"                              = 4324
    AMRecordBanEnforcement: "EMsg"                                   = 4325
    AMRollbackGiftTransfer: "EMsg"                                   = 4326
    AMRollbackGiftTransferResponse: "EMsg"                           = 4327
    AMHandlePendingTransaction: "EMsg"                               = 4328
    AMRequestClanDetails: "EMsg"                                     = 4329
    AMDeleteStoredPaypalAgreement: "EMsg"                            = 4330
    AMGameServerUpdate: "EMsg"                                       = 4331
    AMGameServerRemove: "EMsg"                                       = 4332
    AMGetPaypalAgreements: "EMsg"                                    = 4333
    AMGetPaypalAgreementsResponse: "EMsg"                            = 4334
    AMGameServerPlayerCompatibilityCheck: "EMsg"                     = 4335
    AMGameServerPlayerCompatibilityCheckResponse: "EMsg"             = 4336
    AMRenewLicense: "EMsg"                                           = 4337
    AMGetAccountCommunityBanInfo: "EMsg"                             = 4338
    AMGetAccountCommunityBanInfoResponse: "EMsg"                     = 4339
    AMGameServerAccountChangePassword: "EMsg"                        = 4340
    AMGameServerAccountDeleteAccount: "EMsg"                         = 4341
    AMRenewAgreement: "EMsg"                                         = 4342
    AMXsollaPayment: "EMsg"                                          = 4344
    AMXsollaPaymentResponse: "EMsg"                                  = 4345
    AMAcctAllowedToPurchase: "EMsg"                                  = 4346
    AMAcctAllowedToPurchaseResponse: "EMsg"                          = 4347
    AMSwapKioskDeposit: "EMsg"                                       = 4348
    AMSwapKioskDepositResponse: "EMsg"                               = 4349
    AMSetUserGiftUnowned: "EMsg"                                     = 4350
    AMSetUserGiftUnownedResponse: "EMsg"                             = 4351
    AMClaimUnownedUserGift: "EMsg"                                   = 4352
    AMClaimUnownedUserGiftResponse: "EMsg"                           = 4353
    AMSetClanName: "EMsg"                                            = 4354
    AMSetClanNameResponse: "EMsg"                                    = 4355
    AMGrantCoupon: "EMsg"                                            = 4356
    AMGrantCouponResponse: "EMsg"                                    = 4357
    AMIsPackageRestrictedInUserCountry: "EMsg"                       = 4358
    AMIsPackageRestrictedInUserCountryResponse: "EMsg"               = 4359
    AMHandlePendingTransactionResponse: "EMsg"                       = 4360
    AMGrantGuestPasses2: "EMsg"                                      = 4361
    AMGrantGuestPasses2Response: "EMsg"                              = 4362
    AMSessionQuery: "EMsg"                                           = 4363
    AMSessionQueryResponse: "EMsg"                                   = 4364
    AMGetPlayerBanDetails: "EMsg"                                    = 4365
    AMGetPlayerBanDetailsResponse: "EMsg"                            = 4366
    AMFinalizePurchase: "EMsg"                                       = 4367
    AMFinalizePurchaseResponse: "EMsg"                               = 4368
    AMPersonaChangeResponse: "EMsg"                                  = 4372
    AMGetClanDetailsForForumCreation: "EMsg"                         = 4373
    AMGetClanDetailsForForumCreationResponse: "EMsg"                 = 4374
    AMGetPendingNotificationCount: "EMsg"                            = 4375
    AMGetPendingNotificationCountResponse: "EMsg"                    = 4376
    AMPasswordHashUpgrade: "EMsg"                                    = 4377
    AMMoPayPayment: "EMsg"                                           = 4378
    AMMoPayPaymentResponse: "EMsg"                                   = 4379
    AMBoaCompraPayment: "EMsg"                                       = 4380
    AMBoaCompraPaymentResponse: "EMsg"                               = 4381
    AMExpireCaptchaByGID: "EMsg"                                     = 4382
    AMCompleteExternalPurchase: "EMsg"                               = 4383
    AMCompleteExternalPurchaseResponse: "EMsg"                       = 4384
    AMResolveNegativeWalletCredits: "EMsg"                           = 4385
    AMResolveNegativeWalletCreditsResponse: "EMsg"                   = 4386
    AMPayelpPayment: "EMsg"                                          = 4387
    AMPayelpPaymentResponse: "EMsg"                                  = 4388
    AMPlayerGetClanBasicDetails: "EMsg"                              = 4389
    AMPlayerGetClanBasicDetailsResponse: "EMsg"                      = 4390
    AMMOLPayment: "EMsg"                                             = 4391
    AMMOLPaymentResponse: "EMsg"                                     = 4392
    GetUserIPCountry: "EMsg"                                         = 4393
    GetUserIPCountryResponse: "EMsg"                                 = 4394
    NotificationOfSuspiciousActivity: "EMsg"                         = 4395
    AMDegicaPayment: "EMsg"                                          = 4396
    AMDegicaPaymentResponse: "EMsg"                                  = 4397
    AMEClubPayment: "EMsg"                                           = 4398
    AMEClubPaymentResponse: "EMsg"                                   = 4399
    AMPayPalPaymentsHubPayment: "EMsg"                               = 4400
    AMPayPalPaymentsHubPaymentResponse: "EMsg"                       = 4401
    AMTwoFactorRecoverAuthenticatorRequest: "EMsg"                   = 4402
    AMTwoFactorRecoverAuthenticatorResponse: "EMsg"                  = 4403
    AMSmart2PayPayment: "EMsg"                                       = 4404
    AMSmart2PayPaymentResponse: "EMsg"                               = 4405
    AMValidatePasswordResetCodeAndSendSmsRequest: "EMsg"             = 4406
    AMValidatePasswordResetCodeAndSendSmsResponse: "EMsg"            = 4407
    AMGetAccountResetDetailsRequest: "EMsg"                          = 4408
    AMGetAccountResetDetailsResponse: "EMsg"                         = 4409
    AMBitPayPayment: "EMsg"                                          = 4410
    AMBitPayPaymentResponse: "EMsg"                                  = 4411
    AMSendAccountInfoUpdate: "EMsg"                                  = 4412
    AMSendScheduledGift: "EMsg"                                      = 4413
    AMNodwinPayment: "EMsg"                                          = 4414
    AMNodwinPaymentResponse: "EMsg"                                  = 4415
    AMResolveWalletRevoke: "EMsg"                                    = 4416
    AMResolveWalletReverseRevoke: "EMsg"                             = 4417
    AMFundedPayment: "EMsg"                                          = 4418
    AMFundedPaymentResponse: "EMsg"                                  = 4419
    AMRequestPersonaUpdateForChatServer: "EMsg"                      = 4420
    AMPerfectWorldPayment: "EMsg"                                    = 4421
    AMPerfectWorldPaymentResponse: "EMsg"                            = 4422

    BasePSRange: "EMsg"                                              = 5000
    PSCreateShoppingCart: "EMsg"                                     = 5001
    PSCreateShoppingCartResponse: "EMsg"                             = 5002
    PSIsValidShoppingCart: "EMsg"                                    = 5003
    PSIsValidShoppingCartResponse: "EMsg"                            = 5004
    PSAddPackageToShoppingCart: "EMsg"                               = 5005
    PSAddPackageToShoppingCartResponse: "EMsg"                       = 5006
    PSRemoveLineItemFromShoppingCart: "EMsg"                         = 5007
    PSRemoveLineItemFromShoppingCartResponse: "EMsg"                 = 5008
    PSGetShoppingCartContents: "EMsg"                                = 5009
    PSGetShoppingCartContentsResponse: "EMsg"                        = 5010
    PSAddWalletCreditToShoppingCart: "EMsg"                          = 5011
    PSAddWalletCreditToShoppingCartResponse: "EMsg"                  = 5012

    BaseUFSRange: "EMsg"                                             = 5200
    ClientUFSUploadFileRequest: "EMsg"                               = 5202
    ClientUFSUploadFileResponse: "EMsg"                              = 5203
    ClientUFSUploadFileChunk: "EMsg"                                 = 5204
    ClientUFSUploadFileFinished: "EMsg"                              = 5205
    ClientUFSGetFileListForApp: "EMsg"                               = 5206
    ClientUFSGetFileListForAppResponse: "EMsg"                       = 5207
    ClientUFSDownloadRequest: "EMsg"                                 = 5210
    ClientUFSDownloadResponse: "EMsg"                                = 5211
    ClientUFSDownloadChunk: "EMsg"                                   = 5212
    ClientUFSLoginRequest: "EMsg"                                    = 5213
    ClientUFSLoginResponse: "EMsg"                                   = 5214
    UFSReloadPartitionInfo: "EMsg"                                   = 5215
    ClientUFSTransferHeartbeat: "EMsg"                               = 5216
    UFSSynchronizeFile: "EMsg"                                       = 5217
    UFSSynchronizeFileResponse: "EMsg"                               = 5218
    ClientUFSDeleteFileRequest: "EMsg"                               = 5219
    ClientUFSDeleteFileResponse: "EMsg"                              = 5220
    UFSDownloadRequest: "EMsg"                                       = 5221
    UFSDownloadResponse: "EMsg"                                      = 5222
    UFSDownloadChunk: "EMsg"                                         = 5223
    ClientUFSGetUGCDetails: "EMsg"                                   = 5226
    ClientUFSGetUGCDetailsResponse: "EMsg"                           = 5227
    UFSUpdateFileFlags: "EMsg"                                       = 5228
    UFSUpdateFileFlagsResponse: "EMsg"                               = 5229
    ClientUFSGetSingleFileInfo: "EMsg"                               = 5230
    ClientUFSGetSingleFileInfoResponse: "EMsg"                       = 5231
    ClientUFSShareFile: "EMsg"                                       = 5232
    ClientUFSShareFileResponse: "EMsg"                               = 5233
    UFSReloadAccount: "EMsg"                                         = 5234
    UFSReloadAccountResponse: "EMsg"                                 = 5235
    UFSUpdateRecordBatched: "EMsg"                                   = 5236
    UFSUpdateRecordBatchedResponse: "EMsg"                           = 5237
    UFSMigrateFile: "EMsg"                                           = 5238
    UFSMigrateFileResponse: "EMsg"                                   = 5239
    UFSGetUGCURLs: "EMsg"                                            = 5240
    UFSGetUGCURLsResponse: "EMsg"                                    = 5241
    UFSHttpUploadFileFinishRequest: "EMsg"                           = 5242
    UFSHttpUploadFileFinishResponse: "EMsg"                          = 5243
    UFSDownloadStartRequest: "EMsg"                                  = 5244
    UFSDownloadStartResponse: "EMsg"                                 = 5245
    UFSDownloadChunkRequest: "EMsg"                                  = 5246
    UFSDownloadChunkResponse: "EMsg"                                 = 5247
    UFSDownloadFinishRequest: "EMsg"                                 = 5248
    UFSDownloadFinishResponse: "EMsg"                                = 5249
    UFSFlushURLCache: "EMsg"                                         = 5250
    ClientUFSUploadCommit: "EMsg"                                    = 5251
    ClientUFSUploadCommitResponse: "EMsg"                            = 5252
    UFSMigrateFileAppID: "EMsg"                                      = 5253
    UFSMigrateFileAppIDResponse: "EMsg"                              = 5254

    BaseClient2: "EMsg"                                              = 5400
    ClientRequestForgottenPasswordEmail: "EMsg"                      = 5401
    ClientRequestForgottenPasswordEmailResponse: "EMsg"              = 5402
    ClientCreateAccountResponse: "EMsg"                              = 5403
    ClientResetForgottenPassword: "EMsg"                             = 5404
    ClientResetForgottenPasswordResponse: "EMsg"                     = 5405
    ClientCreateAccount2: "EMsg"                                     = 5406
    ClientInformOfResetForgottenPassword: "EMsg"                     = 5407
    ClientInformOfResetForgottenPasswordResponse: "EMsg"             = 5408
    ClientGamesPlayedWithDataBlob: "EMsg"                            = 5410
    ClientUpdateUserGameInfo: "EMsg"                                 = 5411
    ClientFileToDownload: "EMsg"                                     = 5412
    ClientFileToDownloadResponse: "EMsg"                             = 5413
    ClientLBSSetScore: "EMsg"                                        = 5414
    ClientLBSSetScoreResponse: "EMsg"                                = 5415
    ClientLBSFindOrCreateLB: "EMsg"                                  = 5416
    ClientLBSFindOrCreateLBResponse: "EMsg"                          = 5417
    ClientLBSGetLBEntries: "EMsg"                                    = 5418
    ClientLBSGetLBEntriesResponse: "EMsg"                            = 5419
    ClientChatDeclined: "EMsg"                                       = 5426
    ClientFriendMsgIncoming: "EMsg"                                  = 5427
    ClientTicketAuthComplete: "EMsg"                                 = 5429
    ClientIsLimitedAccount: "EMsg"                                   = 5430
    ClientRequestAuthList: "EMsg"                                    = 5431
    ClientAuthList: "EMsg"                                           = 5432
    ClientStat: "EMsg"                                               = 5433
    ClientP2PConnectionInfo: "EMsg"                                  = 5434
    ClientP2PConnectionFailInfo: "EMsg"                              = 5435
    ClientGetDepotDecryptionKey: "EMsg"                              = 5438
    ClientGetDepotDecryptionKeyResponse: "EMsg"                      = 5439
    GSPerformHardwareSurvey: "EMsg"                                  = 5440
    ClientEnableTestLicense: "EMsg"                                  = 5443
    ClientEnableTestLicenseResponse: "EMsg"                          = 5444
    ClientDisableTestLicense: "EMsg"                                 = 5445
    ClientDisableTestLicenseResponse: "EMsg"                         = 5446
    ClientRequestValidationMail: "EMsg"                              = 5448
    ClientRequestValidationMailResponse: "EMsg"                      = 5449
    ClientCheckAppBetaPassword: "EMsg"                               = 5450
    ClientCheckAppBetaPasswordResponse: "EMsg"                       = 5451
    ClientToGC: "EMsg"                                               = 5452
    ClientFromGC: "EMsg"                                             = 5453
    ClientRequestChangeMail: "EMsg"                                  = 5454
    ClientRequestChangeMailResponse: "EMsg"                          = 5455
    ClientEmailAddrInfo: "EMsg"                                      = 5456
    ClientPasswordChange3: "EMsg"                                    = 5457
    ClientEmailChange3: "EMsg"                                       = 5458
    ClientPersonalQAChange3: "EMsg"                                  = 5459
    ClientResetForgottenPassword3: "EMsg"                            = 5460
    ClientRequestForgottenPasswordEmail3: "EMsg"                     = 5461
    ClientNewLoginKey: "EMsg"                                        = 5463
    ClientNewLoginKeyAccepted: "EMsg"                                = 5464
    ClientStoreUserStats2: "EMsg"                                    = 5466
    ClientStatsUpdated: "EMsg"                                       = 5467
    ClientActivateOEMLicense: "EMsg"                                 = 5468
    ClientRegisterOEMMachine: "EMsg"                                 = 5469
    ClientRegisterOEMMachineResponse: "EMsg"                         = 5470
    ClientRequestedClientStats: "EMsg"                               = 5480
    ClientStat2Int32: "EMsg"                                         = 5481
    ClientStat2: "EMsg"                                              = 5482
    ClientVerifyPassword: "EMsg"                                     = 5483
    ClientVerifyPasswordResponse: "EMsg"                             = 5484
    ClientDRMDownloadRequest: "EMsg"                                 = 5485
    ClientDRMDownloadResponse: "EMsg"                                = 5486
    ClientDRMFinalResult: "EMsg"                                     = 5487
    ClientGetFriendsWhoPlayGame: "EMsg"                              = 5488
    ClientGetFriendsWhoPlayGameResponse: "EMsg"                      = 5489
    ClientOGSBeginSession: "EMsg"                                    = 5490
    ClientOGSBeginSessionResponse: "EMsg"                            = 5491
    ClientOGSEndSession: "EMsg"                                      = 5492
    ClientOGSEndSessionResponse: "EMsg"                              = 5493
    ClientOGSWriteRow: "EMsg"                                        = 5494
    ClientDRMTest: "EMsg"                                            = 5495
    ClientDRMTestResult: "EMsg"                                      = 5496
    ClientServerUnavailable: "EMsg"                                  = 5500
    ClientServersAvailable: "EMsg"                                   = 5501
    ClientRegisterAuthTicketWithCM: "EMsg"                           = 5502
    ClientGCMsgFailed: "EMsg"                                        = 5503
    ClientMicroTxnAuthRequest: "EMsg"                                = 5504
    ClientMicroTxnAuthorize: "EMsg"                                  = 5505
    ClientMicroTxnAuthorizeResponse: "EMsg"                          = 5506
    ClientAppMinutesPlayedData: "EMsg"                               = 5507
    ClientGetMicroTxnInfo: "EMsg"                                    = 5508
    ClientGetMicroTxnInfoResponse: "EMsg"                            = 5509
    ClientMarketingMessageUpdate2: "EMsg"                            = 5510
    ClientDeregisterWithServer: "EMsg"                               = 5511
    ClientSubscribeToPersonaFeed: "EMsg"                             = 5512
    ClientLogon: "EMsg"                                              = 5514
    ClientGetClientDetails: "EMsg"                                   = 5515
    ClientGetClientDetailsResponse: "EMsg"                           = 5516
    ClientReportOverlayDetourFailure: "EMsg"                         = 5517
    ClientGetClientAppList: "EMsg"                                   = 5518
    ClientGetClientAppListResponse: "EMsg"                           = 5519
    ClientInstallClientApp: "EMsg"                                   = 5520
    ClientInstallClientAppResponse: "EMsg"                           = 5521
    ClientUninstallClientApp: "EMsg"                                 = 5522
    ClientUninstallClientAppResponse: "EMsg"                         = 5523
    ClientSetClientAppUpdateState: "EMsg"                            = 5524
    ClientSetClientAppUpdateStateResponse: "EMsg"                    = 5525
    ClientRequestEncryptedAppTicket: "EMsg"                          = 5526
    ClientRequestEncryptedAppTicketResponse: "EMsg"                  = 5527
    ClientWalletInfoUpdate: "EMsg"                                   = 5528
    ClientLBSSetUGC: "EMsg"                                          = 5529
    ClientLBSSetUGCResponse: "EMsg"                                  = 5530
    ClientAMGetClanOfficers: "EMsg"                                  = 5531
    ClientAMGetClanOfficersResponse: "EMsg"                          = 5532
    ClientFriendProfileInfo: "EMsg"                                  = 5535
    ClientFriendProfileInfoResponse: "EMsg"                          = 5536
    ClientUpdateMachineAuth: "EMsg"                                  = 5537
    ClientUpdateMachineAuthResponse: "EMsg"                          = 5538
    ClientReadMachineAuth: "EMsg"                                    = 5539
    ClientReadMachineAuthResponse: "EMsg"                            = 5540
    ClientRequestMachineAuth: "EMsg"                                 = 5541
    ClientRequestMachineAuthResponse: "EMsg"                         = 5542
    ClientScreenshotsChanged: "EMsg"                                 = 5543
    ClientEmailChange4: "EMsg"                                       = 5544
    ClientEmailChangeResponse4: "EMsg"                               = 5545
    ClientGetCDNAuthToken: "EMsg"                                    = 5546
    ClientGetCDNAuthTokenResponse: "EMsg"                            = 5547
    ClientDownloadRateStatistics: "EMsg"                             = 5548
    ClientRequestAccountData: "EMsg"                                 = 5549
    ClientRequestAccountDataResponse: "EMsg"                         = 5550
    ClientResetForgottenPassword4: "EMsg"                            = 5551
    ClientHideFriend: "EMsg"                                         = 5552
    ClientFriendsGroupsList: "EMsg"                                  = 5553
    ClientGetClanActivityCounts: "EMsg"                              = 5554
    ClientGetClanActivityCountsResponse: "EMsg"                      = 5555
    ClientOGSReportString: "EMsg"                                    = 5556
    ClientOGSReportBug: "EMsg"                                       = 5557
    ClientSentLogs: "EMsg"                                           = 5558
    ClientLogonGameServer: "EMsg"                                    = 5559
    AMClientCreateFriendsGroup: "EMsg"                               = 5560
    AMClientCreateFriendsGroupResponse: "EMsg"                       = 5561
    AMClientDeleteFriendsGroup: "EMsg"                               = 5562
    AMClientDeleteFriendsGroupResponse: "EMsg"                       = 5563
    AMClientManageFriendsGroup: "EMsg"                               = 5564
    AMClientManageFriendsGroupResponse: "EMsg"                       = 5565
    AMClientAddFriendToGroup: "EMsg"                                 = 5566
    AMClientAddFriendToGroupResponse: "EMsg"                         = 5567
    AMClientRemoveFriendFromGroup: "EMsg"                            = 5568
    AMClientRemoveFriendFromGroupResponse: "EMsg"                    = 5569
    ClientAMGetPersonaNameHistory: "EMsg"                            = 5570
    ClientAMGetPersonaNameHistoryResponse: "EMsg"                    = 5571
    ClientRequestFreeLicense: "EMsg"                                 = 5572
    ClientRequestFreeLicenseResponse: "EMsg"                         = 5573
    ClientDRMDownloadRequestWithCrashData: "EMsg"                    = 5574
    ClientAuthListAck: "EMsg"                                        = 5575
    ClientItemAnnouncements: "EMsg"                                  = 5576
    ClientRequestItemAnnouncements: "EMsg"                           = 5577
    ClientFriendMsgEchoToSender: "EMsg"                              = 5578
    ClientOGSGameServerPingSample: "EMsg"                            = 5581
    ClientCommentNotifications: "EMsg"                               = 5582
    ClientRequestCommentNotifications: "EMsg"                        = 5583
    ClientPersonaChangeResponse: "EMsg"                              = 5584
    ClientRequestWebAPIAuthenticateUserNonce: "EMsg"                 = 5585
    ClientRequestWebAPIAuthenticateUserNonceResponse: "EMsg"         = 5586
    ClientPlayerNicknameList: "EMsg"                                 = 5587
    AMClientSetPlayerNickname: "EMsg"                                = 5588
    AMClientSetPlayerNicknameResponse: "EMsg"                        = 5589
    ClientCreateAccountProto: "EMsg"                                 = 5590
    ClientCreateAccountProtoResponse: "EMsg"                         = 5591
    ClientGetNumberOfCurrentPlayersDP: "EMsg"                        = 5592
    ClientGetNumberOfCurrentPlayersDPResponse: "EMsg"                = 5593
    ClientServiceMethodLegacy: "EMsg"                                = 5594
    ClientServiceMethodLegacyResponse: "EMsg"                        = 5595
    ClientFriendUserStatusPublished: "EMsg"                          = 5596
    ClientCurrentUIMode: "EMsg"                                      = 5597
    ClientVanityURLChangedNotification: "EMsg"                       = 5598
    ClientUserNotifications: "EMsg"                                  = 5599

    BaseDFS: "EMsg"                                                  = 5600
    DFSGetFile: "EMsg"                                               = 5601
    DFSInstallLocalFile: "EMsg"                                      = 5602
    DFSConnection: "EMsg"                                            = 5603
    DFSConnectionReply: "EMsg"                                       = 5604
    ClientDFSAuthenticateRequest: "EMsg"                             = 5605
    ClientDFSAuthenticateResponse: "EMsg"                            = 5606
    ClientDFSEndSession: "EMsg"                                      = 5607
    DFSPurgeFile: "EMsg"                                             = 5608
    DFSRouteFile: "EMsg"                                             = 5609
    DFSGetFileFromServer: "EMsg"                                     = 5610
    DFSAcceptedResponse: "EMsg"                                      = 5611
    DFSRequestPingback: "EMsg"                                       = 5612
    DFSRecvTransmitFile: "EMsg"                                      = 5613
    DFSSendTransmitFile: "EMsg"                                      = 5614
    DFSRequestPingback2: "EMsg"                                      = 5615
    DFSResponsePingback2: "EMsg"                                     = 5616
    ClientDFSDownloadStatus: "EMsg"                                  = 5617
    DFSStartTransfer: "EMsg"                                         = 5618
    DFSTransferComplete: "EMsg"                                      = 5619
    DFSRouteFileResponse: "EMsg"                                     = 5620
    ClientNetworkingCertRequest: "EMsg"                              = 5621
    ClientNetworkingCertRequestResponse: "EMsg"                      = 5622
    ClientChallengeRequest: "EMsg"                                   = 5623
    ClientChallengeResponse: "EMsg"                                  = 5624
    BadgeCraftedNotification: "EMsg"                                 = 5625
    ClientNetworkingMobileCertRequest: "EMsg"                        = 5626
    ClientNetworkingMobileCertRequestResponse: "EMsg"                = 5627

    BaseMDS: "EMsg"                                                  = 5800
    AMToMDSGetDepotDecryptionKey: "EMsg"                             = 5812
    MDSToAMGetDepotDecryptionKeyResponse: "EMsg"                     = 5813
    MDSContentServerConfigRequest: "EMsg"                            = 5827
    MDSContentServerConfig: "EMsg"                                   = 5828
    MDSGetDepotManifest: "EMsg"                                      = 5829
    MDSGetDepotManifestResponse: "EMsg"                              = 5830
    MDSGetDepotManifestChunk: "EMsg"                                 = 5831
    MDSGetDepotChunk: "EMsg"                                         = 5832
    MDSGetDepotChunkResponse: "EMsg"                                 = 5833
    MDSGetDepotChunkChunk: "EMsg"                                    = 5834
    MDSGetServerListForUser: "EMsg"                                  = 5836
    MDSGetServerListForUserResponse: "EMsg"                          = 5837
    MDSToCSFlushChunk: "EMsg"                                        = 5844
    MDSMigrateChunk: "EMsg"                                          = 5847
    MDSMigrateChunkResponse: "EMsg"                                  = 5848
    MDSToCSFlushManifest: "EMsg"                                     = 5849
    CSBase: "EMsg"                                                   = 6200
    CSPing: "EMsg"                                                   = 6201
    CSPingResponse: "EMsg"                                           = 6202

    GMSBase: "EMsg"                                                  = 6400
    GMSGameServerReplicate: "EMsg"                                   = 6401
    ClientGMSServerQuery: "EMsg"                                     = 6403
    GMSClientServerQueryResponse: "EMsg"                             = 6404
    AMGMSGameServerUpdate: "EMsg"                                    = 6405
    AMGMSGameServerRemove: "EMsg"                                    = 6406
    GameServerOutOfDate: "EMsg"                                      = 6407

    DeviceAuthorizationBase: "EMsg"                                  = 6500
    ClientAuthorizeLocalDeviceRequest: "EMsg"                        = 6501
    ClientAuthorizeLocalDeviceResponse: "EMsg"                       = 6502
    ClientDeauthorizeDeviceRequest: "EMsg"                           = 6503
    ClientDeauthorizeDevice: "EMsg"                                  = 6504
    ClientUseLocalDeviceAuthorizations: "EMsg"                       = 6505
    ClientGetAuthorizedDevices: "EMsg"                               = 6506
    ClientGetAuthorizedDevicesResponse: "EMsg"                       = 6507
    AMNotifySessionDeviceAuthorized: "EMsg"                          = 6508
    ClientAuthorizeLocalDeviceNotification: "EMsg"                   = 6509

    MMSBase: "EMsg"                                                  = 6600
    ClientMMSCreateLobby: "EMsg"                                     = 6601
    ClientMMSCreateLobbyResponse: "EMsg"                             = 6602
    ClientMMSJoinLobby: "EMsg"                                       = 6603
    ClientMMSJoinLobbyResponse: "EMsg"                               = 6604
    ClientMMSLeaveLobby: "EMsg"                                      = 6605
    ClientMMSLeaveLobbyResponse: "EMsg"                              = 6606
    ClientMMSGetLobbyList: "EMsg"                                    = 6607
    ClientMMSGetLobbyListResponse: "EMsg"                            = 6608
    ClientMMSSetLobbyData: "EMsg"                                    = 6609
    ClientMMSSetLobbyDataResponse: "EMsg"                            = 6610
    ClientMMSGetLobbyData: "EMsg"                                    = 6611
    ClientMMSLobbyData: "EMsg"                                       = 6612
    ClientMMSSendLobbyChatMsg: "EMsg"                                = 6613
    ClientMMSLobbyChatMsg: "EMsg"                                    = 6614
    ClientMMSSetLobbyOwner: "EMsg"                                   = 6615
    ClientMMSSetLobbyOwnerResponse: "EMsg"                           = 6616
    ClientMMSSetLobbyGameServer: "EMsg"                              = 6617
    ClientMMSLobbyGameServerSet: "EMsg"                              = 6618
    ClientMMSUserJoinedLobby: "EMsg"                                 = 6619
    ClientMMSUserLeftLobby: "EMsg"                                   = 6620
    ClientMMSInviteToLobby: "EMsg"                                   = 6621
    ClientMMSFlushFrenemyListCache: "EMsg"                           = 6622
    ClientMMSFlushFrenemyListCacheResponse: "EMsg"                   = 6623
    ClientMMSSetLobbyLinked: "EMsg"                                  = 6624
    ClientMMSSetRatelimitPolicyOnClient: "EMsg"                      = 6625
    ClientMMSGetLobbyStatus: "EMsg"                                  = 6626
    ClientMMSGetLobbyStatusResponse: "EMsg"                          = 6627
    MMSGetLobbyList: "EMsg"                                          = 6628
    MMSGetLobbyListResponse: "EMsg"                                  = 6629
    NonStdMsgBase: "EMsg"                                            = 6800
    NonStdMsgMemcached: "EMsg"                                       = 6801
    NonStdMsgHTTPServer: "EMsg"                                      = 6802
    NonStdMsgHTTPClient: "EMsg"                                      = 6803
    NonStdMsgWGResponse: "EMsg"                                      = 6804
    NonStdMsgPHPSimulator: "EMsg"                                    = 6805
    NonStdMsgChase: "EMsg"                                           = 6806
    NonStdMsgDFSTransfer: "EMsg"                                     = 6807
    NonStdMsgTests: "EMsg"                                           = 6808
    NonStdMsgUMQpipeAAPL: "EMsg"                                     = 6809
    NonStdMsgSyslog: "EMsg"                                          = 6810
    NonStdMsgLogsink: "EMsg"                                         = 6811
    NonStdMsgSteam2Emulator: "EMsg"                                  = 6812
    NonStdMsgRTMPServer: "EMsg"                                      = 6813
    NonStdMsgWebSocket: "EMsg"                                       = 6814
    NonStdMsgRedis: "EMsg"                                           = 6815

    UDSBase: "EMsg"                                                  = 7000
    ClientUDSP2PSessionStarted: "EMsg"                               = 7001
    ClientUDSP2PSessionEnded: "EMsg"                                 = 7002
    UDSRenderUserAuth: "EMsg"                                        = 7003
    UDSRenderUserAuthResponse: "EMsg"                                = 7004
    ClientInviteToGame: "EMsg"                                       = 7005
    UDSHasSession: "EMsg"                                            = 7006
    UDSHasSessionResponse: "EMsg"                                    = 7007

    MPASBase: "EMsg"                                                 = 7100
    MPASVacBanReset: "EMsg"                                          = 7101

    KGSBase: "EMsg"                                                  = 7200

    UCMBase: "EMsg"                                                  = 7300
    ClientUCMAddScreenshot: "EMsg"                                   = 7301
    ClientUCMAddScreenshotResponse: "EMsg"                           = 7302
    UCMResetCommunityContent: "EMsg"                                 = 7307
    UCMResetCommunityContentResponse: "EMsg"                         = 7308
    ClientUCMDeleteScreenshot: "EMsg"                                = 7309
    ClientUCMDeleteScreenshotResponse: "EMsg"                        = 7310
    ClientUCMPublishFile: "EMsg"                                     = 7311
    ClientUCMPublishFileResponse: "EMsg"                             = 7312
    ClientUCMDeletePublishedFile: "EMsg"                             = 7315
    ClientUCMDeletePublishedFileResponse: "EMsg"                     = 7316
    ClientUCMEnumerateUserPublishedFiles: "EMsg"                     = 7317
    ClientUCMEnumerateUserPublishedFilesResponse: "EMsg"             = 7318
    ClientUCMEnumerateUserSubscribedFiles: "EMsg"                    = 7321
    ClientUCMEnumerateUserSubscribedFilesResponse: "EMsg"            = 7322
    ClientUCMUpdatePublishedFile: "EMsg"                             = 7325
    ClientUCMUpdatePublishedFileResponse: "EMsg"                     = 7326
    UCMUpdatePublishedFile: "EMsg"                                   = 7327
    UCMUpdatePublishedFileResponse: "EMsg"                           = 7328
    UCMDeletePublishedFile: "EMsg"                                   = 7329
    UCMDeletePublishedFileResponse: "EMsg"                           = 7330
    UCMUpdatePublishedFileStat: "EMsg"                               = 7331
    UCMUpdatePublishedFileBan: "EMsg"                                = 7332
    UCMUpdatePublishedFileBanResponse: "EMsg"                        = 7333
    UCMReloadPublishedFile: "EMsg"                                   = 7337
    UCMReloadUserFileListCaches: "EMsg"                              = 7338
    UCMPublishedFileReported: "EMsg"                                 = 7339
    UCMPublishedFilePreviewAdd: "EMsg"                               = 7341
    UCMPublishedFilePreviewAddResponse: "EMsg"                       = 7342
    UCMPublishedFilePreviewRemove: "EMsg"                            = 7343
    UCMPublishedFilePreviewRemoveResponse: "EMsg"                    = 7344
    ClientUCMPublishedFileSubscribed: "EMsg"                         = 7347
    ClientUCMPublishedFileUnsubscribed: "EMsg"                       = 7348
    UCMPublishedFileSubscribed: "EMsg"                               = 7349
    UCMPublishedFileUnsubscribed: "EMsg"                             = 7350
    UCMPublishFile: "EMsg"                                           = 7351
    UCMPublishFileResponse: "EMsg"                                   = 7352
    UCMPublishedFileChildAdd: "EMsg"                                 = 7353
    UCMPublishedFileChildAddResponse: "EMsg"                         = 7354
    UCMPublishedFileChildRemove: "EMsg"                              = 7355
    UCMPublishedFileChildRemoveResponse: "EMsg"                      = 7356
    UCMPublishedFileParentChanged: "EMsg"                            = 7359
    ClientUCMGetPublishedFilesForUser: "EMsg"                        = 7360
    ClientUCMGetPublishedFilesForUserResponse: "EMsg"                = 7361
    ClientUCMSetUserPublishedFileAction: "EMsg"                      = 7364
    ClientUCMSetUserPublishedFileActionResponse: "EMsg"              = 7365
    ClientUCMEnumeratePublishedFilesByUserAction: "EMsg"             = 7366
    ClientUCMEnumeratePublishedFilesByUserActionResponse: "EMsg"     = 7367
    ClientUCMPublishedFileDeleted: "EMsg"                            = 7368
    UCMGetUserSubscribedFiles: "EMsg"                                = 7369
    UCMGetUserSubscribedFilesResponse: "EMsg"                        = 7370
    UCMFixStatsPublishedFile: "EMsg"                                 = 7371
    ClientUCMEnumerateUserSubscribedFilesWithUpdates: "EMsg"         = 7378
    ClientUCMEnumerateUserSubscribedFilesWithUpdatesResponse: "EMsg" = 7379
    UCMPublishedFileContentUpdated: "EMsg"                           = 7380
    ClientUCMPublishedFileUpdated: "EMsg"                            = 7381
    ClientWorkshopItemChangesRequest: "EMsg"                         = 7382
    ClientWorkshopItemChangesResponse: "EMsg"                        = 7383
    ClientWorkshopItemInfoRequest: "EMsg"                            = 7384
    ClientWorkshopItemInfoResponse: "EMsg"                           = 7385

    FSBase: "EMsg"                                                   = 7500
    ClientRichPresenceUpload: "EMsg"                                 = 7501
    ClientRichPresenceRequest: "EMsg"                                = 7502
    ClientRichPresenceInfo: "EMsg"                                   = 7503
    FSRichPresenceRequest: "EMsg"                                    = 7504
    FSRichPresenceResponse: "EMsg"                                   = 7505
    FSComputeFrenematrix: "EMsg"                                     = 7506
    FSComputeFrenematrixResponse: "EMsg"                             = 7507
    FSPlayStatusNotification: "EMsg"                                 = 7508
    FSAddOrRemoveFollower: "EMsg"                                    = 7510
    FSAddOrRemoveFollowerResponse: "EMsg"                            = 7511
    FSUpdateFollowingList: "EMsg"                                    = 7512
    FSCommentNotification: "EMsg"                                    = 7513
    FSCommentNotificationViewed: "EMsg"                              = 7514
    ClientFSGetFollowerCount: "EMsg"                                 = 7515
    ClientFSGetFollowerCountResponse: "EMsg"                         = 7516
    ClientFSGetIsFollowing: "EMsg"                                   = 7517
    ClientFSGetIsFollowingResponse: "EMsg"                           = 7518
    ClientFSEnumerateFollowingList: "EMsg"                           = 7519
    ClientFSEnumerateFollowingListResponse: "EMsg"                   = 7520
    FSGetPendingNotificationCount: "EMsg"                            = 7521
    FSGetPendingNotificationCountResponse: "EMsg"                    = 7522
    ClientChatOfflineMessageNotification: "EMsg"                     = 7523
    ClientChatRequestOfflineMessageCount: "EMsg"                     = 7524
    ClientChatGetFriendMessageHistory: "EMsg"                        = 7525
    ClientChatGetFriendMessageHistoryResponse: "EMsg"                = 7526
    ClientChatGetFriendMessageHistoryForOfflineMessages: "EMsg"      = 7527
    ClientFSGetFriendsSteamLevels: "EMsg"                            = 7528
    ClientFSGetFriendsSteamLevelsResponse: "EMsg"                    = 7529
    AMRequestFriendData: "EMsg"                                      = 7530

    CEGVersionSetEnableDisableRequest: "EMsg"                        = 7600
    DRMRange2: "EMsg"                                                = 7600
    CEGVersionSetEnableDisableResponse: "EMsg"                       = 7601
    CEGPropStatusDRMSRequest: "EMsg"                                 = 7602
    CEGPropStatusDRMSResponse: "EMsg"                                = 7603
    CEGWhackFailureReportRequest: "EMsg"                             = 7604
    CEGWhackFailureReportResponse: "EMsg"                            = 7605
    DRMSFetchVersionSet: "EMsg"                                      = 7606
    DRMSFetchVersionSetResponse: "EMsg"                              = 7607

    EconBase: "EMsg"                                                 = 7700
    EconTrading_InitiateTradeRequest: "EMsg"                         = 7701
    EconTrading_InitiateTradeProposed: "EMsg"                        = 7702
    EconTrading_InitiateTradeResponse: "EMsg"                        = 7703
    EconTrading_InitiateTradeResult: "EMsg"                          = 7704
    EconTrading_StartSession: "EMsg"                                 = 7705
    EconTrading_CancelTradeRequest: "EMsg"                           = 7706
    EconFlushInventoryCache: "EMsg"                                  = 7707
    EconFlushInventoryCacheResponse: "EMsg"                          = 7708
    EconCDKeyProcessTransaction: "EMsg"                              = 7711
    EconCDKeyProcessTransactionResponse: "EMsg"                      = 7712
    EconGetErrorLogs: "EMsg"                                         = 7713
    EconGetErrorLogsResponse: "EMsg"                                 = 7714

    RMRange: "EMsg"                                                  = 7800
    RMTestVerisignOTP: "EMsg"                                        = 7800
    RMTestVerisignOTPResponse: "EMsg"                                = 7801
    RMDeleteMemcachedKeys: "EMsg"                                    = 7803
    RMRemoteInvoke: "EMsg"                                           = 7804
    BadLoginIPList: "EMsg"                                           = 7805
    RMMsgTraceAddTrigger: "EMsg"                                     = 7806
    RMMsgTraceRemoveTrigger: "EMsg"                                  = 7807
    RMMsgTraceEvent: "EMsg"                                          = 7808

    UGSUpdateGlobalStats: "EMsg"                                     = 7900
    UGSBase: "EMsg"                                                  = 7900
    ClientUGSGetGlobalStats: "EMsg"                                  = 7901
    ClientUGSGetGlobalStatsResponse: "EMsg"                          = 7902

    StoreBase: "EMsg"                                                = 8000

    UMQLogonRequest: "EMsg"                                          = 8100
    UMQBase: "EMsg"                                                  = 8100
    UMQLogonResponse: "EMsg"                                         = 8101
    UMQLogoffRequest: "EMsg"                                         = 8102
    UMQLogoffResponse: "EMsg"                                        = 8103
    UMQSendChatMessage: "EMsg"                                       = 8104
    UMQIncomingChatMessage: "EMsg"                                   = 8105
    UMQPoll: "EMsg"                                                  = 8106
    UMQPollResults: "EMsg"                                           = 8107
    UMQ2AM_ClientMsgBatch: "EMsg"                                    = 8108

    WorkshopBase: "EMsg"                                             = 8200

    WebAPIValidateOAuth2Token: "EMsg"                                = 8300
    WebAPIBase: "EMsg"                                               = 8300
    WebAPIValidateOAuth2TokenResponse: "EMsg"                        = 8301
    WebAPIRegisterGCInterfaces: "EMsg"                               = 8303
    WebAPIInvalidateOAuthClientCache: "EMsg"                         = 8304
    WebAPIInvalidateOAuthTokenCache: "EMsg"                          = 8305
    WebAPISetSecrets: "EMsg"                                         = 8306

    BackpackBase: "EMsg"                                             = 8400
    BackpackAddToCurrency: "EMsg"                                    = 8401
    BackpackAddToCurrencyResponse: "EMsg"                            = 8402

    CREBase: "EMsg"                                                  = 8500
    CREItemVoteSummary: "EMsg"                                       = 8503
    CREItemVoteSummaryResponse: "EMsg"                               = 8504
    CREUpdateUserPublishedItemVote: "EMsg"                           = 8507
    CREUpdateUserPublishedItemVoteResponse: "EMsg"                   = 8508
    CREGetUserPublishedItemVoteDetails: "EMsg"                       = 8509
    CREGetUserPublishedItemVoteDetailsResponse: "EMsg"               = 8510
    CREEnumeratePublishedFiles: "EMsg"                               = 8511
    CREEnumeratePublishedFilesResponse: "EMsg"                       = 8512
    CREPublishedFileVoteAdded: "EMsg"                                = 8513

    SecretsRequestCredentialPair: "EMsg"                             = 8600
    SecretsBase: "EMsg"                                              = 8600
    SecretsCredentialPairResponse: "EMsg"                            = 8601

    BoxMonitorReportRequest: "EMsg"                                  = 8700
    BoxMonitorBase: "EMsg"                                           = 8700
    BoxMonitorReportResponse: "EMsg"                                 = 8701

    LogsinkWriteReport: "EMsg"                                       = 8800
    LogsinkBase: "EMsg"                                              = 8800

    PICSBase: "EMsg"                                                 = 8900
    ClientPICSChangesSinceRequest: "EMsg"                            = 8901
    ClientPICSChangesSinceResponse: "EMsg"                           = 8902
    ClientPICSProductInfoRequest: "EMsg"                             = 8903
    ClientPICSProductInfoResponse: "EMsg"                            = 8904
    ClientPICSAccessTokenRequest: "EMsg"                             = 8905
    ClientPICSAccessTokenResponse: "EMsg"                            = 8906

    WorkerProcess: "EMsg"                                            = 9000
    WorkerProcessPingRequest: "EMsg"                                 = 9000
    WorkerProcessPingResponse: "EMsg"                                = 9001
    WorkerProcessShutdown: "EMsg"                                    = 9002

    DRMWorkerProcess: "EMsg"                                         = 9100
    DRMWorkerProcessDRMAndSign: "EMsg"                               = 9100
    DRMWorkerProcessDRMAndSignResponse: "EMsg"                       = 9101
    DRMWorkerProcessSteamworksInfoRequest: "EMsg"                    = 9102
    DRMWorkerProcessSteamworksInfoResponse: "EMsg"                   = 9103
    DRMWorkerProcessInstallDRMDLLRequest: "EMsg"                     = 9104
    DRMWorkerProcessInstallDRMDLLResponse: "EMsg"                    = 9105
    DRMWorkerProcessSecretIdStringRequest: "EMsg"                    = 9106
    DRMWorkerProcessSecretIdStringResponse: "EMsg"                   = 9107
    DRMWorkerProcessInstallProcessedFilesRequest: "EMsg"             = 9110
    DRMWorkerProcessInstallProcessedFilesResponse: "EMsg"            = 9111
    DRMWorkerProcessExamineBlobRequest: "EMsg"                       = 9112
    DRMWorkerProcessExamineBlobResponse: "EMsg"                      = 9113
    DRMWorkerProcessDescribeSecretRequest: "EMsg"                    = 9114
    DRMWorkerProcessDescribeSecretResponse: "EMsg"                   = 9115
    DRMWorkerProcessBackfillOriginalRequest: "EMsg"                  = 9116
    DRMWorkerProcessBackfillOriginalResponse: "EMsg"                 = 9117
    DRMWorkerProcessValidateDRMDLLRequest: "EMsg"                    = 9118
    DRMWorkerProcessValidateDRMDLLResponse: "EMsg"                   = 9119
    DRMWorkerProcessValidateFileRequest: "EMsg"                      = 9120
    DRMWorkerProcessValidateFileResponse: "EMsg"                     = 9121
    DRMWorkerProcessSplitAndInstallRequest: "EMsg"                   = 9122
    DRMWorkerProcessSplitAndInstallResponse: "EMsg"                  = 9123
    DRMWorkerProcessGetBlobRequest: "EMsg"                           = 9124
    DRMWorkerProcessGetBlobResponse: "EMsg"                          = 9125
    DRMWorkerProcessEvaluateCrashRequest: "EMsg"                     = 9126
    DRMWorkerProcessEvaluateCrashResponse: "EMsg"                    = 9127
    DRMWorkerProcessAnalyzeFileRequest: "EMsg"                       = 9128
    DRMWorkerProcessAnalyzeFileResponse: "EMsg"                      = 9129
    DRMWorkerProcessUnpackBlobRequest: "EMsg"                        = 9130
    DRMWorkerProcessUnpackBlobResponse: "EMsg"                       = 9131
    DRMWorkerProcessInstallAllRequest: "EMsg"                        = 9132
    DRMWorkerProcessInstallAllResponse: "EMsg"                       = 9133

    TestWorkerProcess: "EMsg"                                        = 9200
    TestWorkerProcessLoadUnloadModuleRequest: "EMsg"                 = 9200
    TestWorkerProcessLoadUnloadModuleResponse: "EMsg"                = 9201
    TestWorkerProcessServiceModuleCallRequest: "EMsg"                = 9202
    TestWorkerProcessServiceModuleCallResponse: "EMsg"               = 9203

    QuestServerBase: "EMsg"                                          = 9300

    ClientGetEmoticonList: "EMsg"                                    = 9330
    ClientEmoticonList: "EMsg"                                       = 9331

    SLCUserSessionStatus: "EMsg"                                     = 9400
    SLCBase: "EMsg"                                                  = 9400
    SLCRequestUserSessionStatus: "EMsg"                              = 9401
    SLCSharedLicensesLockStatus: "EMsg"                              = 9402
    ClientSharedLibraryLockStatus: "EMsg"                            = 9405
    ClientSharedLibraryStopPlaying: "EMsg"                           = 9406
    SLCOwnerLibraryChanged: "EMsg"                                   = 9407
    SLCSharedLibraryChanged: "EMsg"                                  = 9408

    RemoteClientAuth_OBSOLETE: "EMsg"                                = 9500
    RemoteClientBase: "EMsg"                                         = 9500
    RemoteClientAuthResponse_OBSOLETE: "EMsg"                        = 9501
    RemoteClientAppStatus: "EMsg"                                    = 9502
    RemoteClientStartStream: "EMsg"                                  = 9503
    RemoteClientStartStreamResponse: "EMsg"                          = 9504
    RemoteClientPing: "EMsg"                                         = 9505
    RemoteClientPingResponse: "EMsg"                                 = 9506
    ClientUnlockStreaming: "EMsg"                                    = 9507
    ClientUnlockStreamingResponse: "EMsg"                            = 9508
    RemoteClientAcceptEULA: "EMsg"                                   = 9509
    RemoteClientGetControllerConfig: "EMsg"                          = 9510
    RemoteClientGetControllerConfigResponse: "EMsg"                  = 9511
    RemoteClientStreamingEnabled: "EMsg"                             = 9512
    ClientUnlockHEVC: "EMsg"                                         = 9513
    ClientUnlockHEVCResponse: "EMsg"                                 = 9514
    RemoteClientStatusRequest: "EMsg"                                = 9515
    RemoteClientStatusResponse: "EMsg"                               = 9516

    ClientPlayingSessionState: "EMsg"                                = 9600
    ClientConcurrentSessionsBase: "EMsg"                             = 9600
    ClientKickPlayingSession: "EMsg"                                 = 9601

    ClientBroadcastBase: "EMsg"                                      = 9700
    ClientBroadcastFrames: "EMsg"                                    = 9701
    ClientBroadcastDisconnect: "EMsg"                                = 9702
    ClientBroadcastScreenshot: "EMsg"                                = 9703
    ClientBroadcastUploadConfig: "EMsg"                              = 9704

    BaseClient3: "EMsg"                                              = 9800
    ClientVoiceCallPreAuthorizeResponse: "EMsg"                      = 9801
    ClientServerTimestampRequest: "EMsg"                             = 9802
    ClientServerTimestampResponse: "EMsg"                            = 9803

    ClientLANP2PRequestChunk: "EMsg"                                 = 9900
    ClientLANP2PBase: "EMsg"                                         = 9900
    ClientLANP2PRequestChunkResponse: "EMsg"                         = 9901
    ClientLANP2PMax: "EMsg"                                          = 9999

    NotifyWatchdog: "EMsg"                                           = 10000

    ClientSiteLicenseSiteInfoNotification: "EMsg"                    = 10100
    ClientSiteLicenseBase: "EMsg"                                    = 10100
    ClientSiteLicenseCheckout: "EMsg"                                = 10101
    ClientSiteLicenseCheckoutResponse: "EMsg"                        = 10102
    ClientSiteLicenseGetAvailableSeats: "EMsg"                       = 10103
    ClientSiteLicenseGetAvailableSeatsResponse: "EMsg"               = 10104
    ClientSiteLicenseGetContentCacheInfo: "EMsg"                     = 10105
    ClientSiteLicenseGetContentCacheInfoResponse: "EMsg"             = 10106

    ChatServerGetPendingNotificationCount: "EMsg"                    = 12000
    BaseChatServer: "EMsg"                                           = 12000
    ChatServerGetPendingNotificationCountResponse: "EMsg"            = 12001

    ServerSecretChanged: "EMsg"                                      = 12100
    BaseSecretServer: "EMsg"                                         = 12100
