"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EsbuildSource = exports.Esbuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const dynamic_package_1 = require("./dynamic-package");
const dynamicEsbuild = new dynamic_package_1.DynamicPackage('esbuild@^0.15.0');
exports.Esbuild = {
    name: dynamicEsbuild.name,
    version: dynamicEsbuild.version,
    spec: dynamicEsbuild.spec,
};
class EsbuildSource {
    /**
     * Set the default mechanism to find the module
     */
    static set default(path) {
        this._default = path;
    }
    /**
     * The current default to find the module
     */
    static get default() {
        return this._default ?? this.platformDefault;
    }
    /**
     * `EsbuildSource.nodeJs` for NodeJs, `EsbuildSource.auto` for all other languages
     */
    static get platformDefault() {
        if (Boolean(process.env.JSII_AGENT)) {
            return this.auto;
        }
        return this.nodeJs;
    }
    /**
     * Try to find the module in most common paths.
     */
    static get anywhere() {
        return this.dynamicPackage.findInPaths();
    }
    /**
     * Try to find the module in common global installation paths.
     */
    static get globalPaths() {
        return this.dynamicPackage.findInGlobalPaths();
    }
    /**
     * Require module by name, do not attempt to find it anywhere else.
     */
    static get nodeJs() {
        return this.dynamicPackage.nodeJs();
    }
    /**
     * Install the module to a temporary location.
     */
    static get install() {
        return this.dynamicPackage.install();
    }
    /**
     * First try to find to module, then install it to a temporary location.
     */
    static get auto() {
        return this.dynamicPackage.auto();
    }
}
exports.EsbuildSource = EsbuildSource;
_a = JSII_RTTI_SYMBOL_1;
EsbuildSource[_a] = { fqn: "@mrgrain/cdk-esbuild.EsbuildSource", version: "3.11.6" };
EsbuildSource.dynamicPackage = dynamicEsbuild;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXNidWlsZC1zb3VyY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvZXNidWlsZC1zb3VyY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSx1REFBbUQ7QUFFbkQsTUFBTSxjQUFjLEdBQUcsSUFBSSxnQ0FBYyxDQUFDLGlCQUFpQixDQUFDLENBQUM7QUFFaEQsUUFBQSxPQUFPLEdBQUc7SUFDckIsSUFBSSxFQUFFLGNBQWMsQ0FBQyxJQUFJO0lBQ3pCLE9BQU8sRUFBRSxjQUFjLENBQUMsT0FBTztJQUMvQixJQUFJLEVBQUUsY0FBYyxDQUFDLElBQUk7Q0FDMUIsQ0FBQztBQUVGLE1BQWEsYUFBYTtJQUl4Qjs7T0FFRztJQUNJLE1BQU0sS0FBSyxPQUFPLENBQUMsSUFBd0I7UUFDaEQsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7SUFDdkIsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxLQUFLLE9BQU87UUFDdkIsT0FBTyxJQUFJLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDL0MsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxLQUFLLGVBQWU7UUFDL0IsSUFBSSxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsRUFBRTtZQUNuQyxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUM7U0FDbEI7UUFFRCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxLQUFLLFFBQVE7UUFDeEIsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQzNDLENBQUM7SUFFRDs7T0FFRztJQUNJLE1BQU0sS0FBSyxXQUFXO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQ2pELENBQUM7SUFFRDs7T0FFRztJQUNJLE1BQU0sS0FBSyxNQUFNO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLEVBQUUsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7O09BRUc7SUFDSSxNQUFNLEtBQUssT0FBTztRQUN2QixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxFQUFFLENBQUM7SUFDdkMsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxLQUFLLElBQUk7UUFDcEIsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ3BDLENBQUM7O0FBOURILHNDQStEQzs7O0FBOURnQiw0QkFBYyxHQUFHLGNBQWMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IER5bmFtaWNQYWNrYWdlIH0gZnJvbSAnLi9keW5hbWljLXBhY2thZ2UnO1xuXG5jb25zdCBkeW5hbWljRXNidWlsZCA9IG5ldyBEeW5hbWljUGFja2FnZSgnZXNidWlsZEBeMC4xNS4wJyk7XG5cbmV4cG9ydCBjb25zdCBFc2J1aWxkID0ge1xuICBuYW1lOiBkeW5hbWljRXNidWlsZC5uYW1lLFxuICB2ZXJzaW9uOiBkeW5hbWljRXNidWlsZC52ZXJzaW9uLFxuICBzcGVjOiBkeW5hbWljRXNidWlsZC5zcGVjLFxufTtcblxuZXhwb3J0IGNsYXNzIEVzYnVpbGRTb3VyY2Uge1xuICBwcml2YXRlIHN0YXRpYyBkeW5hbWljUGFja2FnZSA9IGR5bmFtaWNFc2J1aWxkO1xuICBwcml2YXRlIHN0YXRpYyBfZGVmYXVsdD86IHN0cmluZztcblxuICAvKipcbiAgICogU2V0IHRoZSBkZWZhdWx0IG1lY2hhbmlzbSB0byBmaW5kIHRoZSBtb2R1bGVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgc2V0IGRlZmF1bHQocGF0aDogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZGVmYXVsdCA9IHBhdGg7XG4gIH1cblxuICAvKipcbiAgICogVGhlIGN1cnJlbnQgZGVmYXVsdCB0byBmaW5kIHRoZSBtb2R1bGVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IGRlZmF1bHQoKTogc3RyaW5nIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gdGhpcy5fZGVmYXVsdCA/PyB0aGlzLnBsYXRmb3JtRGVmYXVsdDtcbiAgfVxuXG4gIC8qKlxuICAgKiBgRXNidWlsZFNvdXJjZS5ub2RlSnNgIGZvciBOb2RlSnMsIGBFc2J1aWxkU291cmNlLmF1dG9gIGZvciBhbGwgb3RoZXIgbGFuZ3VhZ2VzXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGdldCBwbGF0Zm9ybURlZmF1bHQoKSB7XG4gICAgaWYgKEJvb2xlYW4ocHJvY2Vzcy5lbnYuSlNJSV9BR0VOVCkpIHtcbiAgICAgIHJldHVybiB0aGlzLmF1dG87XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMubm9kZUpzO1xuICB9XG5cbiAgLyoqXG4gICAqIFRyeSB0byBmaW5kIHRoZSBtb2R1bGUgaW4gbW9zdCBjb21tb24gcGF0aHMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGdldCBhbnl3aGVyZSgpIHtcbiAgICByZXR1cm4gdGhpcy5keW5hbWljUGFja2FnZS5maW5kSW5QYXRocygpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRyeSB0byBmaW5kIHRoZSBtb2R1bGUgaW4gY29tbW9uIGdsb2JhbCBpbnN0YWxsYXRpb24gcGF0aHMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGdldCBnbG9iYWxQYXRocygpIHtcbiAgICByZXR1cm4gdGhpcy5keW5hbWljUGFja2FnZS5maW5kSW5HbG9iYWxQYXRocygpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlcXVpcmUgbW9kdWxlIGJ5IG5hbWUsIGRvIG5vdCBhdHRlbXB0IHRvIGZpbmQgaXQgYW55d2hlcmUgZWxzZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IG5vZGVKcygpIHtcbiAgICByZXR1cm4gdGhpcy5keW5hbWljUGFja2FnZS5ub2RlSnMoKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBJbnN0YWxsIHRoZSBtb2R1bGUgdG8gYSB0ZW1wb3JhcnkgbG9jYXRpb24uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGdldCBpbnN0YWxsKCkge1xuICAgIHJldHVybiB0aGlzLmR5bmFtaWNQYWNrYWdlLmluc3RhbGwoKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBGaXJzdCB0cnkgdG8gZmluZCB0byBtb2R1bGUsIHRoZW4gaW5zdGFsbCBpdCB0byBhIHRlbXBvcmFyeSBsb2NhdGlvbi5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IGF1dG8oKSB7XG4gICAgcmV0dXJuIHRoaXMuZHluYW1pY1BhY2thZ2UuYXV0bygpO1xuICB9XG59XG4iXX0=