"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InlineTsxCode = exports.InlineTypeScriptCode = exports.InlineJsxCode = exports.InlineJavaScriptCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const esbuild_provider_1 = require("./esbuild-provider");
const utils_1 = require("./utils");
class BaseInlineCode extends aws_lambda_1.InlineCode {
    constructor(code, props) {
        super(code);
        this.isInline = true;
        this.inlineCode = aws_cdk_lib_1.Lazy.string({
            produce: () => {
                try {
                    const transformFn = props.transformFn ?? esbuild_provider_1.EsbuildProvider.require(props.esbuildModulePath).transformSync;
                    const transformSync = esbuild_provider_1.EsbuildProvider.withEsbuildBinaryPath(transformFn, props.esbuildBinaryPath);
                    const transformedCode = transformSync(code, {
                        color: process.env.NO_COLOR ? Boolean(process.env.NO_COLOR) : undefined,
                        logLevel: 'warning',
                        ...(props.transformOptions || {}),
                    });
                    return transformedCode.code;
                }
                catch (error) {
                    if (utils_1.isEsbuildError(error)) {
                        throw new Error(`Esbuild failed to transform ${this.constructor.name}`);
                    }
                    throw error;
                }
            },
        });
    }
    bind(scope) {
        const name = scope.node.path + constructs_1.Node.PATH_SEP + this.constructor.name;
        process.stderr.write(`Transforming inline code ${name}...\n`);
        return {
            inlineCode: aws_cdk_lib_1.Stack.of(scope).resolve(this.inlineCode),
        };
    }
}
function instanceOfTransformerProps(object) {
    return [
        'transformOptions',
        'transformFn',
        'esbuildBinaryPath',
        'esbuildModulePath',
    ].reduce((isTransformerProps, propToCheck) => (isTransformerProps || (propToCheck in object)), false);
}
function transformerProps(loader, props) {
    if (!props) {
        return { transformOptions: { loader } };
    }
    if (!instanceOfTransformerProps(props)) {
        return { transformOptions: { loader, ...props } };
    }
    return {
        ...props,
        transformOptions: {
            loader,
            ...props.transformOptions,
        },
    };
}
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability experimental
 */
class InlineJavaScriptCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability experimental
     */
    code, 
    /**
     * Support for `TransformOptions` is deprecated. Please provide `TransformerProps`!
     *
     * Props to change the behaviour of the transformer.
     *
     * Default values for `props.transformOptions`:
     * - `loader='js'`
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability experimental
     */
    props) {
        super(code, transformerProps('js', props));
    }
}
exports.InlineJavaScriptCode = InlineJavaScriptCode;
_a = JSII_RTTI_SYMBOL_1;
InlineJavaScriptCode[_a] = { fqn: "@mrgrain/cdk-esbuild.InlineJavaScriptCode", version: "3.11.6" };
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability experimental
 */
class InlineJsxCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability experimental
     */
    code, 
    /**
     * Support for `TransformOptions` is deprecated. Please provide `TransformerProps`!
     *
     * Props to change the behaviour of the transformer.
     *
     * Default values for `transformOptions`:
     * - `loader='jsx'`
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability experimental
     */
    props) {
        super(code, transformerProps('jsx', props));
    }
}
exports.InlineJsxCode = InlineJsxCode;
_b = JSII_RTTI_SYMBOL_1;
InlineJsxCode[_b] = { fqn: "@mrgrain/cdk-esbuild.InlineJsxCode", version: "3.11.6" };
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability experimental
 */
class InlineTypeScriptCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability experimental
     */
    code, 
    /**
     * Support for `TransformOptions` is deprecated. Please provide `TransformerProps`!
     *
     * Props to change the behaviour of the transformer.
     *
     * Default values for `transformOptions`:
     * - `loader='ts'`
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability experimental
     */
    props) {
        super(code, transformerProps('ts', props));
    }
}
exports.InlineTypeScriptCode = InlineTypeScriptCode;
_c = JSII_RTTI_SYMBOL_1;
InlineTypeScriptCode[_c] = { fqn: "@mrgrain/cdk-esbuild.InlineTypeScriptCode", version: "3.11.6" };
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability experimental
 */
class InlineTsxCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability experimental
     */
    code, 
    /**
     * Support for `TransformOptions` is deprecated. Please provide `TransformerProps`!
     *
     * Props to change the behaviour of the transformer.
     *
     * Default values for `transformOptions`:
     * - `loader='tsx'`
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability experimental
     */
    props) {
        super(code, transformerProps('tsx', props));
    }
}
exports.InlineTsxCode = InlineTsxCode;
_d = JSII_RTTI_SYMBOL_1;
InlineTsxCode[_d] = { fqn: "@mrgrain/cdk-esbuild.InlineTsxCode", version: "3.11.6" };
//# sourceMappingURL=data:application/json;base64,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