## How to contribute

Thank you for considering contributing to trafilatura!

Here are some important resources:

  * [List of currently open issues](https://github.com/adbar/trafilatura/issues) (no pretention to exhaustivity!)
  * [How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)

There are many ways to contribute, you could:

  * Improve the documentation
  * Find bugs and submit bug reports
  * Submit feature requests
  * Write tutorials or blog posts
  * Write code


## Submitting changes

Please send a [GitHub Pull Request to trafilatura](https://github.com/adbar/trafilatura/pull/new/master) with a clear list of what you've done (read more about [pull requests](http://help.github.com/pull-requests/)).

**Working on your first Pull Request?** See this tutorial: [How To Create a Pull Request on GitHub](https://www.digitalocean.com/community/tutorials/how-to-create-a-pull-request-on-github)



## Testing and evaluating the code

Here is how you can run the tests if you wish to correct the errors and further improve the code:

- Run `pytest` from trafilatura's directory, or select a particular test suite, for example `realworld_tests.py`, and run `pytest realworld_tests.py` or simply `python3 realworld_tests.py`
- Check how it performs on the benchmark in `tests/eval/` by running `tests/comparison.py`

See also the [tests Readme](tests/README.rst) for more information on the evaluation.



For further questions you can contact me by way of [GitHub issues](https://github.com/adbar/trafilatura/issues), [Twitter](https://twitter.com/adbarbaresi) or [E-Mail](https://adrien.barbaresi.eu/).

Thanks,

Adrien
