# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#

import os
import sys
sys.path.insert(0, os.path.abspath('.'))

import trafilatura


# -- Project information -----------------------------------------------------

project = 'trafilatura'
copyright = '2022, Adrien Barbaresi'
html_show_sphinx = False
author = 'Adrien Barbaresi'
version = trafilatura.__version__


# -- General configuration ---------------------------------------------------

# The master toctree document.
master_doc = 'index'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.

# The short X.Y version.
version = trafilatura.__version__
# The full version, including alpha/beta/rc tags.
release = trafilatura.__version__

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = 'en'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'sphinx.ext.napoleon',
    'sphinx.ext.viewcode'
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
add_module_names = True


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'pydata_sphinx_theme' # 'furo' # 'alabaster'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ['_static']

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.

## pydata options
html_theme_options = {
  "github_url": "https://github.com/adbar/trafilatura",
  "twitter_url": "https://twitter.com/adbarbaresi",
  "external_links": [
      {"name": "Blog", "url": "https://adrien.barbaresi.eu/blog/tag/trafilatura.html"},
  ],
  "google_analytics_id": "G-K3R5QCVDF1",
#  "use_edit_page_button": True,
#  "navigation_depth": 3,
#  "show_toc_level": 3,
}

html_logo = "trafilatura-logo.png"


html_context = {
    # "github_url": "https://github.com", # or your GitHub Enterprise interprise
    "github_user": "adbar",
    "github_repo": "trafilatura",
    "github_version": "master",
    "doc_path": "docs",
}


## furo options
#html_theme_options = {
#    "announcement": "<em>Important</em> announcement!",
#}

## alabaster theme
#html_theme_options = {
#    "description": "Web scraping tool for text discovery and retrieval",
#    "show_powered_by": False,
#    "github_button": False,
#    "github_user": "adbar",
#    "github_repo": "trafilatura",
#    "github_count": True,
#    "github_banner": False,
#    "show_related": False,
#    "sidebar_collapse": True,
#    "extra_nav_links": {'test': 'https://example.org'},
#    "note_bg": "#FFF59C",
#}

intersphinx_mapping = {
    "python": ("https://docs.python.org/3/", None),
}
