# Contributing

We are open and very happy to receive contributions to make *biome.text* more useful for you and others.

If you want to start contributing to *biome.text* there are three things you need to do.
There are basically three ways you can contribute to *biome.text*:

1. report a bug
2. make a feature request
3. submit a pull request

## Report a bug

To report a bug in the library or point our an error in the documentation please open an [issue on GitHub](https://github.com/recognai/biome-text/issues/new/choose).

## Make a feature request

If you are missing some feature in the library, please let us know in a [GitHub issue](https://github.com/recognai/biome-text/issues/new/choose).
It is always helpful if you describe a concrete use case for the feature.

## Submit a pull request

You can contribute to the code base via [Pull Requests (PRs)](https://docs.github.com/en/free-pro-team@latest/github/collaborating-with-issues-and-pull-requests/about-pull-requests).
Here is a quick guide on how to [set up your system](./3-developer_guides.md#setting-up-for-development) for *biome.text* development.

A PR should always reference an issue.
So before starting to work on some bugfix or new feature, make sure to open a corresponding GitHub issue.
If a corresponding issue already exists, please leave a quick comment that you are working on it.

**For example**: you find an error in the documentation and open a new issue, #13, describing the error.
You want to fix the error and create a new branch in your forked repo with a meaningful name, such as `documentation/#13`.
You work on this branch, make the necessary changes, test them, push them and create a PR against our repo.
This PR should include the text "Closes #13" at the end of its description.
