class MuxError(Exception):
    """ Mutex error """


class MuxConnectError(MuxError, ConnectionError):
    """ Error when MessageType: Connect """


class WDAError(Exception):
    """ base wda error """


class WDABadGateway(WDAError):
    """ bad gateway """

    
class WDARequestError(WDAError):
    def __init__(self, status, value):
        self.status = status
        self.value = value

    def __str__(self):
        return 'WDARequestError(status=%d, value=%s)' % (self.status,
                                                         self.value)


class WDAEmptyResponseError(WDAError):
    """ response body is empty """


class WDAElementNotFoundError(WDAError):
    """ element not found """


class WDAElementNotDisappearError(WDAError):
    """ element not disappera """
