# Tutorials

**If you're just starting, please check out [the tutorial on our website](https://allennlp.org/tutorials). We've designed it to be the simplest and quickest way to get your toes wet with AllenNLP.**

Our 2018 EMNLP tutorial is available at https://github.com/allenai/writing-code-for-nlp-research-emnlp2018.

## Internal Tutorials

The tutorials available here on the repo relate to the version of AllenNLP at the git commit SHA you are currently looking at (likely the HEAD commit of the master branch).  If you want to see the tutorials that relate to the latest pip release, please see https://github.com/allenai/allennlp/tree/v0.8.3/tutorials.

### Getting Started

* [Installation](../README.md#installation)
* [Laziness in AllenNLP](getting_started/laziness.md)

#### A Walk Through AllenNLP

* [Part 1 - Training and Evaluating Models](getting_started/walk_through_allennlp/training_and_evaluating.md)
* [Part 2 - Configuring Experiments](getting_started/walk_through_allennlp/configuration.md)
* [Part 3 - Creating a Model](getting_started/walk_through_allennlp/creating_a_model.md)

#### A Complete Example: Predicting Paper Venues

* [Part 1 - Datasets and Models](getting_started/predicting_paper_venues/predicting_paper_venues_pt1.md)
* [Part 2 - Predictions and Demos](getting_started/predicting_paper_venues/predicting_paper_venues_pt2.md)

### How-to

* [Create your own Configuration File](how_to/create_a_configuration.md)
* [How to train a model with lazy data](how_to/laziness.md)
* [How to train and use a Transformer-based ELMo](how_to/training_transformer_elmo.md)
* [How to Debug Your AllenNLP Code](how_to/using_a_debugger.md)
* [How to visualize model internals (BETA)](how_to/visualizing_model_internals.md)
* [Using pre-trained ELMo representations](how_to/elmo.md)
* [Using span representations](how_to/span_representations.md)

## External Tutorials

* The [blog posts by Masato Hagiwara](http://www.realworldnlpbook.com/blog/) as he writes his NLP book
* [An in-depth tutorial by Keita Kurita](https://mlexplained.com/2019/01/30/an-in-depth-tutorial-to-allennlp-from-basics-to-elmo-and-bert/)
* [Ethan Chau's extended Getting Started guide](https://gitlab.cs.washington.edu/echau18/tech-writing-mirror/blob/master/the-annotated-config/the-annotated-config.md)
* The [blog posts by Joe Barrow](https://jbarrow.ai/)
