# coding: utf-8

"""
    Data Repository API

    This document defines the REST API for Data Repository. **Status: design in progress** There are four top-level endpoints (besides some used by swagger):  * /swagger-ui.html - generated by swagger: swagger API page that provides this documentation and a live UI for      submitting REST requests  * /status - provides the operational status of the service  * /api    - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The overall API (/api) currently supports two interfaces:  * Repository - a general and default interface for initial setup, managing ingest and repository metadata  * Resource - an interface for managing billing accounts and resources  The API endpoints are organized by interface. Each interface is separately versioned. ## Notes on Naming All of the reference items are suffixed with \"Model\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. ## Editing and debugging I have found it best to edit this file directly to make changes and then use the swagger-editor to validate. The errors out of swagger-codegen are not that helpful. In the swagger-editor, it gives you nice errors and links to the place in the YAML where the errors are. But... the swagger-editor has been a bit of a pain for me to run. I tried the online website and was not able to load my YAML. Instead, I run it locally in a docker container, like this: ``` docker pull swaggerapi/swagger-editor docker run -p 9090:8080 swaggerapi/swagger-editor ``` Then navigate to localhost:9090 in your browser. I have not been able to get the file upload to work. It is a bit of a PITA, but I copy-paste the source code, replacing what is in the editor. Then make any fixes. Then copy-paste the resulting, valid file back into our source code. Not elegant, but easier than playing detective with the swagger-codegen errors. This might be something about my browser or environment, so give it a try yourself and see how it goes. ## Merging the DRS standard swagger into this swagger ## The merging is done in three sections:  1. Merging the security definitions into our security definitions  2. This section of paths. We make all paths explicit (prefixed with /ga4gh/drs/v1)     All standard DRS definitions and parameters are prefixed with 'DRS' to separate them     from our native definitions and parameters. We remove the x-swagger-router-controller lines.  3. A separate part of the definitions section for the DRS definitions  NOTE: the code here does not relect the DRS spec anymore. See DR-409.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class ConfigFaultModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'enabled': 'bool',
        'fault_type': 'str',
        'counted': 'ConfigFaultCountedModel'
    }

    attribute_map = {
        'enabled': 'enabled',
        'fault_type': 'faultType',
        'counted': 'counted'
    }

    def __init__(self, enabled=None, fault_type=None, counted=None, local_vars_configuration=None):  # noqa: E501
        """ConfigFaultModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._enabled = None
        self._fault_type = None
        self._counted = None
        self.discriminator = None

        if enabled is not None:
            self.enabled = enabled
        if fault_type is not None:
            self.fault_type = fault_type
        if counted is not None:
            self.counted = counted

    @property
    def enabled(self):
        """Gets the enabled of this ConfigFaultModel.  # noqa: E501

        If the fault is enabled, then is in effect. Fault points cause insert faults. Typical usage is that faults are disabled on system start and explicitly enabled by test code or via the setFault endpoint.   # noqa: E501

        :return: The enabled of this ConfigFaultModel.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this ConfigFaultModel.

        If the fault is enabled, then is in effect. Fault points cause insert faults. Typical usage is that faults are disabled on system start and explicitly enabled by test code or via the setFault endpoint.   # noqa: E501

        :param enabled: The enabled of this ConfigFaultModel.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def fault_type(self):
        """Gets the fault_type of this ConfigFaultModel.  # noqa: E501

        A simple fault has no parameters. It is just enabled or disabled. This type of fault is typically used when the desired behavior of the fault is too complex for expression in the fault types and custom code is needed to get the right failure behavior. A counted fault is used to insert some number of faults in a pattern. See the ConfigFaultCountedModel for details.   # noqa: E501

        :return: The fault_type of this ConfigFaultModel.  # noqa: E501
        :rtype: str
        """
        return self._fault_type

    @fault_type.setter
    def fault_type(self, fault_type):
        """Sets the fault_type of this ConfigFaultModel.

        A simple fault has no parameters. It is just enabled or disabled. This type of fault is typically used when the desired behavior of the fault is too complex for expression in the fault types and custom code is needed to get the right failure behavior. A counted fault is used to insert some number of faults in a pattern. See the ConfigFaultCountedModel for details.   # noqa: E501

        :param fault_type: The fault_type of this ConfigFaultModel.  # noqa: E501
        :type: str
        """
        allowed_values = ["simple", "counted"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and fault_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `fault_type` ({0}), must be one of {1}"  # noqa: E501
                .format(fault_type, allowed_values)
            )

        self._fault_type = fault_type

    @property
    def counted(self):
        """Gets the counted of this ConfigFaultModel.  # noqa: E501


        :return: The counted of this ConfigFaultModel.  # noqa: E501
        :rtype: ConfigFaultCountedModel
        """
        return self._counted

    @counted.setter
    def counted(self, counted):
        """Sets the counted of this ConfigFaultModel.


        :param counted: The counted of this ConfigFaultModel.  # noqa: E501
        :type: ConfigFaultCountedModel
        """

        self._counted = counted

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConfigFaultModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ConfigFaultModel):
            return True

        return self.to_dict() != other.to_dict()
