# coding: utf-8

"""
    Data Repository API

    This document defines the REST API for Data Repository. **Status: design in progress** There are four top-level endpoints (besides some used by swagger):  * /swagger-ui.html - generated by swagger: swagger API page that provides this documentation and a live UI for      submitting REST requests  * /status - provides the operational status of the service  * /api    - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The overall API (/api) currently supports two interfaces:  * Repository - a general and default interface for initial setup, managing ingest and repository metadata  * Resource - an interface for managing billing accounts and resources  The API endpoints are organized by interface. Each interface is separately versioned. ## Notes on Naming All of the reference items are suffixed with \"Model\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. ## Editing and debugging I have found it best to edit this file directly to make changes and then use the swagger-editor to validate. The errors out of swagger-codegen are not that helpful. In the swagger-editor, it gives you nice errors and links to the place in the YAML where the errors are. But... the swagger-editor has been a bit of a pain for me to run. I tried the online website and was not able to load my YAML. Instead, I run it locally in a docker container, like this: ``` docker pull swaggerapi/swagger-editor docker run -p 9090:8080 swaggerapi/swagger-editor ``` Then navigate to localhost:9090 in your browser. I have not been able to get the file upload to work. It is a bit of a PITA, but I copy-paste the source code, replacing what is in the editor. Then make any fixes. Then copy-paste the resulting, valid file back into our source code. Not elegant, but easier than playing detective with the swagger-codegen errors. This might be something about my browser or environment, so give it a try yourself and see how it goes. ## Merging the DRS standard swagger into this swagger ## The merging is done in three sections:  1. Merging the security definitions into our security definitions  2. This section of paths. We make all paths explicit (prefixed with /ga4gh/drs/v1)     All standard DRS definitions and parameters are prefixed with 'DRS' to separate them     from our native definitions and parameters. We remove the x-swagger-router-controller lines.  3. A separate part of the definitions section for the DRS definitions  NOTE: the code here does not relect the DRS spec anymore. See DR-409.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class IngestResponseModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'dataset_id': 'str',
        'dataset': 'str',
        'table': 'str',
        'path': 'str',
        'load_tag': 'str',
        'row_count': 'int',
        'bad_row_count': 'int',
        'load_result': 'BulkLoadArrayResultModel'
    }

    attribute_map = {
        'dataset_id': 'dataset_id',
        'dataset': 'dataset',
        'table': 'table',
        'path': 'path',
        'load_tag': 'load_tag',
        'row_count': 'row_count',
        'bad_row_count': 'bad_row_count',
        'load_result': 'load_result'
    }

    def __init__(self, dataset_id=None, dataset=None, table=None, path=None, load_tag=None, row_count=None, bad_row_count=None, load_result=None, local_vars_configuration=None):  # noqa: E501
        """IngestResponseModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._dataset_id = None
        self._dataset = None
        self._table = None
        self._path = None
        self._load_tag = None
        self._row_count = None
        self._bad_row_count = None
        self._load_result = None
        self.discriminator = None

        if dataset_id is not None:
            self.dataset_id = dataset_id
        if dataset is not None:
            self.dataset = dataset
        self.table = table
        self.path = path
        if load_tag is not None:
            self.load_tag = load_tag
        self.row_count = row_count
        if bad_row_count is not None:
            self.bad_row_count = bad_row_count
        if load_result is not None:
            self.load_result = load_result

    @property
    def dataset_id(self):
        """Gets the dataset_id of this IngestResponseModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The dataset_id of this IngestResponseModel.  # noqa: E501
        :rtype: str
        """
        return self._dataset_id

    @dataset_id.setter
    def dataset_id(self, dataset_id):
        """Sets the dataset_id of this IngestResponseModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param dataset_id: The dataset_id of this IngestResponseModel.  # noqa: E501
        :type: str
        """

        self._dataset_id = dataset_id

    @property
    def dataset(self):
        """Gets the dataset of this IngestResponseModel.  # noqa: E501

        Dataset and snapshot names follow this pattern. It is the same as ObjectNameProperty, but has a greater maxLength.   # noqa: E501

        :return: The dataset of this IngestResponseModel.  # noqa: E501
        :rtype: str
        """
        return self._dataset

    @dataset.setter
    def dataset(self, dataset):
        """Sets the dataset of this IngestResponseModel.

        Dataset and snapshot names follow this pattern. It is the same as ObjectNameProperty, but has a greater maxLength.   # noqa: E501

        :param dataset: The dataset of this IngestResponseModel.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                dataset is not None and len(dataset) > 511):
            raise ValueError("Invalid value for `dataset`, length must be less than or equal to `511`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dataset is not None and len(dataset) < 1):
            raise ValueError("Invalid value for `dataset`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dataset is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', dataset)):  # noqa: E501
            raise ValueError(r"Invalid value for `dataset`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._dataset = dataset

    @property
    def table(self):
        """Gets the table of this IngestResponseModel.  # noqa: E501

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :return: The table of this IngestResponseModel.  # noqa: E501
        :rtype: str
        """
        return self._table

    @table.setter
    def table(self, table):
        """Sets the table of this IngestResponseModel.

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :param table: The table of this IngestResponseModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and table is None:  # noqa: E501
            raise ValueError("Invalid value for `table`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                table is not None and len(table) > 63):
            raise ValueError("Invalid value for `table`, length must be less than or equal to `63`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                table is not None and len(table) < 1):
            raise ValueError("Invalid value for `table`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                table is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', table)):  # noqa: E501
            raise ValueError(r"Invalid value for `table`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._table = table

    @property
    def path(self):
        """Gets the path of this IngestResponseModel.  # noqa: E501


        :return: The path of this IngestResponseModel.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this IngestResponseModel.


        :param path: The path of this IngestResponseModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and path is None:  # noqa: E501
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501

        self._path = path

    @property
    def load_tag(self):
        """Gets the load_tag of this IngestResponseModel.  # noqa: E501

        client-specified tag for a data or file load. If no id is specified, we use the string form of the job create time as the tag.   # noqa: E501

        :return: The load_tag of this IngestResponseModel.  # noqa: E501
        :rtype: str
        """
        return self._load_tag

    @load_tag.setter
    def load_tag(self, load_tag):
        """Sets the load_tag of this IngestResponseModel.

        client-specified tag for a data or file load. If no id is specified, we use the string form of the job create time as the tag.   # noqa: E501

        :param load_tag: The load_tag of this IngestResponseModel.  # noqa: E501
        :type: str
        """

        self._load_tag = load_tag

    @property
    def row_count(self):
        """Gets the row_count of this IngestResponseModel.  # noqa: E501

        number of rows successfully ingested  # noqa: E501

        :return: The row_count of this IngestResponseModel.  # noqa: E501
        :rtype: int
        """
        return self._row_count

    @row_count.setter
    def row_count(self, row_count):
        """Sets the row_count of this IngestResponseModel.

        number of rows successfully ingested  # noqa: E501

        :param row_count: The row_count of this IngestResponseModel.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and row_count is None:  # noqa: E501
            raise ValueError("Invalid value for `row_count`, must not be `None`")  # noqa: E501

        self._row_count = row_count

    @property
    def bad_row_count(self):
        """Gets the bad_row_count of this IngestResponseModel.  # noqa: E501

        number of bad rows skipped  # noqa: E501

        :return: The bad_row_count of this IngestResponseModel.  # noqa: E501
        :rtype: int
        """
        return self._bad_row_count

    @bad_row_count.setter
    def bad_row_count(self, bad_row_count):
        """Sets the bad_row_count of this IngestResponseModel.

        number of bad rows skipped  # noqa: E501

        :param bad_row_count: The bad_row_count of this IngestResponseModel.  # noqa: E501
        :type: int
        """

        self._bad_row_count = bad_row_count

    @property
    def load_result(self):
        """Gets the load_result of this IngestResponseModel.  # noqa: E501


        :return: The load_result of this IngestResponseModel.  # noqa: E501
        :rtype: BulkLoadArrayResultModel
        """
        return self._load_result

    @load_result.setter
    def load_result(self, load_result):
        """Sets the load_result of this IngestResponseModel.


        :param load_result: The load_result of this IngestResponseModel.  # noqa: E501
        :type: BulkLoadArrayResultModel
        """

        self._load_result = load_result

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IngestResponseModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IngestResponseModel):
            return True

        return self.to_dict() != other.to_dict()
