import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Budgets::Budget`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export interface CfnBudgetProps {
    /**
     * `AWS::Budgets::Budget.Budget`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget
     */
    readonly budget: CfnBudget.BudgetDataProperty | cdk.IResolvable;
    /**
     * `AWS::Budgets::Budget.NotificationsWithSubscribers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers
     */
    readonly notificationsWithSubscribers?: Array<CfnBudget.NotificationWithSubscribersProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export declare class CfnBudget extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Budgets::Budget";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBudget;
    /**
     * `AWS::Budgets::Budget.Budget`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget
     */
    budget: CfnBudget.BudgetDataProperty | cdk.IResolvable;
    /**
     * `AWS::Budgets::Budget.NotificationsWithSubscribers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers
     */
    notificationsWithSubscribers: Array<CfnBudget.NotificationWithSubscribersProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Budgets::Budget`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBudgetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export declare namespace CfnBudget {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html
     */
    interface BudgetDataProperty {
        /**
         * `CfnBudget.BudgetDataProperty.BudgetLimit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgetlimit
         */
        readonly budgetLimit?: CfnBudget.SpendProperty | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.BudgetName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgetname
         */
        readonly budgetName?: string;
        /**
         * `CfnBudget.BudgetDataProperty.BudgetType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgettype
         */
        readonly budgetType: string;
        /**
         * `CfnBudget.BudgetDataProperty.CostFilters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-costfilters
         */
        readonly costFilters?: any | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.CostTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-costtypes
         */
        readonly costTypes?: CfnBudget.CostTypesProperty | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.PlannedBudgetLimits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-plannedbudgetlimits
         */
        readonly plannedBudgetLimits?: any | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.TimePeriod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeperiod
         */
        readonly timePeriod?: CfnBudget.TimePeriodProperty | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.TimeUnit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeunit
         */
        readonly timeUnit: string;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export declare namespace CfnBudget {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html
     */
    interface CostTypesProperty {
        /**
         * `CfnBudget.CostTypesProperty.IncludeCredit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includecredit
         */
        readonly includeCredit?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeDiscount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includediscount
         */
        readonly includeDiscount?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeOtherSubscription`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includeothersubscription
         */
        readonly includeOtherSubscription?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeRecurring`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includerecurring
         */
        readonly includeRecurring?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeRefund`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includerefund
         */
        readonly includeRefund?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeSubscription`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includesubscription
         */
        readonly includeSubscription?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeSupport`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includesupport
         */
        readonly includeSupport?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeTax`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includetax
         */
        readonly includeTax?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeUpfront`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includeupfront
         */
        readonly includeUpfront?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.UseAmortized`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-useamortized
         */
        readonly useAmortized?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.UseBlended`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-useblended
         */
        readonly useBlended?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export declare namespace CfnBudget {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html
     */
    interface NotificationProperty {
        /**
         * `CfnBudget.NotificationProperty.ComparisonOperator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-comparisonoperator
         */
        readonly comparisonOperator: string;
        /**
         * `CfnBudget.NotificationProperty.NotificationType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-notificationtype
         */
        readonly notificationType: string;
        /**
         * `CfnBudget.NotificationProperty.Threshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-threshold
         */
        readonly threshold: number;
        /**
         * `CfnBudget.NotificationProperty.ThresholdType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-thresholdtype
         */
        readonly thresholdType?: string;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export declare namespace CfnBudget {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html
     */
    interface NotificationWithSubscribersProperty {
        /**
         * `CfnBudget.NotificationWithSubscribersProperty.Notification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html#cfn-budgets-budget-notificationwithsubscribers-notification
         */
        readonly notification: CfnBudget.NotificationProperty | cdk.IResolvable;
        /**
         * `CfnBudget.NotificationWithSubscribersProperty.Subscribers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html#cfn-budgets-budget-notificationwithsubscribers-subscribers
         */
        readonly subscribers: Array<CfnBudget.SubscriberProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export declare namespace CfnBudget {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html
     */
    interface SpendProperty {
        /**
         * `CfnBudget.SpendProperty.Amount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html#cfn-budgets-budget-spend-amount
         */
        readonly amount: number;
        /**
         * `CfnBudget.SpendProperty.Unit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html#cfn-budgets-budget-spend-unit
         */
        readonly unit: string;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export declare namespace CfnBudget {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html
     */
    interface SubscriberProperty {
        /**
         * `CfnBudget.SubscriberProperty.Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html#cfn-budgets-budget-subscriber-address
         */
        readonly address: string;
        /**
         * `CfnBudget.SubscriberProperty.SubscriptionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html#cfn-budgets-budget-subscriber-subscriptiontype
         */
        readonly subscriptionType: string;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export declare namespace CfnBudget {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html
     */
    interface TimePeriodProperty {
        /**
         * `CfnBudget.TimePeriodProperty.End`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html#cfn-budgets-budget-timeperiod-end
         */
        readonly end?: string;
        /**
         * `CfnBudget.TimePeriodProperty.Start`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html#cfn-budgets-budget-timeperiod-start
         */
        readonly start?: string;
    }
}
