# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/misc.ipynb.

# %% auto 0
__all__ = ['Timer']

# %% ../nbs/misc.ipynb 2
import time

class Timer:
    def __init__(self, N):
        "print elapsed time every iteration and print out remaining time"
        "assumes this timer is called exactly N times or less"
        self.start = time.time()
        self.N = N
        self.ix = 0

    def __call__(self, ix=None, info=None):
        ix = self.ix if ix is None else ix
        info = "" if info is None else f"{info}\t"
        elapsed = time.time() - self.start
        speed = elapsed / (ix + 1)
        unit = 's/item'
        if speed < 1:
            speed = 1 / speed
            unit = 'item/s'
        print(
            "{}{}/{} ({:.2f}s - {:.2f}s remaining - {:.2f} {}){}".format(
                info, ix + 1, self.N, elapsed, (self.N - ix) * (elapsed / (ix + 1)), speed, unit, " "*10
            ),
            end="\r",
        )
        self.ix += 1
