import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
from matplotlib.colors import ListedColormap, LinearSegmentedColormap
from scipy.interpolate import interp1d


def spectral():

    A=np.array([219/256, 55/256, 82/256, 1])	
    B=np.array([226/256, 57/256, 79/256, 1])	
    C=np.array([230/256, 60/256, 76/256, 1])	
    D=np.array([244/256, 109/256, 67/256, 1])	
    E=np.array([253/256, 174/256, 97/256, 1])	
    F=np.array([254/256, 224/256, 139/256, 1])	
    G=np.array([230/256, 245/256, 152/256, 1])	
    H=np.array([171/256, 221/256, 164/256, 1])	
    I=np.array([102/256, 194/256, 165/256, 1])	
    J=np.array([50/256, 136/256, 189/256, 1])	
    K=np.array([94/256, 79/256, 162/256, 1])
    L=np.array([46/256, 67/256, 92/256, 1])
    M=np.array([38/256, 42/256, 77/256, 1])
    N=np.array([37/256, 43/256, 61/256, 1])
    
    ncmap = [N, M, L, K, J, I, H, G, F, E, D, C, B, A]
    c_array = []
    
    for i in range(len(ncmap)):
        if i != len(ncmap)-1:
            linfit = interp1d([1,256], np.vstack([ncmap[i], ncmap[i+1]]), axis=0)
            for j in range(255):
                c_array.append(linfit(j+1))
    
    #newcmp = ListedColormap(c_array)
    spec_cmap = ListedColormap(c_array, name='spec', N=len(c_array))

    return spec_cmap
    #return newcmp

def jade():
    colorlist = [
            [0.08048525330056805, 0.05201415138494773, 0.18107886855112176],
            [0.08282174108497872, 0.05548264112853812, 0.18701136971548327],
            [0.08510083379013808, 0.05893183335200911, 0.19295110050577835],
            [0.08732149679165027, 0.06236391678238993, 0.1988999668728864],
            [0.08948351372779442, 0.06578120659935585, 0.2048568371507506],
            [0.09158630556914435, 0.06918580148954842, 0.21082119130300758],
            [0.09362842795942464, 0.07257954032276293, 0.21679429113373555],
            [0.09560935498577233, 0.07596440682459804, 0.22277440676148685],
            [0.09752794289012831, 0.07934220307926157, 0.22876097274209006],
            [0.09938284674215636, 0.08271467009120442, 0.23475339391593014],
            [0.10117257181649406, 0.08608351243763912, 0.24075089154601287],
            [0.10289547247699185, 0.08945040996935877, 0.2467524877711415],
            [0.10454975102703004, 0.09281702803202968, 0.2527569887119423],
            [0.1061334566793852, 0.09618502637435938, 0.25876296625848433],
            [0.10764448481589006, 0.09955606685021534, 0.26476873860026046],
            [0.1090805767275786, 0.10293181997113154, 0.2707723495983788],
            [0.11043932005016904, 0.10631397032130063, 0.27677154714704316],
            [0.11171815013750855, 0.10970422080750591, 0.2827637607277609],
            [0.11291385345962551, 0.11310429674856487, 0.2887468683086714],
            [0.1140233083021745, 0.11651596835115913, 0.29471787846098235],
            [0.11504384858892774, 0.11994102457968481, 0.3006724844772462],
            [0.11597089088662477, 0.1233813283488848, 0.30660850772352255],
            [0.11680174115245501, 0.12683872558910916, 0.3125203302638832],
            [0.11753210249547663, 0.13031513895001925, 0.3184038841078844],
            [0.1181574480415879, 0.1338125447813214, 0.32425455000037123],
            [0.11867404554559757, 0.13733288407636784, 0.33006601551208176],
            [0.11907736155017198, 0.14087815324940609, 0.33583222502548604],
            [0.11936282780825758, 0.14445034917137684, 0.3415464303645391],
            [0.11952591076460412, 0.14805144454689917, 0.3472011730204451],
            [0.11956219574660862, 0.15168335729817528, 0.35278828230779896],
            [0.11946703477355067, 0.15534797161989095, 0.3582992390025081],
            [0.1192361182953327, 0.15904705059994143, 0.36372475837953394],
            [0.11886664197107047, 0.16278203712265407, 0.3690542044332376],
            [0.11835399462382584, 0.1665544813591542, 0.374278020169446],
            [0.11769708633606693, 0.1703652557411168, 0.3793844485150614],
            [0.11689426108150669, 0.17421509776366004, 0.3843624979497745],
            [0.11594488340102163, 0.17810436176866928, 0.38920113889145524],
            [0.11485082764232488, 0.18203274073193357, 0.39388905389112727],
            [0.11361530601755743, 0.18599943001155309, 0.39841563537326075],
            [0.11224346886066017, 0.19000302137811653, 0.40277110513165004],
            [0.11074249506992631, 0.19404149246058744, 0.4069468678334563],
            [0.10912183718013496, 0.19811218354305332, 0.4109358006442688],
            [0.10739338307745314, 0.20221180337198263, 0.414732549844077],
            [0.10557086837680585, 0.2063365897902914, 0.41833384968466514],
            [0.10366981790516067, 0.21048238687639614, 0.4217386056559858],
            [0.10170740537663389, 0.2146447428278066, 0.4249479122192987],
            [0.09970204311223499, 0.218819059805478, 0.4279649876238323],
            [0.09767282804859789, 0.22300076649675704, 0.4307949866194266],
            [0.09563957769959164, 0.22718536913793097, 0.43344476254076103],
            [0.09362188137321822, 0.23136867376098824, 0.4359225217538353],
            [0.09163911084811141, 0.23554681044865822, 0.4382374975689774],
            [0.08971021055125364, 0.2397162823192331, 0.44039963711046487],
            [0.08785341374317776, 0.24387401198668945, 0.44241929428617943],
            [0.08608604787604748, 0.24801735668271147, 0.44430696071297726],
            [0.08442437388963231, 0.2521441049770898, 0.4460730388692849],
            [0.08288345359298108, 0.25625245906452154, 0.447727660486174],
            [0.08147703924845859, 0.2603410066543993, 0.4492805492702125],
            [0.08021748052286187, 0.26440868618699465, 0.45074092430059326],
            [0.07911564571233268, 0.26845474855588225, 0.45211743879796856],
            [0.07818196546433143, 0.2724785212450291, 0.45341855485145616],
            [0.07742331496842386, 0.27647991363396385, 0.4546514629272957],
            [0.07684645341209317, 0.280458763502449, 0.4558233068453356],
            [0.07645599210316434, 0.2844151611188714, 0.45694050051595053],
            [0.07625499342910952, 0.28834931383124557, 0.4580089753858227],
            [0.07624428803082409, 0.2922616479198641, 0.4590338882994243],
            [0.0764246484998303, 0.2961524057545282, 0.46002064793302405],
            [0.07679349469917862, 0.3000222351904453, 0.4609733587165979],
            [0.07734772413661994, 0.3038716854661879, 0.46189612586822587],
            [0.078082991411866, 0.30770134701768104, 0.46279270218278606],
            [0.078993808850426, 0.3115118505312299, 0.46366648846352626],
            [0.08007372195698081, 0.3153038567985003, 0.4645205619011786],
            [0.08131549154345827, 0.31907804809298085, 0.46535770320028297],
            [0.08271127515321591, 0.3228351208997696, 0.46618042220254335],
            [0.08425280130731319, 0.3265757798371598, 0.46699098185757276],
            [0.08593153135860018, 0.3303007326185666, 0.46779142046902195],
            [0.08773880516989938, 0.334010685915416, 0.46858357220267327],
            [0.08966596826785347, 0.33770634199462096, 0.46936908588615883],
            [0.09170447943493812, 0.34138839601746424, 0.4701494421605266],
            [0.09384627191669201, 0.3450574687940023, 0.4709262383145943],
            [0.0960831566534833, 0.34871425919008814, 0.4717005822800508],
            [0.09840722058294235, 0.35235946876299223, 0.4724733819304247],
            [0.10081130535202479, 0.3559936883277908, 0.47324584798745534],
            [0.10328839922969663, 0.3596175517244634, 0.47401885251126213],
            [0.10583164048268956, 0.3632317468958568, 0.47479285720178294],
            [0.10843529606143137, 0.3668367497552385, 0.47556914313418813],
            [0.11109305466678468, 0.3704332911846674, 0.4763476646233545],
            [0.11379989493818632, 0.3740218347319917, 0.4771294894633465],
            [0.1165504277496224, 0.3776030462838571, 0.4779145781588722],
            [0.11934031236302717, 0.3811773723151275, 0.47870383244981923],
            [0.1221648808955253, 0.38474545266192633, 0.4794970619208388],
            [0.125020411942289, 0.388307718134574, 0.48029500882885473],
            [0.12790299670200686, 0.3918647459621973, 0.4810975439325174],
            [0.1308092677243089, 0.39541701876689145, 0.4819049069345677],
            [0.13373618068307982, 0.39896498572547184, 0.4827174086016704],
            [0.13668069096829463, 0.4025091728463909, 0.48353483099111366],
            [0.13964021136790725, 0.406050015101638, 0.48435734091527266],
            [0.14261235290340157, 0.4095879406664739, 0.4851850431516555],
            [0.14559477505956414, 0.41312342450853995, 0.48601767359538456],
            [0.14858543818884148, 0.416656888067347, 0.48685516603444695],
            [0.15158255724212422, 0.4201887085166255, 0.48769761426022423],
            [0.15458434439836058, 0.4237193171100199, 0.48854470146131307],
            [0.15758922166887118, 0.42724911117277475, 0.48939621005555106],
            [0.1605957694084157, 0.4307784695992068, 0.4902519372161687],
            [0.1636027244822555, 0.4343077490923155, 0.491111721839076],
            [0.16660891649172935, 0.43783730748551647, 0.491975306219297],
            [0.16961325003216388, 0.4413675088749811, 0.49284230322361616],
            [0.17261477331571376, 0.44489869096009016, 0.4937123972630855],
            [0.17561263325397278, 0.448431181362512, 0.4945852472768128],
            [0.17860606961239164, 0.4519652976547541, 0.49546048784714486],
            [0.18159442563504144, 0.4555013401990234, 0.49633777567333176],
            [0.1845771064967393, 0.4590396086408521, 0.49721668703712923],
            [0.18755358492543117, 0.4625803976464912, 0.4980967444907997],
            [0.19052342449086324, 0.4661239845401655, 0.49897749644340034],
            [0.1934862596939449, 0.46967063664691705, 0.4998584718877552],
            [0.19644179279460433, 0.4732206112796254, 0.5007391813298587],
            [0.1993897909500703, 0.47677415572168164, 0.5016191177063423],
            [0.20233008363189392, 0.48033150720616763, 0.5024977572937743],
            [0.20526256029220086, 0.4838928928924224, 0.5033745606130191],
            [0.20818716853545166, 0.48745852970998665, 0.5042489741899993],
            [0.21110391913022836, 0.49102862113430784, 0.5051204525129762],
            [0.214012859795344, 0.4946033684589058, 0.5059883847178445],
            [0.21691410080252765, 0.4981829582182889, 0.5068521777735264],
            [0.21980780356127605, 0.5017675667586048, 0.5077112273640632],
            [0.22269417927572416, 0.5053573602173034, 0.5085649188033458],
            [0.22557348769835062, 0.5089524945064459, 0.5094126279540128],
            [0.22844603596562707, 0.5125531153003807, 0.5102537221502317],
            [0.23131217750215527, 0.5161593580284437, 0.5110875611237955],
            [0.2341723109812675, 0.5197713478732411, 0.5119134979326914],
            [0.23702687933136235, 0.5233891997750044, 0.5127308798910744],
            [0.2398763687784734, 0.5270130184423942, 0.5135390494993705],
            [0.24272130791685848, 0.5306428983700274, 0.5143373453730951],
            [0.24556226680047072, 0.5342789238629028, 0.5151251031688446],
            [0.24839985604932951, 0.5379211690677673, 0.5159016565058445],
            [0.2512347259658508, 0.5415696980113599, 0.5166663378814075],
            [0.25406756565715155, 0.5452245646453509, 0.5174184795786663],
            [0.2568991009236168, 0.5488858134785958, 0.5181574105066044],
            [0.25973009315258094, 0.5525534797568642, 0.5188824561114836],
            [0.26256134496863687, 0.5562275864533538, 0.5195929608006147],
            [0.26539369184988465, 0.5599081478578057, 0.5202882642516484],
            [0.2682280037016422, 0.5635951685028145, 0.5209677102105779],
            [0.2710651839849425, 0.5672886432378643, 0.5216306473195916],
            [0.27390616884799945, 0.5709885573052456, 0.5222764299291535],
            [0.27675192626317563, 0.5746948864166812, 0.5229044188942632],
            [0.2796034551723504, 0.5784075968294059, 0.523513982355227],
            [0.28246178464433935, 0.582126645420309, 0.5241044965037023],
            [0.2853279730484085, 0.5858519797566668, 0.5246753463352459],
            [0.2882031072483145, 0.5895835381618909, 0.5252259263901075],
            [0.29108828884651083, 0.5933212565577812, 0.5257555892911342],
            [0.2939846604340613, 0.5970650547196666, 0.5262637508553819],
            [0.29689339861318054, 0.6008148391688073, 0.5267498712428699],
            [0.29981569680954845, 0.6045705119004785, 0.527213388355503],
            [0.30275277346602947, 0.6083319658590289, 0.5276537530980965],
            [0.3057058714844936, 0.6120990849338634, 0.5280704301107679],
            [0.308676257729572, 0.6158717439366385, 0.5284628985197721],
            [0.3116651844924428, 0.6196498316877389, 0.5288304574993271],
            [0.31467399818062547, 0.6234331862896855, 0.5291727658806836],
            [0.3177040383894046, 0.6272216535888611, 0.5294893603607917],
            [0.32075666502132105, 0.6310150715291278, 0.5297797826634003],
            [0.3238332465869995, 0.6348132784120495, 0.530043503342515],
            [0.32693516421157154, 0.6386161121285183, 0.5302799194545893],
            [0.33006388521640856, 0.6424233561142157, 0.530488851617822],
            [0.33322086276345425, 0.646234808783026, 0.5306699180009546],
            [0.33640753730338296, 0.6500502898970201, 0.5308224462888871],
            [0.3396254290498856, 0.6538695662347603, 0.5309461813870281],
            [0.3428760881310332, 0.6576923857459963, 0.5310409777399243],
            [0.3461610347500491, 0.6615185417790586, 0.5311061293651939],
            [0.3494818741518242, 0.6653477618992945, 0.5311414928487199],
            [0.3528402381206426, 0.6691797574550876, 0.5311470034715506],
            [0.35623773856171426, 0.6730143067272383, 0.5311217222029034],
            [0.3596761062484187, 0.676851043506187, 0.5310661929944817],
            [0.363157037432549, 0.6806897218684089, 0.5309794278887502],
            [0.36668232196586625, 0.6845299559338516, 0.5308619275145658],
            [0.3702537661054113, 0.688371459004273, 0.5307127862939564],
            [0.3738732370128696, 0.6922138036799519, 0.5305326817615184],
            [0.3775426720022207, 0.6960566802988168, 0.530320485453712],
            [0.38126403905296974, 0.6998996193218182, 0.5300769786202738],
            [0.38503939349108407, 0.7037422088073597, 0.5298018609766086],
            [0.3888708941747181, 0.7075840179095334, 0.5294946933173658],
            [0.39276071901393933, 0.7114245237641633, 0.5291560830210313],
            [0.3967111726351727, 0.7152632129656108, 0.5287860528602375],
            [0.40072468195180067, 0.7190995414849927, 0.5283845669202254],
            [0.40480381060253284, 0.7229329261285098, 0.5279515919635486],
            [0.4089511754736086, 0.7267627103199334, 0.5274877745575619],
            [0.41316958249072677, 0.7305882088422349, 0.5269934598071258],
            [0.41746199996491984, 0.7344086805786554, 0.5264691111575563],
            [0.42183157582919034, 0.7382233219015334, 0.5259153345429309],
            [0.42628165637517185, 0.7420312592199182, 0.5253329075509772],
            [0.4308159495525534, 0.7458315530961531, 0.5247222316854205],
            [0.43543825755846133, 0.7496231530434232, 0.5240846850919081],
            [0.44015264342852134, 0.7534049124762969, 0.5234219245218465],
            [0.4449637441301738, 0.7571755824501292, 0.5227350168091132],
            [0.4498764623733374, 0.7609337709003917, 0.5220258491518041],
            [0.45489611347957687, 0.76467793394586, 0.5212967794131992],
            [0.4600284135721672, 0.7684063569319022, 0.5205508850573775],
            [0.4652802364583753, 0.7721171037667829, 0.5197903041391412],
            [0.4706583986040424, 0.775808017926285, 0.5190198195405789],
            [0.47617079223836384, 0.77947665971295, 0.5182442157101737],
            [0.48182612454384705, 0.783120268274458, 0.5174694824886931],
            [0.4876345940605063, 0.7867356566770665, 0.5167020270722432],
            [0.49360651914444914, 0.7903192764479544, 0.515951933522151],
            [0.4997542969228412, 0.7938669847532194, 0.5152298780389132],
            [0.5060909937830524, 0.7973741070821171, 0.5145505062027681],
            [0.5126314280895948, 0.8008352434307523, 0.5139314572129776],
            [0.5193911391402741, 0.8042443116613637, 0.5133958296047287],
            [0.5263861804381819, 0.8075945148292144, 0.5129730996192842],
            [0.5336324426208333, 0.8108783877462027, 0.5127004910846158],
            [0.5411433393153288, 0.8140881656352382, 0.5126254166340589],
            [0.5489266893553753, 0.8172164380899232, 0.5128069977010532],
            [0.556978768743211, 0.8202575660623365, 0.5133171408735032],
            [0.5652812725304268, 0.8232088760132418, 0.5142357628132518],
            [0.5737923021481535, 0.8260734234185916, 0.5156456704889278],
            [0.5824473483043531, 0.8288610568321606, 0.5176179610409625],
            [0.5911645941995308, 0.8315883939622747, 0.5201974543340329],
            [0.599858330407827, 0.8342763530164432, 0.5233923928178723],
            [0.6084544517566809, 0.8369461925190099, 0.5271748094024599],
            [0.6168999702755021, 0.8396161731670932, 0.5314908450651845],
            [0.6251636680659655, 0.8423001907090591, 0.5362741657066403],
            [0.6332336228440085, 0.8450073628975338, 0.5414574370389853],
            [0.6411093866667529, 0.847743485848044, 0.5469782869956143],
            [0.6487998789693498, 0.8505111819429549, 0.5527833406288674],
            [0.656316890709515, 0.8533116313453962, 0.5588274350650004],
            [0.6636732101428703, 0.8561451196472208, 0.5650727734246322],
            [0.6708830645157214, 0.8590108856151255, 0.5714891332277985],
            [0.6779598489467569, 0.8619078974584948, 0.5780517482378954],
            [0.684914937069425, 0.8648353476258606, 0.5847392918208578],
            [0.6917599443374656, 0.8677919267941384, 0.5915352057061675],
            [0.6985046899134919, 0.8707765996691448, 0.5984251049468913],
            [0.705158622327226, 0.8737881445640161, 0.6053976331234809],
            [0.711729506234672, 0.8768256929917826, 0.6124424296197395],
            [0.7182246631832939, 0.8798883088960333, 0.6195510819496212],
            [0.724650949337259, 0.8829750217544431, 0.6267168107234342],
            [0.7310141145761915, 0.8860851139095216, 0.6339332654749323],
            [0.7373187760335642, 0.8892181759460619, 0.6411940604197177],
            [0.7435710067246047, 0.892373048347042, 0.6484964462881493],
            [0.749774311288356, 0.895549515072807, 0.6558350885898453],
            [0.75593256270929, 0.8987471042758479, 0.6632062461514663],
            [0.7620499697846803, 0.9019650926658775, 0.6706077607976545],
            [0.7681296325761946, 0.9052031494938839, 0.6780365298582881],
            [0.7741744830781208, 0.9084609432741264, 0.6854899069977083],
            [0.7801872926043927, 0.9117381451150655, 0.6929656429415475],
            [0.7861706795754828, 0.9150344314012067, 0.7004618329984874],
            [0.7921271175000261, 0.9183494859300595, 0.7079768706647968],
            [0.7980589429955735, 0.9216830015929358, 0.7155094066489497],
            [0.8039675555049253, 0.9250350764535149, 0.7230566721382756],
            [0.809855122400221, 0.9284053993143566, 0.7306178015167443],
            [0.8157241635130554, 0.9317934357780646, 0.7381930896022029],
            [0.8215751100440964, 0.9351996536735647, 0.7457788052451131],
            [0.8274105541549834, 0.9386234101303527, 0.7533760524581912],
            [0.8332313100794004, 0.9420649272461281, 0.7609824265673815],
            [0.839039359653216, 0.9455238038328512, 0.7685983065851764],
            [0.8448351190728174, 0.9490004259689578, 0.7762208147335705],
            [0.850620995988088, 0.9524941146669922, 0.7838517609802298],
            [0.8563970354101208, 0.9560054157499797, 0.791487766250909],
            [0.8621648437660235, 0.9595340314784105, 0.7991291785898682],
            [0.8679258122621484, 0.9630797545854436, 0.8067760394998789],
            [0.8736808458053672, 0.9666426242922864, 0.8144273857287543]
            ]

    jade_cmap = ListedColormap(colorlist, name='jade', N=len(colorlist))
    jade_cmap_r = jade_cmap.reversed()

    return [jade_cmap, jade_cmap_r]


def kelp():
    colorlist = [
            [0.06813277130228468, 0.022673538577072477, 0.09733133276649669],
            [0.07050381564011271, 0.02557111112377508, 0.10206200280673464],
            [0.07281101743023374, 0.028628374062896488, 0.10677258664090364],
            [0.07505650878547063, 0.03184623120682855, 0.11146513299967936],
            [0.077241676095927, 0.03522584155544845, 0.116141985731394],
            [0.07936841068837333, 0.03876822945425361, 0.12080414399177664],
            [0.08143786071596193, 0.0424123531696167, 0.1254530382614688],
            [0.0834509044581849, 0.04601849349104039, 0.13008991368881156],
            [0.085408001259828, 0.04959760355051642, 0.13471605174396742],
            [0.08730970984306724, 0.053152499346528694, 0.13933215184566605],
            [0.08915633036816084, 0.05668574844067031, 0.14393882531258145],
            [0.09094790313916498, 0.060199718092223874, 0.14853661339578939],
            [0.09268430503163366, 0.063696584358887, 0.15312588901013838],
            [0.09436526451942595, 0.06717836018028298, 0.15770685876889493],
            [0.09599037528160198, 0.0706469179720371, 0.16227956459515736],
            [0.097559108609279, 0.07410400793320462, 0.16684388493021612],
            [0.09907082481268728, 0.07755127296366712, 0.17139953556472573],
            [0.10052457088934993, 0.08099031989791086, 0.1759462818642722],
            [0.10191950902350722, 0.08442261148247027, 0.1804835043773494],
            [0.10325484979228777, 0.08784949866645497, 0.18501029910404324],
            [0.10452960412254417, 0.091272298043792, 0.18952572962336003],
            [0.10574218863707019, 0.09469240290454939, 0.19402916309180226],
            [0.1068917272045766, 0.09811094019283806, 0.1985190933926857],
            [0.10797701359854076, 0.10152905673238488, 0.20299411054896765],
            [0.10899627482026708, 0.10494798243031181, 0.2074530523956864],
            [0.10994863654239004, 0.10836865124868877, 0.2118938193937276],
            [0.11083225572417002, 0.11179219223375031, 0.21631488284257344],
            [0.11164580107208924, 0.11521954712151097, 0.22071411532607493],
            [0.112388020739001, 0.11865158693178801, 0.2250891675357406],
            [0.11305707238732596, 0.122089283317065, 0.22943791657267804],
            [0.11365148334984851, 0.12553346577016872, 0.2337578029233337],
            [0.11417000942233932, 0.1289848611009061, 0.2380459772661343],
            [0.11461120121056534, 0.1324442034708569, 0.2422995796920559],
            [0.11497370290195202, 0.13591216042524848, 0.2465155626173154],
            [0.11525628066338467, 0.1393893273998602, 0.25069069877840844],
            [0.11545785348465917, 0.14287622173535403, 0.2548215927517636],
            [0.11557752631698423, 0.14637327633451697, 0.2589046964092988],
            [0.11561447307204939, 0.14988086961342006, 0.2629363879997998],
            [0.11556796873434935, 0.1533993189149446, 0.2669129751628061],
            [0.11543825540899383, 0.15692867698137739, 0.27083042776200916],
            [0.115225316930442, 0.1604690284760446, 0.274684891384324],
            [0.11492934957846024, 0.16402037920749096, 0.278472520507118],
            [0.11455177152571375, 0.16758242551758193, 0.28218926361603436],
            [0.1140934797918593, 0.17115496715017317, 0.28583140576495397],
            [0.1135567196282059, 0.17473747879353244, 0.2893951401233913],
            [0.11294403724968954, 0.17832936176930295, 0.2928769107819342],
            [0.11225801052368886, 0.1819300103408425, 0.296273472438756],
            [0.11150273562612295, 0.18553848545399165, 0.2995817228128769],
            [0.11068246546110513, 0.18915383313840506, 0.3027989854961279],
            [0.10980208718205262, 0.19277498623765843, 0.30592297598315504],
            [0.10886711622835304, 0.19640077644717047, 0.3089518496922009],
            [0.10788363270201692, 0.20002995862034462, 0.31188424299932116],
            [0.10685831533484175, 0.20366121346701693, 0.3147193015840576],
            [0.10579833363827545, 0.20729317991216634, 0.3174567021892232],
            [0.10471122062239335, 0.21092448938281233, 0.32009665388026914],
            [0.10360483594445924, 0.21455377904202277, 0.32263988794510085],
            [0.10248727552535011, 0.21817971430493183, 0.32508763626275206],
            [0.10136677702109581, 0.22180100980923384, 0.32744159821570806],
            [0.10025162397339174, 0.22541644816449508, 0.32970389792854476],
            [0.09915005130575144, 0.22902489595933762, 0.33187703398320334],
            [0.09807015453998641, 0.23262531668156244, 0.3339638239548298],
            [0.09701980472193378, 0.2362167803868766, 0.33596734613394563],
            [0.0960065706106725, 0.2397984701219424, 0.33789088067013856],
            [0.09503764924409203, 0.24336968525501806, 0.33973785212111646],
            [0.09411980558093605, 0.24692984198459889, 0.3415117750569518],
            [0.09325956905269117, 0.25047842564899697, 0.34321627384176157],
            [0.09246252897006638, 0.2540151100498108, 0.34485486036646895],
            [0.09173388586455147, 0.25753964253067246, 0.3464310439679825],
            [0.09107826112478407, 0.26105186849793743, 0.3479482569845471],
            [0.09050018847442926, 0.2645516326389862, 0.34941000420247603],
            [0.0900026681706563, 0.2680390304670478, 0.35081935687435384],
            [0.08958871233011037, 0.2715141204150859, 0.35217944937842804],
            [0.08926086280205867, 0.27497700487429927, 0.35349332260865635],
            [0.08902041717195927, 0.27842796165758754, 0.3547635994124794],
            [0.08886907263914917, 0.28186714749349184, 0.35599312593050164],
            [0.08880694284142798, 0.28529494689177726, 0.35718414984908164],
            [0.08883448380797501, 0.28871162932599426, 0.3583391154838553],
            [0.08895122990881507, 0.292117572607639, 0.3594601123422041],
            [0.08915617560193362, 0.29551319622224326, 0.3605490132792376],
            [0.08944848374297154, 0.2988988377926238, 0.36160781652025864],
            [0.089826383736577, 0.30227495082013156, 0.3626380895283903],
            [0.09028788777725266, 0.3056419816207373, 0.3636412969361112],
            [0.0908308565942896, 0.3090003615043912, 0.3646188287224085],
            [0.09145291120093371, 0.31235052681771974, 0.3655719406083007],
            [0.0921516263871352, 0.3156928886802647, 0.3665018525577798],
            [0.09292404401269069, 0.31902792600168267, 0.36740943706635065],
            [0.09376730451926985, 0.32235607657681115, 0.36829557349392944],
            [0.09467846629632051, 0.32567777426347294, 0.36916102926539546],
            [0.0956545406629618, 0.32899344722708446, 0.37000646592818376],
            [0.09669252404220954, 0.33230351639752853, 0.3708324451004716],
            [0.0977894271493332, 0.33560839411760424, 0.37163943427447466],
            [0.09894230110763907, 0.3389084829637072, 0.3724278124492819],
            [0.10014826048483422, 0.3422041747208775, 0.37319787557589124],
            [0.10140464952613362, 0.3454958210585843, 0.3739499586859639],
            [0.10270863542279973, 0.34878381464911923, 0.37468410908611505],
            [0.10405762817025463, 0.35206851065774625, 0.37540040243757206],
            [0.10544916482269609, 0.3553502505567943, 0.37609885111232755],
            [0.10688091880895373, 0.35862936167990705, 0.37677940855676856],
            [0.10835084781070722, 0.36190612815343404, 0.37744210242478016],
            [0.10985686220821234, 0.3651808585454788, 0.37808673891136646],
            [0.11139699261737201, 0.3684538534837456, 0.37871304103692616],
            [0.1129695238888109, 0.37172537809386635, 0.37932077886258253],
            [0.11457310188504952, 0.37499563826991467, 0.3799098937190273],
            [0.11620606563374211, 0.3782649215751215, 0.3804798315331487],
            [0.11786717762666313, 0.3815334435838344, 0.3810302690727262],
            [0.11955551400600947, 0.3848013683913497, 0.38156103531865104],
            [0.12126987403829484, 0.38806893701342726, 0.3820714738043521],
            [0.12300956226518217, 0.3913362963103797, 0.3825612956725436],
            [0.12477387671224574, 0.39460360982194365, 0.38303003102365457],
            [0.1265621791426709, 0.3978710425816765, 0.3834771006886879],
            [0.1283742170518906, 0.40113868624525745, 0.3839022182320782],
            [0.13020948521318276, 0.4044067048199645, 0.3843046157805386],
            [0.13206801428593687, 0.4076751509639634, 0.38468403691110525],
            [0.13394954753684785, 0.4109441576106127, 0.3850396943850188],
            [0.1358542867961505, 0.41421376034268453, 0.38537125563500957],
            [0.1377822421703599, 0.41748405213122003, 0.38567797766889583],
            [0.139733780395527, 0.42075504891303944, 0.3859594772696414],
            [0.14170911625224483, 0.4240268139746639, 0.3862150125557177],
            [0.14370879022184335, 0.42729933709356865, 0.3864441995916197],
            [0.1457331754221099, 0.43057265896127705, 0.38664626872656743],
            [0.14778298031962914, 0.4338467399104167, 0.38682086946491],
            [0.14985872495319819, 0.43712159638117437, 0.38696722771722875],
            [0.1519612040800056, 0.44039717648168397, 0.38708493071149014],
            [0.15409112366749259, 0.4436734569974488, 0.3871733124095057],
            [0.1562493281098577, 0.44695038002587756, 0.38723186583151753],
            [0.15843667852587565, 0.4502278854909156, 0.38726003456057195],
            [0.16065406172043342, 0.453505908152845, 0.38725723176376753],
            [0.162902457579718, 0.45678435593318717, 0.3872229967445916],
            [0.16518280221821366, 0.4600631505428359, 0.3871567095659742],
            [0.16749613118679352, 0.4633421821198674, 0.3870579192223294],
            [0.16984345412033938, 0.46662134756071866, 0.3869260677996151],
            [0.17222582368586975, 0.46990052751257455, 0.38676066204442106],
            [0.17464430851601198, 0.4731795938415156, 0.3865612219687237],
            [0.17709997728763963, 0.47645841445506004, 0.3863272438139692],
            [0.1795939196027054, 0.47973684475787076, 0.3860582707742898],
            [0.18212722288047395, 0.4830147351133031, 0.3857538348562544],
            [0.1847009795933081, 0.48629192723021647, 0.3854134883521573],
            [0.1873162789955517, 0.48956825658983855, 0.3850367846816016],
            [0.1899742165069394, 0.49284354713304696, 0.38462332885223177],
            [0.19267586103281806, 0.49611762582809965, 0.3841726431649205],
            [0.1954223025218435, 0.4993902986513133, 0.38368439491112066],
            [0.1982145983342311, 0.502661376546192, 0.38315814999847897],
            [0.20105380542484758, 0.5059306584012382, 0.3825935370591811],
            [0.20394097280022944, 0.5091979328569392, 0.38199023660048553],
            [0.20687711733979874, 0.5124629961212678, 0.38134778467997626],
            [0.20986327161879675, 0.5157256138558783, 0.38066599571955967],
            [0.2129004217295556, 0.5189855741009222, 0.3799443616774365],
            [0.21598956701217248, 0.5222426287078961, 0.3791827340219737],
            [0.21913167290418406, 0.5254965463022968, 0.37838068846689005],
            [0.22232770008589414, 0.5287470731203081, 0.3775380055261914],
            [0.22557859113820772, 0.5319939554011606, 0.3766543859765549],
            [0.22888527684038262, 0.5352369318727412, 0.3757295402617988],
            [0.2322486725445338, 0.5384757275860831, 0.3747632831101269],
            [0.2356696882242666, 0.5417100698254749, 0.3737552835184855],
            [0.23914921263910877, 0.5449396649459001, 0.372705429392222],
            [0.24268813981537435, 0.5481642230854534, 0.3716134120235155],
            [0.24628734235401822, 0.5513834352638882, 0.3704791148699131],
            [0.24994769325666277, 0.554596987493184, 0.36930235857398414],
            [0.2536700751135214, 0.5578045590219559, 0.3680828997995617],
            [0.25745531800083243, 0.5610058042270532, 0.3668208479212005],
            [0.26130436346706154, 0.5642003934013794, 0.3655156572384857],
            [0.2652179975271339, 0.567387949484072, 0.36416772301380623],
            [0.2691971636600692, 0.5705681130501585, 0.36277663242285657],
            [0.2732427312567217, 0.5737404950502208, 0.36134244530796755],
            [0.2773555435515881, 0.5769046905509504, 0.359865376085321],
            [0.28153661642260924, 0.580060293784775, 0.35834502836900356],
            [0.28578682251021825, 0.5832068668252918, 0.356781704798795],
            [0.29010707191966867, 0.5863439585231389, 0.3551756436140265],
            [0.2944983672413877, 0.5894711023583653, 0.353526885327515],
            [0.2989618140771339, 0.5925878104639201, 0.3518353134260052],
            [0.3034983296966166, 0.5956935685952599, 0.3501015657877806],
            [0.3081089868835118, 0.5987878429529981, 0.3483259465288665],
            [0.31279489937565275, 0.6018700741509224, 0.34650883227756957],
            [0.3175572253315017, 0.6049396753154918, 0.34465068335216786],
            [0.3223971705966151, 0.6079960300748802, 0.3427520567451361],
            [0.327316020458455, 0.611038489037556, 0.3408135521915197],
            [0.3323150464915319, 0.6140663718654086, 0.33883606319911513],
            [0.3373955819109743, 0.6170789629249103, 0.33682060596980135],
            [0.34255908670585217, 0.6200755039796167, 0.3347682088952961],
            [0.3478070702531591, 0.6230551953787864, 0.33268012826083315],
            [0.35314104395650353, 0.6260171980762103, 0.3305579704782073],
            [0.35856260108890686, 0.6289606256124024, 0.3284035488698602],
            [0.3640733880379873, 0.6318845434760364, 0.3262189816344637],
            [0.369675099651235, 0.6347879669527791, 0.3240067374375134],
            [0.3753699747494803, 0.6376698027373551, 0.3217687830953849],
            [0.3811594892375407, 0.6405289856872279, 0.3195090422335711],
            [0.38704556459542316, 0.6433643503038692, 0.3172311786038816],
            [0.3930306137898691, 0.6461746089286978, 0.3149386809317892],
            [0.3991160988154224, 0.6489585325476988, 0.3126373322113352],
            [0.4053045221152578, 0.6517146920935442, 0.31033195237243577],
            [0.4115976704715293, 0.6544416862495418, 0.30802934453833797],
            [0.4179973191326823, 0.657138050602529, 0.305737172010251],
            [0.42450544434459336, 0.6598022201126739, 0.30346373898386836],
            [0.4311239521367279, 0.6624325644901556, 0.3012184938398597],
            [0.4378538860690653, 0.6650275235110319, 0.29901313733488893],
            [0.4446962517018042, 0.667585480449082, 0.2968604822594548],
            [0.45165150541704663, 0.6701048533957433, 0.29477516142621596],
            [0.45871977128073965, 0.6725840654324252, 0.29277334574581565],
            [0.4658997253442428, 0.6750217714390325, 0.2908739766788722],
            [0.4731890344595801, 0.677416809048926, 0.28909801196000134],
            [0.4805844940518799, 0.6797681975890874, 0.28746807492716486],
            [0.4880810323352392, 0.6820753801199614, 0.28600915294842877],
            [0.49567164497524, 0.6843382972869607, 0.28474808954927083],
            [0.5033474977857411, 0.6865574275390157, 0.28371283580926515],
            [0.5110976568340501, 0.6887339149276965, 0.2829319205944889],
            [0.518908722517422, 0.6908697345810957, 0.2824337824730567],
            [0.526765633552552, 0.692967581098691, 0.2822451601761704],
            [0.5346514677011611, 0.6950309863948769, 0.2823902530668034],
            [0.5425482118485311, 0.697064189117844, 0.2828893106585839],
            [0.5504374801377818, 0.6990719862847224, 0.28375755925141294],
            [0.5583005996705507, 0.7010597316499382, 0.285004665789419],
            [0.5661208910159305, 0.7030326960709197, 0.2866338239316284],
            [0.5738821681815585, 0.704996445589546, 0.28864252176710653],
            [0.5815717197786512, 0.7069559252433839, 0.2910224308131026],
            [0.5891774804699639, 0.708916214501143, 0.2937607040539667],
            [0.5966915836395218, 0.7108813793449442, 0.2968406042916182],
            [0.6041079189375063, 0.7128551164215711, 0.3002428304196506],
            [0.6114226072119529, 0.7148405352760056, 0.3039464386941861],
            [0.6186339127985545, 0.7168401114380352, 0.3079297975011498],
            [0.6257406894924739, 0.7188561502114694, 0.31217091551569076],
            [0.6327448043413827, 0.7208899154585707, 0.3166488708855951],
            [0.6396479750812677, 0.7229426636682975, 0.3213433108783226],
            [0.6464535770481475, 0.7250149916832861, 0.326235522120268],
            [0.6531635814181512, 0.7271079231051997, 0.33130701210441504],
            [0.6597825826666097, 0.7292214326009724, 0.33654196995863894],
            [0.6663144683481157, 0.7313556446687746, 0.3419255005827861],
            [0.6727632626250576, 0.7335105291020358, 0.34744409173587415],
            [0.6791321531478016, 0.7356862862309391, 0.35308474420499686],
            [0.6854256592438658, 0.7378824986721235, 0.35883679449749145],
            [0.6916483891427609, 0.7400986010701429, 0.36469100195889154],
            [0.6978023233502557, 0.7423350124370174, 0.3706365761712863],
            [0.7038931571429075, 0.7445905344959719, 0.3766676469221709],
            [0.7099219669638855, 0.7468658172610753, 0.3827742795682624],
            [0.7158938039437757, 0.7491597580919442, 0.3889519406088403],
            [0.721811502499422, 0.7514721161858754, 0.39519445503025696],
            [0.727677801896505, 0.7538026310016187, 0.40149626320363374],
            [0.7334953710046794, 0.7561510144158329, 0.40785240670894224],
            [0.7392667844917477, 0.7585169642425897, 0.4142584525798199],
            [0.7449946446213148, 0.7609001106068309, 0.42071063236670914],
            [0.7506812935012096, 0.7633001514010357, 0.4272053792257902],
            [0.7563291095991977, 0.7657167184435434, 0.4337397230223225],
            [0.7619403526604275, 0.7681494517240296, 0.44031102506095304],
            [0.7675171948431719, 0.770597987834919, 0.4469169870369983],
            [0.7730611565442617, 0.7730622429714348, 0.4535546277851981],
            [0.7785736170421966, 0.7755421757566625, 0.4602210390195403],
            [0.7840575020366498, 0.7780369328975683, 0.46691645399886167],
            [0.7895131181776833, 0.7805469469960253, 0.473636724260359],
            [0.7949430258399441, 0.7830714775720039, 0.4803821367759196],
            [0.8003479681887296, 0.7856106876017347, 0.4871498660268169],
            [0.805730099186072, 0.7881639785284903, 0.4939400818935485],
            [0.811089618214382, 0.7907317602194375, 0.5007493179180842],
            [0.8164291324508672, 0.793313134348985, 0.5075792145009752],
            [0.8217487355280337, 0.795908530659941, 0.5144264799424542],
            [0.8270499049801611, 0.7985176138390158, 0.5212908700887579],
            [0.8323341899554909, 0.8011399800343302, 0.5281725522515618],
            [0.8376025159364093, 0.8037755492905234, 0.5350705436016258]
            ]
    
    
    kelp = ListedColormap(colorlist, name='kelp', N=len(colorlist))
    kelp_r = kelp.reversed()

    return [kelp, kelp_r]




if __name__=="__main__":
    
    spec = spectral()
    jade, jade_r = jade()
    kelp, kelp_r = kelp()

    
    xx, yy = np.meshgrid(np.linspace(0,3*np.pi,512), np.linspace(0,3*np.pi,512))
    z = np.sin(xx) + np.sin(yy)
    plt.imshow(z, origin='lower', interpolation='none', cmap=spec)
    cbar = plt.colorbar()
    plt.show()
