"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeScriptCode = exports.JavaScriptCode = exports.EsbuildCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const asset_1 = require("./asset");
function nodeMajorVersion() {
    return parseInt(process.versions.node.split('.')[0], 10);
}
;
;
/**
 * Represents a generic esbuild code bundle.
 *
 * You should always use `TypeScriptCode` or `JavaScriptCode`.
 *
 * @stability experimental
 */
class EsbuildCode extends aws_lambda_1.Code {
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @stability stable
     */
    props) {
        super();
        this.entryPoints = entryPoints;
        /**
         * Determines whether this Code is inline code or not.
         *
         * @deprecated this value is ignored since inline is now determined based on the the inlineCode field of CodeConfig returned from bind().
         */
        this.isInline = false;
        const defaultOptions = {
            ...(!props.buildOptions?.platform ||
                props.buildOptions?.platform === 'node'
                ? { platform: 'node', target: 'node' + nodeMajorVersion() }
                : {}),
        };
        this.props = {
            ...props,
            entryPoints,
            buildOptions: {
                ...defaultOptions,
                ...props.buildOptions,
            },
        };
    }
    getAsset(scope) {
        return new asset_1.EsbuildAsset(scope, this.constructor.name, this.props);
    }
    bind(scope) {
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = this.getAsset(scope);
        }
        else if (aws_cdk_lib_1.Stack.of(this.asset) !== aws_cdk_lib_1.Stack.of(scope)) {
            throw new Error(`Asset is already associated with another stack '${aws_cdk_lib_1.Stack.of(this.asset).stackName}'. ` + 'Create a new Asset instance for every stack.');
        }
        return {
            s3Location: {
                bucketName: this.asset.s3BucketName,
                objectKey: this.asset.s3ObjectKey,
            },
        };
    }
    /**
     * Called after the CFN function resource has been created to allow the code class to bind to it.
     *
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     *
     * @stability stable
     */
    bindToResource(resource, options) {
        if (!this.asset) {
            throw new Error('bindToResource() must be called after bind()');
        }
        const resourceProperty = options?.resourceProperty || this.constructor.name;
        // https://github.com/aws/aws-cdk/issues/1432
        this.asset.addResourceMetadata(resource, resourceProperty);
    }
}
exports.EsbuildCode = EsbuildCode;
_a = JSII_RTTI_SYMBOL_1;
EsbuildCode[_a] = { fqn: "@mrgrain/cdk-esbuild.EsbuildCode", version: "3.13.5" };
/**
 * Represents the deployed JavaScript Code.
 *
 * @stability stable
 */
class JavaScriptCode extends EsbuildCode {
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @stability stable
     */
    props = {}) {
        super(entryPoints, props);
    }
    getAsset(scope) {
        return new asset_1.JavaScriptAsset(scope, this.constructor.name, this.props);
    }
}
exports.JavaScriptCode = JavaScriptCode;
_b = JSII_RTTI_SYMBOL_1;
JavaScriptCode[_b] = { fqn: "@mrgrain/cdk-esbuild.JavaScriptCode", version: "3.13.5" };
/**
 * Represents the deployed TypeScript Code.
 *
 * @stability stable
 */
class TypeScriptCode extends EsbuildCode {
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @stability stable
     */
    props = {}) {
        super(entryPoints, props);
    }
    getAsset(scope) {
        return new asset_1.TypeScriptAsset(scope, this.constructor.name, this.props);
    }
}
exports.TypeScriptCode = TypeScriptCode;
_c = JSII_RTTI_SYMBOL_1;
TypeScriptCode[_c] = { fqn: "@mrgrain/cdk-esbuild.TypeScriptCode", version: "3.13.5" };
//# sourceMappingURL=data:application/json;base64,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