# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserSaasArgs', 'UserSaas']

@pulumi.input_type
class UserSaasArgs:
    def __init__(__self__, *,
                 account_admin: pulumi.Input[bool],
                 csp_roles: pulumi.Input[Sequence[pulumi.Input[str]]],
                 email: pulumi.Input[str],
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['UserSaasGroupArgs']]]] = None):
        """
        The set of arguments for constructing a UserSaas resource.
        """
        pulumi.set(__self__, "account_admin", account_admin)
        pulumi.set(__self__, "csp_roles", csp_roles)
        pulumi.set(__self__, "email", email)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @property
    @pulumi.getter(name="accountAdmin")
    def account_admin(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "account_admin")

    @account_admin.setter
    def account_admin(self, value: pulumi.Input[bool]):
        pulumi.set(self, "account_admin", value)

    @property
    @pulumi.getter(name="cspRoles")
    def csp_roles(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "csp_roles")

    @csp_roles.setter
    def csp_roles(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "csp_roles", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserSaasGroupArgs']]]]:
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserSaasGroupArgs']]]]):
        pulumi.set(self, "groups", value)


@pulumi.input_type
class _UserSaasState:
    def __init__(__self__, *,
                 account_admin: Optional[pulumi.Input[bool]] = None,
                 confirmed: Optional[pulumi.Input[bool]] = None,
                 created: Optional[pulumi.Input[str]] = None,
                 csp_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['UserSaasGroupArgs']]]] = None,
                 logins: Optional[pulumi.Input[Sequence[pulumi.Input['UserSaasLoginArgs']]]] = None,
                 multiaccount: Optional[pulumi.Input[bool]] = None,
                 password_reset: Optional[pulumi.Input[bool]] = None,
                 send_announcements: Optional[pulumi.Input[bool]] = None,
                 send_new_plugins: Optional[pulumi.Input[bool]] = None,
                 send_new_risks: Optional[pulumi.Input[bool]] = None,
                 send_scan_results: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UserSaas resources.
        """
        if account_admin is not None:
            pulumi.set(__self__, "account_admin", account_admin)
        if confirmed is not None:
            pulumi.set(__self__, "confirmed", confirmed)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if csp_roles is not None:
            pulumi.set(__self__, "csp_roles", csp_roles)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if logins is not None:
            pulumi.set(__self__, "logins", logins)
        if multiaccount is not None:
            pulumi.set(__self__, "multiaccount", multiaccount)
        if password_reset is not None:
            pulumi.set(__self__, "password_reset", password_reset)
        if send_announcements is not None:
            pulumi.set(__self__, "send_announcements", send_announcements)
        if send_new_plugins is not None:
            pulumi.set(__self__, "send_new_plugins", send_new_plugins)
        if send_new_risks is not None:
            pulumi.set(__self__, "send_new_risks", send_new_risks)
        if send_scan_results is not None:
            pulumi.set(__self__, "send_scan_results", send_scan_results)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accountAdmin")
    def account_admin(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "account_admin")

    @account_admin.setter
    def account_admin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "account_admin", value)

    @property
    @pulumi.getter
    def confirmed(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "confirmed")

    @confirmed.setter
    def confirmed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confirmed", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="cspRoles")
    def csp_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "csp_roles")

    @csp_roles.setter
    def csp_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "csp_roles", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserSaasGroupArgs']]]]:
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserSaasGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def logins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserSaasLoginArgs']]]]:
        return pulumi.get(self, "logins")

    @logins.setter
    def logins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserSaasLoginArgs']]]]):
        pulumi.set(self, "logins", value)

    @property
    @pulumi.getter
    def multiaccount(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "multiaccount")

    @multiaccount.setter
    def multiaccount(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiaccount", value)

    @property
    @pulumi.getter(name="passwordReset")
    def password_reset(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "password_reset")

    @password_reset.setter
    def password_reset(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_reset", value)

    @property
    @pulumi.getter(name="sendAnnouncements")
    def send_announcements(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "send_announcements")

    @send_announcements.setter
    def send_announcements(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_announcements", value)

    @property
    @pulumi.getter(name="sendNewPlugins")
    def send_new_plugins(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "send_new_plugins")

    @send_new_plugins.setter
    def send_new_plugins(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_new_plugins", value)

    @property
    @pulumi.getter(name="sendNewRisks")
    def send_new_risks(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "send_new_risks")

    @send_new_risks.setter
    def send_new_risks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_new_risks", value)

    @property
    @pulumi.getter(name="sendScanResults")
    def send_scan_results(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "send_scan_results")

    @send_scan_results.setter
    def send_scan_results(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_scan_results", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class UserSaas(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_admin: Optional[pulumi.Input[bool]] = None,
                 csp_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserSaasGroupArgs']]]]] = None,
                 __props__=None):
        """
        The `UserSaas` resource manages your saas users within Aqua.

        The users created must have at least one Csp Role that is already present within Aqua.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        ia_c1 = aquasec.UserSaas("iaC1",
            account_admin=True,
            csp_roles=[],
            email="infrastructure1@example.com")
        ia_c2 = aquasec.UserSaas("iaC2",
            account_admin=False,
            csp_roles=["Default"],
            email="infrastructure2@example.com",
            groups=[aquasec.UserSaasGroupArgs(
                group_admin=False,
                name="IacGroupName",
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserSaasArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `UserSaas` resource manages your saas users within Aqua.

        The users created must have at least one Csp Role that is already present within Aqua.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        ia_c1 = aquasec.UserSaas("iaC1",
            account_admin=True,
            csp_roles=[],
            email="infrastructure1@example.com")
        ia_c2 = aquasec.UserSaas("iaC2",
            account_admin=False,
            csp_roles=["Default"],
            email="infrastructure2@example.com",
            groups=[aquasec.UserSaasGroupArgs(
                group_admin=False,
                name="IacGroupName",
            )])
        ```

        :param str resource_name: The name of the resource.
        :param UserSaasArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserSaasArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_admin: Optional[pulumi.Input[bool]] = None,
                 csp_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserSaasGroupArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserSaasArgs.__new__(UserSaasArgs)

            if account_admin is None and not opts.urn:
                raise TypeError("Missing required property 'account_admin'")
            __props__.__dict__["account_admin"] = account_admin
            if csp_roles is None and not opts.urn:
                raise TypeError("Missing required property 'csp_roles'")
            __props__.__dict__["csp_roles"] = csp_roles
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["groups"] = groups
            __props__.__dict__["confirmed"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["logins"] = None
            __props__.__dict__["multiaccount"] = None
            __props__.__dict__["password_reset"] = None
            __props__.__dict__["send_announcements"] = None
            __props__.__dict__["send_new_plugins"] = None
            __props__.__dict__["send_new_risks"] = None
            __props__.__dict__["send_scan_results"] = None
            __props__.__dict__["user_id"] = None
        super(UserSaas, __self__).__init__(
            'aquasec:index/userSaas:UserSaas',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_admin: Optional[pulumi.Input[bool]] = None,
            confirmed: Optional[pulumi.Input[bool]] = None,
            created: Optional[pulumi.Input[str]] = None,
            csp_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            email: Optional[pulumi.Input[str]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserSaasGroupArgs']]]]] = None,
            logins: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserSaasLoginArgs']]]]] = None,
            multiaccount: Optional[pulumi.Input[bool]] = None,
            password_reset: Optional[pulumi.Input[bool]] = None,
            send_announcements: Optional[pulumi.Input[bool]] = None,
            send_new_plugins: Optional[pulumi.Input[bool]] = None,
            send_new_risks: Optional[pulumi.Input[bool]] = None,
            send_scan_results: Optional[pulumi.Input[bool]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'UserSaas':
        """
        Get an existing UserSaas resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserSaasState.__new__(_UserSaasState)

        __props__.__dict__["account_admin"] = account_admin
        __props__.__dict__["confirmed"] = confirmed
        __props__.__dict__["created"] = created
        __props__.__dict__["csp_roles"] = csp_roles
        __props__.__dict__["email"] = email
        __props__.__dict__["groups"] = groups
        __props__.__dict__["logins"] = logins
        __props__.__dict__["multiaccount"] = multiaccount
        __props__.__dict__["password_reset"] = password_reset
        __props__.__dict__["send_announcements"] = send_announcements
        __props__.__dict__["send_new_plugins"] = send_new_plugins
        __props__.__dict__["send_new_risks"] = send_new_risks
        __props__.__dict__["send_scan_results"] = send_scan_results
        __props__.__dict__["user_id"] = user_id
        return UserSaas(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountAdmin")
    def account_admin(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "account_admin")

    @property
    @pulumi.getter
    def confirmed(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "confirmed")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="cspRoles")
    def csp_roles(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "csp_roles")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence['outputs.UserSaasGroup']]]:
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def logins(self) -> pulumi.Output[Sequence['outputs.UserSaasLogin']]:
        return pulumi.get(self, "logins")

    @property
    @pulumi.getter
    def multiaccount(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "multiaccount")

    @property
    @pulumi.getter(name="passwordReset")
    def password_reset(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "password_reset")

    @property
    @pulumi.getter(name="sendAnnouncements")
    def send_announcements(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "send_announcements")

    @property
    @pulumi.getter(name="sendNewPlugins")
    def send_new_plugins(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "send_new_plugins")

    @property
    @pulumi.getter(name="sendNewRisks")
    def send_new_risks(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "send_new_risks")

    @property
    @pulumi.getter(name="sendScanResults")
    def send_scan_results(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "send_scan_results")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "user_id")

