import uuid
from dataclasses import dataclass, field

@dataclass
class Lane:

  trailer_type: str
  origin_city: str
  origin_state: str
  dest_city: str
  dest_state: str  
  origin_zip: str = field(default=None)
  origin_lat: float = field(default=None)
  origin_lng: float = field(default=None)
  origin_deadhead: float = field(default=None)
  dest_zip: str = field(default=None)
  destination_states: str = field(default=None)
  dest_lat: float = field(default=None)
  dest_lng: float = field(default=None)
  destination_deadhead: float = field(default=None)
  priced_loads: int = field(default=0)
  # generated by server
  id: uuid.UUID = field(default=None)