import uuid
import datetime
from dataclasses import dataclass, field

from cc_py_commons.transactions.equipment_class import EquipmentClass

@dataclass
class Transaction:
    """
    Represents the pricing database loads table. 
    Called Transaction here to clarify the difference between a load that may be active
    and a booked or completed transaction used for pricing.
    """
    client_id: uuid.UUID
    reference_number: str
    pickup_date: datetime.date
    delivery_date: datetime.date
    origin_city: str
    origin_state: str
    origin_postcode: str    
    destination_city: str
    destination_state: str
    destination_postcode: str    
    equipment: str
    equipment_class: EquipmentClass
    all_in_cost: int    
    contact_id: uuid.UUID = field(default=None)
    carrier_id: uuid.UUID = field(default=None)
    booking_date: datetime.date = field(default=None)
    pickup_appointment_window: int = field(default=None)
    num_pickups: int = field(default=None)
    num_dropoffs: int = field(default=None)
    origin_country: str = field(default=None)
    origin_latitude : float = field(default=None)
    origin_longitude : float = field(default=None)
    destination_country: str = field(default=None)
    destination_latitude : float = field(default=None)
    destination_longitude : float = field(default=None)
    miles: int = field(default=None)
    line_haul_cost: int = field(default=None)
    fuel_portion: int = field(default=None)
    price_to_shipper: int = field(default=None)
    weight: int = field(default=None)
    commodity: str = field(default=None)
    comments: str = field(default=None)
    import_stats_id: uuid.UUID = field(default=None)
    #   import_stats = relationship("ImportStats", back_populates="loads", lazy='subquery')
    pickup_appointment_required: bool = field(default=False)
    delivery_appointment_required: bool = field(default=False)
    team_service: bool = field(default=False)
    hand_loading: bool = field(default=False)
    driver_assist_loading: bool = field(default=False)
    driver_assist_unloading: bool = field(default=False)
    drop_trailer: bool = field(default=False)
    hazmat: bool = field(default=False)
    lift_gate_required: bool = field(default=False)
    blanket_wrap: bool = field(default=False)
    white_glove: bool = field(default=False)
    home_delivery: bool = field(default=False)
    etrack_load_stabilization: bool = field(default=False)
    contract: bool = field(default=False)    
    straps_required: bool = field(default=False)
    tarps_required: bool = field(default=False)
    frozen: bool = field(default=False)
    origin_hub_weight : float = field(default=None)
    destination_hub_weight : float = field(default=None)
    calculated_miles: int = field(default=None)
    mileage_mismatch: bool = field(default=False)
    holiday: bool = field(default=False)
    accessorials_included: int = field(default=None)
    client_shipper_id: str = field(default=None)
    client_receiver_id: str = field(default=None)
    load_source_type: str = field(default=None)
    predicted_price: int = field(default=None)
    carrier_code: str = field(default=None)
    customer_code: str = field(default=None)
    customer_id: uuid.UUID = field(default=None)
    customer_name: str = field(default=None)
    account_exec_id: uuid.UUID = field(default=None)
    #   account_exec = relationship("AccountExec", lazy='subquery')
    carrier_rep_id: uuid.UUID = field(default=None)
    #   carrier_rep = relationship("CarrierRep", lazy='subquery')
    excluded: bool = field(default=False)
    lane_id: uuid.UUID = field(default=None)
    multi_stop: int = field(default=1)
    margin: int = field(default=None)
    rate_type: str = field(default=None)
    provider: str = field(default=None)
    target_pay: int = field(default=None)
    max_buy: int = field(default=None)
    # generated by server and returned
    id: uuid.UUID = field(default=None)
    pieces: int = field(default=None)
    max_temperature: float = field(default=None)
    min_temperature: float = field(default=None)
