"""
PyMove.

Provides  processing and visualization of trajectories and other
spatial-temporal data

"""

from .core import grid
from .core.dask import DaskMoveDataFrame
from .core.dataframe import MoveDataFrame
from .core.grid import Grid
from .core.pandas import PandasMoveDataFrame
from .core.pandas_discrete import PandasDiscreteMoveDataFrame
from .models.pattern_mining import clustering
from .preprocessing import compression, filters, segmentation, stay_point_detection
from .query import query
from .semantic import semantic
from .utils import (
    constants,
    conversions,
    data_augmentation,
    datetime,
    distances,
    geoutils,
    integration,
    log,
    math,
    mem,
    trajectories,
    visual,
)
from .utils.trajectories import read_csv
from .visualization import folium, matplotlib

__version__ = '3.0.1'
