import { aws_eks } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import * as kong_core from 'kong-core';
/**
 * @summary The KongEks class.
 */
export declare class KongEks extends Construct {
    readonly controlPlane: aws_eks.Cluster;
    privateCaArn: string;
    telemetryDns: string;
    clusterDns: string;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope: Construct, id: string, props: kong_core.KongEksControlPlaneProps);
}
