"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const kong_core = require("kong-core");
// import * as kong_core from '../../kong-core/';
const index_1 = require("./resources/helm-charts/kong/index");
const index_2 = require("./resources/helm-charts/private-ca/index");
/**
 * @summary The KongEks class.
 */
class KongEks extends constructs_1.Construct {
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        this.clusterDns = `cluster.${props.hostedZoneName}`;
        this.telemetryDns = `telemetry.${props.hostedZoneName}`;
        const control_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'CPSecretsKey');
        this.controlPlane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
        });
        const cp_nodegroup = this.controlPlane.addNodegroupCapacity('CpASG', props.controlPlaneNodeProps);
        cp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        // });
        new kong_core.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        const kong_rds_instance = new kong_core.RdsStack(this, 'KongRds', {
            vpc: this.controlPlane.vpc,
            databasename: props.rdsProps.databasename,
            postgresversion: props.rdsProps.postgresversion,
            username: props.rdsProps.username,
        });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: 'kube-system',
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: this.controlPlane,
        });
        new kong_core.ExternalDns(kong_pre_requisites_nested_stack, 'ExtDns', {
            cluster: this.controlPlane,
        });
        const private_ca = new index_2.PrivateCA(kong_pre_requisites_nested_stack, 'KongPCA', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: props.namespace,
            cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-cp.internal',
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
        });
        this.privateCaArn = private_ca.private_ca_arn;
        const kong_control_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongCpNestedStack');
        new index_1.KongControlPlane(kong_control_plane_nested_stack, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            // nodegroup: cp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-cp.internal',
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
        });
        kong_control_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack, kong_rds_instance);
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryNestedStack');
        new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            cluster: this.controlPlane,
            namespace: kong_core.Namespace.TELEMETRY,
            cacertname: kong_core.Tls.ADOT_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
            hostedZoneName: props.hostedZoneName,
        });
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
        // telemetry.node.addDependency(private_ca_nested_stack.node);
        // telemetry.node.findAll().forEach (function (value) {
        //   value.node.addDependency(private_ca.node.findChild(''));
        // });
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "2.0.6" };
//# sourceMappingURL=data:application/json;base64,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