"""First commit

Revision ID: e827c1336bb4
Revises: 
Create Date: 2021-11-21 19:47:24.678501

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "e827c1336bb4"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "files",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("path", sa.String(), nullable=True),
        sa.Column("mtime", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "metas",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("version", sa.String(), nullable=True),
        sa.Column("root", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "infos",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("file_id", sa.Integer(), nullable=True),
        sa.Column("duration", sa.Integer(), nullable=True),
        sa.Column("seekable", sa.Boolean(), nullable=True),
        sa.Column("live", sa.Boolean(), nullable=True),
        sa.Column("audio_streams", sa.Integer(), nullable=True),
        sa.Column("video_streams", sa.Integer(), nullable=True),
        sa.Column("subtitle_streams", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["file_id"],
            ["files.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "streams",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("parent_id", sa.Integer(), nullable=True),
        sa.Column("info_id", sa.Integer(), nullable=True),
        sa.Column("media_type", sa.String(), nullable=True),
        sa.Column("type", sa.String(), nullable=True),
        sa.Column("framerate_denom", sa.Integer(), nullable=True),
        sa.Column("framerate_num", sa.Integer(), nullable=True),
        sa.Column("height", sa.Integer(), nullable=True),
        sa.Column("par_denom", sa.Integer(), nullable=True),
        sa.Column("par_num", sa.Integer(), nullable=True),
        sa.Column("width", sa.Integer(), nullable=True),
        sa.Column("is_image", sa.Boolean(), nullable=True),
        sa.Column("is_interlaced", sa.Boolean(), nullable=True),
        sa.Column("bitrate", sa.Integer(), nullable=True),
        sa.Column("max_bitrate", sa.Integer(), nullable=True),
        sa.Column("depth", sa.Integer(), nullable=True),
        sa.Column("channel_mask", sa.Integer(), nullable=True),
        sa.Column("channels", sa.Integer(), nullable=True),
        sa.Column("sample_rate", sa.Integer(), nullable=True),
        sa.Column("language", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["info_id"],
            ["infos.id"],
        ),
        sa.ForeignKeyConstraint(
            ["parent_id"],
            ["streams.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "fields",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("stream_id", sa.Integer(), nullable=True),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("value", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["stream_id"],
            ["streams.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("fields")
    op.drop_table("streams")
    op.drop_table("infos")
    op.drop_table("metas")
    op.drop_table("files")
    # ### end Alembic commands ###
