# Generated by Django 3.2.10 on 2022-09-20 21:25

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Course',
            fields=[
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='课程ID')),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='课程名称')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CourseVersion',
            fields=[
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='版本ID')),
                ('version', models.CharField(max_length=64, verbose_name='版本')),
                ('title', models.CharField(max_length=128, verbose_name='标题')),
                ('created_at', models.DateTimeField(verbose_name='版本创建时间')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='versions', to='courses.course', verbose_name='数据模型')),
            ],
            options={
                'unique_together': {('course', 'version')},
            },
        ),
        migrations.CreateModel(
            name='Lecture',
            fields=[
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='课时ID')),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='课时名称')),
                ('created_at', models.DateTimeField(verbose_name='课时创建时间')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lectures', to='courses.course', verbose_name='课程')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LectureVersion',
            fields=[
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='课时版本ID')),
                ('updated_at', models.DateTimeField(default=None, verbose_name='课时版本更新时间')),
                ('title', models.CharField(max_length=128, verbose_name='课时名称')),
                ('course_version', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lecture_versions', to='courses.courseversion', verbose_name='课程版本')),
                ('lecture', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='versions', to='courses.lecture', verbose_name='课时')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
