"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhiteListReceiptFilter = exports.AllowListReceiptFilter = exports.ReceiptFilter = exports.ReceiptFilterPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ses_generated_1 = require("./ses.generated");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * The policy for the receipt filter.
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    /**
     * Allow the ip address or range.
     */
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    /**
     * Block the ip address or range.
     */
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter. When instantiated without props, it creates a
 * block all receipt filter.
 */
class ReceiptFilter extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_ses_ReceiptFilterProps(props);
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
_a = JSII_RTTI_SYMBOL_1;
ReceiptFilter[_a] = { fqn: "@aws-cdk/aws-ses.ReceiptFilter", version: "1.151.0" };
/**
 * An allow list receipt filter.
 */
class AllowListReceiptFilter extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_ses_AllowListReceiptFilterProps(props);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
exports.AllowListReceiptFilter = AllowListReceiptFilter;
_b = JSII_RTTI_SYMBOL_1;
AllowListReceiptFilter[_b] = { fqn: "@aws-cdk/aws-ses.AllowListReceiptFilter", version: "1.151.0" };
/**
 * An allow list receipt filter.
 * @deprecated use `AllowListReceiptFilter`
 */
class WhiteListReceiptFilter extends AllowListReceiptFilter {
    constructor(scope, id, props) {
        super(scope, id, props);
        jsiiDeprecationWarnings.print("@aws-cdk/aws-ses.WhiteListReceiptFilter", "use `AllowListReceiptFilter`");
        jsiiDeprecationWarnings._aws_cdk_aws_ses_WhiteListReceiptFilterProps(props);
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
_c = JSII_RTTI_SYMBOL_1;
WhiteListReceiptFilter[_c] = { fqn: "@aws-cdk/aws-ses.WhiteListReceiptFilter", version: "1.151.0" };
//# sourceMappingURL=data:application/json;base64,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