# ory-keto-client
Documentation for all of Ory Oathkeeper's APIs.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0.8.0-alpha.1
- Package version: v0.8.0-alpha.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/ory/sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/ory/sdk.git`)

Then import the package:
```python
import ory_keto_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ory_keto_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import ory_keto_client
from pprint import pprint
from ory_keto_client.api import metadata_api
from ory_keto_client.model.generic_error import GenericError
from ory_keto_client.model.inline_response200 import InlineResponse200
from ory_keto_client.model.inline_response2001 import InlineResponse2001
from ory_keto_client.model.inline_response503 import InlineResponse503
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = ory_keto_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with ory_keto_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = metadata_api.MetadataApi(api_client)
    
    try:
        # Return Running Software Version.
        api_response = api_instance.get_version()
        pprint(api_response)
    except ory_keto_client.ApiException as e:
        print("Exception when calling MetadataApi->get_version: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MetadataApi* | [**get_version**](docs/MetadataApi.md#get_version) | **GET** /version | Return Running Software Version.
*MetadataApi* | [**is_alive**](docs/MetadataApi.md#is_alive) | **GET** /health/alive | Check HTTP Server Status
*MetadataApi* | [**is_ready**](docs/MetadataApi.md#is_ready) | **GET** /health/ready | Check HTTP Server and Database Status
*ReadApi* | [**get_check**](docs/ReadApi.md#get_check) | **GET** /check | Check a relation tuple
*ReadApi* | [**get_expand**](docs/ReadApi.md#get_expand) | **GET** /expand | Expand a Relation Tuple
*ReadApi* | [**get_relation_tuples**](docs/ReadApi.md#get_relation_tuples) | **GET** /relation-tuples | Query relation tuples
*ReadApi* | [**post_check**](docs/ReadApi.md#post_check) | **POST** /check | Check a relation tuple
*WriteApi* | [**create_relation_tuple**](docs/WriteApi.md#create_relation_tuple) | **PUT** /relation-tuples | Create a Relation Tuple
*WriteApi* | [**delete_relation_tuples**](docs/WriteApi.md#delete_relation_tuples) | **DELETE** /relation-tuples | Delete Relation Tuples
*WriteApi* | [**patch_relation_tuples**](docs/WriteApi.md#patch_relation_tuples) | **PATCH** /relation-tuples | Patch Multiple Relation Tuples


## Documentation For Models

 - [CreateRelationTupleBadRequestBody](docs/CreateRelationTupleBadRequestBody.md)
 - [CreateRelationTupleInternalServerErrorBody](docs/CreateRelationTupleInternalServerErrorBody.md)
 - [DeleteRelationTuplesBadRequestBody](docs/DeleteRelationTuplesBadRequestBody.md)
 - [DeleteRelationTuplesInternalServerErrorBody](docs/DeleteRelationTuplesInternalServerErrorBody.md)
 - [ExpandTree](docs/ExpandTree.md)
 - [GenericError](docs/GenericError.md)
 - [GetCheckBadRequestBody](docs/GetCheckBadRequestBody.md)
 - [GetCheckInternalServerErrorBody](docs/GetCheckInternalServerErrorBody.md)
 - [GetCheckResponse](docs/GetCheckResponse.md)
 - [GetExpandBadRequestBody](docs/GetExpandBadRequestBody.md)
 - [GetExpandInternalServerErrorBody](docs/GetExpandInternalServerErrorBody.md)
 - [GetExpandNotFoundBody](docs/GetExpandNotFoundBody.md)
 - [GetRelationTuplesInternalServerErrorBody](docs/GetRelationTuplesInternalServerErrorBody.md)
 - [GetRelationTuplesNotFoundBody](docs/GetRelationTuplesNotFoundBody.md)
 - [GetRelationTuplesResponse](docs/GetRelationTuplesResponse.md)
 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InternalRelationTuple](docs/InternalRelationTuple.md)
 - [IsInstanceAliveInternalServerErrorBody](docs/IsInstanceAliveInternalServerErrorBody.md)
 - [PatchDelta](docs/PatchDelta.md)
 - [PatchRelationTuplesBadRequestBody](docs/PatchRelationTuplesBadRequestBody.md)
 - [PatchRelationTuplesInternalServerErrorBody](docs/PatchRelationTuplesInternalServerErrorBody.md)
 - [PatchRelationTuplesNotFoundBody](docs/PatchRelationTuplesNotFoundBody.md)
 - [PostCheckBadRequestBody](docs/PostCheckBadRequestBody.md)
 - [PostCheckInternalServerErrorBody](docs/PostCheckInternalServerErrorBody.md)
 - [RelationQuery](docs/RelationQuery.md)
 - [SubjectSet](docs/SubjectSet.md)
 - [Version](docs/Version.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

hi@ory.sh


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in ory_keto_client.apis and ory_keto_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from ory_keto_client.api.default_api import DefaultApi`
- `from ory_keto_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import ory_keto_client
from ory_keto_client.apis import *
from ory_keto_client.models import *
```

