"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretKeyStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const key_type_1 = require("./key-type");
class SecretKeyStore {
    constructor(secretKeyType) {
        this.secretKeyType = secretKeyType;
    }
    static fromSSMParameter(secretKeyParameter) {
        return new SSMParameterSecretKeyStore(secretKeyParameter);
    }
    static fromSecretsManager(secretKeySecret) {
        return new SecretsManagerSecretKeyStore(secretKeySecret);
    }
}
exports.SecretKeyStore = SecretKeyStore;
_a = JSII_RTTI_SYMBOL_1;
SecretKeyStore[_a] = { fqn: "@cloudcomponents/cdk-secret-key.SecretKeyStore", version: "1.19.0" };
class SecretsManagerSecretKeyStore extends SecretKeyStore {
    constructor(secretKeySecret) {
        super(key_type_1.KeyType.SECRETS_MANAGER);
        this.secretKeySecret = secretKeySecret;
    }
    grantWrite(grantee) {
        return this.secretKeySecret.grantWrite(grantee);
    }
    serialize() {
        return JSON.stringify({
            secretKeyType: this.secretKeyType,
            secretArn: this.secretKeySecret.secretArn,
        });
    }
}
class SSMParameterSecretKeyStore extends SecretKeyStore {
    constructor(secretKeyParameter) {
        super(key_type_1.KeyType.SSM_PARAMETER);
        this.secretKeyParameter = secretKeyParameter;
    }
    grantWrite(grantee) {
        return this.secretKeyParameter.grantWrite(grantee);
    }
    serialize() {
        return JSON.stringify({
            secretKeyType: this.secretKeyType,
            parameterName: this.secretKeyParameter.parameterName,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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