"""
    University Photo API

      ## Introduction  The Photo API allows access to Photos of members of the University. The Photos exposed by this API are expected to be a good representation of the person they relate to.  The API broadly follows the principles of REST and strives to provide an interface that can be easily consumed by downstream systems.  ### Stability  This release of the Photo API is a `beta` offering: a service we are moving towards live but which requires wider testing with a broader group of users.  ### Versioning  The Photo API is versioned using url path prefixes in the format: `/v1beta1/photos`. This follows the pattern established by the [GCP API](https://cloud.google.com/apis/design/versioning). Breaking changes will not be made without a change in API major version, however non-breaking changes will be introduced without changes to the version path prefix. All changes will be documented in the project's [CHANGELOG](https://gitlab.developers.cam.ac.uk/uis/devops/iam/photo-api/-/blob/master/CHANGELOG.md)  The available versions of the API are listed at the API's root.  ### Domain  The Photo API serves Photos of members of the University, linking a Photo to an individual through `PhotoIdentifiers` (see below) which pertain to a person record within an external system.  The Photos served by the Photo API are expected to be of good enough quality to identify the person they represent. Photos which have been manually reviewed and determined to be good quality are marked as having the status `approved` and exposed through the `approved-photos` endpoints.  ### Data source  The Photos exposed by the Photo API are currently a mirror of card Photos contained within the [Card Database](https://webservices.admin.cam.ac.uk/uc/). With Photos being synced from the Card Database to the Photo API hourly.  In future, the Photo API will be extended to allow Photos to be created and 'approved' using the API.  ## Core entities  ### The `Photo` Entity  The `Photo` entity contains information and metadata about a Photo of a member of the university. The `status` field on a Photo indicates whether this Photo has been reviewed and approved as identifying the person it relates to. Only Photos which have the status `approved` are exposed through the `approved-photos` endpoints.  Each Photo entity contains a link to the image data itself and a thumbnail for this Photo, which is guaranteed to be less than 128x128 pixels. Images are served by redirecting to a temporary url provided by the service used to host images. These temporary urls will expire after an hour so should not be retained for long-lasting access to a given Photo.  Each Photo may contain a block of JSON metadata recording information about the Photo. Seeing as Photos cannot be updated once created (apart from to move their status to `approved`) this metadata should not be used to store application state or any other information which is not related to the content of the Photo.  Each Photo will have a set of `PhotoIdentifier` which allow the Photo to be linked to a person record within another system.  ### The `PhotoIdentifier` Entity  The `PhotoIdentifier` entity holds the `value` and `scheme` of a given identifier. The `value` field of a `PhotoIdentifier` is a simple ID string - e.g. `wgd23` or `000001`. The `scheme` field of a `PhotoIdentifier` indicates what system this identifier relates to or was issued by. This allows many identifiers which relate to different systems to be recorded against a single `Photo`.  The supported schemes are: * `v1.person.identifiers.cam.ac.uk`: The CRSID of the person represented by this Photo * `person.v1.student-records.university.identifiers.cam.ac.uk`: The CamSIS identifier (USN) of the person represented by this Photo * `person.v1.human-resources.university.identifiers.cam.ac.uk`: The CHRIS identifier (staff number) of the person represented by this Photo * `photo.v1.legacy-card.university.identifiers.cam.ac.uk`: The id of this Photo within the legacy card system  ## Using the API  ### Auth  To authenticate against the Photo API, an application must be registered within the API Gateway and granted access to the `University Photo` product. Details of how to register an application and grant access to products can be found in the [API Gateway Getting Started Guide](https://developer.api.apps.cam.ac.uk/start-using-an-api).    # noqa: E501

    The version of the OpenAPI document: v1beta1
    Contact: devops+photoapi@uis.cam.ac.uk
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from identitylib.photo_client.api_client import ApiClient, Endpoint as _Endpoint
from identitylib.photo_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from identitylib.photo_client.model.bad_request import BadRequest
from identitylib.photo_client.model.not_found import NotFound
from identitylib.photo_client.model.v1_beta1_photo import V1Beta1Photo


class ApprovedPhotosApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1beta1_approved_photos_content_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiGatewayOAuthClientCredentials',
                    'apiGatewayClientCredentialsAuth'
                ],
                'endpoint_path': '/v1beta1/approved-photos/{identifier}/content',
                'operation_id': 'v1beta1_approved_photos_content_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifier',
                ],
                'required': [
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identifier':
                        (str,),
                },
                'attribute_map': {
                    'identifier': 'identifier',
                },
                'location_map': {
                    'identifier': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'image/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_approved_photos_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (V1Beta1Photo,),
                'auth': [
                    'ApiGatewayOAuthClientCredentials',
                    'apiGatewayClientCredentialsAuth'
                ],
                'endpoint_path': '/v1beta1/approved-photos/{identifier}',
                'operation_id': 'v1beta1_approved_photos_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifier',
                ],
                'required': [
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identifier':
                        (str,),
                },
                'attribute_map': {
                    'identifier': 'identifier',
                },
                'location_map': {
                    'identifier': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_approved_photos_thumbnail_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiGatewayOAuthClientCredentials',
                    'apiGatewayClientCredentialsAuth'
                ],
                'endpoint_path': '/v1beta1/approved-photos/{identifier}/thumbnail',
                'operation_id': 'v1beta1_approved_photos_thumbnail_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifier',
                ],
                'required': [
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identifier':
                        (str,),
                },
                'attribute_map': {
                    'identifier': 'identifier',
                },
                'location_map': {
                    'identifier': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'image/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def v1beta1_approved_photos_content_retrieve(
        self,
        identifier,
        **kwargs
    ):
        """Get the image content of an approved photo using a person identifier  # noqa: E501

          # Get image content of an approved Photo  This endpoint redirects to the image content of an approved Photo for the given PhotoIdentifier.  The PhotoIdentifier should be included in the url params in the format `<value>@<scheme>` - see the introduction to this API for a list of supported schemes. If the scheme is not provided the identifier is assumed to be a CRSid.  A given PhotoIdentifier may link to many approved Photos, in which case the most recently approved Photo is returned here. If a PhotoIdentifier does not link to an approved Photo a `404` response will be returned.  The Photo returned may change over time if a new Photo is approved for a given PhotoIdentifier. If you want to keep a reference to an exact Photo you can use the `id` or `contentLink` of the Photo returned from the `Get approved Photo` endpoint above, which is guaranteed to always give back the same Photo, regardless of whether a new Photo is approved for a given PhotoIdentifier.  This endpoint redirects to a temporary url provided by the storage service used by this API. This temporary url will expire after a short period of time and therefore should not be recorded or used as a permanent reference to this Photo.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_approved_photos_content_retrieve(identifier, async_req=True)
        >>> result = thread.get()

        Args:
            identifier (str): The PhotoIdentifier to get an approved photo for in the format `<value>@<scheme>`

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['identifier'] = \
            identifier
        return self.v1beta1_approved_photos_content_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_approved_photos_retrieve(
        self,
        identifier,
        **kwargs
    ):
        """Get an approved photo of a person using a person identifier  # noqa: E501

          # Get approved Photo  This endpoint allows information and metadata about an approved Photo to be fetched using a PhotoIdentifier. The PhotoIdentifier should be included in the url params in the format `<value>@<scheme>` - see the introduction to this API for a list of supported schemes. If the scheme is not provided the identifier is assumed to be a CRSid.  A given PhotoIdentifier may link to many approved Photos, in which case the most recently approved Photo is returned here. If a PhotoIdentifier does not link to an approved Photo a `404` response will be returned.  The Photo returned may change over time if a new Photo is approved for a given PhotoIdentifier. If you want to keep a reference to an exact Photo, you can use the `id` or `selfLink` returned to directly reference an instance of an immutable Photo.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_approved_photos_retrieve(identifier, async_req=True)
        >>> result = thread.get()

        Args:
            identifier (str): The PhotoIdentifier to get an approved photo for in the format `<value>@<scheme>`

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            V1Beta1Photo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['identifier'] = \
            identifier
        return self.v1beta1_approved_photos_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_approved_photos_thumbnail_retrieve(
        self,
        identifier,
        **kwargs
    ):
        """Get the thumbnail of an approved photo using a person identifier  # noqa: E501

          # Get thumbnail of an approved Photo  This endpoint redirects to the thumbnail of an approved Photo for the given PhotoIdentifier.  This thumbnail is guaranteed to be smaller than 128x128 pixels and will be in png format.  The documentation for the `Get image content of an approved Photo` additionally applies to this endpoint, as all constraints are the same between the two endpoints.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_approved_photos_thumbnail_retrieve(identifier, async_req=True)
        >>> result = thread.get()

        Args:
            identifier (str): The PhotoIdentifier to get an approved photo for in the format `<value>@<scheme>`

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['identifier'] = \
            identifier
        return self.v1beta1_approved_photos_thumbnail_retrieve_endpoint.call_with_http_info(**kwargs)

