# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ..api_client import ApiClient
from ..exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TatorApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_attribute(self, id, attribute_type_spec, **kwargs):
        """add_attribute

        Add attribute to Type.  A attribute type is the metadata definition object for a user-defined attribute. It includes name, type, and any other associated fields, depending on the type. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_attribute(id, attribute_type_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a unique entity type. (required)
        :param AttributeTypeSpec attribute_type_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_attribute_with_http_info(id, attribute_type_spec, **kwargs)  # noqa: E501

    def add_attribute_with_http_info(self, id, attribute_type_spec, **kwargs):  # noqa: E501
        """
        Add attribute to Type.  A attribute type is the metadata definition object for a user-defined attribute. It includes name, type, and any other associated fields, depending on the type.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_attribute_with_http_info(id, attribute_type_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a unique entity type. (required)
        :param AttributeTypeSpec attribute_type_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'attribute_type_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_attribute" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `add_attribute`")  # noqa: E501
        # verify the required parameter 'attribute_type_spec' is set
        if self.api_client.client_side_validation and ('attribute_type_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['attribute_type_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attribute_type_spec` when calling `add_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'attribute_type_spec' in local_var_params:
            body_params = local_var_params['attribute_type_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/AttributeType/{id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def algorithm_launch(self, project, algorithm_launch_spec, **kwargs):
        """algorithm_launch

        Launch a registered algorithm.  This will create one or more Argo workflows that execute the named algorithm registration. To get a list of available algorithms, use the `Algorithms` endpoint. A media list will be submitted for processing using either a query string or  a list of media IDs. If neither are included, the algorithm will be launched on all media in the project.   Media is divided into batches for based on the `files_per_job` field of the  `Algorithm` object. One batch is submitted to each Argo workflow.  Submitted algorithm jobs may be cancelled via the `Job` or `JobGroup` endpoints. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.algorithm_launch(project, algorithm_launch_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param AlgorithmLaunchSpec algorithm_launch_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.AlgorithmLaunch`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.algorithm_launch_with_http_info(project, algorithm_launch_spec, **kwargs)  # noqa: E501

    def algorithm_launch_with_http_info(self, project, algorithm_launch_spec, **kwargs):  # noqa: E501
        """
        Launch a registered algorithm.  This will create one or more Argo workflows that execute the named algorithm registration. To get a list of available algorithms, use the `Algorithms` endpoint. A media list will be submitted for processing using either a query string or  a list of media IDs. If neither are included, the algorithm will be launched on all media in the project.   Media is divided into batches for based on the `files_per_job` field of the  `Algorithm` object. One batch is submitted to each Argo workflow.  Submitted algorithm jobs may be cancelled via the `Job` or `JobGroup` endpoints.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.algorithm_launch_with_http_info(project, algorithm_launch_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param AlgorithmLaunchSpec algorithm_launch_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.AlgorithmLaunch`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'algorithm_launch_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method algorithm_launch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `algorithm_launch`")  # noqa: E501
        # verify the required parameter 'algorithm_launch_spec' is set
        if self.api_client.client_side_validation and ('algorithm_launch_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['algorithm_launch_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_launch_spec` when calling `algorithm_launch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'algorithm_launch_spec' in local_var_params:
            body_params = local_var_params['algorithm_launch_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/AlgorithmLaunch/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlgorithmLaunch',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clone_media_list(self, project, clone_media_spec, **kwargs):
        """clone_media_list

        Clone media list.  This method copies media to a different project without copying the  underlying files. It accepts the same query parameters as a `Media` `GET` request. All media matching the query will be copied to the project, media type, and section in the given request body. Section is passed as a section name; if the given section does not exist, it will be created.  This endpoint will only clone up to 500 media per request. Use the `start`, `stop`, or `after` parameters to paginate a request. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.clone_media_list(project, clone_media_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying the source project. (required)
        :param CloneMediaSpec clone_media_spec: (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateListResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clone_media_list_with_http_info(project, clone_media_spec, **kwargs)  # noqa: E501

    def clone_media_list_with_http_info(self, project, clone_media_spec, **kwargs):  # noqa: E501
        """
        Clone media list.  This method copies media to a different project without copying the  underlying files. It accepts the same query parameters as a `Media` `GET` request. All media matching the query will be copied to the project, media type, and section in the given request body. Section is passed as a section name; if the given section does not exist, it will be created.  This endpoint will only clone up to 500 media per request. Use the `start`, `stop`, or `after` parameters to paginate a request.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.clone_media_list_with_http_info(project, clone_media_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying the source project. (required)
        :param CloneMediaSpec clone_media_spec: (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateListResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'clone_media_spec',
            'media_id',
            'type',
            'name',
            'section',
            'dtype',
            'md5',
            'gid',
            'uid',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_media_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `clone_media_list`")  # noqa: E501
        # verify the required parameter 'clone_media_spec' is set
        if self.api_client.client_side_validation and ('clone_media_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['clone_media_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `clone_media_spec` when calling `clone_media_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'section' in local_var_params and local_var_params['section'] is not None:  # noqa: E501
            query_params.append(('section', local_var_params['section']))  # noqa: E501
        if 'dtype' in local_var_params and local_var_params['dtype'] is not None:  # noqa: E501
            query_params.append(('dtype', local_var_params['dtype']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'clone_media_spec' in local_var_params:
            body_params = local_var_params['clone_media_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/CloneMedia/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def complete_upload(self, project, upload_completion_spec, **kwargs):
        """complete_upload

        Complete multipart upload. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.complete_upload(project, upload_completion_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param UploadCompletionSpec upload_completion_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.complete_upload_with_http_info(project, upload_completion_spec, **kwargs)  # noqa: E501

    def complete_upload_with_http_info(self, project, upload_completion_spec, **kwargs):  # noqa: E501
        """
        Complete multipart upload.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.complete_upload_with_http_info(project, upload_completion_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param UploadCompletionSpec upload_completion_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'upload_completion_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `complete_upload`")  # noqa: E501
        # verify the required parameter 'upload_completion_spec' is set
        if self.api_client.client_side_validation and ('upload_completion_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['upload_completion_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upload_completion_spec` when calling `complete_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upload_completion_spec' in local_var_params:
            body_params = local_var_params['upload_completion_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/UploadCompletion/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_affiliation(self, organization, affiliation_spec, **kwargs):
        """create_affiliation

        Create affiliation.  Affiliations specify a permission level of a user to an organization. There are currently two cumulative permission levels. `Member` can only view an organization and not change any data. `Admin` can modify an organization, add members to an organization, and create new projects under the organization's account. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_affiliation(organization, affiliation_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int organization: A unique integer identifying an organization. (required)
        :param AffiliationSpec affiliation_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_affiliation_with_http_info(organization, affiliation_spec, **kwargs)  # noqa: E501

    def create_affiliation_with_http_info(self, organization, affiliation_spec, **kwargs):  # noqa: E501
        """
        Create affiliation.  Affiliations specify a permission level of a user to an organization. There are currently two cumulative permission levels. `Member` can only view an organization and not change any data. `Admin` can modify an organization, add members to an organization, and create new projects under the organization's account.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_affiliation_with_http_info(organization, affiliation_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int organization: A unique integer identifying an organization. (required)
        :param AffiliationSpec affiliation_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'organization',
            'affiliation_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_affiliation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization' is set
        if self.api_client.client_side_validation and ('organization' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization` when calling `create_affiliation`")  # noqa: E501
        # verify the required parameter 'affiliation_spec' is set
        if self.api_client.client_side_validation and ('affiliation_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['affiliation_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `affiliation_spec` when calling `create_affiliation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization' in local_var_params:
            path_params['organization'] = local_var_params['organization']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'affiliation_spec' in local_var_params:
            body_params = local_var_params['affiliation_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Affiliations/{organization}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_analysis(self, project, analysis_spec, **kwargs):
        """create_analysis

        Create analysis.  Analysis objects are used to display information about filtered media lists and/or annotations on the project detail page of the web UI. Currently only counting analysis is supported. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_analysis(project, analysis_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param AnalysisSpec analysis_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_analysis_with_http_info(project, analysis_spec, **kwargs)  # noqa: E501

    def create_analysis_with_http_info(self, project, analysis_spec, **kwargs):  # noqa: E501
        """
        Create analysis.  Analysis objects are used to display information about filtered media lists and/or annotations on the project detail page of the web UI. Currently only counting analysis is supported.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_analysis_with_http_info(project, analysis_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param AnalysisSpec analysis_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'analysis_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_analysis" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_analysis`")  # noqa: E501
        # verify the required parameter 'analysis_spec' is set
        if self.api_client.client_side_validation and ('analysis_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['analysis_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `analysis_spec` when calling `create_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'analysis_spec' in local_var_params:
            body_params = local_var_params['analysis_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Analyses/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_audio_file(self, id, audio_definition, **kwargs):
        """create_audio_file

        Create audio file.  Audio files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying audio. One or more audio files can be used to reference the audio role in a `Media` object. The file itself must first be uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the audio file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_audio_file(id, audio_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param AudioDefinition audio_definition: (required)
        :param str role: Role of media file being referenced.
        :param int index: Insertion index. Must be less than size of current list of audio files for the specified `role`. If omitted, the audio file will be appended to the end of the list.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_audio_file_with_http_info(id, audio_definition, **kwargs)  # noqa: E501

    def create_audio_file_with_http_info(self, id, audio_definition, **kwargs):  # noqa: E501
        """
        Create audio file.  Audio files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying audio. One or more audio files can be used to reference the audio role in a `Media` object. The file itself must first be uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the audio file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_audio_file_with_http_info(id, audio_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param AudioDefinition audio_definition: (required)
        :param str role: Role of media file being referenced.
        :param int index: Insertion index. Must be less than size of current list of audio files for the specified `role`. If omitted, the audio file will be appended to the end of the list.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'audio_definition',
            'role',
            'index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_audio_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `create_audio_file`")  # noqa: E501
        # verify the required parameter 'audio_definition' is set
        if self.api_client.client_side_validation and ('audio_definition' not in local_var_params or  # noqa: E501
                                                        local_var_params['audio_definition'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `audio_definition` when calling `create_audio_file`")  # noqa: E501

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `create_audio_file`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'audio_definition' in local_var_params:
            body_params = local_var_params['audio_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/AudioFiles/{id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_bookmark(self, project, bookmark_spec, **kwargs):
        """create_bookmark

        Create bookmark.  Bookmarks are saved links that can be used to mark videos/frames of interest. They are scoped to a project and user, so if a user requests Bookmarks for a project they will only receive the Bookmarks created by them. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_bookmark(project, bookmark_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param BookmarkSpec bookmark_spec: (required)
        :param str name: Name of the bookmark to filter on.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_bookmark_with_http_info(project, bookmark_spec, **kwargs)  # noqa: E501

    def create_bookmark_with_http_info(self, project, bookmark_spec, **kwargs):  # noqa: E501
        """
        Create bookmark.  Bookmarks are saved links that can be used to mark videos/frames of interest. They are scoped to a project and user, so if a user requests Bookmarks for a project they will only receive the Bookmarks created by them.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_bookmark_with_http_info(project, bookmark_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param BookmarkSpec bookmark_spec: (required)
        :param str name: Name of the bookmark to filter on.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'bookmark_spec',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bookmark" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_bookmark`")  # noqa: E501
        # verify the required parameter 'bookmark_spec' is set
        if self.api_client.client_side_validation and ('bookmark_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['bookmark_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bookmark_spec` when calling `create_bookmark`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bookmark_spec' in local_var_params:
            body_params = local_var_params['bookmark_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Bookmarks/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_favorite(self, project, favorite_spec, **kwargs):
        """create_favorite

        Create favorite.  Favorites are saved annotation values to help speed up annotation. They are  scoped to a project and user, so if a user requests Favorites for a project they will only receive the Favorites created by them. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_favorite(project, favorite_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param FavoriteSpec favorite_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_favorite_with_http_info(project, favorite_spec, **kwargs)  # noqa: E501

    def create_favorite_with_http_info(self, project, favorite_spec, **kwargs):  # noqa: E501
        """
        Create favorite.  Favorites are saved annotation values to help speed up annotation. They are  scoped to a project and user, so if a user requests Favorites for a project they will only receive the Favorites created by them.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_favorite_with_http_info(project, favorite_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param FavoriteSpec favorite_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'favorite_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_favorite" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_favorite`")  # noqa: E501
        # verify the required parameter 'favorite_spec' is set
        if self.api_client.client_side_validation and ('favorite_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['favorite_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `favorite_spec` when calling `create_favorite`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'favorite_spec' in local_var_params:
            body_params = local_var_params['favorite_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Favorites/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_image_file(self, id, role, image_definition, **kwargs):
        """create_image_file

        Create image file.  Image files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying image. One or more image files can be used to reference thumbnails, thumbnail GIFs, or images in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the image file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_image_file(id, role, image_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param ImageDefinition image_definition: (required)
        :param int index: Insertion index. Must be less than size of current list of images for the specified `role`. If omitted, the image file will be appended to the end of the list.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_image_file_with_http_info(id, role, image_definition, **kwargs)  # noqa: E501

    def create_image_file_with_http_info(self, id, role, image_definition, **kwargs):  # noqa: E501
        """
        Create image file.  Image files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying image. One or more image files can be used to reference thumbnails, thumbnail GIFs, or images in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the image file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_image_file_with_http_info(id, role, image_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param ImageDefinition image_definition: (required)
        :param int index: Insertion index. Must be less than size of current list of images for the specified `role`. If omitted, the image file will be appended to the end of the list.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'role',
            'image_definition',
            'index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_image_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `create_image_file`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `create_image_file`")  # noqa: E501
        # verify the required parameter 'image_definition' is set
        if self.api_client.client_side_validation and ('image_definition' not in local_var_params or  # noqa: E501
                                                        local_var_params['image_definition'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `image_definition` when calling `create_image_file`")  # noqa: E501

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `create_image_file`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'image_definition' in local_var_params:
            body_params = local_var_params['image_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/ImageFiles/{id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_leaf_list(self, project, leaf_spec, **kwargs):
        """create_leaf_list

        Create leaf list.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes.   This method does a bulk create on a list of `LeafSpec` objects. A  maximum of 500 leaves may be created in one request. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_leaf_list(project, leaf_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[LeafSpec] leaf_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateListResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_leaf_list_with_http_info(project, leaf_spec, **kwargs)  # noqa: E501

    def create_leaf_list_with_http_info(self, project, leaf_spec, **kwargs):  # noqa: E501
        """
        Create leaf list.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes.   This method does a bulk create on a list of `LeafSpec` objects. A  maximum of 500 leaves may be created in one request.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_leaf_list_with_http_info(project, leaf_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[LeafSpec] leaf_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateListResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'leaf_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_leaf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_leaf_list`")  # noqa: E501
        # verify the required parameter 'leaf_spec' is set
        if self.api_client.client_side_validation and ('leaf_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['leaf_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `leaf_spec` when calling `create_leaf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'leaf_spec' in local_var_params:
            body_params = local_var_params['leaf_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaves/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_leaf_type(self, project, leaf_type_spec, **kwargs):
        """create_leaf_type

        Create leaf type.  A leaf type is the metadata definition object for a leaf. It includes name, description, and may have any number of user-defined attribute types associated with it. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_leaf_type(project, leaf_type_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param LeafTypeSpec leaf_type_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_leaf_type_with_http_info(project, leaf_type_spec, **kwargs)  # noqa: E501

    def create_leaf_type_with_http_info(self, project, leaf_type_spec, **kwargs):  # noqa: E501
        """
        Create leaf type.  A leaf type is the metadata definition object for a leaf. It includes name, description, and may have any number of user-defined attribute types associated with it.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_leaf_type_with_http_info(project, leaf_type_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param LeafTypeSpec leaf_type_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'leaf_type_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_leaf_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_leaf_type`")  # noqa: E501
        # verify the required parameter 'leaf_type_spec' is set
        if self.api_client.client_side_validation and ('leaf_type_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['leaf_type_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `leaf_type_spec` when calling `create_leaf_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'leaf_type_spec' in local_var_params:
            body_params = local_var_params['leaf_type_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LeafTypes/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_localization_list(self, project, localization_spec, **kwargs):
        """create_localization_list

        Create localiazation list.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes.   This method does a bulk create on a list of `LocalizationSpec` objects. A  maximum of 500 localizations may be created in one request. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_localization_list(project, localization_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[LocalizationSpec] localization_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateListResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_localization_list_with_http_info(project, localization_spec, **kwargs)  # noqa: E501

    def create_localization_list_with_http_info(self, project, localization_spec, **kwargs):  # noqa: E501
        """
        Create localiazation list.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes.   This method does a bulk create on a list of `LocalizationSpec` objects. A  maximum of 500 localizations may be created in one request.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_localization_list_with_http_info(project, localization_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[LocalizationSpec] localization_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateListResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'localization_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_localization_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_localization_list`")  # noqa: E501
        # verify the required parameter 'localization_spec' is set
        if self.api_client.client_side_validation and ('localization_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['localization_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `localization_spec` when calling `create_localization_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'localization_spec' in local_var_params:
            body_params = local_var_params['localization_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localizations/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_localization_type(self, project, localization_type_spec, **kwargs):
        """create_localization_type

        Create localization type.  A localization type is the metadata definition object for a localization. It includes shape, name, description, and may have any number of user-defined attribute types associated with it. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_localization_type(project, localization_type_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param LocalizationTypeSpec localization_type_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_localization_type_with_http_info(project, localization_type_spec, **kwargs)  # noqa: E501

    def create_localization_type_with_http_info(self, project, localization_type_spec, **kwargs):  # noqa: E501
        """
        Create localization type.  A localization type is the metadata definition object for a localization. It includes shape, name, description, and may have any number of user-defined attribute types associated with it.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_localization_type_with_http_info(project, localization_type_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param LocalizationTypeSpec localization_type_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'localization_type_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_localization_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_localization_type`")  # noqa: E501
        # verify the required parameter 'localization_type_spec' is set
        if self.api_client.client_side_validation and ('localization_type_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['localization_type_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `localization_type_spec` when calling `create_localization_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'localization_type_spec' in local_var_params:
            body_params = local_var_params['localization_type_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationTypes/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_media(self, project, media_spec, **kwargs):
        """create_media

        Create media.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.   This method creates a `Media` object in the database. For images, the  media must already be uploaded and an upload URL must be provided, as well as the group and job IDs associated with the upload. For videos, it is recommended to use the `Transcode` endpoint, which will create the media object itself. This method is only needed for local  transcodes. In that case, it will create an empty Media object; thumbnails, streaming, and archival videos must be subsequently uploaded  and saved via the `Media` PATCH method. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_media(project, media_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param MediaSpec media_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_media_with_http_info(project, media_spec, **kwargs)  # noqa: E501

    def create_media_with_http_info(self, project, media_spec, **kwargs):  # noqa: E501
        """
        Create media.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.   This method creates a `Media` object in the database. For images, the  media must already be uploaded and an upload URL must be provided, as well as the group and job IDs associated with the upload. For videos, it is recommended to use the `Transcode` endpoint, which will create the media object itself. This method is only needed for local  transcodes. In that case, it will create an empty Media object; thumbnails, streaming, and archival videos must be subsequently uploaded  and saved via the `Media` PATCH method.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_media_with_http_info(project, media_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param MediaSpec media_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_media" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_media`")  # noqa: E501
        # verify the required parameter 'media_spec' is set
        if self.api_client.client_side_validation and ('media_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['media_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `media_spec` when calling `create_media`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'media_spec' in local_var_params:
            body_params = local_var_params['media_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Medias/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_media_type(self, project, media_type_spec, **kwargs):
        """create_media_type

        Create media type.  A media type is the metadata definition object for media. It includes file format, name, description, and may have any number of user defined attribute types associated with it. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_media_type(project, media_type_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param MediaTypeSpec media_type_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_media_type_with_http_info(project, media_type_spec, **kwargs)  # noqa: E501

    def create_media_type_with_http_info(self, project, media_type_spec, **kwargs):  # noqa: E501
        """
        Create media type.  A media type is the metadata definition object for media. It includes file format, name, description, and may have any number of user defined attribute types associated with it.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_media_type_with_http_info(project, media_type_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param MediaTypeSpec media_type_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_type_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_media_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_media_type`")  # noqa: E501
        # verify the required parameter 'media_type_spec' is set
        if self.api_client.client_side_validation and ('media_type_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['media_type_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `media_type_spec` when calling `create_media_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'media_type_spec' in local_var_params:
            body_params = local_var_params['media_type_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaTypes/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_membership(self, project, membership_spec, **kwargs):
        """create_membership

        Create membership.  Memberships specify a permission level of a user to a project. There are currently five cumulative permission levels: - `View Only` can only view a project and not change any data. - `Can Edit` can create, modify, and delete annotations. - `Can Transfer` can upload and download media. - `Can Execute` can launch algorithm workflows. - `Full Control` can change project settings, including inviting new members, project name, and    project metadata schema. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_membership(project, membership_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param MembershipSpec membership_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_membership_with_http_info(project, membership_spec, **kwargs)  # noqa: E501

    def create_membership_with_http_info(self, project, membership_spec, **kwargs):  # noqa: E501
        """
        Create membership.  Memberships specify a permission level of a user to a project. There are currently five cumulative permission levels: - `View Only` can only view a project and not change any data. - `Can Edit` can create, modify, and delete annotations. - `Can Transfer` can upload and download media. - `Can Execute` can launch algorithm workflows. - `Full Control` can change project settings, including inviting new members, project name, and    project metadata schema.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_membership_with_http_info(project, membership_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param MembershipSpec membership_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'membership_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_membership" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_membership`")  # noqa: E501
        # verify the required parameter 'membership_spec' is set
        if self.api_client.client_side_validation and ('membership_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['membership_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `membership_spec` when calling `create_membership`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'membership_spec' in local_var_params:
            body_params = local_var_params['membership_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Memberships/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_obtain_auth_token(self, **kwargs):
        """create_obtain_auth_token


        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_obtain_auth_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Credentials credentials:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Token`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_obtain_auth_token_with_http_info(**kwargs)  # noqa: E501

    def create_obtain_auth_token_with_http_info(self, **kwargs):  # noqa: E501
        """

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_obtain_auth_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Credentials credentials:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Token`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'credentials'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_obtain_auth_token" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'credentials' in local_var_params:
            body_params = local_var_params['credentials']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Token', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Token',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_organization(self, organization_spec, **kwargs):
        """create_organization

        Create organization.  Organizations are used to represent groups of users. Multiple projects may be owned by an organization, and users may be members of multiple organizations.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_organization(organization_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganizationSpec organization_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_organization_with_http_info(organization_spec, **kwargs)  # noqa: E501

    def create_organization_with_http_info(self, organization_spec, **kwargs):  # noqa: E501
        """
        Create organization.  Organizations are used to represent groups of users. Multiple projects may be owned by an organization, and users may be members of multiple organizations.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_organization_with_http_info(organization_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganizationSpec organization_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'organization_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_organization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_spec' is set
        if self.api_client.client_side_validation and ('organization_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_spec` when calling `create_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'organization_spec' in local_var_params:
            body_params = local_var_params['organization_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Organizations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_project(self, project_spec, **kwargs):
        """create_project

        Create project.  Projects are the object under which all data in Tator is grouped, including user access, metadata definitions, media, and annotations. Data does not cross boundaries between projects.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_project(project_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProjectSpec project_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_project_with_http_info(project_spec, **kwargs)  # noqa: E501

    def create_project_with_http_info(self, project_spec, **kwargs):  # noqa: E501
        """
        Create project.  Projects are the object under which all data in Tator is grouped, including user access, metadata definitions, media, and annotations. Data does not cross boundaries between projects.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_project_with_http_info(project_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProjectSpec project_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_spec' is set
        if self.api_client.client_side_validation and ('project_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_spec` when calling `create_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'project_spec' in local_var_params:
            body_params = local_var_params['project_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_section(self, project, section_spec, **kwargs):
        """create_section

        Create section.  Sections represent groups of media using saved queries. The queries can be in the form of a <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>lucene search string</a> or a list of <a href=https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-bool-query.html>boolean filter queries</a> applied to either media or child annotations of media. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_section(project, section_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param SectionSpec section_spec: (required)
        :param str name: Name of the section.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_section_with_http_info(project, section_spec, **kwargs)  # noqa: E501

    def create_section_with_http_info(self, project, section_spec, **kwargs):  # noqa: E501
        """
        Create section.  Sections represent groups of media using saved queries. The queries can be in the form of a <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>lucene search string</a> or a list of <a href=https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-bool-query.html>boolean filter queries</a> applied to either media or child annotations of media.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_section_with_http_info(project, section_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param SectionSpec section_spec: (required)
        :param str name: Name of the section.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'section_spec',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_section" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_section`")  # noqa: E501
        # verify the required parameter 'section_spec' is set
        if self.api_client.client_side_validation and ('section_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['section_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `section_spec` when calling `create_section`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'section_spec' in local_var_params:
            body_params = local_var_params['section_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Sections/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_state_list(self, project, state_spec, **kwargs):
        """create_state_list

        Create state list.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes.   This method does a bulk create on a list of `StateSpec` objects. A  maximum of 500 states may be created in one request. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_state_list(project, state_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[StateSpec] state_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateListResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_state_list_with_http_info(project, state_spec, **kwargs)  # noqa: E501

    def create_state_list_with_http_info(self, project, state_spec, **kwargs):  # noqa: E501
        """
        Create state list.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes.   This method does a bulk create on a list of `StateSpec` objects. A  maximum of 500 states may be created in one request.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_state_list_with_http_info(project, state_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[StateSpec] state_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateListResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'state_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_state_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_state_list`")  # noqa: E501
        # verify the required parameter 'state_spec' is set
        if self.api_client.client_side_validation and ('state_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['state_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `state_spec` when calling `create_state_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'state_spec' in local_var_params:
            body_params = local_var_params['state_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/States/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_state_type(self, project, state_type_spec, **kwargs):
        """create_state_type

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and may have any number of user-defined attribute types associated with it. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_state_type(project, state_type_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param StateTypeSpec state_type_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_state_type_with_http_info(project, state_type_spec, **kwargs)  # noqa: E501

    def create_state_type_with_http_info(self, project, state_type_spec, **kwargs):  # noqa: E501
        """
        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and may have any number of user-defined attribute types associated with it.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_state_type_with_http_info(project, state_type_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param StateTypeSpec state_type_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'state_type_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_state_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_state_type`")  # noqa: E501
        # verify the required parameter 'state_type_spec' is set
        if self.api_client.client_side_validation and ('state_type_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['state_type_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `state_type_spec` when calling `create_state_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'state_type_spec' in local_var_params:
            body_params = local_var_params['state_type_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateTypes/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_temporary_file(self, project, temporary_file_spec, **kwargs):
        """create_temporary_file

        Create temporary file.  Temporary files are files stored server side for a defined duration.   The file must first be uploaded via tus, and can subsequently be saved using this endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_temporary_file(project, temporary_file_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param TemporaryFileSpec temporary_file_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_temporary_file_with_http_info(project, temporary_file_spec, **kwargs)  # noqa: E501

    def create_temporary_file_with_http_info(self, project, temporary_file_spec, **kwargs):  # noqa: E501
        """
        Create temporary file.  Temporary files are files stored server side for a defined duration.   The file must first be uploaded via tus, and can subsequently be saved using this endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_temporary_file_with_http_info(project, temporary_file_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param TemporaryFileSpec temporary_file_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'temporary_file_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_temporary_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_temporary_file`")  # noqa: E501
        # verify the required parameter 'temporary_file_spec' is set
        if self.api_client.client_side_validation and ('temporary_file_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['temporary_file_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `temporary_file_spec` when calling `create_temporary_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'temporary_file_spec' in local_var_params:
            body_params = local_var_params['temporary_file_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TemporaryFiles/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_version(self, project, version_spec, **kwargs):
        """create_version

        Create version.  Versions allow for multiple \"layers\" of annotations on the same media. Versions are created at the project level, but are only displayed for a given media if that media contains annotations in that version. The version of an annotation can be set by providing it in a POST operation. Currently only localizations and states can have versions. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_version(project, version_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param VersionSpec version_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_version_with_http_info(project, version_spec, **kwargs)  # noqa: E501

    def create_version_with_http_info(self, project, version_spec, **kwargs):  # noqa: E501
        """
        Create version.  Versions allow for multiple \"layers\" of annotations on the same media. Versions are created at the project level, but are only displayed for a given media if that media contains annotations in that version. The version of an annotation can be set by providing it in a POST operation. Currently only localizations and states can have versions.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_version_with_http_info(project, version_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param VersionSpec version_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'version_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_version`")  # noqa: E501
        # verify the required parameter 'version_spec' is set
        if self.api_client.client_side_validation and ('version_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['version_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_spec` when calling `create_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'version_spec' in local_var_params:
            body_params = local_var_params['version_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Versions/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_video_file(self, id, role, video_definition, **kwargs):
        """create_video_file

        Create video file.  Video files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying video. One or more video files can be used to reference streaming or archival roles in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the video file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_video_file(id, role, video_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param VideoDefinition video_definition: (required)
        :param int index: Insertion index. Must be less than size of current list of videos for the specified `role`. If omitted, the video file will be appended to the end of the list.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_video_file_with_http_info(id, role, video_definition, **kwargs)  # noqa: E501

    def create_video_file_with_http_info(self, id, role, video_definition, **kwargs):  # noqa: E501
        """
        Create video file.  Video files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying video. One or more video files can be used to reference streaming or archival roles in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the video file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_video_file_with_http_info(id, role, video_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param VideoDefinition video_definition: (required)
        :param int index: Insertion index. Must be less than size of current list of videos for the specified `role`. If omitted, the video file will be appended to the end of the list.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'role',
            'video_definition',
            'index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_video_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `create_video_file`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `create_video_file`")  # noqa: E501
        # verify the required parameter 'video_definition' is set
        if self.api_client.client_side_validation and ('video_definition' not in local_var_params or  # noqa: E501
                                                        local_var_params['video_definition'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `video_definition` when calling `create_video_file`")  # noqa: E501

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `create_video_file`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'video_definition' in local_var_params:
            body_params = local_var_params['video_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/VideoFiles/{id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_affiliation(self, id, **kwargs):
        """delete_affiliation

        Delete affiliation.  Affiliations specify a permission level of a user to an organization. There are currently two cumulative permission levels. `Member` can only view an organization and not change any data. `Admin` can modify an organization, add members to an organization, and create new projects under the organization's account. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_affiliation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a affiliation. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_affiliation_with_http_info(id, **kwargs)  # noqa: E501

    def delete_affiliation_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete affiliation.  Affiliations specify a permission level of a user to an organization. There are currently two cumulative permission levels. `Member` can only view an organization and not change any data. `Admin` can modify an organization, add members to an organization, and create new projects under the organization's account.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_affiliation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a affiliation. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_affiliation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_affiliation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Affiliation/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_algorithm(self, id, **kwargs):
        """delete_algorithm

        Delete registered algorithm workflow

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_algorithm(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a registered algorithm workflow. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_algorithm_with_http_info(id, **kwargs)  # noqa: E501

    def delete_algorithm_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete registered algorithm workflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_algorithm_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a registered algorithm workflow. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_algorithm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Algorithm/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_analysis(self, id, **kwargs):
        """delete_analysis

        Delete analysis record

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_analysis(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an analysis record. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_analysis_with_http_info(id, **kwargs)  # noqa: E501

    def delete_analysis_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete analysis record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_analysis_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an analysis record. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_analysis" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Analysis/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_attribute(self, id, attribute_type_delete, **kwargs):
        """delete_attribute

        Delete an existing attribute on Type.  A attribute type is the metadata definition object for a user-defined attribute. It includes name, type, and any other associated fields, depending on the type. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_attribute(id, attribute_type_delete, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a unique entity type. (required)
        :param AttributeTypeDelete attribute_type_delete: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_attribute_with_http_info(id, attribute_type_delete, **kwargs)  # noqa: E501

    def delete_attribute_with_http_info(self, id, attribute_type_delete, **kwargs):  # noqa: E501
        """
        Delete an existing attribute on Type.  A attribute type is the metadata definition object for a user-defined attribute. It includes name, type, and any other associated fields, depending on the type.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_attribute_with_http_info(id, attribute_type_delete, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a unique entity type. (required)
        :param AttributeTypeDelete attribute_type_delete: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'attribute_type_delete'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_attribute" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_attribute`")  # noqa: E501
        # verify the required parameter 'attribute_type_delete' is set
        if self.api_client.client_side_validation and ('attribute_type_delete' not in local_var_params or  # noqa: E501
                                                        local_var_params['attribute_type_delete'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attribute_type_delete` when calling `delete_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'attribute_type_delete' in local_var_params:
            body_params = local_var_params['attribute_type_delete']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/AttributeType/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_audio_file(self, id, index, **kwargs):
        """delete_audio_file

        Delete audio file.  Audio files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying audio. One or more audio files can be used to reference the audio role in a `Media` object. The file itself must first be uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the audio file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_audio_file(id, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param int index: Index of object. Must be less than size of current list of audio files for the specified `role`. (required)
        :param str role: Role of media file being referenced.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_audio_file_with_http_info(id, index, **kwargs)  # noqa: E501

    def delete_audio_file_with_http_info(self, id, index, **kwargs):  # noqa: E501
        """
        Delete audio file.  Audio files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying audio. One or more audio files can be used to reference the audio role in a `Media` object. The file itself must first be uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the audio file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_audio_file_with_http_info(id, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param int index: Index of object. Must be less than size of current list of audio files for the specified `role`. (required)
        :param str role: Role of media file being referenced.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'index',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_audio_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_audio_file`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and ('index' not in local_var_params or  # noqa: E501
                                                        local_var_params['index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `index` when calling `delete_audio_file`")  # noqa: E501

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `delete_audio_file`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/AudioFile/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_bookmark(self, id, **kwargs):
        """delete_bookmark

        Delete bookmark.  Bookmarks are saved links that can be used to mark videos/frames of interest. They are scoped to a project and user, so if a user requests Bookmarks for a project they will only receive the Bookmarks created by them. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_bookmark(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a bookmark. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_bookmark_with_http_info(id, **kwargs)  # noqa: E501

    def delete_bookmark_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete bookmark.  Bookmarks are saved links that can be used to mark videos/frames of interest. They are scoped to a project and user, so if a user requests Bookmarks for a project they will only receive the Bookmarks created by them.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_bookmark_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a bookmark. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bookmark" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_bookmark`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Bookmark/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_favorite(self, id, **kwargs):
        """delete_favorite

        Delete favorite.  Favorites are saved annotation values to help speed up annotation. They are  scoped to a project and user, so if a user requests Favorites for a project they will only receive the Favorites created by them. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_favorite(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a favorite. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_favorite_with_http_info(id, **kwargs)  # noqa: E501

    def delete_favorite_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete favorite.  Favorites are saved annotation values to help speed up annotation. They are  scoped to a project and user, so if a user requests Favorites for a project they will only receive the Favorites created by them.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_favorite_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a favorite. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_favorite" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_favorite`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Favorite/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_image_file(self, id, role, index, **kwargs):
        """delete_image_file

        Delete image file.  Image files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying image. One or more image files can be used to reference thumbnails, thumbnail GIFs, or images in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the image file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_image_file(id, role, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param int index: Index of object. Must be less than size of current list of images for the specified `role`. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_image_file_with_http_info(id, role, index, **kwargs)  # noqa: E501

    def delete_image_file_with_http_info(self, id, role, index, **kwargs):  # noqa: E501
        """
        Delete image file.  Image files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying image. One or more image files can be used to reference thumbnails, thumbnail GIFs, or images in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the image file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_image_file_with_http_info(id, role, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param int index: Index of object. Must be less than size of current list of images for the specified `role`. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'role',
            'index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_image_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_image_file`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `delete_image_file`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and ('index' not in local_var_params or  # noqa: E501
                                                        local_var_params['index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `index` when calling `delete_image_file`")  # noqa: E501

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `delete_image_file`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/ImageFile/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_job(self, uid, **kwargs):
        """delete_job

        Delete background job.  Algorithms and transcodes create argo workflows that are annotated with two uuid1 strings, one identifying the run and the other identifying the group. Jobs that are submitted together have the same group id, but each workflow has a unique run id.   This method allows the user to cancel a job using the `uid` returned by either the `AlgorithmLaunch` or `Transcode` endpoints. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: A uuid1 string identifying to single Job. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_job_with_http_info(uid, **kwargs)  # noqa: E501

    def delete_job_with_http_info(self, uid, **kwargs):  # noqa: E501
        """
        Delete background job.  Algorithms and transcodes create argo workflows that are annotated with two uuid1 strings, one identifying the run and the other identifying the group. Jobs that are submitted together have the same group id, but each workflow has a unique run id.   This method allows the user to cancel a job using the `uid` returned by either the `AlgorithmLaunch` or `Transcode` endpoints.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: A uuid1 string identifying to single Job. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `delete_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in local_var_params:
            path_params['uid'] = local_var_params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Job/{uid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_job_list(self, project, **kwargs):
        """delete_job_list

        Delete background job list.  Algorithms and transcodes create argo workflows that are annotated with two uuid1 strings, one identifying the run and the other identifying the group. Jobs that are submitted together have the same group id, but each workflow has a unique run id.   This method allows the user to batch delete a list of jobs that were created by either the `AlgorithmLaunch` or `Transcode` endpoints. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str gid: A UUID string identifying a group of jobs.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_job_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_job_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Delete background job list.  Algorithms and transcodes create argo workflows that are annotated with two uuid1 strings, one identifying the run and the other identifying the group. Jobs that are submitted together have the same group id, but each workflow has a unique run id.   This method allows the user to batch delete a list of jobs that were created by either the `AlgorithmLaunch` or `Transcode` endpoints.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str gid: A UUID string identifying a group of jobs.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'gid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_job_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Jobs/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_leaf(self, id, **kwargs):
        """delete_leaf

        Delete leaf.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a leaf. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_leaf_with_http_info(id, **kwargs)  # noqa: E501

    def delete_leaf_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete leaf.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a leaf. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_leaf" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_leaf`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaf/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_leaf_list(self, project, **kwargs):
        """delete_leaf_list

        Delete leaf list.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes.   This method performs a bulk delete on all leaves matching a query. It is  recommended to use a GET request first to check what is being deleted. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int type: Unique integer identifying a leaf type.
        :param str name: Name of the leaf element.
        :param int depth: Get a specific tree depth. Root node depth is 0.
        :param list[int] leaf_id: Comma-separated list of leaf IDs.
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_leaf_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_leaf_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Delete leaf list.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes.   This method performs a bulk delete on all leaves matching a query. It is  recommended to use a GET request first to check what is being deleted.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int type: Unique integer identifying a leaf type.
        :param str name: Name of the leaf element.
        :param int depth: Get a specific tree depth. Root node depth is 0.
        :param list[int] leaf_id: Comma-separated list of leaf IDs.
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'type',
            'name',
            'depth',
            'leaf_id',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_leaf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_leaf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'depth' in local_var_params and local_var_params['depth'] is not None:  # noqa: E501
            query_params.append(('depth', local_var_params['depth']))  # noqa: E501
        if 'leaf_id' in local_var_params and local_var_params['leaf_id'] is not None:  # noqa: E501
            query_params.append(('leaf_id', local_var_params['leaf_id']))  # noqa: E501
            collection_formats['leaf_id'] = 'multi'  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaves/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_leaf_type(self, id, **kwargs):
        """delete_leaf_type

        Delete leaf type.  A leaf type is the metadata definition object for a leaf. It includes name, description, and may have any number of user-defined attribute types associated with it. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf_type(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an leaf type. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_leaf_type_with_http_info(id, **kwargs)  # noqa: E501

    def delete_leaf_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete leaf type.  A leaf type is the metadata definition object for a leaf. It includes name, description, and may have any number of user-defined attribute types associated with it.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an leaf type. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_leaf_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_leaf_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LeafType/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_localization(self, id, **kwargs):
        """delete_localization

        Delete localization.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_localization_with_http_info(id, **kwargs)  # noqa: E501

    def delete_localization_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete localization.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_localization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_localization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localization/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_localization_list(self, project, **kwargs):
        """delete_localization_list

        Delete localiazation list.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes.   This method performs a bulk delete on all localizations matching a query. It is  recommended to use a GET request first to check what is being deleted. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param int exclude_parents: If a clone is present, do not send parent. This parameter will cause an exception if an Elasticsearch query is triggered and pagination parameters (start or stop) are included.
        :param int frame: Frame number of this localization if it is in a video.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_localization_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_localization_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Delete localiazation list.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes.   This method performs a bulk delete on all localizations matching a query. It is  recommended to use a GET request first to check what is being deleted.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param int exclude_parents: If a clone is present, do not send parent. This parameter will cause an exception if an Elasticsearch query is triggered and pagination parameters (start or stop) are included.
        :param int frame: Frame number of this localization if it is in a video.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es',
            'exclude_parents',
            'frame'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_localization_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_localization_list`")  # noqa: E501

        if self.api_client.client_side_validation and 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] > 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exclude_parents` when calling `delete_localization_list`, must be a value less than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exclude_parents` when calling `delete_localization_list`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'frame' in local_var_params and local_var_params['frame'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frame` when calling `delete_localization_list`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501
        if 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] is not None:  # noqa: E501
            query_params.append(('excludeParents', local_var_params['exclude_parents']))  # noqa: E501
        if 'frame' in local_var_params and local_var_params['frame'] is not None:  # noqa: E501
            query_params.append(('frame', local_var_params['frame']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localizations/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_localization_type(self, id, **kwargs):
        """delete_localization_type

        Delete localization type.  A localization type is the metadata definition object for a localization. It includes shape, name, description, and may have any number of user-defined attribute types associated with it.   Note that this will also delete any localizations associated with the localization type. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization_type(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization type. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_localization_type_with_http_info(id, **kwargs)  # noqa: E501

    def delete_localization_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete localization type.  A localization type is the metadata definition object for a localization. It includes shape, name, description, and may have any number of user-defined attribute types associated with it.   Note that this will also delete any localizations associated with the localization type.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization type. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_localization_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_localization_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationType/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_media(self, id, **kwargs):
        """delete_media

        Delete media.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_media_with_http_info(id, **kwargs)  # noqa: E501

    def delete_media_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete media.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_media" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_media`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Media/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_media_list(self, project, **kwargs):
        """delete_media_list

        Delete media list.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.   This method performs a bulk delete on all media matching a query. It is  recommended to use a GET request first to check what is being deleted. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_media_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_media_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Delete media list.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.   This method performs a bulk delete on all media matching a query. It is  recommended to use a GET request first to check what is being deleted.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type',
            'name',
            'section',
            'dtype',
            'md5',
            'gid',
            'uid',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_media_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_media_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'section' in local_var_params and local_var_params['section'] is not None:  # noqa: E501
            query_params.append(('section', local_var_params['section']))  # noqa: E501
        if 'dtype' in local_var_params and local_var_params['dtype'] is not None:  # noqa: E501
            query_params.append(('dtype', local_var_params['dtype']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Medias/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_media_type(self, id, **kwargs):
        """delete_media_type

        Delete media type.  A media type is the metadata definition object for media. It includes file format, name, description, and may have any number of user defined attribute types associated with it.   Note that this will also delete any media associated with the media type. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media_type(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an media type. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_media_type_with_http_info(id, **kwargs)  # noqa: E501

    def delete_media_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete media type.  A media type is the metadata definition object for media. It includes file format, name, description, and may have any number of user defined attribute types associated with it.   Note that this will also delete any media associated with the media type.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an media type. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_media_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_media_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaType/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_membership(self, id, **kwargs):
        """delete_membership

        Delete membership.  Memberships specify a permission level of a user to a project. There are currently five cumulative permission levels: - `View Only` can only view a project and not change any data. - `Can Edit` can create, modify, and delete annotations. - `Can Transfer` can upload and download media. - `Can Execute` can launch algorithm workflows. - `Full Control` can change project settings, including inviting new members, project name, and    project metadata schema. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_membership(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a membership. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_membership_with_http_info(id, **kwargs)  # noqa: E501

    def delete_membership_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete membership.  Memberships specify a permission level of a user to a project. There are currently five cumulative permission levels: - `View Only` can only view a project and not change any data. - `Can Edit` can create, modify, and delete annotations. - `Can Transfer` can upload and download media. - `Can Execute` can launch algorithm workflows. - `Full Control` can change project settings, including inviting new members, project name, and    project metadata schema.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_membership_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a membership. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_membership" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_membership`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Membership/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_organization(self, id, **kwargs):
        """delete_organization

        Delete organization.  Organizations are used to represent groups of users. Multiple projects may be owned by an organization, and users may be members of multiple organizations.   Only organization owners may delete an organization. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_organization(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an organization. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_organization_with_http_info(id, **kwargs)  # noqa: E501

    def delete_organization_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete organization.  Organizations are used to represent groups of users. Multiple projects may be owned by an organization, and users may be members of multiple organizations.   Only organization owners may delete an organization.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_organization_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an organization. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Organization/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project(self, id, **kwargs):
        """delete_project

        Delete project.  Projects are the object under which all data in Tator is grouped, including user access, metadata definitions, media, and annotations. Data does not cross boundaries between projects.   Only project owners may delete a project. Note that deleting a project will also delete all media and annotations within a project. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_project(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a project. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_project_with_http_info(id, **kwargs)  # noqa: E501

    def delete_project_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete project.  Projects are the object under which all data in Tator is grouped, including user access, metadata definitions, media, and annotations. Data does not cross boundaries between projects.   Only project owners may delete a project. Note that deleting a project will also delete all media and annotations within a project.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_project_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a project. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Project/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_section(self, id, **kwargs):
        """delete_section

        Delete section.  Sections represent groups of media using saved queries. The queries can be in the form of a <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>lucene search string</a> or a list of <a href=https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-bool-query.html>boolean filter queries</a> applied to either media or child annotations of media. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_section(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a section. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_section_with_http_info(id, **kwargs)  # noqa: E501

    def delete_section_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete section.  Sections represent groups of media using saved queries. The queries can be in the form of a <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>lucene search string</a> or a list of <a href=https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-bool-query.html>boolean filter queries</a> applied to either media or child annotations of media.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_section_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a section. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_section" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_section`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Section/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_state(self, id, **kwargs):
        """delete_state

        Delete state.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a state. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_state_with_http_info(id, **kwargs)  # noqa: E501

    def delete_state_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete state.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a state. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/State/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_state_list(self, project, **kwargs):
        """delete_state_list

        Delete state list.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes.   This method performs a bulk delete on all states matching a query. It is  recommended to use a GET request first to check what is being deleted. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_state_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_state_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Delete state list.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes.   This method performs a bulk delete on all states matching a query. It is  recommended to use a GET request first to check what is being deleted.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_state_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_state_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/States/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_state_type(self, id, **kwargs):
        """delete_state_type

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and may have any number of user-defined attribute types associated with it.   Note that this will also delete any states associated with the state type. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state_type(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a state type. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_state_type_with_http_info(id, **kwargs)  # noqa: E501

    def delete_state_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and may have any number of user-defined attribute types associated with it.   Note that this will also delete any states associated with the state type.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a state type. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_state_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_state_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateType/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_temporary_file(self, id, **kwargs):
        """delete_temporary_file

        Delete temporary file.  Temporary files are files stored server side for a defined duration. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_temporary_file(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a temporary file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_temporary_file_with_http_info(id, **kwargs)  # noqa: E501

    def delete_temporary_file_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete temporary file.  Temporary files are files stored server side for a defined duration.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_temporary_file_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a temporary file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_temporary_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_temporary_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TemporaryFile/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_temporary_file_list(self, project, **kwargs):
        """delete_temporary_file_list

        Delete temporary file list.  Temporary files are files stored server side for a defined duration.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_temporary_file_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int expired: If greater than 0 will return only expired files
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_temporary_file_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_temporary_file_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Delete temporary file list.  Temporary files are files stored server side for a defined duration.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_temporary_file_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int expired: If greater than 0 will return only expired files
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'expired'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_temporary_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_temporary_file_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'expired' in local_var_params and local_var_params['expired'] is not None:  # noqa: E501
            query_params.append(('expired', local_var_params['expired']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TemporaryFiles/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_version(self, id, **kwargs):
        """delete_version

        Delete version.  Versions allow for multiple \"layers\" of annotations on the same media. Versions are created at the project level, but are only displayed for a given media if that media contains annotations in that version. The version of an annotation can be set by providing it in a POST operation. Currently only localizations and states can have versions.   Note that this will also delete any localizations or states associated with the deleted version. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_version(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a version. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_version_with_http_info(id, **kwargs)  # noqa: E501

    def delete_version_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Delete version.  Versions allow for multiple \"layers\" of annotations on the same media. Versions are created at the project level, but are only displayed for a given media if that media contains annotations in that version. The version of an annotation can be set by providing it in a POST operation. Currently only localizations and states can have versions.   Note that this will also delete any localizations or states associated with the deleted version.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_version_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a version. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Version/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_video_file(self, id, role, index, **kwargs):
        """delete_video_file

        Delete video file.  Video files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying video. One or more video files can be used to reference streaming or archival roles in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the video file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_video_file(id, role, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param int index: Index of object. Must be less than size of current list of videos for the specified `role`. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_video_file_with_http_info(id, role, index, **kwargs)  # noqa: E501

    def delete_video_file_with_http_info(self, id, role, index, **kwargs):  # noqa: E501
        """
        Delete video file.  Video files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying video. One or more video files can be used to reference streaming or archival roles in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the video file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_video_file_with_http_info(id, role, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param int index: Index of object. Must be less than size of current list of videos for the specified `role`. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'role',
            'index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_video_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_video_file`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `delete_video_file`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and ('index' not in local_var_params or  # noqa: E501
                                                        local_var_params['index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `index` when calling `delete_video_file`")  # noqa: E501

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `delete_video_file`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/VideoFile/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_affiliation(self, id, **kwargs):
        """get_affiliation

        Get affiliation.  Affiliations specify a permission level of a user to an organization. There are currently two cumulative permission levels. `Member` can only view an organization and not change any data. `Admin` can modify an organization, add members to an organization, and create new projects under the organization's account. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_affiliation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a affiliation. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Affiliation`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_affiliation_with_http_info(id, **kwargs)  # noqa: E501

    def get_affiliation_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get affiliation.  Affiliations specify a permission level of a user to an organization. There are currently two cumulative permission levels. `Member` can only view an organization and not change any data. `Admin` can modify an organization, add members to an organization, and create new projects under the organization's account.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_affiliation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a affiliation. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Affiliation`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_affiliation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_affiliation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Affiliation/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Affiliation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_affiliation_list(self, organization, **kwargs):
        """get_affiliation_list

        Get affiliation list.  Affiliations specify a permission level of a user to an organization. There are currently two cumulative permission levels. `Member` can only view an organization and not change any data. `Admin` can modify an organization, add members to an organization, and create new projects under the organization's account. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_affiliation_list(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int organization: A unique integer identifying an organization. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Affiliation]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_affiliation_list_with_http_info(organization, **kwargs)  # noqa: E501

    def get_affiliation_list_with_http_info(self, organization, **kwargs):  # noqa: E501
        """
        Get affiliation list.  Affiliations specify a permission level of a user to an organization. There are currently two cumulative permission levels. `Member` can only view an organization and not change any data. `Admin` can modify an organization, add members to an organization, and create new projects under the organization's account.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_affiliation_list_with_http_info(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int organization: A unique integer identifying an organization. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Affiliation]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'organization'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_affiliation_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization' is set
        if self.api_client.client_side_validation and ('organization' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization` when calling `get_affiliation_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization' in local_var_params:
            path_params['organization'] = local_var_params['organization']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Affiliations/{organization}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Affiliation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_algorithm(self, id, **kwargs):
        """get_algorithm

        Get registered algorithm workflow

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algorithm(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a registered algorithm workflow. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Algorithm`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_algorithm_with_http_info(id, **kwargs)  # noqa: E501

    def get_algorithm_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get registered algorithm workflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algorithm_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a registered algorithm workflow. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Algorithm`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_algorithm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Algorithm/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Algorithm',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_algorithm_list(self, project, **kwargs):
        """get_algorithm_list

        Get registered algorithms. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algorithm_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Algorithm]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_algorithm_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_algorithm_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get registered algorithms.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algorithm_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Algorithm]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_algorithm_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_algorithm_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Algorithms/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Algorithm]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analysis(self, id, **kwargs):
        """get_analysis

        Get analysis record

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_analysis(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an analysis record. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Analysis`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_analysis_with_http_info(id, **kwargs)  # noqa: E501

    def get_analysis_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get analysis record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_analysis_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an analysis record. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Analysis`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analysis" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Analysis/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Analysis',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analysis_list(self, project, **kwargs):
        """get_analysis_list

        Get analysis.  Analysis objects are used to display information about filtered media lists and/or annotations on the project detail page of the web UI. Currently only counting analysis is supported. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_analysis_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Analysis]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_analysis_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_analysis_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get analysis.  Analysis objects are used to display information about filtered media lists and/or annotations on the project detail page of the web UI. Currently only counting analysis is supported.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_analysis_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Analysis]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analysis_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_analysis_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Analyses/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Analysis]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audio_file(self, id, index, **kwargs):
        """get_audio_file

        Get audio file.  Audio files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying audio. One or more audio files can be used to reference the audio role in a `Media` object. The file itself must first be uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the audio file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_audio_file(id, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param int index: Index of object. Must be less than size of current list of audio files for the specified `role`. (required)
        :param str role: Role of media file being referenced.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.AudioDefinition`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_audio_file_with_http_info(id, index, **kwargs)  # noqa: E501

    def get_audio_file_with_http_info(self, id, index, **kwargs):  # noqa: E501
        """
        Get audio file.  Audio files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying audio. One or more audio files can be used to reference the audio role in a `Media` object. The file itself must first be uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the audio file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_audio_file_with_http_info(id, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param int index: Index of object. Must be less than size of current list of audio files for the specified `role`. (required)
        :param str role: Role of media file being referenced.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.AudioDefinition`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'index',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audio_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_audio_file`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and ('index' not in local_var_params or  # noqa: E501
                                                        local_var_params['index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `index` when calling `get_audio_file`")  # noqa: E501

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `get_audio_file`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/AudioFile/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AudioDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audio_file_list(self, id, **kwargs):
        """get_audio_file_list

        Get audio file list.  Audio files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying audio. One or more audio files can be used to reference the audio role in a `Media` object. The file itself must first be uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the audio file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_audio_file_list(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[AudioDefinition]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_audio_file_list_with_http_info(id, **kwargs)  # noqa: E501

    def get_audio_file_list_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get audio file list.  Audio files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying audio. One or more audio files can be used to reference the audio role in a `Media` object. The file itself must first be uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the audio file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_audio_file_list_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[AudioDefinition]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audio_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_audio_file_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/AudioFiles/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AudioDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bookmark(self, id, **kwargs):
        """get_bookmark

        Get bookmark.  Bookmarks are saved links that can be used to mark videos/frames of interest. They are scoped to a project and user, so if a user requests Bookmarks for a project they will only receive the Bookmarks created by them. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bookmark(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a bookmark. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Bookmark`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_bookmark_with_http_info(id, **kwargs)  # noqa: E501

    def get_bookmark_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get bookmark.  Bookmarks are saved links that can be used to mark videos/frames of interest. They are scoped to a project and user, so if a user requests Bookmarks for a project they will only receive the Bookmarks created by them.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bookmark_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a bookmark. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Bookmark`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bookmark" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_bookmark`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Bookmark/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Bookmark',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bookmark_list(self, project, **kwargs):
        """get_bookmark_list

        Get bookmark list.  Bookmarks are saved links that can be used to mark videos/frames of interest. They are scoped to a project and user, so if a user requests Bookmarks for a project they will only receive the Bookmarks created by them. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bookmark_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str name: Name of the bookmark to filter on.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Bookmark]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_bookmark_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_bookmark_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get bookmark list.  Bookmarks are saved links that can be used to mark videos/frames of interest. They are scoped to a project and user, so if a user requests Bookmarks for a project they will only receive the Bookmarks created by them.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bookmark_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str name: Name of the bookmark to filter on.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Bookmark]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bookmark_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_bookmark_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Bookmarks/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Bookmark]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_clip(self, id, frame_ranges, **kwargs):
        """get_clip

        Get video clip.  Facility to get a clip from the server. Returns a temporary file object that expires in 24 hours. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_clip(id, frame_ranges, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param list[str] frame_ranges: Comma-seperated list of frame ranges to capture. (required)
        :param int quality: Source resolution to use (default to highest quality)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.VideoClip`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_clip_with_http_info(id, frame_ranges, **kwargs)  # noqa: E501

    def get_clip_with_http_info(self, id, frame_ranges, **kwargs):  # noqa: E501
        """
        Get video clip.  Facility to get a clip from the server. Returns a temporary file object that expires in 24 hours.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_clip_with_http_info(id, frame_ranges, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param list[str] frame_ranges: Comma-seperated list of frame ranges to capture. (required)
        :param int quality: Source resolution to use (default to highest quality)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.VideoClip`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'frame_ranges',
            'quality'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clip" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_clip`")  # noqa: E501
        # verify the required parameter 'frame_ranges' is set
        if self.api_client.client_side_validation and ('frame_ranges' not in local_var_params or  # noqa: E501
                                                        local_var_params['frame_ranges'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `frame_ranges` when calling `get_clip`")  # noqa: E501

        if self.api_client.client_side_validation and 'quality' in local_var_params and local_var_params['quality'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `quality` when calling `get_clip`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'frame_ranges' in local_var_params and local_var_params['frame_ranges'] is not None:  # noqa: E501
            query_params.append(('frameRanges', local_var_params['frame_ranges']))  # noqa: E501
            collection_formats['frameRanges'] = 'csv'  # noqa: E501
        if 'quality' in local_var_params and local_var_params['quality'] is not None:  # noqa: E501
            query_params.append(('quality', local_var_params['quality']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/GetClip/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoClip',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_download_info(self, project, download_info_spec, **kwargs):
        """get_download_info

        Retrieve URL for one or more file downloads from a given project. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_download_info(project, download_info_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param DownloadInfoSpec download_info_spec: (required)
        :param int expiration: Number of seconds until URL expires and becomes invalid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[DownloadInfo]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_download_info_with_http_info(project, download_info_spec, **kwargs)  # noqa: E501

    def get_download_info_with_http_info(self, project, download_info_spec, **kwargs):  # noqa: E501
        """
        Retrieve URL for one or more file downloads from a given project.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_download_info_with_http_info(project, download_info_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param DownloadInfoSpec download_info_spec: (required)
        :param int expiration: Number of seconds until URL expires and becomes invalid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[DownloadInfo]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'download_info_spec',
            'expiration'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_download_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_download_info`")  # noqa: E501
        # verify the required parameter 'download_info_spec' is set
        if self.api_client.client_side_validation and ('download_info_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['download_info_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `download_info_spec` when calling `get_download_info`")  # noqa: E501

        if self.api_client.client_side_validation and 'expiration' in local_var_params and local_var_params['expiration'] > 86400:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expiration` when calling `get_download_info`, must be a value less than or equal to `86400`")  # noqa: E501
        if self.api_client.client_side_validation and 'expiration' in local_var_params and local_var_params['expiration'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expiration` when calling `get_download_info`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'expiration' in local_var_params and local_var_params['expiration'] is not None:  # noqa: E501
            query_params.append(('expiration', local_var_params['expiration']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'download_info_spec' in local_var_params:
            body_params = local_var_params['download_info_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/DownloadInfo/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DownloadInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_favorite(self, id, **kwargs):
        """get_favorite

        Get favorite.  Favorites are saved annotation values to help speed up annotation. They are  scoped to a project and user, so if a user requests Favorites for a project they will only receive the Favorites created by them. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_favorite(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a favorite. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Favorite`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_favorite_with_http_info(id, **kwargs)  # noqa: E501

    def get_favorite_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get favorite.  Favorites are saved annotation values to help speed up annotation. They are  scoped to a project and user, so if a user requests Favorites for a project they will only receive the Favorites created by them.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_favorite_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a favorite. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Favorite`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_favorite" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_favorite`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Favorite/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Favorite',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_favorite_list(self, project, **kwargs):
        """get_favorite_list

        Get favorite list.  Favorites are saved annotation values to help speed up annotation. They are  scoped to a project and user, so if a user requests Favorites for a project they will only receive the Favorites created by them. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_favorite_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Favorite]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_favorite_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_favorite_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get favorite list.  Favorites are saved annotation values to help speed up annotation. They are  scoped to a project and user, so if a user requests Favorites for a project they will only receive the Favorites created by them.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_favorite_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Favorite]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_favorite_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_favorite_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Favorites/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Favorite]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_frame(self, id, **kwargs):
        """get_frame

        Get frame(s) from a video.  Facility to get a frame(jpg/png) of a given video frame, returns a square tile of frames based on the input parameter. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_frame(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param list[int] frames: Comma-seperated list of frames to capture.
        :param str tile: wxh, if not supplied is made as squarish as possible.
        :param str roi: w:h:x:y, optionally crop each frame to a given roi in relative coordinates.
        :param int animate: If not tiling, animate each frame at a given fps in a gif.
        :param int quality: Source resolution to use (default to highest quality)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.file`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_frame_with_http_info(id, **kwargs)  # noqa: E501

    def get_frame_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get frame(s) from a video.  Facility to get a frame(jpg/png) of a given video frame, returns a square tile of frames based on the input parameter.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_frame_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param list[int] frames: Comma-seperated list of frames to capture.
        :param str tile: wxh, if not supplied is made as squarish as possible.
        :param str roi: w:h:x:y, optionally crop each frame to a given roi in relative coordinates.
        :param int animate: If not tiling, animate each frame at a given fps in a gif.
        :param int quality: Source resolution to use (default to highest quality)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.file`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'frames',
            'tile',
            'roi',
            'animate',
            'quality'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_frame" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_frame`")  # noqa: E501

        if self.api_client.client_side_validation and ('frames' in local_var_params and  # noqa: E501
                                                        len(local_var_params['frames']) > 32):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frames` when calling `get_frame`, length must be less than or equal to `32`")  # noqa: E501
        if self.api_client.client_side_validation and 'animate' in local_var_params and local_var_params['animate'] > 15:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `animate` when calling `get_frame`, must be a value less than or equal to `15`")  # noqa: E501
        if self.api_client.client_side_validation and 'animate' in local_var_params and local_var_params['animate'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `animate` when calling `get_frame`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'quality' in local_var_params and local_var_params['quality'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `quality` when calling `get_frame`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'frames' in local_var_params and local_var_params['frames'] is not None:  # noqa: E501
            query_params.append(('frames', local_var_params['frames']))  # noqa: E501
            collection_formats['frames'] = 'csv'  # noqa: E501
        if 'tile' in local_var_params and local_var_params['tile'] is not None:  # noqa: E501
            query_params.append(('tile', local_var_params['tile']))  # noqa: E501
        if 'roi' in local_var_params and local_var_params['roi'] is not None:  # noqa: E501
            query_params.append(('roi', local_var_params['roi']))  # noqa: E501
        if 'animate' in local_var_params and local_var_params['animate'] is not None:  # noqa: E501
            query_params.append(('animate', local_var_params['animate']))  # noqa: E501
        if 'quality' in local_var_params and local_var_params['quality'] is not None:  # noqa: E501
            query_params.append(('quality', local_var_params['quality']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/GetFrame/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_image_file(self, id, role, index, **kwargs):
        """get_image_file

        Get image file.  Image files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying image. One or more image files can be used to reference thumbnails, thumbnail GIFs, or images in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the image file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_image_file(id, role, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param int index: Index of object. Must be less than size of current list of images for the specified `role`. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.ImageDefinition`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_image_file_with_http_info(id, role, index, **kwargs)  # noqa: E501

    def get_image_file_with_http_info(self, id, role, index, **kwargs):  # noqa: E501
        """
        Get image file.  Image files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying image. One or more image files can be used to reference thumbnails, thumbnail GIFs, or images in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the image file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_image_file_with_http_info(id, role, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param int index: Index of object. Must be less than size of current list of images for the specified `role`. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.ImageDefinition`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'role',
            'index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_image_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_image_file`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `get_image_file`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and ('index' not in local_var_params or  # noqa: E501
                                                        local_var_params['index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `index` when calling `get_image_file`")  # noqa: E501

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `get_image_file`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/ImageFile/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_image_file_list(self, id, role, **kwargs):
        """get_image_file_list

        Get image file list.  Image files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying image. One or more image files can be used to reference thumbnails, thumbnail GIFs, or images in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the image file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_image_file_list(id, role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[ImageDefinition]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_image_file_list_with_http_info(id, role, **kwargs)  # noqa: E501

    def get_image_file_list_with_http_info(self, id, role, **kwargs):  # noqa: E501
        """
        Get image file list.  Image files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying image. One or more image files can be used to reference thumbnails, thumbnail GIFs, or images in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the image file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_image_file_list_with_http_info(id, role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[ImageDefinition]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_image_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_image_file_list`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `get_image_file_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/ImageFiles/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ImageDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job(self, uid, **kwargs):
        """get_job

        Get background job.  Algorithms and transcodes create argo workflows that are annotated with two uuid1 strings, one identifying the run and the other identifying the group. Jobs that are submitted together have the same group id, but each workflow has a unique run id.   This method allows the user to get a job's status using the `uid` returned by either the `AlgorithmLaunch` or `Transcode` endpoints. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: A uuid1 string identifying to single Job. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Job`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_with_http_info(uid, **kwargs)  # noqa: E501

    def get_job_with_http_info(self, uid, **kwargs):  # noqa: E501
        """
        Get background job.  Algorithms and transcodes create argo workflows that are annotated with two uuid1 strings, one identifying the run and the other identifying the group. Jobs that are submitted together have the same group id, but each workflow has a unique run id.   This method allows the user to get a job's status using the `uid` returned by either the `AlgorithmLaunch` or `Transcode` endpoints.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: A uuid1 string identifying to single Job. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Job`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `get_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in local_var_params:
            path_params['uid'] = local_var_params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Job/{uid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_list(self, project, **kwargs):
        """get_job_list

        Get background job list.  Algorithms and transcodes create argo workflows that are annotated with two uuid1 strings, one identifying the run and the other identifying the group. Jobs that are submitted together have the same group id, but each workflow has a unique run id.   This method allows the user to status for a list of jobs in a project that were created by either the `AlgorithmLaunch` or `Transcode` endpoints. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str gid: A UUID string identifying a group of jobs.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Job]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_job_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get background job list.  Algorithms and transcodes create argo workflows that are annotated with two uuid1 strings, one identifying the run and the other identifying the group. Jobs that are submitted together have the same group id, but each workflow has a unique run id.   This method allows the user to status for a list of jobs in a project that were created by either the `AlgorithmLaunch` or `Transcode` endpoints.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str gid: A UUID string identifying a group of jobs.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Job]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'gid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_job_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Jobs/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Job]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_leaf(self, id, **kwargs):
        """get_leaf

        Get leaf.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a leaf. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Leaf`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_leaf_with_http_info(id, **kwargs)  # noqa: E501

    def get_leaf_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get leaf.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a leaf. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Leaf`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_leaf" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_leaf`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaf/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Leaf',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_leaf_count(self, project, **kwargs):
        """get_leaf_count

        Retrieve count of leaves in a leaf list.  This endpoint accepts the same query parameters as a GET request to the `Leaves` endpoint, but only returns the number of leaves. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_count(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int type: Unique integer identifying a leaf type.
        :param str name: Name of the leaf element.
        :param int depth: Get a specific tree depth. Root node depth is 0.
        :param list[int] leaf_id: Comma-separated list of leaf IDs.
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.int`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_leaf_count_with_http_info(project, **kwargs)  # noqa: E501

    def get_leaf_count_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Retrieve count of leaves in a leaf list.  This endpoint accepts the same query parameters as a GET request to the `Leaves` endpoint, but only returns the number of leaves.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_count_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int type: Unique integer identifying a leaf type.
        :param str name: Name of the leaf element.
        :param int depth: Get a specific tree depth. Root node depth is 0.
        :param list[int] leaf_id: Comma-separated list of leaf IDs.
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.int`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'type',
            'name',
            'depth',
            'leaf_id',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_leaf_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_leaf_count`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'depth' in local_var_params and local_var_params['depth'] is not None:  # noqa: E501
            query_params.append(('depth', local_var_params['depth']))  # noqa: E501
        if 'leaf_id' in local_var_params and local_var_params['leaf_id'] is not None:  # noqa: E501
            query_params.append(('leaf_id', local_var_params['leaf_id']))  # noqa: E501
            collection_formats['leaf_id'] = 'multi'  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LeafCount/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_leaf_list(self, project, **kwargs):
        """get_leaf_list

        Get leaf list.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int type: Unique integer identifying a leaf type.
        :param str name: Name of the leaf element.
        :param int depth: Get a specific tree depth. Root node depth is 0.
        :param list[int] leaf_id: Comma-separated list of leaf IDs.
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Leaf]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_leaf_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_leaf_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get leaf list.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int type: Unique integer identifying a leaf type.
        :param str name: Name of the leaf element.
        :param int depth: Get a specific tree depth. Root node depth is 0.
        :param list[int] leaf_id: Comma-separated list of leaf IDs.
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Leaf]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'type',
            'name',
            'depth',
            'leaf_id',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_leaf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_leaf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'depth' in local_var_params and local_var_params['depth'] is not None:  # noqa: E501
            query_params.append(('depth', local_var_params['depth']))  # noqa: E501
        if 'leaf_id' in local_var_params and local_var_params['leaf_id'] is not None:  # noqa: E501
            query_params.append(('leaf_id', local_var_params['leaf_id']))  # noqa: E501
            collection_formats['leaf_id'] = 'multi'  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaves/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Leaf]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_leaf_list_by_id(self, project, request_body, **kwargs):
        """get_leaf_list_by_id

        Get leaf list by ID.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_list_by_id(project, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] request_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Leaf]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_leaf_list_by_id_with_http_info(project, request_body, **kwargs)  # noqa: E501

    def get_leaf_list_by_id_with_http_info(self, project, request_body, **kwargs):  # noqa: E501
        """
        Get leaf list by ID.  Leaves are used to define label hierarchies that can be used for autocompletion of string attribute types. Leaves are a type of entity in Tator, meaning they can be described by user-defined attributes.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_list_by_id_with_http_info(project, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] request_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Leaf]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_leaf_list_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_leaf_list_by_id`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `get_leaf_list_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaves/{project}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Leaf]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_leaf_type(self, id, **kwargs):
        """get_leaf_type

        Get leaf type.  A leaf type is the metadata definition object for a leaf. It includes name, description, and may have any number of user-defined attribute types associated with it. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_type(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an leaf type. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.LeafType`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_leaf_type_with_http_info(id, **kwargs)  # noqa: E501

    def get_leaf_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get leaf type.  A leaf type is the metadata definition object for a leaf. It includes name, description, and may have any number of user-defined attribute types associated with it.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an leaf type. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.LeafType`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_leaf_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_leaf_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LeafType/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LeafType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_leaf_type_list(self, project, **kwargs):
        """get_leaf_type_list

        Get leaf type list.  A leaf type is the metadata definition object for a leaf. It includes name, description, and may have any number of user-defined attribute types associated with it. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_type_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[LeafType]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_leaf_type_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_leaf_type_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get leaf type list.  A leaf type is the metadata definition object for a leaf. It includes name, description, and may have any number of user-defined attribute types associated with it.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_type_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[LeafType]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_leaf_type_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_leaf_type_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LeafTypes/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LeafType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization(self, id, **kwargs):
        """get_localization

        Get localization.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Localization`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_with_http_info(id, **kwargs)  # noqa: E501

    def get_localization_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get localization.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Localization`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_localization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localization/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Localization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization_count(self, project, **kwargs):
        """get_localization_count

        Retrieve count of localizations in a localization list.  This endpoint accepts the same query parameters as a GET request to the `Localizations` endpoint, but only returns the number of localizations. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_count(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.int`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_count_with_http_info(project, **kwargs)  # noqa: E501

    def get_localization_count_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Retrieve count of localizations in a localization list.  This endpoint accepts the same query parameters as a GET request to the `Localizations` endpoint, but only returns the number of localizations.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_count_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.int`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_localization_count`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationCount/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization_graphic(self, id, **kwargs):
        """get_localization_graphic

        Get localization graphic from a media object. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_graphic(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization. (required)
        :param str force_scale: Size of final image to return. This forces scaling the image. Default is the localization size and margins define the image size. Example: 100x100 
        :param bool use_default_margins: Use default margins for localization types.  Default margins (x,y pixels) - dot: (10,10) line:  (10,10) box: (0,0) 
        :param int margin_x: Pixel margin to apply to the height of the localization when generating the image. Valid only if use_default_margins is false. 
        :param int margin_y: Pixel margin to apply to the width of the localization when generating the image. Valid only if use_default_margins is false. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.file`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_graphic_with_http_info(id, **kwargs)  # noqa: E501

    def get_localization_graphic_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get localization graphic from a media object.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_graphic_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization. (required)
        :param str force_scale: Size of final image to return. This forces scaling the image. Default is the localization size and margins define the image size. Example: 100x100 
        :param bool use_default_margins: Use default margins for localization types.  Default margins (x,y pixels) - dot: (10,10) line:  (10,10) box: (0,0) 
        :param int margin_x: Pixel margin to apply to the height of the localization when generating the image. Valid only if use_default_margins is false. 
        :param int margin_y: Pixel margin to apply to the width of the localization when generating the image. Valid only if use_default_margins is false. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.file`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'force_scale',
            'use_default_margins',
            'margin_x',
            'margin_y'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization_graphic" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_localization_graphic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'force_scale' in local_var_params and local_var_params['force_scale'] is not None:  # noqa: E501
            query_params.append(('force_scale', local_var_params['force_scale']))  # noqa: E501
        if 'use_default_margins' in local_var_params and local_var_params['use_default_margins'] is not None:  # noqa: E501
            query_params.append(('use_default_margins', local_var_params['use_default_margins']))  # noqa: E501
        if 'margin_x' in local_var_params and local_var_params['margin_x'] is not None:  # noqa: E501
            query_params.append(('margin_x', local_var_params['margin_x']))  # noqa: E501
        if 'margin_y' in local_var_params and local_var_params['margin_y'] is not None:  # noqa: E501
            query_params.append(('margin_y', local_var_params['margin_y']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationGraphic/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization_list(self, project, **kwargs):
        """get_localization_list

        Get localization list.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param int exclude_parents: If a clone is present, do not send parent. This parameter will cause an exception if an Elasticsearch query is triggered and pagination parameters (start or stop) are included.
        :param int frame: Frame number of this localization if it is in a video.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Localization]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_localization_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get localization list.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param int exclude_parents: If a clone is present, do not send parent. This parameter will cause an exception if an Elasticsearch query is triggered and pagination parameters (start or stop) are included.
        :param int frame: Frame number of this localization if it is in a video.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Localization]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es',
            'exclude_parents',
            'frame'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_localization_list`")  # noqa: E501

        if self.api_client.client_side_validation and 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] > 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exclude_parents` when calling `get_localization_list`, must be a value less than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exclude_parents` when calling `get_localization_list`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'frame' in local_var_params and local_var_params['frame'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frame` when calling `get_localization_list`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501
        if 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] is not None:  # noqa: E501
            query_params.append(('excludeParents', local_var_params['exclude_parents']))  # noqa: E501
        if 'frame' in local_var_params and local_var_params['frame'] is not None:  # noqa: E501
            query_params.append(('frame', local_var_params['frame']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localizations/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Localization]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization_list_by_id(self, project, request_body, **kwargs):
        """get_localization_list_by_id

        Get localization list by ID.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_list_by_id(project, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] request_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Localization]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_list_by_id_with_http_info(project, request_body, **kwargs)  # noqa: E501

    def get_localization_list_by_id_with_http_info(self, project, request_body, **kwargs):  # noqa: E501
        """
        Get localization list by ID.  Localizations are shape annotations drawn on a video or image. Available shapes (`dtype`) are  box, line, or dot. Each shape is parameterized by a different subset of data members: - `box` uses `x`, `y`, `width`, `height`. - `line` uses `x`, `y`, `u`, `v`. - `dot` uses `x` and `y`.  Geometry members may be left null when creating a localization, in which case the shapes may be  drawn later using the redraw capability in the web UI. Localizations are a type of entity in Tator, meaning they can be described by user defined attributes.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_list_by_id_with_http_info(project, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] request_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Localization]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization_list_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_localization_list_by_id`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `get_localization_list_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localizations/{project}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Localization]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization_type(self, id, **kwargs):
        """get_localization_type

        Get localization type.  A localization type is the metadata definition object for a localization. It includes shape, name, description, and may have any number of user-defined attribute types associated with it.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_type(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization type. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.LocalizationType`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_type_with_http_info(id, **kwargs)  # noqa: E501

    def get_localization_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get localization type.  A localization type is the metadata definition object for a localization. It includes shape, name, description, and may have any number of user-defined attribute types associated with it.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization type. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.LocalizationType`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_localization_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationType/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocalizationType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization_type_list(self, project, **kwargs):
        """get_localization_type_list

        Get localization type list.  A localization type is the metadata definition object for a localization. It includes shape, name, description, and may have any number of user-defined attribute types associated with it. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_type_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of unique integers identifying a media.
        :param int type: Deprecated. Use `LocalizationType` endpoint to retrieve individual localization type by ID.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[LocalizationType]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_type_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_localization_type_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get localization type list.  A localization type is the metadata definition object for a localization. It includes shape, name, description, and may have any number of user-defined attribute types associated with it.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_type_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of unique integers identifying a media.
        :param int type: Deprecated. Use `LocalizationType` endpoint to retrieve individual localization type by ID.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[LocalizationType]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization_type_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_localization_type_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationTypes/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LocalizationType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media(self, id, **kwargs):
        """get_media

        Get media.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media. (required)
        :param int presigned: If given, all `path` fields in `media_files` will be replaced with presigned URLs that can be downloaded without authentication. The value is the expiration time of the URLs in seconds.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Media`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_with_http_info(id, **kwargs)  # noqa: E501

    def get_media_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get media.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media. (required)
        :param int presigned: If given, all `path` fields in `media_files` will be replaced with presigned URLs that can be downloaded without authentication. The value is the expiration time of the URLs in seconds.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Media`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'presigned'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_media`")  # noqa: E501

        if self.api_client.client_side_validation and 'presigned' in local_var_params and local_var_params['presigned'] > 86400:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `presigned` when calling `get_media`, must be a value less than or equal to `86400`")  # noqa: E501
        if self.api_client.client_side_validation and 'presigned' in local_var_params and local_var_params['presigned'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `presigned` when calling `get_media`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'presigned' in local_var_params and local_var_params['presigned'] is not None:  # noqa: E501
            query_params.append(('presigned', local_var_params['presigned']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Media/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Media',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_count(self, project, **kwargs):
        """get_media_count

        Retrieve count of media in a media list.  This endpoint accepts the same query parameters as a GET request to the `Medias` endpoint, but only returns the number of media. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_count(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.int`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_count_with_http_info(project, **kwargs)  # noqa: E501

    def get_media_count_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Retrieve count of media in a media list.  This endpoint accepts the same query parameters as a GET request to the `Medias` endpoint, but only returns the number of media.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_count_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.int`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type',
            'name',
            'section',
            'dtype',
            'md5',
            'gid',
            'uid',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_media_count`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'section' in local_var_params and local_var_params['section'] is not None:  # noqa: E501
            query_params.append(('section', local_var_params['section']))  # noqa: E501
        if 'dtype' in local_var_params and local_var_params['dtype'] is not None:  # noqa: E501
            query_params.append(('dtype', local_var_params['dtype']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaCount/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_list(self, project, **kwargs):
        """get_media_list

        Get media list.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param int presigned: If given, all `path` fields in `media_files` will be replaced with presigned URLs that can be downloaded without authentication. The value is the expiration time of the URLs in seconds.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Media]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_media_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get media list.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param int presigned: If given, all `path` fields in `media_files` will be replaced with presigned URLs that can be downloaded without authentication. The value is the expiration time of the URLs in seconds.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Media]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type',
            'name',
            'section',
            'dtype',
            'md5',
            'gid',
            'uid',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es',
            'presigned'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_media_list`")  # noqa: E501

        if self.api_client.client_side_validation and 'presigned' in local_var_params and local_var_params['presigned'] > 86400:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `presigned` when calling `get_media_list`, must be a value less than or equal to `86400`")  # noqa: E501
        if self.api_client.client_side_validation and 'presigned' in local_var_params and local_var_params['presigned'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `presigned` when calling `get_media_list`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'section' in local_var_params and local_var_params['section'] is not None:  # noqa: E501
            query_params.append(('section', local_var_params['section']))  # noqa: E501
        if 'dtype' in local_var_params and local_var_params['dtype'] is not None:  # noqa: E501
            query_params.append(('dtype', local_var_params['dtype']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501
        if 'presigned' in local_var_params and local_var_params['presigned'] is not None:  # noqa: E501
            query_params.append(('presigned', local_var_params['presigned']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Medias/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Media]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_list_by_id(self, project, request_body, **kwargs):
        """get_media_list_by_id

        Get media list by ID.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_list_by_id(project, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] request_body: (required)
        :param int presigned: If given, all `path` fields in `media_files` will be replaced with presigned URLs that can be downloaded without authentication. The value is the expiration time of the URLs in seconds.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Media]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_list_by_id_with_http_info(project, request_body, **kwargs)  # noqa: E501

    def get_media_list_by_id_with_http_info(self, project, request_body, **kwargs):  # noqa: E501
        """
        Get media list by ID.  A media may be an image or a video. Media are a type of entity in Tator, meaning they can be described by user defined attributes.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_list_by_id_with_http_info(project, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] request_body: (required)
        :param int presigned: If given, all `path` fields in `media_files` will be replaced with presigned URLs that can be downloaded without authentication. The value is the expiration time of the URLs in seconds.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Media]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'request_body',
            'presigned'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_list_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_media_list_by_id`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `get_media_list_by_id`")  # noqa: E501

        if self.api_client.client_side_validation and 'presigned' in local_var_params and local_var_params['presigned'] > 86400:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `presigned` when calling `get_media_list_by_id`, must be a value less than or equal to `86400`")  # noqa: E501
        if self.api_client.client_side_validation and 'presigned' in local_var_params and local_var_params['presigned'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `presigned` when calling `get_media_list_by_id`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'presigned' in local_var_params and local_var_params['presigned'] is not None:  # noqa: E501
            query_params.append(('presigned', local_var_params['presigned']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Medias/{project}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Media]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_next(self, id, **kwargs):
        """get_media_next

        Retrieve ID of next media in a media list.  This endpoint accepts the same query parameters as a GET request to the `Medias` endpoint, but only returns the next media ID from the media passed as a path parameter. This allows iteration through a media list without serializing the entire list, which may be large. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_next(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MediaNext`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_next_with_http_info(id, **kwargs)  # noqa: E501

    def get_media_next_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Retrieve ID of next media in a media list.  This endpoint accepts the same query parameters as a GET request to the `Medias` endpoint, but only returns the next media ID from the media passed as a path parameter. This allows iteration through a media list without serializing the entire list, which may be large.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_next_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MediaNext`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'media_id',
            'type',
            'name',
            'section',
            'dtype',
            'md5',
            'gid',
            'uid',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_next" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_media_next`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'section' in local_var_params and local_var_params['section'] is not None:  # noqa: E501
            query_params.append(('section', local_var_params['section']))  # noqa: E501
        if 'dtype' in local_var_params and local_var_params['dtype'] is not None:  # noqa: E501
            query_params.append(('dtype', local_var_params['dtype']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaNext/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MediaNext',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_prev(self, id, **kwargs):
        """get_media_prev

        Retrieve ID of previous media in a media list.  This endpoint accepts the same query parameters as a GET request to the `Medias` endpoint, but only returns the previous media ID from the media passed as a path parameter. This  allows iteration through a media list without serializing the entire list, which may be  large. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_prev(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MediaPrev`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_prev_with_http_info(id, **kwargs)  # noqa: E501

    def get_media_prev_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Retrieve ID of previous media in a media list.  This endpoint accepts the same query parameters as a GET request to the `Medias` endpoint, but only returns the previous media ID from the media passed as a path parameter. This  allows iteration through a media list without serializing the entire list, which may be  large.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_prev_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MediaPrev`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'media_id',
            'type',
            'name',
            'section',
            'dtype',
            'md5',
            'gid',
            'uid',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_prev" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_media_prev`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'section' in local_var_params and local_var_params['section'] is not None:  # noqa: E501
            query_params.append(('section', local_var_params['section']))  # noqa: E501
        if 'dtype' in local_var_params and local_var_params['dtype'] is not None:  # noqa: E501
            query_params.append(('dtype', local_var_params['dtype']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaPrev/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MediaPrev',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_stats(self, project, **kwargs):
        """get_media_stats

        Retrieve count, download size, total size, and duration of a media list.  This endpoint accepts the same query parameters as a GET request to the `Medias` endpoint, but only returns statistics about the media. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_stats(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MediaStats`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_stats_with_http_info(project, **kwargs)  # noqa: E501

    def get_media_stats_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Retrieve count, download size, total size, and duration of a media list.  This endpoint accepts the same query parameters as a GET request to the `Medias` endpoint, but only returns statistics about the media.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_stats_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of integers identifying media.
        :param int type: Unique integer identifying media type.
        :param str name: Name of the media to filter on.
        :param int section: Unique integer identifying a media section.
        :param str dtype: Data type of the files, either image or video.
        :param str md5: MD5 sum of the media file.
        :param str gid: Upload group ID of the media file.
        :param str uid: Upload unique ID of the media file.
        :param str after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MediaStats`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type',
            'name',
            'section',
            'dtype',
            'md5',
            'gid',
            'uid',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_stats" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_media_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'section' in local_var_params and local_var_params['section'] is not None:  # noqa: E501
            query_params.append(('section', local_var_params['section']))  # noqa: E501
        if 'dtype' in local_var_params and local_var_params['dtype'] is not None:  # noqa: E501
            query_params.append(('dtype', local_var_params['dtype']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaStats/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MediaStats',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_type(self, id, **kwargs):
        """get_media_type

        Get media type.  A media type is the metadata definition object for media. It includes file format, name, description, and may have any number of user defined attribute types associated with it.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_type(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an media type. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MediaType`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_type_with_http_info(id, **kwargs)  # noqa: E501

    def get_media_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get media type.  A media type is the metadata definition object for media. It includes file format, name, description, and may have any number of user defined attribute types associated with it.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an media type. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MediaType`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_media_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaType/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MediaType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_type_list(self, project, **kwargs):
        """get_media_type_list

        Get media type list.  A media type is the metadata definition object for media. It includes file format, name, description, and may have any number of user defined attribute types associated with it. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_type_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[MediaType]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_type_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_media_type_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get media type list.  A media type is the metadata definition object for media. It includes file format, name, description, and may have any number of user defined attribute types associated with it.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_type_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[MediaType]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_type_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_media_type_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaTypes/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MediaType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_membership(self, id, **kwargs):
        """get_membership

        Get membership.  Memberships specify a permission level of a user to a project. There are currently five cumulative permission levels: - `View Only` can only view a project and not change any data. - `Can Edit` can create, modify, and delete annotations. - `Can Transfer` can upload and download media. - `Can Execute` can launch algorithm workflows. - `Full Control` can change project settings, including inviting new members, project name, and    project metadata schema. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_membership(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a membership. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Membership`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_membership_with_http_info(id, **kwargs)  # noqa: E501

    def get_membership_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get membership.  Memberships specify a permission level of a user to a project. There are currently five cumulative permission levels: - `View Only` can only view a project and not change any data. - `Can Edit` can create, modify, and delete annotations. - `Can Transfer` can upload and download media. - `Can Execute` can launch algorithm workflows. - `Full Control` can change project settings, including inviting new members, project name, and    project metadata schema.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_membership_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a membership. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Membership`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_membership" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_membership`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Membership/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Membership',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_membership_list(self, project, **kwargs):
        """get_membership_list

        Get membership list.  Memberships specify a permission level of a user to a project. There are currently five cumulative permission levels: - `View Only` can only view a project and not change any data. - `Can Edit` can create, modify, and delete annotations. - `Can Transfer` can upload and download media. - `Can Execute` can launch algorithm workflows. - `Full Control` can change project settings, including inviting new members, project name, and    project metadata schema. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_membership_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Membership]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_membership_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_membership_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get membership list.  Memberships specify a permission level of a user to a project. There are currently five cumulative permission levels: - `View Only` can only view a project and not change any data. - `Can Edit` can create, modify, and delete annotations. - `Can Transfer` can upload and download media. - `Can Execute` can launch algorithm workflows. - `Full Control` can change project settings, including inviting new members, project name, and    project metadata schema.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_membership_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Membership]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_membership_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_membership_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Memberships/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Membership]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization(self, id, **kwargs):
        """get_organization

        Get organization.  Organizations are used to represent groups of users. Multiple projects may be owned by an organization, and users may be members of multiple organizations.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organization(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an organization. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Organization`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_organization_with_http_info(id, **kwargs)  # noqa: E501

    def get_organization_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get organization.  Organizations are used to represent groups of users. Multiple projects may be owned by an organization, and users may be members of multiple organizations.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organization_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an organization. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Organization`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Organization/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_list(self, **kwargs):
        """get_organization_list

        Get organization list.  Organizations are used to represent groups of users. Multiple projects may be owned by an organization, and users may be members of multiple organizations.   Returns all organizations that a user is affiliated with.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organization_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Organization]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_organization_list_with_http_info(**kwargs)  # noqa: E501

    def get_organization_list_with_http_info(self, **kwargs):  # noqa: E501
        """
        Get organization list.  Organizations are used to represent groups of users. Multiple projects may be owned by an organization, and users may be members of multiple organizations.   Returns all organizations that a user is affiliated with.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organization_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Organization]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Organizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Organization]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project(self, id, **kwargs):
        """get_project

        Get project.  Projects are the object under which all data in Tator is grouped, including user access, metadata definitions, media, and annotations. Data does not cross boundaries between projects.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a project. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Project`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_with_http_info(id, **kwargs)  # noqa: E501

    def get_project_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get project.  Projects are the object under which all data in Tator is grouped, including user access, metadata definitions, media, and annotations. Data does not cross boundaries between projects.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a project. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Project`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Project/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Project',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_list(self, **kwargs):
        """get_project_list

        Get project list.  Projects are the object under which all data in Tator is grouped, including user access, metadata definitions, media, and annotations. Data does not cross boundaries between projects.   Returns all projects that a user has access to.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Project]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_list_with_http_info(**kwargs)  # noqa: E501

    def get_project_list_with_http_info(self, **kwargs):  # noqa: E501
        """
        Get project list.  Projects are the object under which all data in Tator is grouped, including user access, metadata definitions, media, and annotations. Data does not cross boundaries between projects.   Returns all projects that a user has access to.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Project]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Project]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section(self, id, **kwargs):
        """get_section

        Get section.  Sections represent groups of media using saved queries. The queries can be in the form of a <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>lucene search string</a> or a list of <a href=https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-bool-query.html>boolean filter queries</a> applied to either media or child annotations of media. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_section(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a section. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Section`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_section_with_http_info(id, **kwargs)  # noqa: E501

    def get_section_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get section.  Sections represent groups of media using saved queries. The queries can be in the form of a <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>lucene search string</a> or a list of <a href=https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-bool-query.html>boolean filter queries</a> applied to either media or child annotations of media.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_section_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a section. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Section`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_section`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Section/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Section',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section_analysis(self, project, **kwargs):
        """get_section_analysis

        Retrieve analysis results for a media list.  This endpoint uses objects created with the `Analysis` endpoint to perform analysis on filtered media lists. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_section_analysis(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: Unique integer identifying a media. Use this to do analyis on a single file instead of sections.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.dict(str, object)`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_section_analysis_with_http_info(project, **kwargs)  # noqa: E501

    def get_section_analysis_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Retrieve analysis results for a media list.  This endpoint uses objects created with the `Analysis` endpoint to perform analysis on filtered media lists.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_section_analysis_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: Unique integer identifying a media. Use this to do analyis on a single file instead of sections.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.dict(str, object)`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section_analysis" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_section_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/SectionAnalysis/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section_list(self, project, **kwargs):
        """get_section_list

        Get section list.  Sections represent groups of media using saved queries. The queries can be in the form of a <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>lucene search string</a> or a list of <a href=https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-bool-query.html>boolean filter queries</a> applied to either media or child annotations of media. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_section_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str name: Name of the section.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Section]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_section_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_section_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get section list.  Sections represent groups of media using saved queries. The queries can be in the form of a <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>lucene search string</a> or a list of <a href=https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-bool-query.html>boolean filter queries</a> applied to either media or child annotations of media.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_section_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str name: Name of the section.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Section]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_section_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Sections/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Section]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state(self, id, **kwargs):
        """get_state

        Get state.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a state. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.State`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_with_http_info(id, **kwargs)  # noqa: E501

    def get_state_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get state.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a state. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.State`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/State/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='State',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_count(self, project, **kwargs):
        """get_state_count

        Retrieve count of states in a state list.  This endpoint accepts the same query parameters as a GET request to the `States` endpoint, but only returns the number of states. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_count(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.int`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_count_with_http_info(project, **kwargs)  # noqa: E501

    def get_state_count_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Retrieve count of states in a state list.  This endpoint accepts the same query parameters as a GET request to the `States` endpoint, but only returns the number of states.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_count_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.int`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_state_count`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateCount/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_graphic(self, id, **kwargs):
        """get_state_graphic

         Get frame(s) of a given localization-associated state.  Use the mode argument to control whether it is an animated gif or a tiled jpg. A maximum of 100 detections may be retrieved at once. Use the length and offset parameters to  control which section of a state is retrieved. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_graphic(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a state. (required)
        :param str mode: Whether to animate or tile.
        :param float fps: Frame rate if `mode` is `animate`.
        :param str force_scale: wxh to force each tile prior to stich
        :param int length: Number of detections to extract.
        :param int offset: Index offset of detections to extract.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.file`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_graphic_with_http_info(id, **kwargs)  # noqa: E501

    def get_state_graphic_with_http_info(self, id, **kwargs):  # noqa: E501
        """
         Get frame(s) of a given localization-associated state.  Use the mode argument to control whether it is an animated gif or a tiled jpg. A maximum of 100 detections may be retrieved at once. Use the length and offset parameters to  control which section of a state is retrieved.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_graphic_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a state. (required)
        :param str mode: Whether to animate or tile.
        :param float fps: Frame rate if `mode` is `animate`.
        :param str force_scale: wxh to force each tile prior to stich
        :param int length: Number of detections to extract.
        :param int offset: Index offset of detections to extract.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.file`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'mode',
            'fps',
            'force_scale',
            'length',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_graphic" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_state_graphic`")  # noqa: E501

        if self.api_client.client_side_validation and 'length' in local_var_params and local_var_params['length'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `length` when calling `get_state_graphic`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'mode' in local_var_params and local_var_params['mode'] is not None:  # noqa: E501
            query_params.append(('mode', local_var_params['mode']))  # noqa: E501
        if 'fps' in local_var_params and local_var_params['fps'] is not None:  # noqa: E501
            query_params.append(('fps', local_var_params['fps']))  # noqa: E501
        if 'force_scale' in local_var_params and local_var_params['force_scale'] is not None:  # noqa: E501
            query_params.append(('forceScale', local_var_params['force_scale']))  # noqa: E501
        if 'length' in local_var_params and local_var_params['length'] is not None:  # noqa: E501
            query_params.append(('length', local_var_params['length']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateGraphic/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_list(self, project, **kwargs):
        """get_state_list

        Get state list.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[State]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_state_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get state list.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :param list[int] media_id: Comma-separated list of media IDs.
        :param int type: Unique integer identifying a annotation type.
        :param list[int] version: List of integers representing versions to fetch
        :param int after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :param str search: Lucene query syntax string for use with Elasticsearch. See <a href=https://www.elastic.co/guide/en/elasticsearch/reference/7.10/query-dsl-query-string-query.html#query-string-syntax>reference</a>. If this parameter is applied to localizations or states, it will include search results for parent media. Likewise, if this parameter is applied media, it will include results for child localizations and states. For example, if the search is for \"foo\" on media, results will include all media with attributes or name \"foo\", as well as media containing states and/or localizations with attributes equal to \"foo\".
        :param list[str] attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :param list[str] attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :param list[str] attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :param int start: Pagination start index. Index of the first item in a larger list to return.
        :param int stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :param int force_es: Set to 1 to require an Elasticsearch based query. This can be used as a consistency check or for performance comparison.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[State]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'start',
            'stop',
            'force_es'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_state_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
            collection_formats['attribute'] = 'csv'  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
            collection_formats['attribute_lt'] = 'csv'  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
            collection_formats['attribute_lte'] = 'csv'  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
            collection_formats['attribute_gt'] = 'csv'  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
            collection_formats['attribute_gte'] = 'csv'  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
            collection_formats['attribute_contains'] = 'csv'  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
            collection_formats['attribute_distance'] = 'csv'  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
            collection_formats['attribute_null'] = 'csv'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'force_es' in local_var_params and local_var_params['force_es'] is not None:  # noqa: E501
            query_params.append(('force_es', local_var_params['force_es']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/States/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[State]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_list_by_id(self, project, request_body, **kwargs):
        """get_state_list_by_id

        Get state list by ID.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_list_by_id(project, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] request_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[State]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_list_by_id_with_http_info(project, request_body, **kwargs)  # noqa: E501

    def get_state_list_by_id_with_http_info(self, project, request_body, **kwargs):  # noqa: E501
        """
        Get state list by ID.  A state is a description of a collection of other objects. The objects a state describes could be media (image or video), video frames, or localizations. A state referring to a collection of localizations is often referred to as a track. States are a type of entity in Tator, meaning they can be described by user defined attributes.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_list_by_id_with_http_info(project, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] request_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[State]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_list_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_state_list_by_id`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `get_state_list_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/States/{project}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[State]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_type(self, id, **kwargs):
        """get_state_type

        Get state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and may have any number of user-defined attribute types associated with it.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_type(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a state type. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.StateType`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_type_with_http_info(id, **kwargs)  # noqa: E501

    def get_state_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and may have any number of user-defined attribute types associated with it.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a state type. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.StateType`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_state_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateType/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StateType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_type_list(self, project, **kwargs):
        """get_state_type_list

        Get state type list.  A state type is the metadata definition object for a state. It includes association type, name, description, and may have any number of user-defined attribute types associated with it. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_type_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of unique integers identifying a media.
        :param int type: Deprecated. Use `LocalizationType` endpoint to retrieve individual localization type by ID.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[StateType]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_type_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_state_type_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get state type list.  A state type is the metadata definition object for a state. It includes association type, name, description, and may have any number of user-defined attribute types associated with it.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_type_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param list[int] media_id: List of unique integers identifying a media.
        :param int type: Deprecated. Use `LocalizationType` endpoint to retrieve individual localization type by ID.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[StateType]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_type_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_state_type_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateTypes/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[StateType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_temporary_file(self, id, **kwargs):
        """get_temporary_file

        Get temporary file.  Temporary files are files stored server side for a defined duration. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temporary_file(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a temporary file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.TemporaryFile`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_temporary_file_with_http_info(id, **kwargs)  # noqa: E501

    def get_temporary_file_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get temporary file.  Temporary files are files stored server side for a defined duration.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temporary_file_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a temporary file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.TemporaryFile`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_temporary_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_temporary_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TemporaryFile/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TemporaryFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_temporary_file_list(self, project, **kwargs):
        """get_temporary_file_list

        Get temporary file list.  Temporary files are files stored server side for a defined duration.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temporary_file_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int expired: If greater than 0 will return only expired files
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[TemporaryFile]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_temporary_file_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_temporary_file_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get temporary file list.  Temporary files are files stored server side for a defined duration.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temporary_file_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int expired: If greater than 0 will return only expired files
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[TemporaryFile]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'expired'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_temporary_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_temporary_file_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'expired' in local_var_params and local_var_params['expired'] is not None:  # noqa: E501
            query_params.append(('expired', local_var_params['expired']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TemporaryFiles/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TemporaryFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_upload_info(self, project, **kwargs):
        """get_upload_info

        Retrieve URL for file upload to a given project. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_upload_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int expiration: Number of seconds until URL expires and becomes invalid.
        :param int num_parts: Number of upload parts. Maximum part size is 5GB.
        :param int media_id: Media ID if this is an upload for existing media.
        :param str filename: Filename to use if `media_id` is given. If a file with the same name already exists under the given media ID prefix, the new upload will replace it. Ignored if `media_id` is not given.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.UploadInfo`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_upload_info_with_http_info(project, **kwargs)  # noqa: E501

    def get_upload_info_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Retrieve URL for file upload to a given project.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_upload_info_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int expiration: Number of seconds until URL expires and becomes invalid.
        :param int num_parts: Number of upload parts. Maximum part size is 5GB.
        :param int media_id: Media ID if this is an upload for existing media.
        :param str filename: Filename to use if `media_id` is given. If a file with the same name already exists under the given media ID prefix, the new upload will replace it. Ignored if `media_id` is not given.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.UploadInfo`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'expiration',
            'num_parts',
            'media_id',
            'filename'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upload_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_upload_info`")  # noqa: E501

        if self.api_client.client_side_validation and 'expiration' in local_var_params and local_var_params['expiration'] > 86400:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expiration` when calling `get_upload_info`, must be a value less than or equal to `86400`")  # noqa: E501
        if self.api_client.client_side_validation and 'expiration' in local_var_params and local_var_params['expiration'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expiration` when calling `get_upload_info`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'num_parts' in local_var_params and local_var_params['num_parts'] > 10000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `num_parts` when calling `get_upload_info`, must be a value less than or equal to `10000`")  # noqa: E501
        if self.api_client.client_side_validation and 'num_parts' in local_var_params and local_var_params['num_parts'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `num_parts` when calling `get_upload_info`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_id' in local_var_params and local_var_params['media_id'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_id` when calling `get_upload_info`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'expiration' in local_var_params and local_var_params['expiration'] is not None:  # noqa: E501
            query_params.append(('expiration', local_var_params['expiration']))  # noqa: E501
        if 'num_parts' in local_var_params and local_var_params['num_parts'] is not None:  # noqa: E501
            query_params.append(('num_parts', local_var_params['num_parts']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
        if 'filename' in local_var_params and local_var_params['filename'] is not None:  # noqa: E501
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/UploadInfo/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UploadInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user(self, id, **kwargs):
        """get_user

        Get user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization association. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.User`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_user_with_http_info(id, **kwargs)  # noqa: E501

    def get_user_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a localization association. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.User`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/User/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_list(self, **kwargs):
        """get_user_list

        Get list of users.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username: Username associated with user. Either this or email must be supplied.
        :param str email: Email address associated with user. Either this or email must be supplied.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[User]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_user_list_with_http_info(**kwargs)  # noqa: E501

    def get_user_list_with_http_info(self, **kwargs):  # noqa: E501
        """
        Get list of users.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username: Username associated with user. Either this or email must be supplied.
        :param str email: Email address associated with user. Either this or email must be supplied.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[User]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'username',
            'email'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in local_var_params and local_var_params['username'] is not None:  # noqa: E501
            query_params.append(('username', local_var_params['username']))  # noqa: E501
        if 'email' in local_var_params and local_var_params['email'] is not None:  # noqa: E501
            query_params.append(('email', local_var_params['email']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[User]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_version(self, id, **kwargs):
        """get_version

        Get version.  Versions allow for multiple \"layers\" of annotations on the same media. Versions are created at the project level, but are only displayed for a given media if that media contains annotations in that version. The version of an annotation can be set by providing it in a POST operation. Currently only localizations and states can have versions.   

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_version(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a version. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Version`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_version_with_http_info(id, **kwargs)  # noqa: E501

    def get_version_with_http_info(self, id, **kwargs):  # noqa: E501
        """
        Get version.  Versions allow for multiple \"layers\" of annotations on the same media. Versions are created at the project level, but are only displayed for a given media if that media contains annotations in that version. The version of an annotation can be set by providing it in a POST operation. Currently only localizations and states can have versions.     # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_version_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a version. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Version`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Version/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Version',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_version_list(self, project, **kwargs):
        """get_version_list

        Get version list.  Versions allow for multiple \"layers\" of annotations on the same media. Versions are created at the project level, but are only displayed for a given media if that media contains annotations in that version. The version of an annotation can be set by providing it in a POST operation. Currently only localizations and states can have versions. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_version_list(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int media_id: Unique integer identifying a media.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[Version]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_version_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_version_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """
        Get version list.  Versions allow for multiple \"layers\" of annotations on the same media. Versions are created at the project level, but are only displayed for a given media if that media contains annotations in that version. The version of an annotation can be set by providing it in a POST operation. Currently only localizations and states can have versions.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_version_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param int media_id: Unique integer identifying a media.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[Version]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_version_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Versions/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Version]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_video_file(self, id, role, index, **kwargs):
        """get_video_file

        Get video file.  Video files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying video. One or more video files can be used to reference streaming or archival roles in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the video file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_video_file(id, role, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param int index: Index of object. Must be less than size of current list of videos for the specified `role`. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.VideoDefinition`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_video_file_with_http_info(id, role, index, **kwargs)  # noqa: E501

    def get_video_file_with_http_info(self, id, role, index, **kwargs):  # noqa: E501
        """
        Get video file.  Video files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying video. One or more video files can be used to reference streaming or archival roles in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the video file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_video_file_with_http_info(id, role, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param int index: Index of object. Must be less than size of current list of videos for the specified `role`. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.VideoDefinition`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'role',
            'index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_video_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_video_file`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `get_video_file`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and ('index' not in local_var_params or  # noqa: E501
                                                        local_var_params['index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `index` when calling `get_video_file`")  # noqa: E501

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `get_video_file`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/VideoFile/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_video_file_list(self, id, role, **kwargs):
        """get_video_file_list

        Get video file list.  Video files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying video. One or more video files can be used to reference streaming or archival roles in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the video file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_video_file_list(id, role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[VideoDefinition]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_video_file_list_with_http_info(id, role, **kwargs)  # noqa: E501

    def get_video_file_list_with_http_info(self, id, role, **kwargs):  # noqa: E501
        """
        Get video file list.  Video files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying video. One or more video files can be used to reference streaming or archival roles in a `Media` object. The file itself must first be  uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the video file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_video_file_list_with_http_info(id, role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param str role: Role of media file being referenced. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[VideoDefinition]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_video_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_video_file_list`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `get_video_file_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/VideoFiles/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[VideoDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def leaf_suggestion(self, project, ancestor, query, **kwargs):
        """leaf_suggestion

        Get list of autocomplete suggestions.  This endpoint is compatible with <a href=https://github.com/kraaden/autocomplete> devbridge suggestion format</a>. It performs a glob search on leaf objects in the project. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.leaf_suggestion(project, ancestor, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str ancestor: Get descendents of a leaf element (inclusive), by path (i.e. ITIS.Animalia). (required)
        :param str query: String to search for matching names. (required)
        :param int min_level: Integer specifying level of results that may be returned. For example, 2 refers to grandchildren of the level specified by the `ancestor` parameter.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.list[LeafSuggestion]`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.leaf_suggestion_with_http_info(project, ancestor, query, **kwargs)  # noqa: E501

    def leaf_suggestion_with_http_info(self, project, ancestor, query, **kwargs):  # noqa: E501
        """
        Get list of autocomplete suggestions.  This endpoint is compatible with <a href=https://github.com/kraaden/autocomplete> devbridge suggestion format</a>. It performs a glob search on leaf objects in the project.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.leaf_suggestion_with_http_info(project, ancestor, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param str ancestor: Get descendents of a leaf element (inclusive), by path (i.e. ITIS.Animalia). (required)
        :param str query: String to search for matching names. (required)
        :param int min_level: Integer specifying level of results that may be returned. For example, 2 refers to grandchildren of the level specified by the `ancestor` parameter.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.list[LeafSuggestion]`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'ancestor',
            'query',
            'min_level'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method leaf_suggestion" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `leaf_suggestion`")  # noqa: E501
        # verify the required parameter 'ancestor' is set
        if self.api_client.client_side_validation and ('ancestor' not in local_var_params or  # noqa: E501
                                                        local_var_params['ancestor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ancestor` when calling `leaf_suggestion`")  # noqa: E501
        # verify the required parameter 'query' is set
        if self.api_client.client_side_validation and ('query' not in local_var_params or  # noqa: E501
                                                        local_var_params['query'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `query` when calling `leaf_suggestion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501
        if 'ancestor' in local_var_params:
            path_params['ancestor'] = local_var_params['ancestor']  # noqa: E501

        query_params = []
        if 'min_level' in local_var_params and local_var_params['min_level'] is not None:  # noqa: E501
            query_params.append(('minLevel', local_var_params['min_level']))  # noqa: E501
        if 'query' in local_var_params and local_var_params['query'] is not None:  # noqa: E501
            query_params.append(('query', local_var_params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaves/Suggestion/{ancestor}/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LeafSuggestion]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def merge_states(self, id, state_merge_update, **kwargs):
        """merge_states

        Merges the source state into the target state.  The target state will inherit the the source's localizations and will be deleted. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.merge_states(id, state_merge_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying the target state to accept the merge. (required)
        :param StateMergeUpdate state_merge_update: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.merge_states_with_http_info(id, state_merge_update, **kwargs)  # noqa: E501

    def merge_states_with_http_info(self, id, state_merge_update, **kwargs):  # noqa: E501
        """
        Merges the source state into the target state.  The target state will inherit the the source's localizations and will be deleted.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.merge_states_with_http_info(id, state_merge_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying the target state to accept the merge. (required)
        :param StateMergeUpdate state_merge_update: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'state_merge_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method merge_states" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `merge_states`")  # noqa: E501
        # verify the required parameter 'state_merge_update' is set
        if self.api_client.client_side_validation and ('state_merge_update' not in local_var_params or  # noqa: E501
                                                        local_var_params['state_merge_update'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `state_merge_update` when calling `merge_states`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'state_merge_update' in local_var_params:
            body_params = local_var_params['state_merge_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MergeStates/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notify(self, notify_spec, **kwargs):
        """notify

        Send a notification to administrators.  Uses the Slack API to send a notification to system administrators. This endpoint can only be used by system administrators and must be configured in a Tator deployment's settings. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.notify(notify_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param NotifySpec notify_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.notify_with_http_info(notify_spec, **kwargs)  # noqa: E501

    def notify_with_http_info(self, notify_spec, **kwargs):  # noqa: E501
        """
        Send a notification to administrators.  Uses the Slack API to send a notification to system administrators. This endpoint can only be used by system administrators and must be configured in a Tator deployment's settings.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.notify_with_http_info(notify_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param NotifySpec notify_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'notify_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notify" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'notify_spec' is set
        if self.api_client.client_side_validation and ('notify_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['notify_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `notify_spec` when calling `notify`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'notify_spec' in local_var_params:
            body_params = local_var_params['notify_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Notify', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_algorithm(self, project, algorithm_spec, **kwargs):
        """register_algorithm

        Register an algorithm argo workflow.  This endpoint replicates the algorithm registration through the admin portal. The provided manifest file must have been uploaded and saved by the SaveAlgorithmManifest endpoint. This endpoint will respond with an error if one of the following conditions occur:  - Provided workflow name is not unique (across projects) - Not all the required fields are present - There are syntax errors with the given manifest file 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.register_algorithm(project, algorithm_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param AlgorithmSpec algorithm_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.CreateResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.register_algorithm_with_http_info(project, algorithm_spec, **kwargs)  # noqa: E501

    def register_algorithm_with_http_info(self, project, algorithm_spec, **kwargs):  # noqa: E501
        """
        Register an algorithm argo workflow.  This endpoint replicates the algorithm registration through the admin portal. The provided manifest file must have been uploaded and saved by the SaveAlgorithmManifest endpoint. This endpoint will respond with an error if one of the following conditions occur:  - Provided workflow name is not unique (across projects) - Not all the required fields are present - There are syntax errors with the given manifest file   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.register_algorithm_with_http_info(project, algorithm_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param AlgorithmSpec algorithm_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.CreateResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'algorithm_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_algorithm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `register_algorithm`")  # noqa: E501
        # verify the required parameter 'algorithm_spec' is set
        if self.api_client.client_side_validation and ('algorithm_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['algorithm_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_spec` when calling `register_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'algorithm_spec' in local_var_params:
            body_params = local_var_params['algorithm_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Algorithms/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rename_attribute(self, id, attribute_type_update, **kwargs):
        """rename_attribute

        Rename and/or change the type of an existing attribute on Type.  A attribute type is the metadata definition object for a user-defined attribute. It includes name, type, and any other associated fields, depending on the type. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rename_attribute(id, attribute_type_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a unique entity type. (required)
        :param AttributeTypeUpdate attribute_type_update: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.rename_attribute_with_http_info(id, attribute_type_update, **kwargs)  # noqa: E501

    def rename_attribute_with_http_info(self, id, attribute_type_update, **kwargs):  # noqa: E501
        """
        Rename and/or change the type of an existing attribute on Type.  A attribute type is the metadata definition object for a user-defined attribute. It includes name, type, and any other associated fields, depending on the type.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rename_attribute_with_http_info(id, attribute_type_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a unique entity type. (required)
        :param AttributeTypeUpdate attribute_type_update: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'attribute_type_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_attribute" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `rename_attribute`")  # noqa: E501
        # verify the required parameter 'attribute_type_update' is set
        if self.api_client.client_side_validation and ('attribute_type_update' not in local_var_params or  # noqa: E501
                                                        local_var_params['attribute_type_update'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attribute_type_update` when calling `rename_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'attribute_type_update' in local_var_params:
            body_params = local_var_params['attribute_type_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/AttributeType/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_algorithm_manifest(self, project, algorithm_manifest_spec, **kwargs):
        """save_algorithm_manifest

        Saves an uploaded algorithm manifest to the desired project. It is expected this manifest corresponds with an algorithm workflow to be registered by another endpoint.  Manifest is uploaded via tus, a separate mechanism from the REST API. Once a manifest upload is complete (a .yaml file), the file must be saved to the database using this endpoint. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_algorithm_manifest(project, algorithm_manifest_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project (required)
        :param AlgorithmManifestSpec algorithm_manifest_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.AlgorithmManifest`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.save_algorithm_manifest_with_http_info(project, algorithm_manifest_spec, **kwargs)  # noqa: E501

    def save_algorithm_manifest_with_http_info(self, project, algorithm_manifest_spec, **kwargs):  # noqa: E501
        """
        Saves an uploaded algorithm manifest to the desired project. It is expected this manifest corresponds with an algorithm workflow to be registered by another endpoint.  Manifest is uploaded via tus, a separate mechanism from the REST API. Once a manifest upload is complete (a .yaml file), the file must be saved to the database using this endpoint.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_algorithm_manifest_with_http_info(project, algorithm_manifest_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project (required)
        :param AlgorithmManifestSpec algorithm_manifest_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.AlgorithmManifest`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'algorithm_manifest_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_algorithm_manifest" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `save_algorithm_manifest`")  # noqa: E501
        # verify the required parameter 'algorithm_manifest_spec' is set
        if self.api_client.client_side_validation and ('algorithm_manifest_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['algorithm_manifest_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_manifest_spec` when calling `save_algorithm_manifest`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'algorithm_manifest_spec' in local_var_params:
            body_params = local_var_params['algorithm_manifest_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/SaveAlgorithmManifest/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlgorithmManifest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_email(self, project, email_spec, **kwargs):
        """send_email

        Send an email message using the Tator AWS SES configured credentials.'  Messages can only be sent to members of the same project. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_email(project, email_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param EmailSpec email_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.send_email_with_http_info(project, email_spec, **kwargs)  # noqa: E501

    def send_email_with_http_info(self, project, email_spec, **kwargs):  # noqa: E501
        """
        Send an email message using the Tator AWS SES configured credentials.'  Messages can only be sent to members of the same project.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_email_with_http_info(project, email_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param EmailSpec email_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'email_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_email" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `send_email`")  # noqa: E501
        # verify the required parameter 'email_spec' is set
        if self.api_client.client_side_validation and ('email_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['email_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `email_spec` when calling `send_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_spec' in local_var_params:
            body_params = local_var_params['email_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Email/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def transcode(self, project, transcode_spec, **kwargs):
        """transcode

        Start a transcode.  Videos in Tator must be transcoded to a multi-resolution streaming format before they can be viewed or annotated. This endpoint launches a transcode on raw uploaded video by creating an Argo workflow. The workflow will download the uploaded raw video, transcode it to the proper format, upload the transcoded video, and save the video using the  `SaveVideo` endpoint.  Note that the raw video must be uploaded first via tus, which is a separate mechanism  from the REST API. This endpoint requires a group and run UUID associated with this  upload. If no progress messages were generated during upload, then the group and run  UUIDs can be newly generated.  Transcodes may be cancelled via the `Job` or `JobGroup` endpoints. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transcode(project, transcode_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param TranscodeSpec transcode_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.Transcode`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.transcode_with_http_info(project, transcode_spec, **kwargs)  # noqa: E501

    def transcode_with_http_info(self, project, transcode_spec, **kwargs):  # noqa: E501
        """
        Start a transcode.  Videos in Tator must be transcoded to a multi-resolution streaming format before they can be viewed or annotated. This endpoint launches a transcode on raw uploaded video by creating an Argo workflow. The workflow will download the uploaded raw video, transcode it to the proper format, upload the transcoded video, and save the video using the  `SaveVideo` endpoint.  Note that the raw video must be uploaded first via tus, which is a separate mechanism  from the REST API. This endpoint requires a group and run UUID associated with this  upload. If no progress messages were generated during upload, then the group and run  UUIDs can be newly generated.  Transcodes may be cancelled via the `Job` or `JobGroup` endpoints.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transcode_with_http_info(project, transcode_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int project: A unique integer identifying a project. (required)
        :param TranscodeSpec transcode_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.Transcode`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'project',
            'transcode_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transcode" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `transcode`")  # noqa: E501
        # verify the required parameter 'transcode_spec' is set
        if self.api_client.client_side_validation and ('transcode_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['transcode_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transcode_spec` when calling `transcode`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transcode_spec' in local_var_params:
            body_params = local_var_params['transcode_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Transcode/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Transcode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trim_state_end(self, id, state_trim_update, **kwargs):
        """trim_state_end

        Trims the state's start or end point by deleting the localizations  before the new start point or after the new end point. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.trim_state_end(id, state_trim_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying the state to trim (required)
        :param StateTrimUpdate state_trim_update: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.trim_state_end_with_http_info(id, state_trim_update, **kwargs)  # noqa: E501

    def trim_state_end_with_http_info(self, id, state_trim_update, **kwargs):  # noqa: E501
        """
        Trims the state's start or end point by deleting the localizations  before the new start point or after the new end point.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.trim_state_end_with_http_info(id, state_trim_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying the state to trim (required)
        :param StateTrimUpdate state_trim_update: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'state_trim_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trim_state_end" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `trim_state_end`")  # noqa: E501
        # verify the required parameter 'state_trim_update' is set
        if self.api_client.client_side_validation and ('state_trim_update' not in local_var_params or  # noqa: E501
                                                        local_var_params['state_trim_update'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `state_trim_update` when calling `trim_state_end`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'state_trim_update' in local_var_params:
            body_params = local_var_params['state_trim_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TrimStateEnd/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_affiliation(self, id, affiliation_update, **kwargs):
        """update_affiliation

        Update affiliation.  Affiliations specify a permission level of a user to an organization. There are currently two cumulative permission levels. `Member` can only view an organization and not change any data. `Admin` can modify an organization, add members to an organization, and create new projects under the organization's account. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_affiliation(id, affiliation_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a affiliation. (required)
        :param AffiliationUpdate affiliation_update: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_affiliation_with_http_info(id, affiliation_update, **kwargs)  # noqa: E501

    def update_affiliation_with_http_info(self, id, affiliation_update, **kwargs):  # noqa: E501
        """
        Update affiliation.  Affiliations specify a permission level of a user to an organization. There are currently two cumulative permission levels. `Member` can only view an organization and not change any data. `Admin` can modify an organization, add members to an organization, and create new projects under the organization's account.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_affiliation_with_http_info(id, affiliation_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a affiliation. (required)
        :param AffiliationUpdate affiliation_update: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'affiliation_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_affiliation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_affiliation`")  # noqa: E501
        # verify the required parameter 'affiliation_update' is set
        if self.api_client.client_side_validation and ('affiliation_update' not in local_var_params or  # noqa: E501
                                                        local_var_params['affiliation_update'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `affiliation_update` when calling `update_affiliation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'affiliation_update' in local_var_params:
            body_params = local_var_params['affiliation_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Affiliation/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_algorithm(self, id, algorithm_spec, **kwargs):
        """update_algorithm

        Updated registered algorithm workflow

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_algorithm(id, algorithm_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a registered algorithm workflow. (required)
        :param AlgorithmSpec algorithm_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_algorithm_with_http_info(id, algorithm_spec, **kwargs)  # noqa: E501

    def update_algorithm_with_http_info(self, id, algorithm_spec, **kwargs):  # noqa: E501
        """
        Updated registered algorithm workflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_algorithm_with_http_info(id, algorithm_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a registered algorithm workflow. (required)
        :param AlgorithmSpec algorithm_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'algorithm_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_algorithm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_algorithm`")  # noqa: E501
        # verify the required parameter 'algorithm_spec' is set
        if self.api_client.client_side_validation and ('algorithm_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['algorithm_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_spec` when calling `update_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'algorithm_spec' in local_var_params:
            body_params = local_var_params['algorithm_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Algorithm/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_analysis(self, id, analysis_spec, **kwargs):
        """update_analysis

        Update analysis record

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_analysis(id, analysis_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an analysis record. (required)
        :param AnalysisSpec analysis_spec: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_analysis_with_http_info(id, analysis_spec, **kwargs)  # noqa: E501

    def update_analysis_with_http_info(self, id, analysis_spec, **kwargs):  # noqa: E501
        """
        Update analysis record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_analysis_with_http_info(id, analysis_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying an analysis record. (required)
        :param AnalysisSpec analysis_spec: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'analysis_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_analysis" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_analysis`")  # noqa: E501
        # verify the required parameter 'analysis_spec' is set
        if self.api_client.client_side_validation and ('analysis_spec' not in local_var_params or  # noqa: E501
                                                        local_var_params['analysis_spec'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `analysis_spec` when calling `update_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'analysis_spec' in local_var_params:
            body_params = local_var_params['analysis_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Analysis/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_audio_file(self, id, index, audio_definition, **kwargs):
        """update_audio_file

        Update audio file.  Audio files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying audio. One or more audio files can be used to reference the audio role in a `Media` object. The file itself must first be uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the audio file's `path` field. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_audio_file(id, index, audio_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param int index: Index of object. Must be less than size of current list of audio files for the specified `role`. (required)
        :param AudioDefinition audio_definition: (required)
        :param str role: Role of media file being referenced.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_audio_file_with_http_info(id, index, audio_definition, **kwargs)  # noqa: E501

    def update_audio_file_with_http_info(self, id, index, audio_definition, **kwargs):  # noqa: E501
        """
        Update audio file.  Audio files are stored under the `media_files` field of `Media` objects. They are used to  relate media metadata to an underlying audio. One or more audio files can be used to reference the audio role in a `Media` object. The file itself must first be uploaded to a URL retrieved from the `UploadInfo` endpoint, and the returned object key  should be specified in the audio file's `path` field.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_audio_file_with_http_info(id, index, audio_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a media object. (required)
        :param int index: Index of object. Must be less than size of current list of audio files for the specified `role`. (required)
        :param AudioDefinition audio_definition: (required)
        :param str role: Role of media file being referenced.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'index',
            'audio_definition',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_audio_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_audio_file`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and ('index' not in local_var_params or  # noqa: E501
                                                        local_var_params['index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `index` when calling `update_audio_file`")  # noqa: E501
        # verify the required parameter 'audio_definition' is set
        if self.api_client.client_side_validation and ('audio_definition' not in local_var_params or  # noqa: E501
                                                        local_var_params['audio_definition'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `audio_definition` when calling `update_audio_file`")  # noqa: E501

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `update_audio_file`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'audio_definition' in local_var_params:
            body_params = local_var_params['audio_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/AudioFile/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_bookmark(self, id, bookmark_update, **kwargs):
        """update_bookmark

        Update bookmark.  Bookmarks are saved links that can be used to mark videos/frames of interest. They are scoped to a project and user, so if a user requests Bookmarks for a project they will only receive the Bookmarks created by them. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_bookmark(id, bookmark_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a bookmark. (required)
        :param BookmarkUpdate bookmark_update: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_bookmark_with_http_info(id, bookmark_update, **kwargs)  # noqa: E501

    def update_bookmark_with_http_info(self, id, bookmark_update, **kwargs):  # noqa: E501
        """
        Update bookmark.  Bookmarks are saved links that can be used to mark videos/frames of interest. They are scoped to a project and user, so if a user requests Bookmarks for a project they will only receive the Bookmarks created by them.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_bookmark_with_http_info(id, bookmark_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a bookmark. (required)
        :param BookmarkUpdate bookmark_update: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'bookmark_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bookmark" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_bookmark`")  # noqa: E501
        # verify the required parameter 'bookmark_update' is set
        if self.api_client.client_side_validation and ('bookmark_update' not in local_var_params or  # noqa: E501
                                                        local_var_params['bookmark_update'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bookmark_update` when calling `update_bookmark`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bookmark_update' in local_var_params:
            body_params = local_var_params['bookmark_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Bookmark/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_favorite(self, id, favorite_update, **kwargs):
        """update_favorite

        Update favorite.  Favorites are saved annotation values to help speed up annotation. They are  scoped to a project and user, so if a user requests Favorites for a project they will only receive the Favorites created by them. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_favorite(id, favorite_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a favorite. (required)
        :param FavoriteUpdate favorite_update: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: :class:`tator.models.MessageResponse`
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_favorite_with_http_info(id, favorite_update, **kwargs)  # noqa: E501

    def update_favorite_with_http_info(self, id, favorite_update, **kwargs):  # noqa: E501
        """
        Update favorite.  Favorites are saved annotation values to help speed up annotation. They are  scoped to a project and user, so if a user requests Favorites for a project they will only receive the Favorites created by them.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_favorite_with_http_info(id, favorite_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer identifying a favorite. (required)
        :param FavoriteUpdate favorite_update: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(:class:`tator.models.MessageResponse`, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'favorite_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_favorite" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_favorite`")  # noqa: E501
        # verify the required parameter 'favorite_update' is set
        if self.api_client.client_side_validation and ('favorite_update' not in local_var_params or  # noqa: E501
                                                        local_var_params['favorite_update'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `favorite_update` when calling `update_favorite`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'favorite_update' in local_var_params:
            body_params = local_var_params['favorite_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Favorite/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
       