# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class Algorithm(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'int',
        'description': 'str',
        'files_per_job': 'int',
        'id': 'int',
        'manifest': 'str',
        'name': 'str',
        'project': 'int',
        'user': 'int'
    }

    attribute_map = {
        'cluster': 'cluster',
        'description': 'description',
        'files_per_job': 'files_per_job',
        'id': 'id',
        'manifest': 'manifest',
        'name': 'name',
        'project': 'project',
        'user': 'user'
    }

    def __init__(self, cluster=None, description=None, files_per_job=None, id=None, manifest=None, name=None, project=None, user=None, local_vars_configuration=None):  # noqa: E501
        """Algorithm - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._cluster = None
        self._description = None
        self._files_per_job = None
        self._id = None
        self._manifest = None
        self._name = None
        self._project = None
        self._user = None
        self.discriminator = None

        if cluster is not None:
            self.cluster = cluster
        if description is not None:
            self.description = description
        if files_per_job is not None:
            self.files_per_job = files_per_job
        if id is not None:
            self.id = id
        if manifest is not None:
            self.manifest = manifest
        if name is not None:
            self.name = name
        if project is not None:
            self.project = project
        if user is not None:
            self.user = user

    @property
    def cluster(self):
        """
        Unique integer identifying the job cluster.

        :return: The cluster of this Algorithm. 
        :rtype: int
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """
        Unique integer identifying the job cluster.

        :param cluster: The cluster of this Algorithm.
        :type: int
        """

        self._cluster = cluster

    @property
    def description(self):
        """
        Description of the algorithm.

        :return: The description of this Algorithm. 
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Description of the algorithm.

        :param description: The description of this Algorithm.
        :type: str
        """

        self._description = description

    @property
    def files_per_job(self):
        """
        Number of media files to be submitted to each workflow.

        :return: The files_per_job of this Algorithm. 
        :rtype: int
        """
        return self._files_per_job

    @files_per_job.setter
    def files_per_job(self, files_per_job):
        """
        Number of media files to be submitted to each workflow.

        :param files_per_job: The files_per_job of this Algorithm.
        :type: int
        """

        self._files_per_job = files_per_job

    @property
    def id(self):
        """
        Unique integer identifying the registered algorithm.

        :return: The id of this Algorithm. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying the registered algorithm.

        :param id: The id of this Algorithm.
        :type: int
        """

        self._id = id

    @property
    def manifest(self):
        """
        Server URL to argo manifest file (.yaml)

        :return: The manifest of this Algorithm. 
        :rtype: str
        """
        return self._manifest

    @manifest.setter
    def manifest(self, manifest):
        """
        Server URL to argo manifest file (.yaml)

        :param manifest: The manifest of this Algorithm.
        :type: str
        """

        self._manifest = manifest

    @property
    def name(self):
        """
        Unique name of the algorithm workflow.

        :return: The name of this Algorithm. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Unique name of the algorithm workflow.

        :param name: The name of this Algorithm.
        :type: str
        """

        self._name = name

    @property
    def project(self):
        """
        Unique integer identifying the project associated with the algorithm.

        :return: The project of this Algorithm. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying the project associated with the algorithm.

        :param project: The project of this Algorithm.
        :type: int
        """

        self._project = project

    @property
    def user(self):
        """
        Unique integer identifying the user registering the algorithm.

        :return: The user of this Algorithm. 
        :rtype: int
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Unique integer identifying the user registering the algorithm.

        :param user: The user of this Algorithm.
        :type: int
        """

        self._user = user

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Algorithm):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Algorithm):
            return True

        return self.to_dict() != other.to_dict()
