# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class Job(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'gid': 'str',
        'id': 'str',
        'nodes': 'list[JobNode]',
        'project': 'int',
        'start_time': 'datetime',
        'status': 'str',
        'stop_time': 'datetime',
        'uid': 'str',
        'user': 'int'
    }

    attribute_map = {
        'gid': 'gid',
        'id': 'id',
        'nodes': 'nodes',
        'project': 'project',
        'start_time': 'start_time',
        'status': 'status',
        'stop_time': 'stop_time',
        'uid': 'uid',
        'user': 'user'
    }

    def __init__(self, gid=None, id=None, nodes=None, project=None, start_time=None, status=None, stop_time=None, uid=None, user=None, local_vars_configuration=None):  # noqa: E501
        """Job - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._gid = None
        self._id = None
        self._nodes = None
        self._project = None
        self._start_time = None
        self._status = None
        self._stop_time = None
        self._uid = None
        self._user = None
        self.discriminator = None

        if gid is not None:
            self.gid = gid
        if id is not None:
            self.id = id
        if nodes is not None:
            self.nodes = nodes
        if project is not None:
            self.project = project
        self.start_time = start_time
        if status is not None:
            self.status = status
        self.stop_time = stop_time
        if uid is not None:
            self.uid = uid
        if user is not None:
            self.user = user

    @property
    def gid(self):
        """
        Group ID of the job.

        :return: The gid of this Job. 
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """
        Group ID of the job.

        :param gid: The gid of this Job.
        :type: str
        """

        self._gid = gid

    @property
    def id(self):
        """
        Unique identifier of the job generated by Argo.

        :return: The id of this Job. 
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique identifier of the job generated by Argo.

        :param id: The id of this Job.
        :type: str
        """

        self._id = id

    @property
    def nodes(self):
        """

        :return: The nodes of this Job. 
        :rtype: list[JobNode]
        """
        return self._nodes

    @nodes.setter
    def nodes(self, nodes):
        """

        :param nodes: The nodes of this Job.
        :type: list[JobNode]
        """

        self._nodes = nodes

    @property
    def project(self):
        """
        Unique integer identifying a project.

        :return: The project of this Job. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying a project.

        :param project: The project of this Job.
        :type: int
        """

        self._project = project

    @property
    def start_time(self):
        """
        Start time of this job.

        :return: The start_time of this Job. 
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Start time of this job.

        :param start_time: The start_time of this Job.
        :type: datetime
        """

        self._start_time = start_time

    @property
    def status(self):
        """
        Status of this job.

        :return: The status of this Job. 
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Status of this job.

        :param status: The status of this Job.
        :type: str
        """

        self._status = status

    @property
    def stop_time(self):
        """
        Stop time of this job.

        :return: The stop_time of this Job. 
        :rtype: datetime
        """
        return self._stop_time

    @stop_time.setter
    def stop_time(self, stop_time):
        """
        Stop time of this job.

        :param stop_time: The stop_time of this Job.
        :type: datetime
        """

        self._stop_time = stop_time

    @property
    def uid(self):
        """
        Unique ID of the job.

        :return: The uid of this Job. 
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """
        Unique ID of the job.

        :param uid: The uid of this Job.
        :type: str
        """

        self._uid = uid

    @property
    def user(self):
        """
        Unique integer identifying user who submitted the job.

        :return: The user of this Job. 
        :rtype: int
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Unique integer identifying user who submitted the job.

        :param user: The user of this Job.
        :type: int
        """

        self._user = user

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Job):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Job):
            return True

        return self.to_dict() != other.to_dict()
