# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class JobNode(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'children': 'list[str]',
        'id': 'str',
        'start_time': 'datetime',
        'status': 'str',
        'stop_time': 'datetime',
        'task': 'str'
    }

    attribute_map = {
        'children': 'children',
        'id': 'id',
        'start_time': 'start_time',
        'status': 'status',
        'stop_time': 'stop_time',
        'task': 'task'
    }

    def __init__(self, children=None, id=None, start_time=None, status=None, stop_time=None, task=None, local_vars_configuration=None):  # noqa: E501
        """JobNode - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._children = None
        self._id = None
        self._start_time = None
        self._status = None
        self._stop_time = None
        self._task = None
        self.discriminator = None

        if children is not None:
            self.children = children
        if id is not None:
            self.id = id
        self.start_time = start_time
        if status is not None:
            self.status = status
        self.stop_time = stop_time
        if task is not None:
            self.task = task

    @property
    def children(self):
        """

        :return: The children of this JobNode. 
        :rtype: list[str]
        """
        return self._children

    @children.setter
    def children(self, children):
        """

        :param children: The children of this JobNode.
        :type: list[str]
        """

        self._children = children

    @property
    def id(self):
        """
        Unique identifier of the job node.

        :return: The id of this JobNode. 
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique identifier of the job node.

        :param id: The id of this JobNode.
        :type: str
        """

        self._id = id

    @property
    def start_time(self):
        """
        Start time of this node.

        :return: The start_time of this JobNode. 
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Start time of this node.

        :param start_time: The start_time of this JobNode.
        :type: datetime
        """

        self._start_time = start_time

    @property
    def status(self):
        """
        Status of this node.

        :return: The status of this JobNode. 
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Status of this node.

        :param status: The status of this JobNode.
        :type: str
        """

        self._status = status

    @property
    def stop_time(self):
        """
        Stop time of this node.

        :return: The stop_time of this JobNode. 
        :rtype: datetime
        """
        return self._stop_time

    @stop_time.setter
    def stop_time(self, stop_time):
        """
        Stop time of this node.

        :param stop_time: The stop_time of this JobNode.
        :type: datetime
        """

        self._stop_time = stop_time

    @property
    def task(self):
        """
        Name of task performed by this node.

        :return: The task of this JobNode. 
        :rtype: str
        """
        return self._task

    @task.setter
    def task(self, task):
        """
        Name of task performed by this node.

        :param task: The task of this JobNode.
        :type: str
        """

        self._task = task

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobNode):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobNode):
            return True

        return self.to_dict() != other.to_dict()
