# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class MediaFiles(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'archival': 'list[VideoDefinition]',
        'audio': 'list[AudioDefinition]',
        'ids': 'list[int]',
        'image': 'list[ImageDefinition]',
        'layout': 'list[int]',
        'quality': 'int',
        'streaming': 'list[VideoDefinition]',
        'thumbnail': 'list[ImageDefinition]',
        'thumbnail_gif': 'list[ImageDefinition]'
    }

    attribute_map = {
        'archival': 'archival',
        'audio': 'audio',
        'ids': 'ids',
        'image': 'image',
        'layout': 'layout',
        'quality': 'quality',
        'streaming': 'streaming',
        'thumbnail': 'thumbnail',
        'thumbnail_gif': 'thumbnail_gif'
    }

    def __init__(self, archival=None, audio=None, ids=None, image=None, layout=None, quality=None, streaming=None, thumbnail=None, thumbnail_gif=None, local_vars_configuration=None):  # noqa: E501
        """MediaFiles - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._archival = None
        self._audio = None
        self._ids = None
        self._image = None
        self._layout = None
        self._quality = None
        self._streaming = None
        self._thumbnail = None
        self._thumbnail_gif = None
        self.discriminator = None

        if archival is not None:
            self.archival = archival
        if audio is not None:
            self.audio = audio
        if ids is not None:
            self.ids = ids
        if image is not None:
            self.image = image
        if layout is not None:
            self.layout = layout
        if quality is not None:
            self.quality = quality
        if streaming is not None:
            self.streaming = streaming
        if thumbnail is not None:
            self.thumbnail = thumbnail
        if thumbnail_gif is not None:
            self.thumbnail_gif = thumbnail_gif

    @property
    def archival(self):
        """

        :return: The archival of this MediaFiles. 
        :rtype: list[VideoDefinition]
        """
        return self._archival

    @archival.setter
    def archival(self, archival):
        """

        :param archival: The archival of this MediaFiles.
        :type: list[VideoDefinition]
        """

        self._archival = archival

    @property
    def audio(self):
        """

        :return: The audio of this MediaFiles. 
        :rtype: list[AudioDefinition]
        """
        return self._audio

    @audio.setter
    def audio(self, audio):
        """

        :param audio: The audio of this MediaFiles.
        :type: list[AudioDefinition]
        """

        self._audio = audio

    @property
    def ids(self):
        """
        If multi-stream list of ids of sub-videos

        :return: The ids of this MediaFiles. 
        :rtype: list[int]
        """
        return self._ids

    @ids.setter
    def ids(self, ids):
        """
        If multi-stream list of ids of sub-videos

        :param ids: The ids of this MediaFiles.
        :type: list[int]
        """

        self._ids = ids

    @property
    def image(self):
        """

        :return: The image of this MediaFiles. 
        :rtype: list[ImageDefinition]
        """
        return self._image

    @image.setter
    def image(self, image):
        """

        :param image: The image of this MediaFiles.
        :type: list[ImageDefinition]
        """

        self._image = image

    @property
    def layout(self):
        """
        2-element array to define rxc layout

        :return: The layout of this MediaFiles. 
        :rtype: list[int]
        """
        return self._layout

    @layout.setter
    def layout(self, layout):
        """
        2-element array to define rxc layout

        :param layout: The layout of this MediaFiles.
        :type: list[int]
        """

        self._layout = layout

    @property
    def quality(self):
        """
        Resolution to fetch on each sub-video

        :return: The quality of this MediaFiles. 
        :rtype: int
        """
        return self._quality

    @quality.setter
    def quality(self, quality):
        """
        Resolution to fetch on each sub-video

        :param quality: The quality of this MediaFiles.
        :type: int
        """

        self._quality = quality

    @property
    def streaming(self):
        """

        :return: The streaming of this MediaFiles. 
        :rtype: list[VideoDefinition]
        """
        return self._streaming

    @streaming.setter
    def streaming(self, streaming):
        """

        :param streaming: The streaming of this MediaFiles.
        :type: list[VideoDefinition]
        """

        self._streaming = streaming

    @property
    def thumbnail(self):
        """

        :return: The thumbnail of this MediaFiles. 
        :rtype: list[ImageDefinition]
        """
        return self._thumbnail

    @thumbnail.setter
    def thumbnail(self, thumbnail):
        """

        :param thumbnail: The thumbnail of this MediaFiles.
        :type: list[ImageDefinition]
        """

        self._thumbnail = thumbnail

    @property
    def thumbnail_gif(self):
        """

        :return: The thumbnail_gif of this MediaFiles. 
        :rtype: list[ImageDefinition]
        """
        return self._thumbnail_gif

    @thumbnail_gif.setter
    def thumbnail_gif(self, thumbnail_gif):
        """

        :param thumbnail_gif: The thumbnail_gif of this MediaFiles.
        :type: list[ImageDefinition]
        """

        self._thumbnail_gif = thumbnail_gif

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MediaFiles):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MediaFiles):
            return True

        return self.to_dict() != other.to_dict()
